      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CCONFIG.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isopensave.def".
       77  hWin                    handle of window.
       77  crt-status              special-names crt status pic 9(5).
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
                               
       77  varname                 pic x any length.
       77  varvalue                pic x any length.
       77  e-standalone            pic 9.

       77  config-path             pic x any length.
       77  opensave-status         pic s9.
       77  wstatus                 pic s9.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 4
              col                  2 
              size                 30 cells
              title                "Set environment variable:"
              .
           03 ef-var
              entry-field
              line                 6
              col                  2
              size                 20 cells
              value                varname
              .
           03 ef-val
              entry-field
              line                 6
              col                  + 2 |35
              size                 20 cells
              .
           03 push-button 
              line                 6
              col                  + 2
              size                 10 cells
              title                "Set"
              exception-value      101
              .

           03 push-button 
              line                 6
              col                  + 2 |37
              size                 10 cells
              title                "Accept"
              exception-value      102
              .
           03 label
              title                "File"
              line                 8
              col                  2
              size                 4 cells
              .
           03 file-conf 
              entry-field
              line                 10
              col                  2
              size                 63 cells
              max-text             256
              value                config-path
              .
           03 pb-choose
              push-button
              line                 10
              col                  + 2
              title                "..."
              size                 4 cells
              exception-value      103
              enabled              e-standalone
              self-act
              .

           03 push-button 
              line                 14
              col                  2
              size                 30 cells
              title                "Reset configuration"
              exception-value      104
              .

           03 push-button 
              line                 16
              col                  2
              size                 30 cells
              title                "Set configuration from file"
              exception-value      105
              .

           03 push-button 
              line                 18
              col                  2
              size                 30 cells
              title                "Append to configuration from file"
              exception-value      106
              .
           03 Pb-exit  
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       INI.    

           move "newconfvar" to varname
           move "files\cconfig.properties"
                             to config-path

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           accept terminal-abilities from terminal-info.
           if is-remote
              move zero                  to e-standalone
           else
              move 1                     to e-standalone
           end-if

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$CONFIG Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 101
                perform SET-VAR
           when 102
                perform ACCEPT-VAR
           when 103
                perform CHOOSE-FILE
           when 104
                perform REST-CONFIGURATION
           when 105
                perform REST-CONFIGURATION-AND-LOAD-CONF
           when 106
                perform APPEND-CONFIGURATION
           end-evaluate.

       REST-CONFIGURATION.
           call "c$config" using cconfig-reset
                          giving wstatus
           if wstatus not = 0
              display message "Error resetting configuration"
           end-if
           .

       REST-CONFIGURATION-AND-LOAD-CONF.
           call "c$config" using cconfig-reset
                                 config-path 
                          giving wstatus
           if wstatus not = 0
              display message "Error loading"
           end-if
           .

       APPEND-CONFIGURATION.
           call "c$config" using cconfig-append
                                 config-path 
                          giving wstatus
           if wstatus not = 0
              display message "Error append configuration"
           end-if
           .
       
       SET-VAR.
           inquire ef-var value varname
           inquire ef-val value varvalue
           set environment varname to varvalue
           .

       ACCEPT-VAR.
           inquire ef-var value varname
           accept varvalue from environment varname
              on exception
                 display message "Environment variable not set"
                 initialize varvalue
              not on exception
                 display message "The value of the variable '" varname
                                 "'"
                                 x"0D0A"
                                 "is '" varvalue "'"
           end-accept
           . 

       CHOOSE-FILE.
           move 1 to opnsav-default-filter
           move "All Files (*.*)" to opnsav-filters
           call "C$OPENSAVEBOX" using opensave-open-box 
                                      opensave-data
                               giving opensave-status
           if opensave-status > 0
              move opnsav-filename to config-path 
              modify file-conf value config-path
           end-if
           .


       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .