      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CCOPY.

       WORKING-STORAGE SECTION.
       copy "isopensave.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  opensave-status         pic s9.
       77  source-file             pic x(256).
       77  dest-file               pic x(256).
       77  file-base-name          pic x(256).
       77  wstatus                 pic s9.
       77  v-remote                pic 9.
       77  v-findex                pic 9 value 0.
       77  path-user-home          pic x any length.
       
       77  rb-type                 pic 9 value 1.
       77  rb-orig                 pic 9 value 1.
       77  rb-dest                 pic 9 value 1.
       77  e-client                pic 9.

       01  source-type             pic X.
           88 client-source        value "C".
           88 server-source        value "S".

       01  destination-type        pic X.
           88 client-dest          value "C".
           88 server-dest          value "S".

       77  cont                    pic 9(3).
       77  file-message            pic x any length.
       77  file-type               pic x.
       
       77  title-lbl-file          pic x any length.

       01  cblt-splitjoin-buf.
           03 cblte-sj-param-length            pic x(2) comp-x.
           03 cblte-sj-split-join-flag1        pic x comp-x.
           03 cblte-sj-split-join-flag2        pic x comp-x.
           03 cblte-sj-device-offset           pic x(2) comp-x.
           03 cblte-sj-device-length           pic x(2) comp-x.
           03 cblte-sj-basename-offset         pic x(2) comp-x.
           03 cblte-sj-basename-length         pic x(2) comp-x.
           03 cblte-sj-extension-offset        pic x(2) comp-x.
           03 cblte-sj-extension-length        pic x(2) comp-x.
           03 cblte-sj-total-length            pic x(2) comp-x.
           03 cblte-sj-split-buf-len           pic x(2) comp-x.
           03 cblte-sj-join-buf-len            pic x(2) comp-x.
           03 cblte-sj-first-component-length  pic x(2) comp-x.

       77  findex                  pic x any length.

       SCREEN SECTION.
       01  Mask.
           03 lbl-file
              label
              line                 2 
              col                  2
              title                title-lbl-file
              .
           03 file-copy
              entry-field
              line                 4 
              col                  2
              value                source-file
              size                 62 cells
              max-text             256
              boxed
              .
           03 pb-choose
              push-button
              line                 4
              col                  + 2
              title                "..."
              size                 4 cells
              exception-value      101
              enabled              e-client
              .
           03 label
              title                "File type"
              line                 6
              col                  2
              .
           03 radio-button 
              line                 8 
              col                  2
              title                "Sequential"
              group                1
              group-value          1 
              value                rb-type
              exception-value      105
              . 
           03 radio-button 
              line                 8 
              col                  17
              title                "Line Sequential"
              group                1
              group-value          2 
              value                rb-type
              exception-value      105
              . 
           03 radio-button 
              line                 8 
              col                  37
              title                "Index"
              group                1
              group-value          3
              value                rb-type
              exception-value      105
              . 
           03 radio-button 
              line                 8
              col                  54
              title                "Relative"
              group                1
              group-value          4
              value                rb-type
              exception-value      105
              . 
           03  lbl-findex-1
               label 
               line                10
               col                 2
               title               "current file.index:"
               visible             v-findex
               .
           03  lbl-findex-2
               label  
               col                 20
               title               findex
               visible             v-findex
               .  
           03 label
              title                "Source"
              line                 12
              col                  2
              visible              v-remote
              .
           03 radio-button 
              line                 14
              col                  2
              title                "Client"
              group                2
              group-value          1 
              value                rb-orig
              exception-value      103
              visible              v-remote
              . 
           03 radio-button 
              line                 14
              col                  17
              title                "Server"
              group                2
              group-value          2 
              value                rb-orig
              exception-value      103
              visible              v-remote
              . 
           03 label
              title                "Destination"
              line                 16
              col                  2
              visible              v-remote
              .
           03 radio-button 
              line                 18
              col                  2
              title                "Client"
              group                3
              group-value          1 
              value                rb-dest
              exception-value      104
              visible              v-remote
              . 
           03 radio-button 
              line                 18
              col                  17
              title                "Server"
              group                3
              group-value          2 
              value                rb-dest
              exception-value      104
              visible              v-remote
              . 
           03 push-button
              line                 20
              col                  2
              title                "Create &Backup"
              size                 19 cells
              exception-value      102
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
               
       PROCEDURE DIVISION.
       MAIN. 
           accept findex from environment "file.index"
              on exception 
                 move "jisam" to findex
           end-accept.
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1   to v-remote
           else
              move 0   to v-remote
           end-if
           move 1      to e-client

           set client-source to true
           set client-dest   to true

           perform SET-LBL-FILE-TITLE

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$COPY Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display Mask
                          
           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                perform CHOOSE-FILE
           when 102
                perform BACKUP-FILE
           when 103
                if rb-orig = 1
                   set client-source   to true
                   move 1                 to e-client
                else
                   set server-source   to true
                   move zero              to e-client
                end-if
                modify pb-choose enabled e-client
           when 104
                if rb-dest = 1
                   set client-dest   to true
                else
                   set server-dest   to true
                end-if
                modify pb-choose enabled e-client
           when 105
                perform SET-LBL-FILE-TITLE
                modify lbl-file title title-lbl-file
           end-evaluate
           .
            
       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .

       CHOOSE-FILE.
           initialize opensave-data
           call client "C$GETENV" USING "user.home"
                                        opnsav-default-dir
           call "C$OPENSAVEBOX" using opensave-open-box
                                      opensave-data
                               giving opensave-status
           if opensave-status > 0
              modify file-copy value opnsav-filename
           end-if.

       BACKUP-FILE.
           initialize file-message.

           inquire file-copy value in source-file

           initialize dest-file
           string source-file   delimited by trailing spaces
                  "-Bk"         delimited by size
                  into dest-file
           end-string

           evaluate rb-type
           when 1
                move "S"  to file-type
           when 2
                move "T"  to file-type
           when 3
                move "I"  to file-type
           when 4
                move "R"  to file-type
           end-evaluate

           if is-remote
              evaluate true also true 
              when client-source also client-dest
                   perform CALL-CLIENT-COPY
                   string "The name of the new file is: "
                                            delimited by size
                          dest-file         delimited by trailing space
                          " on the client"  delimited by size
                          into file-message
              when client-source also server-dest
                   perform RETRIVE-BASE-FILENAME
                   call "C$GETENV" USING "user.home"
                                         path-user-home
                   initialize dest-file
                   string path-user-home   delimited by trailing space
                          "/"              delimited by size
                          file-base-name   delimited by trailing spaces
                          "-Bk"            delimited by size
                          into dest-file
                   end-string

                   string "@[DISPLAY]:"  delimited by size
                          source-file    delimited by trailing space
                          into source-file

                   perform CALL-COPY
                   string "The name of the new file is: " 
                                            delimited by size
                          dest-file         delimited by trailing space
                          " on the server"  delimited by size 
                          into file-message
              when server-source also client-dest
                   perform RETRIVE-BASE-FILENAME
                   call client "C$GETENV" USING "user.home"
                                                path-user-home
                   initialize dest-file
                   string "@[DISPLAY]:"    delimited by size
                          path-user-home   delimited by trailing space
                          "/"              delimited by size
                          file-base-name   delimited by trailing spaces
                          "-Bk"            delimited by size
                          into dest-file
                   end-string
                   perform CALL-COPY
                   string "The name of the new file is:" 
                                            delimited by size
                          path-user-home    delimited by trailing space
                          "/"               delimited by size
                          file-base-name    delimited by trailing spaces
                          "-Bk"             delimited by size
                          " on the client"  delimited by size
                          into file-message
              when server-source also server-dest
                   perform CALL-COPY
                   string "The name of the new file is: "
                                            delimited by size
                          dest-file         delimited by trailing space
                          " on the server"  delimited by size
                          into file-message
              end-evaluate
           else
              perform CALL-COPY
              string "The name of the new file is: " delimited by size
                      dest-file             delimited by trailing space
                      into file-message
           end-if
           evaluate wstatus
           when 0
                display message "Copy successful"
                                x"0A"
                                file-message
           when 1
           when 2
                display message "Copy failed"
                                icon 3
           end-evaluate.


       CALL-COPY.
           call "C$COPY" using source-file 
                               dest-file
                               file-type
                        giving wstatus.
       
       CALL-CLIENT-COPY.
           call client "C$COPY" using source-file 
                                      dest-file
                                      file-type
                               giving wstatus.

       RETRIVE-BASE-FILENAME.
           set cblte-sj-param-length     to size of cblt-splitjoin-buf
           set cblte-sj-split-buf-len    to size of source-file
           move b#10                     to cblte-sj-split-join-flag1
           call "CBL_SPLIT_FILENAME" using cblt-splitjoin-buf
                                           source-file
                                 returning wstatus.

           move source-file
                     (cblte-sj-basename-offset:)
                                   to file-base-name.

       SET-LBL-FILE-TITLE.
           if rb-type = 3
              move "Select a file, the use of the extension depends on y
      -            "our file handler configuration" to title-lbl-file
              move 1   to v-findex
           else
              move "Select a file:"   to title-lbl-file
              move 0                  to v-findex
           end-if
           modify lbl-findex-1 visible v-findex
           modify lbl-findex-2 visible v-findex
           .
      
