      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CRUN.

       WORKING-STORAGE SECTION.
       copy "iscobol.def".
       copy "isresize.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  cmd-line                pic x(256).  
       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.
       
       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2 
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              . 
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 radio-button 
              line                 2 
              col                  34
              title                "Run on Server"  
              group                1
              group-value          3
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 label
              line                 4
              col                  2
              size                 10 cells
              title                "Launch:"
              .
           03 entry-field
              line                 6
              col                  2
              size                 68 cells
              value                cmd-line
              max-text             256
              .
           03 push-button
              default-button
              line                 8
              col                  2
              size                 8 cells
              title                "&RUN"
              exception-value      100
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.    
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$RUN Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           accept system-information from system-info

           if os-is-win-family
              move "notepad.exe" to cmd-line
           end-if
              
           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 100
                evaluate true
                when client-execution
                     call client "C$RUN" using cmd-line
                when standalone-execution
                when server-execution
                     call "C$RUN" using cmd-line
                end-evaluate
                if return-code not = 0
                   display message "failed" 
                           icon     mb-warning-icon
                end-if
           when 103
                if rb-value = 2
                   set client-execution   to true
                else
                   set server-execution   to true
                end-if
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
