      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CSORT.

       WORKING-STORAGE SECTION.
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  cmd-line                pic x any length.  
       77  path-user-home          pic x any length.
       77  sorted-file             pic x any length.
       77  wstatus                 pic 9(3).
       77  cont                    pic 9(3).

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 4
              col                  2
              title                "Sort Command:"
              .
           03 entry-field
              line                 6
              lines                4
              col                  2
              size                 68 cells
              value                cmd-line
              multiline
              .
           03 push-button
              default-button
              line                 11
              col                  2
              size                 8 cells
              title                "&Sort"
              exception-value      100
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.    
           call "C$GETENV" USING "user.home"
                                 path-user-home

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$SORT Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           accept system-information from system-info

           string path-user-home            delimited by trailing space 
                  "/sorted-output.txt"
                  into sorted-file

           perform SORTED-FILE-NORMALIZATION

           string "sort fields (1, 6, ch, d) use "    delimited by size
                  "files/csortidxfile org ix "        delimited by size
                  "record f 40 key (1, 6, p, 7, 15, " delimited by size
                  "c, 22, 15, ad) give "              delimited by size
                  sorted-file                         delimited by size 
                  " org ls "                          delimited by size
                  "record f 40 "                      delimited by size
                  "include cond = 37,4,ge,902"        delimited by size
                  into cmd-line
              
           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 100
                perform CSORT
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       CSORT.
           call "C$SORT" using cmd-line
                        giving wstatus

           evaluate wstatus
           when 0
                display message "Sort Succesfull"
           when 2
                display message "Unsupported feature"
           when 15
                display message "Command statement error(s) detected"
           when 100
                display message "I/O error"
           end-evaluate.

       SORTED-FILE-NORMALIZATION.
           initialize cont.
           inspect sorted-file tallying cont for all space

           if cont not = zero
              string '"'           delimited by size
                     sorted-file   delimited by trailing space
                     '"'           delimited by size
                     into sorted-file
           end-if.
