      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CUNLOAD.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  num-unloaded            pic 9(3).
       77  pgm-name                pic x any length.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 4
              col                  2
              title                "Name of the programs to reload from 
      -                            "the disk (metacharacters are allowed
      -                            ")"
              .
           03  ef-pgm-name
               entry-field
               size                68 cells
               line                06 
               col                 02 
               value               pgm-name
               .
           03  push-button
               line                8
               col                 2 
               title               "&C$UNLOAD"
               size                10 
               exception-value     101
               self-act
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.
           move "*"    to pgm-name
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$UNLOAD Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception
                    continue
              end-accept
              if crt-status = 101
                 perform UNLOAD
              end-if
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .
           
       UNLOAD.
           call "C$UNLOAD" using pgm-name
                          giving num-unloaded
           display message "Number of unloaded program " num-unloaded
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
