      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CWRU2.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  label-calling           pic x(256) value space. 
       01  who-called-me.
           05  the-calling-program    pic x(30)  value spaces.
           05  the-calling-line       pic s9(6)  binary.
           05  my-line-num            pic s9(02) binary.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              size                 34 cells
              title                "Who called me?"
              .
           03 label
              line                 4
              col                  2
              size                 34 cells
              title                label-calling
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       INI.   
           call "C$WRU" using the-calling-program
      *                        the-calling-line
      *                        my-line-num

           if the-calling-program = "RUNCOBOL"
              move "I've not been called" to label-calling
           else
              string "I've been called by: " delimited by size
                     the-calling-program     delimited by size
                     into label-calling
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display independent graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$WRU Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT
           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception 
                    continue
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
