      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. cxml.

       CONFIGURATION SECTION.
       SPECIAL-NAMES.

       WORKING-STORAGE SECTION.
       copy "isfonts.def".
       copy "isgui.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       copy "isopensave.def".

       77  crt-status                 special-names crt status pic 9(5).
       77  hWin                          handle of window.
       77  close-win                     pic 9 value 0.
       77  control-font                  handle of font.
       77  xmlfile                       pic x any length.
       77  opensave-status               pic s9.
       01  w-flag                        pic 9 value 0.
       01  idx                           pic 9(6) value 0.

       77  xml-handle                    handle.
       77  elem-handle                   handle.
       77  old-elem-handle               handle.

       01  save-elem-handle-occurs.
           05  save-elem-handle          handle occurs dynamic 
                                              capacity num-handle.

       77  xml-item-name                 pic x any length.
       77  xml-item-value                pic x(50).
       77  xml-value-length              pic 9(3).

       77  w-tv-old                      unsigned-int.
       77  w-tv-item                     unsigned-int.
       77  w-tv-root                     unsigned-int.
       01  last-level-occurs.
           05 last-level                 unsigned-int occurs dynamic.
       77  level                         pic 9(3).
       77  title-xml-elem-value          pic x any length.

       01  hidden-xml-value.
           05 h-xml-item-value           pic x(50).
           05 h-xml-value-length         pic 9(3).
           05 h-xml-start-idx-attr       pic 9(3).
           05 h-xml-end-idx-attr         pic 9(3).

       77  attr-count                    pic 99.
       77  attr-name                     pic x(32).
       77  attr-value                    pic x(32).
       01  attr-occurs.
           05 filler                     occurs dynamic 
                                            capacity h-xml-attr-count.
              10 xml-attr-name           pic x(20).
              10 xml-attr-value          pic x(50).
              10 xml-attr-value-length   pic 9(3).

       01  gd-attr-rec. 
           10 gd-attr-name               pic x(20).
           10 gd-attr-value              pic x(50).

       77  rb-value                      pic 9.
       01  execution-type                pic x.
           88 standalone-execution       value "A".
           88 client-execution           value "C".
           88 server-execution           value "S".
       77  e-remote                      pic 9.
       77  e-standalone                  pic 9.
       77  e-client                      pic 9.
       77  ERR-DESC                      pic x(100).


       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2 
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              . 
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 radio-button 
              line                 2 
              col                  34
              title                "Run on Server"
              group                1
              group-value          3
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 label 
              title                "XML file: " 
              line                 4 
              col                  2
              height-in-cells 
              width-in-cells
              .       
           03 e1 
              entry-field 
              value                xmlfile
              line                 4 
              col                  + 2 
              size                 48  cells
              id                   101
              .
           03 pb-choose
              push-button 
              title                "..." 
              line                 4 
              col                  + 1.2
              size                 3  cells
              exception-value      101
              enabled              e-client
              .
           03 push-button 
              title                "Parse" 
              line                 4 
              col                  + 1
              exception-value      102
              id                   101
              .
           03 label
              title                "Xml structure"
              line                 6
              col                  2
              .
           03 xml-structure 
              tree-View 
              col                  2 
              line                 8
              lines                11
              size                 35 
              id                   102 
              buttons 
              height-in-cells 
              width-in-cells
              lines-at-root
              show-lines 
              show-sel-always
              event procedure      t-event-proc
              .
           03 label
              title                "Elem. Value: "
              line                 6
              col                  40
              .
           03 lbl-xml-elem-value
              label
              title title-xml-elem-value
              line                 6
              col                  51
              .
           03 label
              title                "Attributes:"
              line                 8
              col                  40
              .
           03 g-attribute 
              grid
              line                 10
              col                  40
              data-columns         (1, 21)
              display-columns      (1, 10)
              lines                5
              size                 30
              virtual-width        26
              width-in-cells
              adjustable-columns
              column-headings
              tiled-headings
              heading-color        257
              vscroll
              cursor-frame-width   2
              protection           1
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if
           move 1                        to e-client

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   lines  21
                   min-lines  21
                   size 70
                   min-size 70
                   title  "C$XML Routine"
                   control font control-font
                   handle hWin
                   event  WIN-EVT

           display mask.

           perform until crt-status = 27 or close-win = 1
              accept mask
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              if w-flag = 1
                 move 0   to w-flag
                 move 4   to accept-control
                 move 102 to control-id
              end-if
              move 4      to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                perform CHOOSE-XML
           when 102
                perform BROWSE-XML-DESCRIPTION
           when 103
                if rb-value = 2
                   set client-execution   to true
                   move 1                 to e-client
                else
                   set server-execution   to true
                   move zero              to e-client
                end-if
                modify pb-choose enabled e-client
           end-evaluate.

       CHOOSE-XML.
           move "XML file (*.xml)|*.xml" to opnsav-filters.
           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data
                               giving opensave-status.
           if opensave-status > 0
              move opnsav-filename to xmlfile
              modify e1 value xmlfile
           end-if
           move opnsav-basename to opnsav-default-dir
           .

       BROWSE-XML-DESCRIPTION.  
           modify xml-structure reset-list 1.
           modify g-attribute reset-grid 1.

           initialize last-level-occurs
                      attr-occurs
                      save-elem-handle-occurs.

      *    Open the xml
           evaluate true
           when client-execution
                call client "c$xml" using cxml-parse-file
                                          xmlfile
                                   giving xml-handle
           when standalone-execution
           when server-execution
                call "c$xml" using cxml-parse-file
                                   xmlfile
                            giving xml-handle
           end-evaluate           

           if xml-handle = zero
              evaluate true
              when client-execution
                   call client "c$xml" using cxml-get-last-error
                                             err-desc
              when standalone-execution
              when server-execution
                   call "c$xml" using cxml-get-last-error
                                      err-desc
              end-evaluate           
              display message err-desc 
                     icon     mb-warning-icon
              exit paragraph
           end-if

      *    Obtain the data of the root element
           move xml-handle   to elem-handle
           perform GIVING-XML-ELEMENT-VALUE

      *    Display the data into the tree-view
           move 1 to level
           perform ADD-ITEM

      *    retrive the first child
           evaluate true
           when client-execution
                call client "c$xml" using cxml-get-first-child
                                          xml-handle
                                      giving elem-handle
           when standalone-execution
           when server-execution
                call "c$xml" using cxml-get-first-child
                                   xml-handle
                            giving elem-handle
           end-evaluate           

      *    Loop to retrive all XML element
           if elem-handle not = zero
              perform until 1 = 2 
                 move 2   to level
      *    retrive the xml element value
                 perform GIVING-XML-ELEMENT-VALUE
      *    add the xml element to the tree-view
                 perform ADD-ITEM
      *    check for sub element
                 perform XML-SUB-ELEMENT
      *    obtain the next element
                 move elem-handle to old-elem-handle
                 evaluate true
                 when client-execution
                      call client "c$xml" using cxml-get-next-sibling 
                                                elem-handle
                                          giving elem-handle
                 when standalone-execution
                 when server-execution
                      call "c$xml" using cxml-get-next-sibling 
                                         elem-handle
                                  giving elem-handle
                 end-evaluate           
                 destroy old-elem-handle

                 if elem-handle = 0
                    exit perform
                 end-if
              end-perform
           end-if.

           evaluate true
           when client-execution
                call client "c$xml" using cxml-release-parser
                                          xml-handle
           when standalone-execution
           when server-execution
                call "c$xml" using cxml-release-parser
                                   xml-handle
           end-evaluate.

       XML-SUB-ELEMENT.
           move elem-handle  to save-elem-handle(level)
           
           add 1 to level

           evaluate true
           when client-execution
                call client "C$XML" using cxml-get-first-child
                                          elem-handle
                                   giving elem-handle
           when standalone-execution
           when server-execution
                call "C$XML" using cxml-get-first-child
                                   elem-handle
                            giving elem-handle
           end-evaluate.

           if elem-handle not = zero
              perform until 1 = 2
      *    retrive the xml element value
                 perform GIVING-XML-ELEMENT-VALUE
      *    add the xml element to the tree-view
                 perform ADD-ITEM
      *    check for sub element
                 perform XML-SUB-ELEMENT

      *    obtain the next element
                 move elem-handle to old-elem-handle
                 evaluate true
                 when client-execution
                      call client "C$XML" using cxml-get-next-sibling 
                                                elem-handle
                                         giving elem-handle
                 when standalone-execution
                 when server-execution
                      call "C$XML" using cxml-get-next-sibling 
                                         elem-handle
                                  giving elem-handle
                 end-evaluate
                 destroy old-elem-handle

                 if elem-handle = 0
                    exit perform
                 end-if
              end-perform
           end-if.

           subtract 1 from level.

           move save-elem-handle(level)   to elem-handle.

       ADD-ITEM.
           if level = 1
              move zero to w-tv-item
           else
              move last-level(level - 1) to w-tv-item
           end-if

           modify xml-structure parent        w-tv-item
                                item-to-add   xml-item-name
                                giving        w-tv-root
                                hidden-data   hidden-xml-value
           move w-tv-root  to last-level(level)

           if level < 3
              MODIFY xml-structure, ensure-visible w-tv-root
           end-if.

       GIVING-XML-ELEMENT-VALUE.
           initialize hidden-xml-value.

           evaluate true
           when client-execution
                call client "C$XML" using cxml-get-data
                                          elem-handle
                                          xml-item-name
                                          xml-item-value
                                          xml-value-length
           when standalone-execution
           when server-execution
                call "C$XML" using cxml-get-data
                                   elem-handle
                                   xml-item-name
                                   xml-item-value
                                   xml-value-length
           end-evaluate

           move xml-item-value  to h-xml-item-value
           move xml-value-length    to h-xml-value-length

           evaluate true
           when client-execution
                call client "C$XML" using cxml-get-attribute-count
                                          elem-handle
                                   giving attr-count
           when standalone-execution
           when server-execution
                call "C$XML" using cxml-get-attribute-count
                                   elem-handle
                            giving attr-count
           end-evaluate

           if attr-count > 0
              add   1  to h-xml-attr-count giving h-xml-start-idx-attr
              perform varying idx from 1 by 1 until idx > attr-count

                 evaluate true
                 when client-execution
                      call client "C$XML" using cxml-get-attribute
                                                elem-handle
                                                idx
                                                attr-name
                                                attr-value
                                                xml-value-length
                 when standalone-execution
                 when server-execution
                      call "C$XML" using cxml-get-attribute
                                         elem-handle
                                         idx
                                         attr-name
                                         attr-value
                                         xml-value-length
                 end-evaluate

                 add 1 to h-xml-attr-count giving h-xml-end-idx-attr
                 
                 move attr-name to xml-attr-name(h-xml-end-idx-attr)
                 move attr-value to xml-attr-value(h-xml-end-idx-attr)
                 move xml-value-length  
                         to xml-attr-value-length(h-xml-end-idx-attr)

              end-perform
           end-if.

       T-EVENT-PROC.

           evaluate event-type
           when msg-tv-selchange
                move event-data-2 to w-tv-item
                if w-tv-old not = w-tv-item
                   move w-tv-item to w-tv-old
                   inquire xml-structure(w-tv-item) 
                                      hidden-data = hidden-xml-value
                   perform SHOW-XML-ELEMENT-VALUE
                   move 1 to w-flag
                   set event-action to event-action-terminate
                end-if
           end-evaluate.


       SHOW-XML-ELEMENT-VALUE.
           move h-xml-item-value   to title-xml-elem-value.
           modify lbl-xml-elem-value title title-xml-elem-value.
    
           modify g-attribute MASS-UPDATE 1
                              reset-grid 1

           move "Name" to gd-attr-name
           move "Value"   to gd-attr-value
           
           modify g-attribute record-to-add gd-attr-rec
           

           if h-xml-start-idx-attr not = zero
              perform varying idx from h-xml-start-idx-attr by 1 
                                         until idx > h-xml-end-idx-attr
                 move xml-attr-name(idx)  to gd-attr-name
                 move xml-attr-value(idx) to gd-attr-value
                 modify g-attribute record-to-add gd-attr-rec
              end-perform
           end-if.

           modify g-attribute MASS-UPDATE zero.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
