      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. DELETER.

       WORKING-STORAGE SECTION.
       copy "isopensave.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  opensave-status         pic s9.
       77  file-name               pic x(256).
       77  wstatus                 pic s9(4) binary.
       77  risp                    pic 9.

       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.
       77  e-client                pic 9.

       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2 
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              . 
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 radio-button 
              line                 2 
              col                  34
              title                "Run on Server"
              group                1
              group-value          3
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 label
              title                "File"
              line                 4
              col                  2
              size                 4 cells
              .
           03 file-del 
              entry-field
              line                 6
              col                  2
              value                file-name
              size                 63 cells
              max-text             256
              .
           03 pb-choose
              push-button
              line                 6 
              col                  + 2
              title                "..."
              size                 4 cells
              exception-value      101
              enabled              e-client
              .
           03 push-button
              line                 8 
              col                  2
              title                "&Delete"
              size                 10
              exception-value      102
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
              
       PROCEDURE DIVISION.
       MAIN.    
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if
           move 1                        to e-client
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "DELETE Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform  until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .         
             
       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 101
                perform CHOOSE-FILE
           when 102
                perform DELETE-FILE
           when 103
                if rb-value = 2
                   set client-execution   to true
                   move 1                 to e-client
                else
                   set server-execution   to true
                   move zero              to e-client
                end-if
                modify pb-choose enabled e-client
           end-evaluate      
           .
        
       CHOOSE-FILE.
           move 1 to opnsav-default-filter
           move "All Files (*.*)" to opnsav-filters
           call "C$OPENSAVEBOX" using opensave-open-box 
                                      opensave-data
                               giving opensave-status
           if opensave-status > 0
              modify file-del value opnsav-filename
           end-if
           .
              
       DELETE-FILE. 
           inquire file-del value in file-name
           inspect file-name replacing trailing spaces by low-value
           display message box "Are you sure you want delete " file-name 
                                " ?"
                   type         mb-yes-no
                   default      mb-no
                   giving       risp

           evaluate risp
           when mb-yes
                evaluate true
                when client-execution
                     call client "DELETE" using file-name
                                         giving wstatus
                when standalone-execution
                when server-execution
                     call "DELETE" using file-name
                                  giving wstatus
                     end-call
                end-evaluate
                evaluate wstatus
                when 0
                     display message "File deleted"
                             icon mb-default-icon
                when other
                     display message "File not deleted"
                                     x"0D0A"
                                     "Error code " 
                                     wstatus
                             icon mb-default-icon
                 end-evaluate 
           when mb-no
                continue
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
