      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WBITMAP-ICON.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isfonts.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  bitmap-path             pic x(256).

       77  h-image-icon            pic s9(9) comp-4.
       77  h-font-icon             pic s9(9) comp-4.
       77  h-font                  handle of font.

       77  font-name               pic x any length.
       77  icon-characters         pic n any length.

       77  character-1-hex         pic x(4).
       77  character-2-hex         pic x(4).
       77  character-3-hex         pic x(4).
       77  old-character-1-hex     pic x(4).
       77  old-character-2-hex     pic x(4).
       77  old-character-3-hex     pic x(4).

       77  color-1-hex             pic x(6).
       77  color-2-hex             pic x(6).
       77  color-3-hex             pic x(6).
       77  old-color-1-hex         pic x(6).
       77  old-color-2-hex         pic x(6).
       77  old-color-3-hex         pic x(6).

       77  character-1-n           pic n(1).
       77  character-1-red         pic x(2) comp-x 
                                            redefines character-1-n.

       77  character-2-n           pic n(1).
       77  character-2-red         pic x(2) comp-x 
                                            redefines character-2-n.

       77  character-3-n           pic n(1).
       77  character-3-red         pic x(2) comp-x 
                                            redefines character-3-n.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       77  icon-color              pic s9(9) value -4804695.

       77  rb-type                 pic 9 value 1.
           88 load-symbol          value 1.
           88 load-symbol-ex       value 2.
       77  e-color                 pic 9 value 0.

       01  wrk-color-hex.
           03  wrk-hex-r   pic xx.
           03  wrk-hex-g   pic xx.
           03  wrk-hex-b   pic xx.
       77  wrk-color       pic s9(9).

       01  wrk-buffer-rgb.
           03  wrk-r       pic 999.
           03  wrk-g       pic 999.
           03  wrk-b       pic 999.

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              line                       1
              col                        2
              size                       68
              lines                      4.5
              title                      "Icon from strip image file"
              .
           03 ef-image
              entry-field
              line                       3
              col                        4
              lines                      1.8 cells
              size                       19 cells
              bitmap-handle              h-image-icon
              bitmap-width               16
              bitmap-number              1
              bitmap-trailing-number     2
              .
           03 pb-image
              push-button
              line                       3
              col                        26
              lines                      1.8 cells
              size                       19 cells
              bitmap-handle              h-image-icon
              bitmap-width               16
              title-position             2
              title                      "Change image"
              bitmap-number              3
              exception-value            101
              .
           03 label
              line                       2.7
              lines                      2
              col                        47
              size                       20
              title                      "Works best with strip images"
                                       & " with 16x16 frame"
              .
           03 frame
              engraved
              line                       6
              col                        2
              size                       68
              lines                      13.5
              title                      "Icon from font file"
              .
           03 radio-button 
              line                       8
              col                        4
              title                      "WBITMAP-LOAD-SYMBOL-FONT"
              group                      1
              group-value                1
              value                      rb-type
              exception-value            105
              . 
           03 radio-button 
              line                       8
              col                        37
              title                      "WBITMAP-LOAD-SYMBOL-FONT-EX"
              group                      1
              group-value                2
              value                      rb-type
              exception-value            105
              . 
           03 label
              line                       9.5
              lines                      1.2
              col                        4
              size                       30 cells
              transparent
              title                      "Hex value of charactres "
                                       & "to render"
              .
           03 label
              line                       11
              lines                      1.2
              col                        4
              title                      "Icon 1"
              .
           03 ef-charcter-1
              entry-field
              line                       11
              col                        10
              size                       8 cells
              value                      character-1-hex
              format-string              "HHHH"
              after                      AFT-EF-CHARACTER 
              .
           03 label
              line                       11
              col                        25
              title                      "Icon 2"
              .
           03 ef-charcter-2
              entry-field
              line                       11
              col                        31
              size                       8 cells
              value                      character-2-hex
              format-string              "HHHH"
              after                      AFT-EF-CHARACTER 
              .
           03 label
              line                       11
              col                        45
              title                      "Icon 3"
              .
           03 ef-charcter-3
              entry-field
              line                       11
              col                        51
              size                       8 cells
              value                      character-3-hex
              format-string              "HHHH"
              after                      AFT-EF-CHARACTER 
              .
           03 label
              line                       13
              lines                      1.2
              col                        4
              size                       30 cells
              transparent
              title                      "Hex value of "
                                       & "color to render"
              .
           03 label
              line                       14.5
              lines                      1.2
              col                        4
              title                      "Color 1"
              .
           03 ef-color-1
              entry-field
              line                       14.5
              col                        10
              size                       8 cells
              value                      color-1-hex
              format-string              "HHHHHH"
              enabled                    e-color 
              after                      AFT-EF-CHARACTER
              .
           03 label
              line                       14.5
              col                        25
              title                      "Color 2"
              .
           03 ef-color-2
              entry-field
              line                       14.5
              col                        31
              size                       8 cells
              value                      color-2-hex
              format-string              "HHHHHH"
              enabled                    e-color 
              after                      AFT-EF-CHARACTER 
              .
           03 label
              line                       14.5
              col                        45
              title                      "Color 3"
              .
           03 ef-color-3
              entry-field
              line                       14.5
              col                        51
              size                       8 cells
              value                      color-3-hex
              format-string              "HHHHHH"
              after                      AFT-EF-CHARACTER 
              enabled                    e-color 
              .
           03 label
              line                       16.8
              lines                      1.2
              col                        47
              title                      "Used font: "
              .
           03 lbl-font-name
              label
              line                       17.8
              lines                      1.2
              col                        47
              title                      font-name
              .
           03 ef-font 
              entry-field
              line                       17
              col                        4
              size                       19 cells
              lines                      1.8 cells
              bitmap-handle              h-font-icon
              bitmap-width               16
              bitmap-number              1
              bitmap-trailing-number     2
              .
           03 pb-font
              push-button
              line                       17
              col                        26
              lines                      1.8 cells
              size                       19 cells
              bitmap-handle              h-font-icon
              bitmap-width               16
              title-position             2
              title                      "Change font"
              bitmap-number              3
              exception-value            102
              .
           03 push-button
              line                       20
              col                        2
              size                       20 cells
              title                      "View &Source [F2]"
              exception-value            2
              .
           03 Pb-exit  
              push-button
              line                       20
              col                        62 
              size                       8 cells
              title                      "Exit" 
              exception-value            27
              .
       PROCEDURE DIVISION.
       MAIN.
           accept base-sorg-path from environment "home_source".

           call "w$createfont" 
                       using "files/Font Awesome 6 Free-Solid-900.otf" 
                             font-name

           call "W$BITMAP" using wbitmap-load, "files/tools.gif"
                          giving h-image-icon.

           move "f002"    to character-1-hex
                             old-character-1-hex
           move "f891"    to character-2-hex
                             old-character-2-hex
           move "f031"    to character-3-hex
                             old-character-3-hex

           move "495057"  to color-1-hex
           move "D05057"  to color-2-hex
           move "D0A116"  to color-3-hex

           perform LOAD-FONT-FROM-NAME
           perform LOAD-ICON-FROM-FONT

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$BITMAP Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           perform DESTROY-BITMAP.
           call "W$BITMAP" using wbitmap-destroy, h-image-icon
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 2
                perform VIEW-SORG
           when 101
                perform CHANGE-IMAGE
           when 102
                perform CHANGE-FONT
           when 105
                perform SWITCH-TYPE
           end-evaluate
           .

       LOAD-FONT-FROM-NAME.
           if function handle-type (h-font) = handle-of-font
              destroy h-font
           end-if

           initialize wfont-data
           set wfdevice-console to true
           move font-name       to wfont-name
           move 10              to wfont-size
           CALL "W$FONT" using wfont-get-font
                               h-font
                               wfont-data
           .

       CHANGE-FONT.
           initialize wfont-data
           set wfdevice-console to true
           move font-name       to wfont-name
           move 10              to wfont-size
           CALL "W$FONT" using wfont-choose-font
                               h-font
                               wfont-data

           if return-code     = 1 and 
              wfont-name  not = font-name 
              move wfont-name   to font-name
              modify lbl-font-name title font-name
              perform LOAD-FONT-FROM-NAME 
              perform LOAD-ICON-FROM-FONT
              modify ef-font bitmap-handle h-font-icon 
              modify pb-font bitmap-handle h-font-icon
           end-if
           .

       LOAD-ICON-FROM-FONT.
           if function handle-type (h-font-icon) = handle-of-bitmap
              call "W$BITMAP" using wbitmap-destroy, h-font-icon
           end-if.

           move function hex2dec(character-1-hex) to character-1-red
           move function hex2dec(character-2-hex) to character-2-red
           move function hex2dec(character-3-hex) to character-3-red

           initialize icon-characters 
           string character-1-n delimited by space 
                  character-2-n delimited by space 
                  character-3-n delimited by space 
                  into icon-characters.

           evaluate true
           when load-symbol 
                CALL "W$BITMAP" using wbitmap-load-symbol-font, 
                                      h-font
                                      icon-characters
                                      16
                                      icon-color
                               giving h-font-icon
           when load-symbol-ex 
                initialize wbitmap-lsf-data
       
                move h-font        to wbitmap-lsf-font(1)
                move character-1-n to wbitmap-lsf-characters(1)
                move color-1-hex   to wrk-color-hex
                perform CALCULATE-COLOR
                move wrk-color     to wbitmap-lsf-color(1)

                move h-font        to wbitmap-lsf-font(2)
                move character-2-n to wbitmap-lsf-characters(2)
                move color-2-hex   to wrk-color-hex
                perform CALCULATE-COLOR
                move wrk-color     to wbitmap-lsf-color(2)

                move h-font        to wbitmap-lsf-font(3)
                move character-3-n to wbitmap-lsf-characters(3)
                move color-3-hex   to wrk-color-hex
                perform CALCULATE-COLOR
                move wrk-color  to wbitmap-lsf-color(3)

                call "W$BITMAP" using wbitmap-load-symbol-font-ex
                                      16
                                      wbitmap-lsf-data
                               giving h-font-icon
           end-evaluate
           .

       CALCULATE-COLOR.
           move function hex2dec(wrk-hex-r) to wrk-r.
           move function hex2dec(wrk-hex-g) to wrk-g.
           move function hex2dec(wrk-hex-b) to wrk-b.

           compute wrk-color = (wrk-r  * 65536 + 
                                wrk-g  * 256   + 
                                wrk-b) * -1
           .

       SWITCH-TYPE.
           evaluate true
           when load-symbol 
                move 0                 to e-color
           when load-symbol-ex
                move 1                 to e-color
           end-evaluate

           modify ef-color-1 ENABLED e-color
           modify ef-color-2 ENABLED e-color
           modify ef-color-3 ENABLED e-color

           perform LOAD-ICON-FROM-FONT
           
           modify ef-font BITMAP-HANDLE h-font-icon 
           modify pb-font BITMAP-HANDLE h-font-icon
           .

       DESTROY-BITMAP.
           if function handle-type (h-image-icon) = handle-of-bitmap
              call "W$BITMAP" using wbitmap-destroy, h-image-icon
           end-if.

       CHANGE-IMAGE.
           initialize opensave-data

           string "BMP Files (*.bmp)|*.bmp|"
                  "JPG Files (*.jpg)|*.jpg|"
                  "GIF Files (*.gif)|*.gif|"
                  "PNG Files (*.png)|*.png|"
                  "All images (*.bmp;*.jpg;*.gif;*.png)|"
                  "*.bmp;*.jpg;*.gif;*.png"
                  delimited by size
                  into opnsav-filters.

           move 5   to opnsav-default-filter

           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data

           if return-code not < 0
              move opnsav-filename to bitmap-path
              perform SHOW-IMAGE
           end-if
           .

       SHOW-IMAGE.
           perform DESTROY-BITMAP

           call "W$BITMAP" using wbitmap-load, 
                                 bitmap-path
                          giving h-image-icon

           evaluate h-image-icon
           when -1
                display message "File not found or not readable"
                                icon mb-error-icon
           when -2
                display message "Out of memory loading the bitmap"
                                icon mb-error-icon
           when -3
                display message "Not a valid bitmap"
                                icon mb-error-icon
           when -4
                display message "Format not supported"
                                icon mb-error-icon
           end-evaluate

           modify ef-image bitmap-handle h-image-icon
           modify pb-image bitmap-handle h-image-icon
           .

       AFT-EF-CHARACTER.
           if character-1-hex not = old-character-1-hex or 
              character-2-hex not = old-character-2-hex or 
              character-3-hex not = old-character-3-hex or 
              color-1-hex     not =  old-color-1-hex or
              color-2-hex     not =  old-color-2-hex or
              color-3-hex     not =  old-color-3-hex

              move character-1-hex to old-character-1-hex
              move character-2-hex to old-character-2-hex 
              move character-3-hex to old-character-3-hex

              move color-1-hex to old-color-1-hex
              move color-2-hex to old-color-2-hex 
              move color-3-hex to old-color-3-hex

              perform LOAD-ICON-FROM-FONT

              modify ef-font BITMAP-HANDLE h-font-icon 
              modify pb-font BITMAP-HANDLE h-font-icon
           end-if.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path      delimited by trailing space
                  "s-routines"        delimited by space
                  "/WBITMAP-ICON.cbl" delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
