      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.  WTEXTSIZ.

       WORKING-STORAGE SECTION.
       COPY "iscrt.def".
       COPY "isgui.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isfonts.def".
       
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  text-string             pic x any length.
       
       77  rb-value                pic 9.
       77  cb-font-value           pic x(15).
       77  e-cb-font               pic 9.
       77  e-pb-chose-font         pic 9.
       77  lb-font-title           pic x any length.
       77  h-font                  handle of font.
       77  font-size               pic zz9.

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              line                 1.5 
              col                  2
              lines                5 cells 
              size                 68 cells
              title                "Font selection"
              .
           03 radio-button 
              line                 3.2
              col                  3
              title                "Internal font"
              group                1
              group-value          1 
              value                rb-value
              exception-value      100
              . 
           03 cb-font 
              combo-box 
              drop-list 
              line                 3
              col                  18 
              size                 15 cells
              Notify-Selchange
              value                cb-font-value
              item-to-add         ("Fixed", "Traditional", "Default",
                                   "Small", "Medium", "Large")
              enabled              e-cb-font
              event                EVENT-COMBO
              .
           03 radio-button 
              line                 3.2
              col                  38
              title                "Other font"
              group                1
              group-value          2
              value                rb-value
              exception-value      100
              . 
           03 pb-chose-font  
              push-button
              line                 3
              col                  52
              size                 15 cells
              title                "Change Font"
              enabled              e-pb-chose-font
              exception-value      101
              .
           03 label 
              line                 5
              col                  6
              title                "Chosen Font:"
              .
           03 lb-font
              label 
              line                 5
              col                  + 2
              title                lb-font-title
              .
           03 frame
              engraved
              line                 7.5 
              col                  2
              lines                5 cells 
              size                 68 cells
              title                "String"
              .
           03 ef-string
              entry-field 
              line                 9
              lines                2
              col                  3
              size                 64
              value                text-string 
              notify-change
              font                 h-font
              event                MEASURE-STRING
              .
           03 frame
              engraved
              line                 13.5
              col                  2
              lines                6 cells 
              size                 68 cells
              title                "W$TEXTSIZE result"
              .
           03 text-size-info.
              05 label             
                 line              15 
                 col               3
                 title             "Width in cells: "  
                 .
              05 label
                 line              15  
                 col               22
                 title             textsize-cells-x 
                 pic               z(6)9.99
                 .
              05 label
                 line              17
                 col               3 
                 title             "Height in cells: "
                 .
              05 label 
                 line              17  
                 col               22 
                 title             textsize-cells-y   
                 pic               z(6)9.99
                 .
              05 label  
                 line              15 
                 col               40
                 title             "Width in pixels: " 
                 .
              05 label  
                 line              15  
                 col               59
                 from              textsize-base-x   
                 pic               z(7)9
                 .                  
              05 label 
                 line              17  
                 col               40
                 title             "Height in pixels: "
                 .
              05 label  
                 line              17 
                 col               59 
                 title             textsize-base-y
                 pic               z(7)9
                 .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

           
       PROCEDURE DIVISION.
       INI.
           set h-font     to small-font
           move "Small"   to cb-font-value
           move 1         to rb-value
           move 1         to e-cb-font
           move 0         to e-pb-chose-font
           initialize textsize-data.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$TEXTSIZE Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask
           
           perform UPDATE-FONT-DESCRIPTION
           
           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       CALL-TEXT-SIZE.
           move hWin   to textsize-window
           move h-font to textsize-font
           set textsize-strip-spaces to true
           inquire ef-string value in text-string
           call "W$TEXTSIZE" using text-string, 
                                   textsize-data
           display text-size-info.

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 100
                if rb-value = 1
                   move 1 to e-cb-font
                   move 0 to e-pb-chose-font
                   inquire cb-font VALUE cb-font-value 
                   perform UPDATE-FONT-DESCRIPTION
                   perform MEASURE-STRING
                else
                   move 0 to e-cb-font
                   move 1 to e-pb-chose-font
                   perform CHOOSE-FONT
                end-if
                modify cb-font        enabled e-cb-font 
                modify pb-chose-font  enabled e-pb-chose-font 
           when 101
                perform CHOOSE-FONT 
           end-evaluate
           .

       MEASURE-STRING.
           if event-type = ntf-changed
              perform CALL-TEXT-SIZE
              set event-action to event-action-continue
           end-if
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       EVENT-COMBO.
           if event-type = NTF-SELCHANGE
              inquire cb-font VALUE cb-font-value 
              perform UPDATE-FONT-DESCRIPTION
              perform CALL-TEXT-SIZE
           end-if
           .

       UPDATE-FONT-DESCRIPTION.
           if rb-value = 1
              evaluate cb-font-value
              when "Fixed"
                   move "Fixed"       to lb-font-title
                   set h-font         to fixed-font
              when "Traditional"
                   move "Traditional" to lb-font-title
                   set h-font         to traditional-font
              when "Default"
                   move "Default"     to lb-font-title
                   set h-font         to default-font
              when "Small"
                   move "Small"       to lb-font-title
                   set h-font         to small-font
              when "Medium"
                   move "Medium"      to lb-font-title
                   set h-font         to medium-font
              when "Large"
                   move "Large"       to lb-font-title
                   set h-font         to large-font
              end-evaluate
           else
              initialize lb-font-title
              move wfont-size   to font-size
              string wfont-name delimited by trailing space
                     " "        delimited by size
                     font-size  delimited by size
                     into lb-font-title
              if wfont-bold
                 string lb-font-title delimited by trailing space
                        ", Bold"      delimited by size
                        into lb-font-title
              end-if

              if wfont-italic
                 string lb-font-title delimited by trailing space
                        ", Italic"    delimited by size
                        into lb-font-title
              end-if

              if wfont-underline
                 string lb-font-title delimited by trailing space
                        ", Underline" delimited by size
                        into lb-font-title
              end-if

              if wfont-strikeout
                 string lb-font-title delimited by trailing space
                        ", Strikeout" delimited by size
                        into lb-font-title
              end-if

           end-if.
           modify lb-font title lb-font-title
           modify ef-string font h-font 
           .
       
       CHOOSE-FONT.
           if function handle-type (h-font) = handle-of-font
              destroy h-font
           end-if
      *
           initialize wfont-data
           call "W$FONT" using wfont-choose-font
                               h-font
                               wfont-data

           call "W$FONT" using wfont-get-font
                               h-font
                               wfont-data
           .       
           perform UPDATE-FONT-DESCRIPTION
           perform CALL-TEXT-SIZE.
           