      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       IDENTIFICATION DIVISION.
       PROGRAM-ID. printcsv.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscobol.def".
       copy "iscrt.def".
       copy "isfonts.def".
       copy "isresize.def".
       copy "PRINT-CSV.lnk".

       77  crt-status is special-names crt status pic 9(5).
       77  hWin          handle of window.
       77  control-font  handle of font.
       77  close-win     pic 9 value 0.
       77  e-printer     pic 9.
       77  e-preview     pic 9.

       screen section.
       01  mask.
           03 S-PARAMETER 
              Entry-Field
              line 3
              column 24
              size 50 cells 
              max-text 50
              value STRING-PARAMETERS
              .
           03 pb-pdf  
              Push-Button
              exception-value 101
              line 6
              column 2
              size 20 cells 
              lines 2.5 cells 
              title "Print fo Pdf"
              .
           03 pb-printer 
              Push-Button
              exception-value 102
              line 6
              column 28
              size 20 cells 
              lines 2.5 cells 
              enabled e-printer
              title "Printer"
              .
           03 pb-preview 
              Push-Button
              exception-value 103
              line 6
              column 54
              size 20 cells 
              lines 2.5 cells 
              enabled e-preview
              title "Preview"
              .
           03 pb-exit 
              Push-Button
              exception-value 27
              line 9
              column 54
              size 20 cells 
              lines 2.5 cells 
              title "exit"
              .
           03 Label
              line 3
              column 3
              title "String Parameter"
              .

       PROCEDURE DIVISION.
       main-logic.

           accept terminal-abilities from terminal-info.
           move 1       to e-printer
                           e-preview

           if is-remote
              call client "C$FORNAME" using 
                   "com.veryant.javabeans.jasperreport.ReportViewer"
                                       giving return-code
              if return-code = 0
                 call client "C$FORNAME" using 
                       "net.sf.jasperreports.engine.JasperReport"
                                       giving return-code
              end-if
              if return-code not = 0
                 move 0  to e-printer
                            e-preview
              end-if
           end-if

           move "This string is received from the Cobol program"
                                                 to string-parameters

           call "J$GETFROMLAF" using jget-laf-font
                                     "Label.font" 
                                     control-font

           display standard graphical window 
                   background-low  
                   title "isCOBOL - Print CSV file with Jasper"
                   lines 11
                   min-lines 11
                   size 75
                   min-size 75
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT
                   .

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 101
                perform CREATE-PDF
           when 102
                perform PRINT-THE-REPORT
           when 103
                perform REPORT-PREVIEW
           end-evaluate
           .

       CREATE-PDF.
           set to-pdf      to true.
           perform CALL-PRINT
           .

       PRINT-THE-REPORT.
           set to-printer  to true.
           perform CALL-PRINT
           .

       REPORT-PREVIEW.
           set to-preview  to true.
           perform CALL-PRINT
           .

       CALL-PRINT.
           inquire s-parameter value string-parameters.

           if (to-preview and is-remote) or
              (to-printer and is-remote) 
              call "print-csv-data-client" using kind-of-print
                                                 string-parameters
           else
              call "print-csv-data" using kind-of-print
                                          string-parameters
           end-if.
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .
