      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. Customer.

       WORKING-STORAGE SECTION.
       COPY "constants.def".
       COPY "customer.wrk".
       COPY "customer.wrk" replacing 
                                 leading "Customer" by "Customer-back"
                                 leading "Cust" by "Cust-back".
       COPY "state.wrk".
       77  key-status is special-names crt status pic 999.
       77  w-key                pic 9(5).
       77  w-key-ed             pic zz,zz9 blank when zero.
       77  sub-customer         pic x(10).
       77  sub1                 pic x(10).
       77  idx1                 pic 99.
       77  idx2                 pic 99.
       77  idx3                 pic 99.
       77  varx3                pic xxx.
       01  w-table.
           03 w-record          occurs 10.
              05 w-code         pic x(6).
              05 filler         pic xx.
              05 w-first-name   pic x(30).
              05 filler         pic xx.
              05 w-last-name    pic x(30).

       01                       pic 9.
           88 check-ok          value 0 false 1.
       77  err-message          pic x(60).

       SCREEN SECTION.
       01  s1.
           03 "Customer code:"        line 3 col 2.
           03 using cust-code         col + 2 high prompt.
           03 "First name: "          line 4 col 2.
           03 using Cust-First-Name   col + 2 high prompt.
           03 "Last name:"            line 5 col 2.
           03 using Cust-Last-Name    col + 2 high prompt.
           03 "Address:"              line 7 col 2.
           03 "Street:"               line 8 col 2.
           03 using Cust-Street       col + 2 high prompt.
           03 "City:"                 col 50.
           03 using Cust-City         col + 2 high prompt.
           03 " State:"               line 9 col 2.
           03 using Cust-State        col + 2 high prompt
                                      after CHECK-STATE.
           03 from State-Description  col + 2.
           03 "Zip code:"             col 50.
           03 using Cust-Zip          col + 2 high prompt.
           03 "Gender:"               line 11 col 2.
           03 using Cust-Gender       col + 2 high prompt.
           03 "Phone number:     "    line 13 col 2.
           03 using Cust-Phone        col + 2 high prompt.
           03 "Cell Phone number:"    line 14 col 2.
           03 using Cust-CellPhone    col + 2 high prompt.

       01  s-func.
           03 "F1=Lookup"             line 21 col 2 reverse.
           03 "F2=Lookup State"       col + 2 reverse.
           03 "F3=Del"                col + 2 reverse.
           03 "F5=First"              col + 2 reverse.
           03 "F6=Prev"               col + 2 reverse.
           03 "F7=Next"               col + 2 reverse.
           03 "F8=Last"               col + 2 reverse.
           03 "F9=Save"               col + 2 reverse.
           03 "F10=Print"             Line 23 col 2 reverse.
           03 "ESC=Exit"              col + 2 reverse.

       01  s-lookup.
           03 "<Code>"                line 1 col 3.
           03 "<First name>"          col + 2.
           03 "<Second name>"         col + 19.
           03 from W-RECORD(1)        line + 1 col 3.
           03 from W-RECORD(2)        line + 1 col 3.
           03 from W-RECORD(3)        line + 1 col 3.
           03 from W-RECORD(4)        line + 1 col 3.
           03 from W-RECORD(5)        line + 1 col 3.
           03 from W-RECORD(6)        line + 1 col 3.
           03 from W-RECORD(7)        line + 1 col 3.
           03 from W-RECORD(8)        line + 1 col 3.
           03 from W-RECORD(9)        line + 1 col 3.
           03 from W-RECORD(10)       line + 1 col 3.
           03 
            "Select customer and press <ENTER> or press <ESC> to cancel" 
                                      line 13 col 3.

       PROCEDURE DIVISION.
       MAIN.
           call "PCUSTOMER" using 78-open-i-o
           call "PSTATE"    using 78-open-input

           display subwindow line 1 col 1 size 80 lines 25 erase screen
                   pop-up area sub-customer

           display box title "CUSTOMER MAINTENANCE"
                   line 2 col 1 size 80 lines 18.
           display s1.
           display box line 20 col 1 size 80 lines 5.
           display s-func.

           perform until key-status = 27
              accept s1 
                 on exception 
                    continue 
              end-accept
              evaluate key-status
              when 1
                   perform LOOKUP
              when 2
                   perform LOOKUP-STATE
              when 3
                   perform REC-DELETE
              when 5
                   perform REC-FIRST
              when 6
                   perform REC-PREV
              when 7
                   perform REC-NEXT
              when 8
                   perform REC-LAST
              when 9
                   perform REC-SAVE
              when 10
                   perform PRINT-REPORT
              end-evaluate
           end-perform.
           call "PCUSTOMER" using 78-close
           call "PSTATE"    using 78-close
           close window sub-customer

           goback.
       
       REC-FIRST.
           move low-value to w-key(1:)
           call "PCUSTOMER" using 78-start-great, w-key
           call "PCUSTOMER" using 78-read-next, customer-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              perform RESET-ERROR
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, state-rec
              display S1
           end-if.

       REC-PREV.  
           call "PCUSTOMER" using 78-read-prev, customer-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              perform RESET-ERROR
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, state-rec
              display S1
           end-if.

       REC-NEXT.  
           call "PCUSTOMER" using 78-read-next, customer-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              perform RESET-ERROR
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, state-rec
              display S1
           end-if.

       REC-LAST.  
           move high-value to w-key
           call "PCUSTOMER" using 78-start-less, w-key
           call "PCUSTOMER" using 78-read-next, customer-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              perform RESET-ERROR
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, state-rec
              display S1
           end-if.

       REC-DELETE.
           display 
             "ARE YOU SURE YOU WANT TO DELETE THIS RECORD? (YES/NO)"  
             at 2501
           accept varx3 upper at 2577.
           display omitted erase eol line 25.
           
           if varx3 = "YES" or "Y"
              call "PCUSTOMER" using 78-delete, cust-code
              if return-code > 9
                 perform SHOW-FILE-ERROR
              else
                 initialize customer-rec
                 initialize state-rec
                 display s1
              end-if
           end-if.

       REC-SAVE.
           perform CHECK-FIELDS.
           if check-ok
              call "PCUSTOMER" using 78-write, customer-rec
              if return-code = 22
                 call "PCUSTOMER" using 78-rewrite, customer-rec
                 if return-code > 9
                    perform SHOW-FILE-ERROR
                 end-if
              end-if
           end-if
           .

       CHECK-FIELDS.
           set check-ok   to true.

           if cust-Code = 0
              move "CUSTOMER CODE MANDATORY"  to err-message
              perform SHOW-ERROR
              set check-ok   to false
           end-if

           if check-ok 
              if Cust-First-Name = space and 
                 Cust-Last-Name = space
                 move "CUSTOMER NAME MANDATORY"  to err-message
                 perform SHOW-ERROR
                 set check-ok   to false
              end-if
           end-if
           
           if check-ok
              perform CHECK-STATE
           end-if.
           
           if check-ok
              display omitted erase eol line 25
           end-if
           display s1
           .

       CHECK-STATE.
           set check-ok   to true
           if Cust-State not = space
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, State-rec
              if return-code > 9
                 move "INVALID STATE CODE"  to err-message
                 perform SHOW-ERROR
                 move space  to State-Description
                 set check-ok   to false
              else
                 display omitted erase eol line 25
              end-if
              display s1
           end-if
           .

       PRINT-REPORT.
           call "PCustomer" using 78-close.
           display omitted erase eol           line 25.
           display "Print in progress... "     at 2502
           call "PRINTCUSTOMER".
           call "PCustomer" using 78-open-i-o.
           call "PCustomer" using 78-read, customer-rec.
           display omitted erase eol           line 25.
           display "Printing completed"        at 2502.


       SHOW-ERROR.
           display omitted erase eol           line 25.
           display "Error: "                   at 2501
           display err-message                 at 2510
           .

       SHOW-FILE-ERROR.
           display omitted erase eol           line 25.
           display "Error: "                   at 2501
           if return-code = 10
              display "NO MORE RECORDS" high   at 2510
           else
              display return-code high         at 2510
           end-if
           display "Press Enter to continue"   at 2540
           accept omitted at 2578
              on exception
                 continue
           end-accept.
           display omitted erase eol line 25.

       RESET-ERROR.
           display omitted erase eol line 25.

       LOOKUP.
           move customer-rec to customer-back-rec
           initialize w-table
           display subwindow line 4 col 4 size 74 lines 13 erase screen
                   boxed title "CUSTOMER LOOKUP" pop-up area sub1
           move low-value to w-key
           call "PCUSTOMER" using 78-start-great, w-key
           perform LOAD-TABLE
           move 1 to idx1
           display omitted, line idx1 + 1, pos 1, size 74, reverse
           perform until key-status = 27 or 13
              accept omitted line idx1 + 1, col 1
                 on exception perform LOOKUP-EXCEPTION
              end-accept
              display omitted, line idx1 + 1 pos 1, size 74 reverse
           end-perform
           close window sub1
           if key-status = 13
              move w-code(idx1) to cust-code
              call "PCUSTOMER" using 78-read, customer-rec
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, state-rec
           else
              move Cust-back-Code         to Cust-Code
              call "PCUSTOMER" using 78-read, customer-rec
              move customer-back-rec to customer-rec
           end-if
           display s1
           move 0 to key-status
           .

       LOOKUP-STATE.
           call "LOOKUP-STATE" using state-rec
           move state-Code   to Cust-State
           display s1
           .

       LOOKUP-EXCEPTION.
           display omitted, line idx1 + 1 pos 1, size 74.
           evaluate key-status
           when 52 |UP
                subtract 1 from idx1
                if idx1 < 1
                   move 1 to idx1
                   move w-code(idx1) to w-key with convert
                   call "PCUSTOMER" using 78-start-less, w-key
                   if return-code not > 9
                      call "PCUSTOMER" using 78-read-prev, customer-rec
                      if return-code not > 9
                         perform SHIFT-TABLE-UP
                         perform MOVE-CUST-TO-W
                         display s-lookup
                     end-if
                   end-if
                end-if
           when 53 |DOWN
                add 1 to idx1
                if idx1 > 10
                   move 10 to idx1
                   move w-code(idx1) to w-key with convert
                   call "PCUSTOMER" using 78-start-great, w-key
                   if return-code not > 9
                      call "PCUSTOMER" using 78-read-next, customer-rec
                      if return-code not > 9
                         perform SHIFT-TABLE-DOWN
                         perform MOVE-CUST-TO-W
                         display s-lookup
                      end-if
                   end-if
                else
                   if w-code(idx1) = spaces
                      subtract 1 from idx1
                   end-if
                end-if
           end-evaluate.

       MOVE-CUST-TO-W.
           move cust-code       to w-key-ed
           move w-key-ed        to w-code(idx1).
           move cust-first-name to w-first-name(idx1).
           move cust-last-name  to w-last-name(idx1).

       LOAD-TABLE.
           perform varying idx1 from 1 by 1 until idx1 > 10
              call "PCUSTOMER" using 78-read-next, customer-rec
              if return-code > 9
                 exit perform
              else
                 perform MOVE-CUST-TO-W
              end-if
           end-perform
           subtract 1 from idx1
           display s-lookup
           .

       SHIFT-TABLE-DOWN.
           perform varying idx2 from 2 by 1 until idx2 > 10
              compute idx3 = idx2 - 1
              move w-record(idx2) to w-record(idx3)
           end-perform.

       SHIFT-TABLE-UP.
           perform varying idx2 from 9 by -1 until idx2 < 1
              compute idx3 = idx2 + 1
              move w-record(idx2) to w-record(idx3)
           end-perform.

