      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
      
       PROGRAM-ID. PRINTCUSTOMER.
       configuration section.
       special-names.   
      
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select print-f assign to print print-env
                      organization is line sequential
                      file status status-print-f.

       DATA DIVISION.
       FILE SECTION.
       fd  print-f.
       01  p-row pic x(88).

       WORKING-STORAGE SECTION.

       copy "constants.def".
       copy "customer.wrk".
       copy "isfonts.def".
       copy "isgui.def".
       copy "iscrt.def".

       copy "isopensave.def".
       copy "isprint.def".

       77  key-status is special-names crt status pic 9(4).

       77  h-main                  handle of window.

       77  status-print-f          pic xx.
       
       77  print-env               pic x(256).
       77  opensave-status         pic s9.

       01  screen-value.
           05 scr-print-mode       pic 9 value 1.
              88 scr-preview       value 1.
              88 scr-pdf           value 2.
              88 scr-print         value 3.
           05 scr-pdf-name         pic x(256).

       01                          pic 9.
           88 first-record         value 1 false zero.

       01  header-row.
           05 filler               pic x(1) value space.
           05 hr-title             pic x(80).
           05 filler               pic x(5) value "Page ".
           05 hr-page              pic z9.

       01  detail-row.
           05 filler               pic x(1) value space.
           05 dr-cust-code         pic z(4).
           05 filler               pic x(1) value space.
           05 dr-Cust-First-Name   pic x(15).
           05 filler               pic x(1) value space.
           05 dr-Cust-Last-Name    pic x(15).
           05 filler               pic x(1) value space.
           05 dr-Cust-Street       pic x(30).
           05 filler               pic x(1) value space.
           05 dr-cust-city         pic x(20).

       77  prz-ed                  pic zzz.zz9,99.
       77  call-result             signed-int.
       77  num-row                 pic 9(3).
       78  78-page-rows            value 50.
       77  num-pag                 pic 99 value zero.
       77  cont                    pic 9(3).
 
       77  h-font-print            usage handle of font.
 
       screen section.
       01  mask-main.
           05 Radio-Button 
              col 3
              line 2
              size 12  
              group 1
              group-value 1
              value scr-print-mode
              height-in-cells
              width-in-cells
              title "Preview"
              event DISABLE-PDF
              .
           05 Radio-Button 
              col 3
              line 4 
              size 10   
              group 1
              group-value 2
              value scr-print-mode
              height-in-cells
              title "Pdf"
              event ENABLE-PDF
              .
           05 ef-scr-pdf-name
              entry-field
              col + 2
              line 4 
              size 40 
              height-in-cells
              width-in-cells
              max-text 256
              enabled 0
              value scr-pdf-name
              after AFT-PDF-NAME
              .
           05 pb-sel-pdf 
              push-button
              title "..."
              line 4, 
              col + 1.5
              size 3
              height-in-cells
              width-in-cells
              enabled 0
              exception-value 2001
              .
           05 Radio-Button 
              col 3
              line 6
              lines 2
              size 10
              group 1
              group-value 3
              value scr-print-mode
              height-in-cells
              width-in-cells
              title "Printer"
              event DISABLE-PDF
              .
           05 push-button
              title "&Print"
              line 8 
              col 3
              size 8
              exception-value 2002
              .
           05 push-button
              title "&Exit"
              line 8 
              col 50
              size 8
              exception-value 27
              .

       PROCEDURE DIVISION.

       MAIN.
           perform OPEN-FILES.

           initialize screen-value.
           move 1   to scr-print-mode.

           display floating graphical window
                   background-low  
                   title  "PRINT CUSTOMER"
                   cell size is entry-field font 
                   size 60
                   lines 8.5
                   control font small-font
                   handle h-main

           display mask-main upon h-main

           modify h-main visible 1

           perform until key-status = 27
              accept mask-main
                 on exception 
                    continue
              end-accept
              perform AFTER-ACCEPT
              move 4   to accept-control
           end-perform
           
           perform EXIT-PRG.
           
           goback.

       AFTER-ACCEPT.
           evaluate key-status
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           when 2001
                perform SELECT-PDF-NAME
           when 2002
                perform PRINT-LIST
           end-evaluate.

       SELECT-PDF-NAME.
           initialize opensave-data
           move "pdf"            to opnsav-default-ext
           move "Save PDF file"  to opnsav-title
           
           move "Pdf files (*.pdf)|*.pdf|All files (*.*)|*.*"  
                                                  to opnsav-filters
           move 1 to opnsav-default-filter
           call "C$OPENSAVEBOX" using opensave-save-box-checked
                                      opensave-data
                               giving opensave-status
           if opensave-status > 0
              move opnsav-filename  to scr-pdf-name
              modify EF-SCR-PDF-NAME value scr-pdf-name
           end-if.

       PRINT-LIST.
           set first-record  to true
           move 200 to num-row
           move zero   to num-pag

           perform REC-FIRST

           if return-code > 9
              continue
           else
              perform until 1 = 2
                 perform REC-NEXT
                 if return-code > 9
                    exit perform
                 else
                    perform PRINT-RECORD
                    if call-result not = zero |first-record
                        exit perform
                    end-if
                 end-if
              end-perform
           end-if.

           if first-record
              display message box "No data to print"
                      icon mb-warning-icon 
           else
              if call-result = zero
                 close print-f
                 evaluate true
                 when scr-pdf
                      call client "C$EASYOPEN" using scr-pdf-name
                 when scr-print
                      display message box "Printing completed"
                 end-evaluate

              end-if
           end-if.

       REC-FIRST.
           move low-value to Cust-Code
           call "PCUSTOMER" using 78-start-great, Cust-Code
           call "PCUSTOMER" using 78-read-next, customer-rec.

       REC-NEXT.  
           call "PCUSTOMER" using 78-read-next, customer-rec
           .

       PRINT-RECORD.
           if first-record
              perform OPEN-PRINT
              if call-result < zero
                 set first-record  to false
              end-if
           end-if
           
           if call-result = zero
              if num-row > 78-page-rows
                 perform PRINT-HEADER
              end-if
           
              set first-record        to false
              move cust-code          to dr-cust-code
              move Cust-First-Name    to dr-Cust-First-Name
              move Cust-Last-Name     to dr-Cust-Last-Name
              move Cust-Street        to dr-Cust-Street
              move cust-city          to dr-cust-city

              write p-row from detail-row
              add 1 to num-row
           end-if.

       OPEN-PRINT.
           initialize print-env
           move zero   to call-result
           evaluate true
           when scr-preview
                move "-P PREVIEW" to print-env
           when scr-pdf
                string "-P PDF "     delimited by size
                       scr-pdf-name  delimited by trailing space
                       into print-env
           when scr-print
                initialize winprint-selection
                call "WIN$PRINTER" using winprint-get-current-info
                                         winprint-selection
                if winprint-name = spaces
                   display message box "No printer on this machine"
                           icon mb-warning-icon 
                   move -1   to call-result
                end-if
                move "-P SPOOLER" to print-env
                call "WIN$PRINTER" using winprint-setup 
                                  giving call-result 
           end-evaluate.
           
           if call-result not < 0
      *    set the margins
              move 1  to wprtdata-top-margin
                         wprtdata-bottom-margin
                         wprtdata-left-margin
                         wprtdata-right-margin
              move wprtmargin-centimeters   to wprtdata-margin-units
              call "WIN$PRINTER" using winprint-set-margins
                                       winprint-data
                                giving call-result
           end-if
           
           if call-result not < 0
              open output print-f
      *      set the fixed font for the print
              move WPRTFONT-COURIER-10 to wprtdata-std-font
              call "WIN$PRINTER" using winprint-set-std-font 
                                       WINPRINT-DATA 
                                giving call-result
              move zero   to call-result
           end-if
           .

       PRINT-HEADER.
           if num-pag not = zero
              write p-row from space after page
           end-if
           
           set first-record     to false
           add 1                to num-pag
           move zero            to num-row
           
           move "Customer List" to hr-title
           move num-pag         to hr-page
           write p-row from header-row
           add 1                to num-row.
           
           initialize p-row
           move all "="         to p-row(2:).
           write p-row 
           add 1                to num-row.
           
           move "Code"          to dr-cust-code
           move "First Name"    to dr-Cust-First-Name
           move "Last Name"     to dr-Cust-Last-Name
           move "Address"       to dr-Cust-Street
           move "City"          to dr-cust-city

           write p-row from detail-row
           add 1                to num-row.
           
           initialize p-row
           move all "="         to p-row(2:).
           write p-row 
           add 1 to num-row.

       OPEN-FILES.
           call "PCUSTOMER" using 78-open-input.

       EXIT-PRG.
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           call "PCUSTOMER" using 78-close.

       DESTROY-RESOURCE.
           modify h-main visible 0
           destroy mask-main 
                   h-main 
           .

       ENABLE-PDF.
           evaluate event-type
           when cmd-clicked
                modify ef-scr-pdf-name enabled 1
                modify pb-sel-pdf enabled 1
           end-evaluate
           .
      
       DISABLE-PDF.
           evaluate event-type
           when cmd-clicked
                modify ef-scr-pdf-name  enabled 0
                modify pb-sel-pdf enabled 0
           end-evaluate
           .

       AFT-PDF-NAME.
           inquire EF-SCR-PDF-NAME value scr-pdf-name
           initialize cont
           inspect scr-pdf-name tallying cont for characters 
                                               before trailing space
           if cont < 4
              string scr-pdf-name  delimited by trailing space
                     ".pdf"        delimited by size
                     into scr-pdf-name
              modify EF-SCR-PDF-NAME value scr-pdf-name
           else
              subtract 3 from cont
              call "C$TOLOWER" using scr-pdf-name(cont:4)
              if scr-pdf-name(cont:4) not = ".pdf"
                 string scr-pdf-name  delimited by trailing space
                     ".pdf"        delimited by size
                     into scr-pdf-name
                     modify EF-SCR-PDF-NAME value scr-pdf-name
              end-if
           end-if
           .
