      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. PRINTCUSTOMER.
       configuration section.
       special-names.   

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select print-f assign to print print-env
                      organization is line sequential
                      file status status-print-f.

       DATA DIVISION.
       FILE SECTION.
       fd  print-f.
       01  p-row pic x(120).

       WORKING-STORAGE SECTION.

       copy "constants.def".
       copy "customer.wrk".
       copy "isfonts.def".
       copy "isgui.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "isprint.def".
       copy "image-handling.wrk".
       copy "font-handling.wrk".

       77  key-status is special-names crt status pic 9(4).

       77  h-main                  handle of window.
       77  h-tool                  handle of window.

       77  status-print-f          pic xx.
       
       77  print-env               pic x(256).
       77  opensave-status         pic s9.

       01  screen-value.
           05 scr-print-mode       pic 9 value 1.
              88 scr-preview       value 1.
              88 scr-pdf           value 2.
              88 scr-print         value 3.
           05 scr-pdf-name         pic x(256).

       01                          pic 9.
           88 first-record         value 1 false zero.

       01                          pic 9 value 0.
           88 print-error          value 1 false zero.

       01  detail-row.
           05 dr-cust-code         pic z(5).
           05 dr-cust-first-name   pic x(30).
           05 dr-cust-last-name    pic x(30).
           05 dr-cust-street       pic x(30).
           05 dr-cust-city         pic x(20).
           05 dr-cust-state        pic x(20).

       77  call-result             signed-int.
       77  num-row                 pic 9(3).
       78  78-page-rows            value 55.
       77  num-pag                 pic 99 value zero.
       77  cont                    pic 9(3).
 
       77  h-header-font           usage handle of font.
       77  h-body-font             usage handle of font.

       77  pic-company             pic s9(9) comp-4.

       screen section.
       01  mask-main.
           05 frame 
              engraved
              title                      "Output selection"
              line                       2
              col                        3
              lines                      7
              size                       67
              height-in-cells
              width-in-cells
              .
           05 Radio-Button 
              col                        5
              line                       3
              lines                      1.2
              size                       14
              group                      1
              group-value                1
              value                      scr-print-mode
              height-in-cells
              width-in-cells
              bitmap-width               78-tb-bmp-width
              bitmap-handle              h-tools
              bitmap-number              78-nb-preview
              bitmap-rollover            78-nb-rol-preview
              bitmap-pressed             78-nb-rol-preview
              bitmap-rollover-selected   78-nb-rol-preview
              title-position             2
              title                      "Preview"
              event                      DISABLE-PDF
              rollover-foreground-color  78-toolbar-rollover-color
              .
           05 Radio-Button 
              col                        5
              line                       5
              lines                      1.2
              size                       14
              group                      1
              group-value                2
              value                      scr-print-mode
              height-in-cells
              width-in-cells
              bitmap-width               78-tb-bmp-width
              bitmap-handle              h-tools
              bitmap-number              78-nb-pdf
              bitmap-rollover            78-nb-rol-pdf
              bitmap-pressed             78-nb-rol-pdf
              bitmap-rollover-selected   78-nb-rol-pdf
              title-position             2
              title                      "Pdf"
              event                      ENABLE-PDF
              rollover-foreground-color  78-toolbar-rollover-color
              .
           05 ef-scr-pdf-name
              entry-field
              col                        + 2
              line                       5
              size                       45 
              lines                      1.2 
              height-in-cells
              width-in-cells
              max-text                   256
              enabled                    0
              value                      scr-pdf-name
              after                      AFT-PDF-NAME
              .
           05 pb-sel-pdf 
              push-button
              title                      "..."
              line                       5
              col                        + 1.5
              size                       3
              lines                      1.2
              height-in-cells
              width-in-cells
              enabled                    0
              exception-value            2001
              .
           05 Radio-Button 
              col                        5
              line                       7
              lines                      1.2
              size                       14
              group                      1
              group-value                3
              value                      scr-print-mode
              height-in-cells
              width-in-cells
              bitmap-width               78-tb-bmp-width
              bitmap-handle              h-tools
              bitmap-number              78-nb-print
              bitmap-rollover            78-nb-rol-print
              bitmap-rollover-selected   78-nb-rol-print
              title-position             2
              title                      "Printer"
              event                      DISABLE-PDF
              rollover-foreground-color  78-toolbar-rollover-color
              .
           05 push-button
              title "&Run"
              line                       10 
              col                        3
              size                       8
              exception-value            2002
              rollover-foreground-color  78-toolbar-rollover-color
              .

       01  mask-tool.
           05 push-button 
              title                "&Exit"
              hint                 "(Esc)"
              bitmap-handle        h-tools
              bitmap-number        78-nb-exit
              bitmap-rollover      78-nb-rol-exit
              bitmap-pressed       78-nb-rol-exit
              title-position       2
              lines                2.2
              size                 12
              bitmap-width         78-tb-bmp-width
              col                  + 1.2
              exception-value      27
              self-act
              height-in-cells
              width-in-cells
              rollover-foreground-color     78-toolbar-rollover-color
              .

       PROCEDURE DIVISION.

       MAIN.
           perform OPEN-FILES.
           perform LOAD-BMP.
           perform LOAD-FONTS.

           initialize screen-value.
           move 1   to scr-print-mode.

           display floating graphical window
                   background-low  
                   title  "PRINT CUSTOMER"
                   cell size is entry-field font 
                   size 71
                   lines 10.5
                   control font window-font
                   handle h-main

           display tool-bar lines 2.5 control font tool-bar-font 
                                      handle h-tool upon h-main

           display mask-main upon h-main
           display mask-tool upon h-tool

           modify h-main visible 1

           move 0   to key-status
           perform until key-status = 27
              accept mask-main
                 on exception 
                    continue
              end-accept
              perform AFTER-ACCEPT
              move 4   to accept-control
           end-perform

           perform EXIT-PRG.

           goback.

       AFTER-ACCEPT.
           evaluate key-status
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           when 2001
                perform SELECT-PDF-NAME
           when 2002
                perform PRINT-LIST
           end-evaluate.

       SELECT-PDF-NAME.
           initialize opensave-data
           move "pdf"            to opnsav-default-ext
           move "Save PDF file"  to opnsav-title
           
           move "Pdf files (*.pdf)|*.pdf|All files (*.*)|*.*"  
                                                  to opnsav-filters
           move 1 to opnsav-default-filter
           call "C$OPENSAVEBOX" using opensave-save-box-checked
                                      opensave-data
                               giving opensave-status
           if opensave-status > 0
              move opnsav-filename    to scr-pdf-name
              modify EF-SCR-PDF-NAME  value scr-pdf-name
           end-if.

       PRINT-LIST.

           call "W$MOUSE" using set-mouse-shape, 
                                wait-pointer.
 
           set first-record  to true
           move 200          to num-row
           move zero         to num-pag

           perform REC-START

           if return-code > 9
              continue
           else
              perform until 1 = 2
                 perform REC-NEXT
                 if return-code > 9
                    exit perform
                 else
                    perform PRINT-RECORD
                    if print-error
                        exit perform
                    end-if
                 end-if
              end-perform
           end-if.

           if first-record
              call "W$MOUSE" using set-mouse-shape, 
                                   arrow-pointer
              display message box "No data to print"
                       icon mb-warning-icon 
           else
              if not print-error
                 close print-f
                 call "W$MOUSE" using set-mouse-shape, 
                                      arrow-pointer
                 evaluate true
                 when scr-pdf
                      call client "C$EASYOPEN" using scr-pdf-name
                 when scr-print
                      display message box "Printing completed"
                 end-evaluate
              end-if
           end-if.

       REC-START.
           move low-value to Cust-Code
           call "PCUSTOMER" using 78-start-great, Cust-Code.

       REC-NEXT.
           call "PCUSTOMER" using 78-read-next, customer-rec.

       PRINT-RECORD.
           if first-record
              perform OPEN-PRINT
           end-if

           if not print-error
              if num-row > 78-page-rows
                 perform PRINT-HEADER
              end-if

              move cust-code         to dr-cust-code
              move cust-first-name   to dr-cust-first-name
              move cust-last-name    to dr-cust-last-name
              move cust-street       to dr-cust-street
              move cust-city         to dr-cust-city
              move cust-state        to dr-cust-state

              write p-row from detail-row before 1 
              add 1 to num-row
           end-if
           .

       OPEN-PRINT.
           initialize print-env
           move zero   to call-result
           evaluate true
           when scr-preview
                move "-P PREVIEW" to print-env
           when scr-pdf
                string "-P PDF "     delimited by size
                       scr-pdf-name  delimited by trailing space
                       into print-env
           when scr-print
                initialize winprint-selection
                call "WIN$PRINTER" using winprint-get-current-info
                                         winprint-selection
                if winprint-name = spaces
                   display message box "No printer on this machine"
                          icon mb-error-icon 
                   set print-error to true
                end-if
                move "-P SPOOLER" to print-env
                call "WIN$PRINTER" using winprint-setup 
                                  giving call-result 
                perform TEST-GIVING
           end-evaluate.
           
           if not print-error
              move 0.3  to wprtdata-top-margin
                           wprtdata-bottom-margin
                           wprtdata-left-margin
                           wprtdata-right-margin
              move wprtmargin-inches   to wprtdata-margin-units
              call "WIN$PRINTER" using winprint-set-margins
                                       winprint-data
                                giving call-result
              perform TEST-GIVING
           end-if
           
           if not print-error
              open output print-f
              if status-print-f not = "00" 
                 set print-error to true
              end-if
           end-if
           .

       PRINT-HEADER.

           if num-pag not = zero
              perform RESET-COLUMN
              write p-row from space after page
           end-if

           perform PRINT-F-PIC
           perform ST-UNDER-LOGO
           
           perform DRAW-LINES

           perform SET-HEADER-FONT

           initialize wprtdata-draw.
           move 3.9 to wprtdata-draw-start-x.
           move 0.65 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving call-result.

           set first-record     to false
           add 1                to num-pag
           move zero            to num-row
           
           write p-row from "Customer List" before 1 lines.

           perform SET-BODY-FONT

           initialize wprtdata-draw.
           move 7.1 to wprtdata-draw-start-x.
           move 0.1 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving call-result.

           initialize p-row 
           string "Page "  delimited by size
                  num-pag  delimited by size
                  into p-row 
           write p-row before 1 lines.

           initialize wprtdata-draw.
           move 0.1 to wprtdata-draw-start-x.
           move 1.55 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving call-result.

           perform SET-COLUMNS

           move "Code"          to dr-cust-code
           move "First Name"    to dr-Cust-First-Name
           move "Last Name"     to dr-Cust-Last-Name
           move "Address"       to dr-Cust-Street
           move "City"          to dr-cust-city
           move "State"         to dr-cust-state
           .

           write p-row from detail-row before 1 lines

           initialize wprtdata-draw.
           move 0.1 to wprtdata-draw-start-x.
           move 1.8 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving call-result.

           write p-row from spaces before 1 lines
           .

       RESET-COLUMN.
       call "WIN$PRINTER" using  winprint-clear-data-columns,
                          giving call-result.
       perform TEST-GIVING.
       call "WIN$PRINTER" using  winprint-clear-page-columns,
                          giving call-result.
       perform TEST-GIVING.


       SET-COLUMNS.
           call "WIN$PRINTER" using winprint-set-data-columns,
                                   record-position of dr-cust-code
                                   record-position of dr-cust-first-name
                                   record-position of dr-cust-last-name
                                   record-position of dr-cust-street
                                   record-position of dr-cust-city
                                   record-position of dr-cust-state
                                   .

           perform TEST-GIVING.
           
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.05             to winprint-col-indent
                                    winprint-col-separation.

      *    code
           move 0.2              to winprint-col-start.
           move h-body-font      to winprint-col-font. 
           move wprtalign-right  to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.

      *    first name
           move 0.7              to winprint-col-start.
           move wprtalign-left   to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.

      *    last name
           move 2.5                to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
               winprint-column,
               giving call-result.
           perform TEST-GIVING.

      *    street
           move 3.7              to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.

      *    city
           move 5.4              to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.      

      *    state
           move 6.9              to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.

       DRAW-LINES.
           initialize wprtdata-draw.
           move wprt-draw-round-rectangle to wprtdata-draw-shape.
           move 0.015  to wprtdata-draw-start-x.
           move 7.63   to wprtdata-draw-stop-x.
           move 1.5    to wprtdata-draw-start-y.
           move 11.05  to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
              giving call-result.
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.01 to wprtdata-draw-start-x.
           move 7.63 to wprtdata-draw-stop-x.
           move 1.8 to wprtdata-draw-start-y.
           move 1.8 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
              giving call-result.
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.7  to wprtdata-draw-start-x
                        wprtdata-draw-stop-x.
           move 1.5    to wprtdata-draw-start-y.
           move 11.05  to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
              giving call-result.
           perform TEST-GIVING.

           move 0.7  to wprtdata-draw-start-x
                        wprtdata-draw-stop-x.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
              giving call-result.
           perform TEST-GIVING.

      *    last name
           move 2.5            to wprtdata-draw-start-x
                        wprtdata-draw-stop-x.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
              giving call-result.
           perform TEST-GIVING.
      
      *    street
           move 3.7    to wprtdata-draw-start-x
                        wprtdata-draw-stop-x.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
              giving call-result.
           perform TEST-GIVING.

      *    city
           move 5.4            to wprtdata-draw-start-x
                        wprtdata-draw-stop-x.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
              giving call-result.
           perform TEST-GIVING.
           
      *    state
           move 6.9  to wprtdata-draw-start-x
                        wprtdata-draw-stop-x.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
              giving call-result.
           perform TEST-GIVING.

       PRINT-F-PIC.
           initialize wprtdata-print-bitmap.
           move pic-company to wprtdata-bitmap.
           move 0.2 to wprtdata-bitmap-row.
           move 0.3 to wprtdata-bitmap-col.
           move 1.7 to wprtdata-bitmap-width.
           move 0.8 to wprtdata-bitmap-height.
           move wprtbitmap-scale-inches to wprtdata-bitmap-flags.
           add  wprtbitmap-units-inches to wprtdata-bitmap-flags.  
           call "WIN$PRINTER" using winprint-print-bitmap,
                                    winprint-data.

       ST-UNDER-LOGO.
           initialize wprtdata-draw.
           move 0.3 to wprtdata-draw-start-x.
           move 1.0 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving call-result.
           perform TEST-GIVING.
           move "http://www.veryant.com"    to p-row.
           write p-row before 1 lines.

           move 0.23 to wprtdata-draw-start-x.
           move 1.17 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving call-result.
           perform TEST-GIVING.

           move "e-mail: info@veryant.com"  to p-row.
           write p-row before 1 lines.

       OPEN-FILES.
           call "PCUSTOMER" using 78-open-input.

       EXIT-PRG.
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           call "PCUSTOMER" using 78-close.

       DESTROY-RESOURCE.
           modify h-main visible 0
           destroy mask-tool
                   h-tool
           destroy mask-main 
                   h-main 
           call "W$BITMAP" using wbitmap-destroy
                                 pic-company
           .

       ENABLE-PDF.
           evaluate event-type
           when cmd-clicked
                modify ef-scr-pdf-name enabled 1
                modify pb-sel-pdf enabled 1
           end-evaluate
           .
      
       DISABLE-PDF.
           evaluate event-type
           when cmd-clicked
                modify ef-scr-pdf-name  enabled 0
                modify pb-sel-pdf enabled 0
           end-evaluate
           .

       AFT-PDF-NAME.
           inquire EF-SCR-PDF-NAME value scr-pdf-name
           initialize cont
           inspect scr-pdf-name tallying cont for characters 
                                              before trailing space
           if cont < 4
              string scr-pdf-name  delimited by trailing space
                     ".pdf"        delimited by size
                     into scr-pdf-name
              modify EF-SCR-PDF-NAME value scr-pdf-name
           else
              subtract 3 from cont
              call "C$TOLOWER" using scr-pdf-name(cont:4)
              if scr-pdf-name(cont:4) not = ".pdf"
                 string scr-pdf-name  delimited by trailing space
                     ".pdf"           delimited by size
                     into scr-pdf-name
                     modify EF-SCR-PDF-NAME value scr-pdf-name
              end-if
           end-if
           .

       LOAD-BMP.
           copy resource "../resources/veryant.png".
           call "W$BITMAP" using wbitmap-load
                                 "veryant.png"
                          giving pic-company.

       LOAD-FONTS.
           initialize wfont-data.
           set wfdevice-win-printer to true.
           move "Arial" to wfont-name.
           move 10 to wfont-size.
           call "W$FONT" using wfont-get-font,
                               h-body-font, 
                               wfont-data
                        giving call-result.
           perform TEST-GIVING.

           initialize wfont-data.
           set wfdevice-win-printer   to true.
           move "Arial"               to wfont-name.
           move 20                    to wfont-size.
           set wfont-bold             to true.
           call "W$FONT" using wfont-get-font,
                               h-header-font, 
                               wfont-data
                        giving call-result.
           perform TEST-GIVING.

       SET-BODY-FONT.
           initialize wprtdata-set-font
           move h-body-font to wprtdata-font
           call "WIN$PRINTER" using winprint-set-font,
                                    winprint-data
                             giving call-result
           perform TEST-GIVING.

       SET-HEADER-FONT.
           initialize wprtdata-set-font
           move h-header-font to wprtdata-font
           call "WIN$PRINTER" using winprint-set-font,
                                    winprint-data
                             giving call-result
           perform TEST-GIVING.

       TEST-GIVING.
           if call-result not = 1
              set print-error   to true
              display message box "Operation failed!"
                       icon mb-error-icon 
           end-if.

