var baseUrl = '';
var scriptAdded=false;
var menuLoaded = false;
var appName = getParam('args');
// remove username from appName
appName = appName.split(" ")[0];

// google maps
var map = null;
var mapControl = null;

console.log(appName);


// actions
const actionBell = 'bell';
const actionWarning = 'warning';
const actionError = 'error';
const actionAddIcon = 'addIcon';
const actionRemoveIcon = 'removeIcon';
const actionClose = 'close';
const actionQuit = 'quit';
const actionNotification = 'notification';
const actionGetSessionID = 'GetSessionID';

const ARGS_SEPARATOR = '|';

function getInstance(){
  return webclientInstance;
}


var webclientInstance = {
  options: {
      autoStart: true,
      syncClipboard: true,
      args: getParam('args'),
      recording: getParam('recording'),
      debugPort: getParam('debugPort'),
      syncClipboard : true,
      compositingWindowsListener: {
        windowOpening: function(htmlOrCanvasWindow) {
        },
        windowOpened: function(appWindow) {
          if (window.top && !window.top.apps[appName]){
            window.top.apps[appName]={
              name: appName,
              instance: webclientInstance,
              window: appWindow
            }
          }
          
          if (appWindow.name === 'f-map'){
            createMap(appWindow)
          }
          
        },
        windowClosing: function(appWindow) {
        },
        windowClosed: function(appWindow) {
          
        },
        windowModalBlockedChanged: function(htmlOrCanvasWindow) {
        }
      },
      customization: function(injector) {

        injector.services.base.handleActionEvent = function(actionName, data, binaryData) {
          if (actionName === actionBell){
            window.top.appUI.notifyApp(appName, 'fa-bell');
          }
          if (actionName === actionWarning){
            window.top.appUI.notifyApp(appName, 'fa-exclamation-triangle');
          }
          if (actionName === actionError){
            window.top.appUI.notifyApp(appName, 'fa-warning');
          }
          if (actionName === actionAddIcon){
            // data contains the program name and icon to show, separated by a pipe (|)
            window.top.appUI.notifyApp(data.split('|')[0], data.split('|')[1]);
          }
          if (actionName === actionRemoveIcon){
            window.top.appUI.removeNotification(data.split(ARGS_SEPARATOR)[0]);
          }
          if (actionName === actionQuit){
            window.top.appUI.quitApp(appName);
          }
          if (actionName === actionClose){
            window.top.appUI.quitApp(appName);
          }
          if (actionName === actionNotification){
            let params = data.split(ARGS_SEPARATOR);
            window.top.appUI.notification(params[0], params[1], params[2]);
          } else if (actionName === actionGetSessionID){
            const id = localStorage.getItem('webswingID');
            webclientInstance.performAction({actionName: actionGetSessionID, data: id}) 
          }
        }

        injector.services.dialog.content.startingDialog.content = null,
        injector.services.dialog.content.initializingDialog.content = '',
        injector.services.dialog.content.readyDialog.content = '',
        injector.services.dialog.content.stoppedDialog.content = ''

      }
    }
};


function notification( type, description, message){
  if (type === 'info'){
    toastr.info(message,description);
  } else if (type === 'warning'){
    toastr.warning(message,description);
  } else if (type === 'error'){
    toastr.error(message,description);
  } else if (type === 'success'){
    toastr.success(message,description);
  }
  
}

function getParam(name) {
  name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
  var results = new RegExp("[\\?&]" + name + "=([^&#]*)").exec(location.href);
  return results == null ? null : decodeURIComponent(results[1]);
}

function addMarker(office){
  var marker = L.marker([office.office.lat, office.office.lng]).addTo(map);
  marker.bindPopup(office.office.description).openPopup();
}

function selectOffice(office){
  if (map != null){
    addMarker(office);

    map.setView([office.office.lat, office.office.lng], 14);
  }
}

function showArea(office) {
  centerMarker = L.circleMarker([office.office.lat, office.office.lng],{radius: 100}).addTo(map);
}

function hideArea(office) {
  if (centerMarker) {
    centerMarker.remove();      
    centerMarker = null;
  }
}

function centerMap(office) {
  map.setView([office.office.lat, office.office.lng], 14, {
      animate: true,
      duration: 1, // Duration of animation in seconds
      easeLinearity: 0.25, // Animation easing, 0.0 is linear, 1.0 is no easing
  });
}


function setControlId(elementName){
  var panel = webclientInstance.getWindows().filter(w => w.name === elementName);
  if (panel.length > 0){
    panel[0].element.id = elementName;
    return true;
  } else {
    return false;
  }
}


function createMap(win) {
  setControlId(win.name);
  mapControl = win;

  map = L.map(win.name).setView([51.505, -0.09], 13);

  L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
    attribution: 'Veryant',
    attributionControl: false,
  }).addTo(map);

 win.performAction({actionName: 'mapCreated'});

 win.handleActionEvent = function(actionName, data, binaryData) {
     if (actionName === 'selectOffice'){
        let office = JSON.parse(data);
        selectOffice(office);
      } else if (actionName === 'showArea'){
        let office = JSON.parse(data);
        showArea(office);
      } else if (actionName === 'hideArea'){
        let office = JSON.parse(data);
        hideArea(office);
      } else if (actionName === 'centerMap'){
        let office = JSON.parse(data);
        centerMap(office);
      }        
  }
}

(function (window, document) {
   var loader = function () {
       baseUrl = baseUrl.indexOf("/", baseUrl.length - 1) !== -1 ? baseUrl : (baseUrl + "/");
       var xmlhttp = new XMLHttpRequest();
       xmlhttp.onreadystatechange = function () {
           if (xmlhttp.readyState == XMLHttpRequest.DONE) {
               var version = xmlhttp.status == 200 ? xmlhttp.responseText : "undefined";
               var script = document.createElement("script"),
                   tag = document.getElementsByTagName("script")[0];
               script.src =  "javascript/webswing-embed.js?version=" + version;
               tag.parentNode.insertBefore(script, tag);
           }
       };
       xmlhttp.open("GET", "rest/version", true);
       xmlhttp.send();
   };
   window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload", loader);
})(window, document);

