const baseAppUrl = baseAddress + '/' + appWebAppName +'?args='; 
const htmlVersion = 'isCOBOL release 2024 R2 build#1131.8-20241108-38916';
var apps=[];
const actionClose = 'close';
const actionQuit = 'quit';
const actionCloseMenu = 'CloseMenu';
const actionLoadMenu = 'loadMenu';
const actionNotification = 'notification';
const actionGetVersion = 'GetVersion';
const actionGetSessionID = 'GetSessionID';

var menuAppInstance = {
  options: {
      autoStart: true,
      syncClipboard: true,
      args: '',
      recording: getParam('recording'),
      debugPort: getParam('debugPort'),
      connectionUrl:baseAddress + '/' + menuWebAppName,
      compositingWindowsListener: {
        windowOpening: function(appWindow) {
        },
        windowOpened: function(appWindow) {
        },
        windowClosing: function(appWindow) {
        },
        windowClosed: function(appWindow) {
        },
        windowModalBlockedChanged: function(appWindow) {
        }
      },
      customization: function(injector) {
        injector.services.base.handleActionEvent = function(actionName, data, binaryData) {
            if (actionName === actionLoadMenu){
              var menu = JSON.parse(data);
              menuLoaded = true;
              buildMenu(menu);
              showUser();
              checkUI();
              document.getElementById('htmlVersion').innerHTML = htmlVersion;
            } else if (actionName === actionGetVersion){
              document.getElementById('appVersion').innerHTML = data;
            } else if (actionName === actionGetSessionID){
             
              if (data && window.apps[data]){
                window.appUI.getSessionID(data.trim());
              } else {
                const id = localStorage.getItem('webswingID');
                menuAppInstance.performAction({actionName: actionGetSessionID, data: id}) 
              }
             
            }
      },
      injector.services.dialog.content.startingDialog.content = null;
    }
  }
}

function showUser(){
  //document.getElementById('user').innerText = getUserName();
}

function getUserName(){
  if (menuAppInstance && menuAppInstance.instanceId && menuAppInstance.instanceId().split("_").length>0){
   return menuAppInstance.instanceId().split("_")[1];
  } else {
    return null;
  }
}

function showMenu(){

}


   function notifyApp(appName, notificationIcon){
    if (!document.getElementById('notification_' + appName)){
      var i = document.createElement('i');
      i.id='notification_' + appName;
      i.className = 'fa ' + notificationIcon +' mr-2 animate__animated animate__swing animate__repeat-2';
     document.getElementById('a_' + appName).insertBefore(i,document.getElementById('a_' + appName).childNodes[0]);
     i.onclick = function(){
       document.getElementById('notification_' + appName).remove();
     }
    }
   }

   function addBell(appName){
     if (!document.getElementById('bell_' + appName)){
       var i = document.createElement('i');
       i.id='bell_' + appName;
       i.className = 'fa fa-bell mr-2 animate__animated animate__swing animate__repeat-2';
      document.getElementById('a_' + appName).insertBefore(i,document.getElementById('a_' + appName).childNodes[0]);
      i.onclick = function(){
        document.getElementById('bell_' + appName).remove();
      }
     }
   }

   function removeNotification(appName){
    if (document.getElementById('notification_' + appName)){
      document.getElementById('notification_' + appName).remove();
    }
  }


  function removeBell(appName){
    if (document.getElementById('bell_' + appName)){
      document.getElementById('bell_' + appName).remove();
    }
  }

   function getInstance(instanceVar){
     return eval(instanceVar)
   }


   function getParam(name) {
    name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
    var results = new RegExp("[\\?&]" + name + "=([^&#]*)").exec(location.href);
    return results == null ? null : decodeURIComponent(results[1]);
}


(function (window, document) {
   var loader = function () {
       baseUrl = baseUrl.indexOf("/", baseUrl.length - 1) !== -1 ? baseUrl : (baseUrl + "/");
       var xmlhttp = new XMLHttpRequest();
       xmlhttp.onreadystatechange = function () {
           if (xmlhttp.readyState == XMLHttpRequest.DONE) {
               var version = xmlhttp.status == 200 ? xmlhttp.responseText : "undefined";
               var script = document.createElement("script"),
                   tag = document.getElementsByTagName("script")[0];
               script.src =  "javascript/webswing-embed.js?version=" + (version? version: '1');
               tag.parentNode.insertBefore(script, tag);
           }
       };
       xmlhttp.open("GET", "rest/version", true);
       xmlhttp.send();
   };
   window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload", loader);

   $('[data-widget="signout"]').on('click', signout);

})(window, document);


jQuery(function() {
  $('.content-wrapper').IFrame({
    onTabClick(item) {
      return item
    },
    onTabChanged(item) {
      return item
    },
    onTabCreated(item) {
      return item
    },
    onTabCloseClick(item){

    },
    autoIframeMode: true,
    autoItemActive: true,
    autoShowNewTab: true,
    allowDuplicates: false,
    loadingScreen: 750,
    useNavbarItems: true
  });
});

function startApplication(appTitle, appName){
  if (window.appUI.appIsOpen(appName)){
    $('.content-wrapper').IFrame('switchTab','#tab-' + appName);
  } else {
    $('.content-wrapper').IFrame('createTab', appTitle,
         baseAppUrl + appName + ' ' + getUserName() + ' ' + localStorage.getItem('webswingID'),
        appName, true);

        $('#tab-'+ appName).on('click', e => {
          const data = e.target.id.split('-');
          if (data.length > 1){
            const appName = data[1];
            setTimeout( () => {window.apps[appName].instance.repaint()}, 300);
          }
        })
      
 // set up a click listener on the application tab
    // that will remove any notifications and force a repaint to update the content
    $('#tab-'+ appName).on('click', e => {
      const data = e.target.id.split('-');
      if (data.length > 1){
        const appName = data[1];

        appUI.removeNotification(appName);

        setTimeout( () => {
          // repaint the canvas to position popups correctly
          window.apps[appName].instance.repaint();
        }, 200);
      }
    });
  

  }
  return false;
}

// close button override
// disable default behavior that is to just remove the tab
// notify the cobol program instead, and wait for it to close
// tab will be removed when the action quit is received

setTimeout(function(){
  $(document).off('click', '[data-widget="iframe-close"]')
  $(document).on('click', '[data-widget="iframe-close"]', e => {
    e.preventDefault();

    if (e.target.dataset['type'] === 'all'){
      //"Close all" was clicked
      closeAllPrograms();

    } else if (e.target.dataset['type'] === 'all-other'){ 
      // "Close all other" was clicked
      closeOtherPrograms();
    } else {
      // single tab is being closed  
      // get the <li> item and find out the involved program
      var li = e.target.parentElement.parentElement;
      // the program name is in the id attribute, preceded by the "frame_panel-" constant
      var appName = li.id.substring("frane_panel-".length);

      // send the app the quit request.
      window.apps[appName].instance.performAction({actionName: actionClose, data: appName});
    }
  })
  checkUI();
},500);

function closeAllPrograms(){
  for (var appName in window.apps){
    if(window.apps.hasOwnProperty(appName)){
      window.apps[appName].instance.performAction({actionName: actionClose, data: appName})
    }
  }
}

function closeOtherPrograms(){
  const activeApp = $('.nav-link.active');
  if (activeApp.length > 0){
    const instancesToClose = [];
    const activeAppName = activeApp[0].id.substring("tab-".length);
    for (var appName in window.apps){
      if(window.apps.hasOwnProperty(appName) && appName !== activeAppName){
        instancesToClose.push({instance: window.apps[appName].instance, appName: appName});
      }
    }

    instancesToClose.forEach(instance => instance.instance.performAction({actionName: actionClose, data: instance.appName}));
    setTimeout(function(){
      $('.content-wrapper').IFrame('switchTab','#tab-' + activeAppName);
    }, 500);
  }
}


function checkUI(){
  var userName = getUserName();
  setVisibilityById('webclientLogin',userName==null? 'block': 'none')
  setVisibilityById('webclientAppContainer',userName==null? 'block': 'none')
  setVisibilityById('wrapper',userName==null? 'none': 'block')

  // if username is set, hide the login div
  if (userName |= null) {
    document.getElementsByClassName('webclientAppContainer webswing-element')[0].style.display = 'none';
  } else {
    if (document.getElementsByClassName('webswing-element-content').length > 0){
      document.getElementsByClassName('webswing-element-content')[0].classList.add('composition')
    }
  }
}

function setVisibilityById(elementId, displayClass){
  if (document.getElementById(elementId)){
    document.getElementById(elementId).style.display = displayClass;
  }
}

function quitAllPrograms(){
  for (var appName in window.apps){
    if(window.apps.hasOwnProperty(appName)){
      window.apps[appName].instance.performAction({actionName: actionQuit})
    }
  }
}


function signout(){
  // when signing out, close all running programs
  // when all programs are closed, kill the webclient instance
  quitAllPrograms();
  setTimeout(killInstance, 500);  
}

function killInstance(){
  // if no programs are running, kill the webclient instance
  if (Object.keys(apps).length === 0) {
    menuAppInstance.performAction({actionName: actionCloseMenu});
    menuAppInstance.kill();
  } else {
    setTimeout(killInstance, 500);
  }
}
