      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       program-id. COB-CHECK-LOGIN.

       configuration section.
       special-names.

       input-output section.
       file-control.
           copy "users.sl".

       file section.
           copy "users.fd".

       working-storage section.
       copy "settings.wrk".
       01  goback-status        pic 9.
           88 login-successfull value 1 false zero.
       77  status-users         pic  xx.

       77  encrypted-data1      pic x any length.
       77  encrypted-data2      pic x any length.
       
       77  wrk-msg              pic x any length.
       77  wrk-error            pic x any length.

       linkage section.
       77  lnk-users-id         pic x(20).
       77  lnk-pwd              pic x(50).

       procedure division using lnk-users-id
                                lnk-pwd.
       DECLARATIVES.
       USERS-ERR section.
           use after standard error procedure on users.
       
           initialize wrk-msg
           string "Error on file users. File status "
                   status-users 
                   into wrk-msg
           perform DISPLAY-MESSAGE.

           goback goback-status
           .
       end declaratives.
       MAIN.
           set environment "crypt.algorithm"   to "Blowfish"

           perform SETTINGS
           call "CHECKFILE"

      *    Debug display
      *     initialize wrk-msg
      *     string "LOGIN Credential "    delimited by size
      *            x"0A"                  delimited by size
      *            "User: "               delimited by size 
      *            lnk-users-id           delimited by trailing space  
      *            x"0A"                  delimited by size
      *            "Password: "           delimited by size
      *            lnk-pwd                delimited by trailing space
      *            into wrk-msg
      *     perform DISPLAY-MESSAGE

           set login-successfull   to false
           open input Users
           move lnk-users-id       to users-id
           read users no lock
              invalid
                 continue
              not invalid
                 perform CHECK-ENCRYPTION
           end-read

           close users

      *    Debug display
      *     initialize wrk-msg
      *     string "Goback status: "  delimited by size
      *            goback-status      delimited by size
      *            into wrk-msg 
      *     perform DISPLAY-MESSAGE.

           goback goback-status.

       CHECK-ENCRYPTION.
           call "C$ENCRYPT" using function trimr(lnk-pwd), 
                                           "Veryant" , 
                                           encrypted-data1
                                           wrk-error
                           giving return-code
           if return-code = 0
              call "ASCII2HEX" using encrypted-data1, 
                                     encrypted-data2
              if encrypted-data2  = users-pass 
                 set login-successfull   to true
              end-if
           else
             initialize wrk-msg
             string "Decrypt error:"  delimited by size
                     x"0A"            delimited by size
                     wrk-error        delimited by size
                     into wrk-msg 
             perform DISPLAY-MESSAGE
           end-if.

       DISPLAY-MESSAGE.
           display ""  upon sysout.
           display ""  upon syserr.
           display "COBOL-CECK-LOGIN: " upon sysout. 
           display "COBOL-CECK-LOGIN: " upon syserr. 
           display wrk-msg  upon sysout.
           display wrk-msg  upon syserr.

           copy "settings.prd".