      *>   Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *>   may freely modify and redistribute this program.
      
       program-id. isprintinvoice.
       input-output section.
       file-control.
           copy "print-f.sl".
           copy "invoice.sl".
           copy "invoicedetail.sl".
           copy "customer.sl".
           copy "product.sl".
      
       file section.
           copy "print-f.fd".
           copy "invoice.fd".
           copy "invoicedetail.fd".
           copy "customer.fd".
           copy "product.fd".
      
       working-storage section.
           copy "isprint.def".
           copy "common.wrk".
           copy "iwc.lks".
           copy "iwc.wrk".

           77  pic-company      pic s9(9) comp-4.
           77  call-result      signed-int.
           77  h-font-print     usage handle of font.
           77  h-small-font2    usage handle of font.
           77  h-small-font     usage handle of font.
           77  h-large-font     usage handle of font.
           77  h-large-font2    usage handle of font.
           77  h-large-font3    usage handle of font.
           77  flag             pic 9 value 0.

           77  status-print-f       pic xx.
           77  status-invoice       pic xx.
           77  status-invoicedetail pic xx.
           77  status-customer      pic xx.
           77  status-product       pic xx.

       01  p-row1.
           03 field1-p-row1 pic x(11) value R"CUSTOMER.N.".
           03 field2-p-row1 pic x(14) value R"DOCUMENT".
           03 field3-p-row1 pic x(9)  value R"PAGE".
       
       01  p-row2.
           03 field1-p-row2 pic x(13) value R"NUMBER".
           03 field2-p-row2 pic x(7)  value R"INVOICE".
           03 field3-p-row2 pic x(12) value R"INVOICE_DATE".
       
       01  p-row3.
           03 field1-p-row3 pic x(10) value "13057".
           03 field2-p-row3 pic x(18) value R"SELL_INVOICE".
           03 field3-p-row3 pic x(4) value "1/ 1".
       
       01  p-row4.
           03 field1-p-row4 pic x.
           03 field2-p-row4 pic x(8) value "1066/002".
           03 field3-p-row4 pic x(10) value "12/05/2006".
       
       01  p-row5.
           03 field1-p-row5 pic x(19) value R"CUSTOMER".
           03 field2-p-row5 pic x(16) value R"ORDER_N/DATE".
           03 field3-p-row5 pic x(15) value R"DELIVERY_N/DATE".
       
       01  p-row6.
           03 field1-p-row6 pic x(8)  value R"PAY.NO.".
           03 field2-p-row6 pic x(21) value R"PAYMENT_DESCRIPTION".
           03 field3-p-row6 pic x(16) value R"BANK".
           03 field4-p-row6 pic x(16) value R"PAYMENT_DATE".
       
       01  p-row7.
           03 field1-p-row7 pic x(3) value "007".
           03 field2-p-row7 pic x(21) value R"30_days_after_invoice".
           03 field3-p-row7 pic x(48) value SPACE.
           03 field4-p-row7 pic x(10) value space.
       
       01  p-row8.
           03 field1-p-row8 pic x(20) value R"SEND_TO".
       
       01  p-row9.
           03 field1-p-row9 pic x(4) value R"IDEM".
       
       01  p-row10.
           03 field1-p-row10 pic x(12) value R"ART.NO.".
           03 field2-p-row10 pic x(11) value R"DESCRIPTION".
           03 field3-p-row10 pic x(4)  value R"U.M.".
           03 field4-p-row10 pic x(9)  value R"QTY.ORDER".
           03 field5-p-row10 pic x(6)  value R"PRICE".
           03 field6-p-row10 pic x(3)  value R"RP%".
           03 field7-p-row10 pic x(13) value R"AMOUNT".
           03 field8-p-row10 pic x(4)  value R"VAT".
       
       01  p-row12.
           03 field1-p-row12 pic x(23). 
           03 field2-p-row12 pic x(35).
           03 field3-p-row12 pic x(2).
           03 field4-p-row12 pic z(2)9.99. 
           03 field5-p-row12 pic z(05)9.99. 
           03 field6-p-row12 pic x.
           03 field7-p-row12 pic z(05)9.99. 
           03 field8-p-row12 pic z9. 
       
       01  p-row13.
           03 field1-p-row13 pic x(15) value R"SUBTOTAL".
           03 field2-p-row13 pic x(8)  value R"%_RP".
           03 field3-p-row13 pic x(14) value R"NEW_SUBTOTAL".
           03 field4-p-row13 pic x(10)  value R"DELIVERY".
           03 field5-p-row13 pic x(18) value R"NET_AMOUNT".
           03 field6-p-row13 pic x(7)  value R"PACK".
           03 field7-p-row13 pic x(5)  value R"MISC.".
       
       01  p-row14.
           03 field1-p-row14 pic x(10).
           03 field2-p-row14 pic x.
           03 field3-p-row14 pic x.
           03 field4-p-row14 pic x.
           03 field5-p-row14 pic x(10).
           03 field6-p-row14 pic x.
           03 field7-p-row14 pic x(4).
        
       01  p-row15.
           03 field1-p-row15    pic x(10)  value R"DELIVERY".
           03 field2-p-row15    pic x(7)  value R"PACK".
           03 field3-p-row15    pic x(5)  value R"MISC".
           03 field4-p-row15    pic x(4)  value R"VAT%".
           03 field5-p-row15    pic x(15) value R"VAT_DESCRIPTION".
           03 field6-p-row15    pic x(10) value R"NET_TOTAL".
           03 field7-p-row15    pic x(3)  value R"VAT".
        
       01  p-row16.
           03 field1-p-row16    pic x.
           03 field2-p-row16    pic x.
           03 field3-p-row16    pic x(4).
           03 field4-p-row16    pic z(2).
           03 field5-p-row16    pic x(10).
           03 field6-p-row16    pic x(10).
           03 field7-p-row16    pic x(10).
        
       01  p-row17.
           03 field1-p-row17    pic x(17) value R"NET_AMOUNT".
           03 field2-p-row17    pic x(10) value R"VAT_AMOUNT".
           03 field3-p-row17    pic x(14) value R"INVOICE_TOTAL".
        
       01  p-row18.
           03 field1-p-row18    pic x(10).
           03 field2-p-row18    pic x(10).
           03 field3-p-row18    pic x(10). 
        
       01  p-row19.
           03 field1-p-row19    pic x(11) value R"NOTE".
           03 field2-p-row19    pic x.
        
       77  print-env            pic x(256).
        
       01                       pic 9.
           88 all-ok            value 1 false zero.
        
       01                       pic 9.
           88 end-of-invoice    value 1 false zero.

       77  page-num             pic 9(3) value zero.
       77  page-num-ed          pic z(3).
           
       77  ed-inv-number        pic z(10).
           
       77  wrk-row-amount       pic 9(06)v99.
       77  wrk-total            pic 9(06)v99.
       77  wrk-vat              pic 9(06)v99.
       77  wrk-total-ed         pic z(05)9.99.
           
       77  num-rows-detail      pic 9(2).
       78  max-row-detail       value 33.
       77  row-position         pic 99v99.
       77  wrk-arial            pic x any length.
       77  wrk-arial-black      pic x any length.
           
       linkage section.
           copy "isprintinvoice-link.lks".
  
       procedure division using ips-linkage.
       DECLARATIVES.
       INVOICE-ERR section.
           use after standard error procedure on invoice.
           perform ERROR-FILE
           .
       INVOICEDETAIL-ERR section.
           use after standard error procedure on invoicedetail.
           perform ERROR-FILE
           .
       CUSTOMER-ERR section.
           use after standard error procedure on customer.
           perform ERROR-FILE
           .
       PRODUCT-ERR section.
          use after standard error procedure on product.
          perform ERROR-FILE
          .
       PRINT-F-ERR section.
           use after standard error procedure on print-f.
           goback.
       end declaratives.

       MAIN.
           perform CHOOSE-PRINTER
              
           perform LOAD-FONT.
           perform LOAD-BMP.
           perform OPEN-FILES.
           perform LOAD-INVOICE.
           if all-ok
              set end-of-invoice   to false
              move zero   to wrk-total
              perform PRINT-HEADER
              perform PRINT-DETAIL
              perform PRINT-FOOTER
              call "IWC-ICON" using 78-report-icon
              move r"Print_job_completed"   to iwc-notification
              call "IWC-ADD-NOTIFICATION" using 78-report-icon,
                                                78-evt-report,
                                                iwc-notification
           end-if.
           perform CLOSE-FILES
           perform DESTROY-RESOURCE.

           goback.

       CHOOSE-PRINTER.
           evaluate true
           when ips-print
                move "-P SPOOLER" to print-env
           when ips-preview
                move "-P PREVIEW" to print-env
           end-evaluate
           .

       LOAD-BMP.
           call "W$BITMAP" using wbitmap-load, "veryant.png"
                          giving pic-company.

       OPEN-FILES.
           open output print-f.
           open input invoice.
           open input invoicedetail.
           open input Customer.
           open input product.

       CLOSE-FILES.
           close print-f.
           close invoice.
           close invoicedetail.
           close Customer.
           close product.

       LOAD-INVOICE.
           set all-ok  to true
           move ips-inv-key  to inv-key.
           
           read invoice no lock
              invalid
                 display message box R"Invoice_not_found"
                      icon mb-warning-icon
                 set all-ok  to false
           end-read
           
           move inv-customer to cust-id
           read customer
              invalid
                 initialize cust-record
                 move inv-customer to cust-id
           end-read.

       PRINT-HEADER.
           add 1 to page-num
           move page-num  to page-num-ed
           perform PRINT-F-PIC
           perform ST-UNDER-LOGO
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 0.5 to wprtdata-draw-start-y.
           move 0.7 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.572 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 0.5 to wprtdata-draw-start-y.
           move 0.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 1.3 to wprtdata-draw-start-y.
           move 1.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.572 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 1.5 to wprtdata-draw-start-y.
           move 1.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 4.7 to wprtdata-draw-stop-x.
           move 0.5 to wprtdata-draw-start-y.
           move 0.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 4.5 to wprtdata-draw-stop-x.
           move 0.5 to wprtdata-draw-start-y.
           move 0.7 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 4.5 to wprtdata-draw-stop-x.
           move 1.3 to wprtdata-draw-start-y.
           move 1.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 4.7 to wprtdata-draw-stop-x.
           move 1.5 to wprtdata-draw-start-y.
           move 1.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move 4.575 to wprtdata-draw-start-x.
           move 0.6 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           perform TEST-GIVING.      
           move R"Company" to p-row.
           write p-row before 1 lines.
           
           initialize wprtdata-draw.
           move 4.575 to wprtdata-draw-start-x.
           move 0.85 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           perform TEST-GIVING.
           move 1 to flag.
           perform LOAD-LARGE-FONT2.
           move 0 to flag.
           initialize p-row
           string cust-fname delimited by trailing space
                  " "        delimited by size
                  cust-lname delimited by size
                  into p-row
           
           write p-row before 1 lines.
           
           initialize wprtdata-draw.
           move 4.575 to wprtdata-draw-start-x.
           move 1 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           perform TEST-GIVING.
           move cust-addr to p-row.
           write p-row before 1 lines.
           
           initialize wprtdata-draw.
           move 4.575 to wprtdata-draw-start-x.
           move 1.2 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-pen.
           move wprt-pen-solid to wprtdata-pen-style.
           move 2 to wprtdata-pen-width.
           call "WIN$PRINTER" using winprint-graph-pen, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 1.6 to wprtdata-draw-start-y.
           move 1.6 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-pen.
           move wprt-pen-solid to wprtdata-pen-style.
           call "WIN$PRINTER" using winprint-graph-pen, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 4.5 to wprtdata-draw-stop-x.
           move 1.6 to wprtdata-draw-start-y.
           move 2.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
               giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 1.95 to wprtdata-draw-start-y.
           move 1.95 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 2.3 to wprtdata-draw-start-y.
           move 2.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 1.6 to wprtdata-draw-start-y.
           move 2.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
               giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5.4 to wprtdata-draw-start-x.
           move 5.4 to wprtdata-draw-stop-x.
           move 1.6 to wprtdata-draw-start-y.
           move 2.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 6.7 to wprtdata-draw-start-x.
           move 6.7 to wprtdata-draw-stop-x.           
           move 1.6 to wprtdata-draw-start-y.
           move 2.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
  
           move 1 to flag.
           perform SET-SMALL-FONT2.
           move 0 to flag.
           initialize wprtdata-draw.
           move 4.5 to wprtdata-draw-start-x.
           move 1.65 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row1
                record-position of field2-p-row1
                record-position of field3-p-row1.
           move wprtunits-inches to winprint-col-units.
           move 4.5 to winprint-col-start.
           move 0.070 to winprint-col-indent.
           move h-small-font2 to winprint-col-font. 
           move wprtalign-left to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 5.4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 6.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move p-row1 to p-row.
           write p-row before 1 lines.
           perform reset-column.

           initialize wprtdata-draw.
           move 4.5 to wprtdata-draw-start-x.
           move 1.975 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row2
                record-position of field2-p-row2
                record-position of field3-p-row2.
           move wprtunits-inches to winprint-col-units.
           move 4.5 to winprint-col-start.
           move 0.070 to winprint-col-indent.
           move h-small-font2 to winprint-col-font. 
           move wprtalign-left to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 5.4 to winprint-col-start.
           call "WIN$PRINTER" using  winprint-set-page-column,
                                     winprint-column,
                              giving call-result.
           perform TEST-GIVING.
           move 6.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                                    winprint-column,
                              giving call-result.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                                    winprint-column,
                              giving call-result.
           perform TEST-GIVING.
           move p-row2 to p-row.
           write p-row before 1 lines.
           perform reset-column.
           
           perform LOAD-LARGE-FONT3.
           initialize wprtdata-draw.
           move 4.5 to wprtdata-draw-start-x.
           move 1.75 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           perform TEST-GIVING.
           initialize winprint-column.
           
           move cust-id   to field1-p-row3
           move page-num-ed  to field3-p-row3.
           
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row3
                record-position of field2-p-row3
                record-position of field3-p-row3.           
           move wprtunits-inches to winprint-col-units.
           move 4.5 to winprint-col-start.           
           move h-large-font3 to winprint-col-font. 
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 5.4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 6.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           move cust-id   to field1-p-row3

           move p-row3 to p-row.
           write p-row before 1 lines.
           perform reset-column.
           
           initialize wprtdata-draw.
           move 4.5 to wprtdata-draw-start-x.
           move 2.15 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           perform TEST-GIVING.
           initialize winprint-column.
           
           initialize p-row4
           move inv-number to ed-inv-number
           call "C$JUSTIFY" using ed-inv-number, "L"
           string ed-inv-number delimited by trailing space
                  "/"           delimited by size
                  inv-year      delimited by size
                  into field2-p-row4
                  
           string inv-date(7:2) delimited by size
                  "/"           delimited by size
                  inv-date(5:2) delimited by size
                  "/"           delimited by size
                  inv-date(1:4) delimited by size
                  into field3-p-row4
                  
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row4
                record-position of field2-p-row4
                record-position of field3-p-row4.           
           move wprtunits-inches to winprint-col-units.
           move 4.5 to winprint-col-start.           
           move h-large-font3 to winprint-col-font. 
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 5.4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 6.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move p-row4 to p-row.
           write p-row before 1 lines.
           perform reset-column.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 2.5 to wprtdata-draw-start-y.
           move 2.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 2.85 to wprtdata-draw-start-y.
           move 2.85 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 3.2 to wprtdata-draw-start-y.
           move 3.2 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 3.55 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 0.5 to wprtdata-draw-stop-x.
           move 2.5 to wprtdata-draw-start-y.
           move 3.55 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 2.5 to wprtdata-draw-start-y.
           move 3.55 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 2.55 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row5
                record-position of field2-p-row5
                record-position of field3-p-row5.           
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.           
           move 0.050 to winprint-col-indent.
           move h-small-font2 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 2.3 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move p-row5 to p-row.
           write p-row before 1 lines.
           perform reset-column.
    
           initialize wprtdata-draw.
           move 0.7 to wprtdata-draw-start-x.
           move 2.65 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           perform TEST-GIVING.               
           move space   to p-row.
           move 1 to flag.
           perform LOAD-LARGE-FONT2.
           move 0 to flag.
           write p-row before 1 lines.
           
           initialize wprtdata-draw.
           move 2.3 to wprtdata-draw-start-x.
           move 2.3 to wprtdata-draw-stop-x.
           move 2.5 to wprtdata-draw-start-y.
           move 2.85 to wprtdata-draw-stop-y.
           move wprt-draw-line to wprtdata-draw-shape.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
 
           initialize wprtdata-draw.
           move 5 to wprtdata-draw-start-x.
           move 5 to wprtdata-draw-stop-x.
           move 2.5 to wprtdata-draw-start-y.
           move 2.85 to wprtdata-draw-stop-y.
           move wprt-draw-line to wprtdata-draw-shape.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move 0.95 to wprtdata-draw-start-x.
           move 0.95 to wprtdata-draw-stop-x.
           move 2.85 to wprtdata-draw-start-y.
           move 3.2 to wprtdata-draw-stop-y.
           move wprt-draw-line to wprtdata-draw-shape.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move 3 to wprtdata-draw-start-x.
           move 3 to wprtdata-draw-stop-x.
           move 2.85 to wprtdata-draw-start-y.
           move 3.2 to wprtdata-draw-stop-y.
           move wprt-draw-line to wprtdata-draw-shape.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move 6.8 to wprtdata-draw-start-x.
           move 6.8 to wprtdata-draw-stop-x.
           move 2.85 to wprtdata-draw-start-y.
           move 3.2 to wprtdata-draw-stop-y.
           move wprt-draw-line to wprtdata-draw-shape.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 2.9 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           perform TEST-GIVING.
           
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row6
                record-position of field2-p-row6
                record-position of field3-p-row6
                record-position of field4-p-row6.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.           
           move 0.050 to winprint-col-indent.
           move h-small-font2 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           move 0.95 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           move 3 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           move 6.8 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
               winprint-column,
               giving call-result.
           perform TEST-GIVING.
           move p-row6 to p-row.
           write p-row before 1 lines.
           perform reset-column.
               
           initialize wprtdata-draw.                      
           move 0.5 to wprtdata-draw-start-x.
           move 3 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           perform TEST-GIVING.           
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row7
                record-position of field2-p-row7
                record-position of field3-p-row7
                record-position of field4-p-row7.           
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.           
           move 0.050 to winprint-col-indent.
           move h-large-font2 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 0.95 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 3 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 6.8 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
               winprint-column,
               giving call-result.
           perform TEST-GIVING.
           move p-row7 to p-row.
           write p-row before 1 lines.
           perform reset-column. 
           
           initialize wprtdata-draw.                      
           move 0.5 to wprtdata-draw-start-x.
           move 3.25 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           perform TEST-GIVING.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row8.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.           
           move 0.050 to winprint-col-indent.
           move h-small-font2 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move p-row8 to p-row.
           write p-row before 1 lines.
           perform reset-column.

      *>      * IDEM
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 3.35 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           perform TEST-GIVING.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row9.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.
           move 0.050 to winprint-col-indent.
           move h-large-font2 to winprint-col-font.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move p-row9 to p-row.
           write p-row before 1 lines.
           perform reset-column.
           
               
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 3.8 to wprtdata-draw-start-y.
           move 3.8 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 0.5 to wprtdata-draw-stop-x.
           move 3.3 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 3.3 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 1.5 to wprtdata-draw-start-x.
           move 1.5 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.       
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4 to wprtdata-draw-start-x.
           move 4 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.       

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.3 to wprtdata-draw-start-x.
           move 4.3 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.       
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5 to wprtdata-draw-start-x.
           move 5 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.       
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5.9 to wprtdata-draw-start-x.
           move 5.9 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.       
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 6.4 to wprtdata-draw-start-x.
           move 6.4 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.       

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.5 to wprtdata-draw-start-x.
           move 7.5 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.       
           
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 3.6 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           perform TEST-GIVING.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row10
                record-position of field2-p-row10
                record-position of field3-p-row10
                record-position of field4-p-row10
                record-position of field5-p-row10
                record-position of field6-p-row10
                record-position of field7-p-row10
                record-position of field8-p-row10.
           perform TEST-GIVING.
           
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.           
           move h-large-font3 to winprint-col-font. 
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 1.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
               winprint-column,
               giving call-result.
           perform TEST-GIVING.
           move 4.3 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.      
           move 5.9 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 6.4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move p-row10 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 3.9 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using  winprint-set-cursor, winprint-data
                              giving call-result.
                    perform TEST-GIVING.
           
           move zero   to num-rows-detail.
           move 3.7    to row-position.

       PRINT-DETAIL.
           move inv-key     to invde-inv-key
           move low-value   to invde-row
           
           start invoicedetail key not < invde-key
             invalid
                continue
             not invalid
                perform until 1 = 2
                   read invoicedetail next no lock
                      at end
                         exit perform
                   end-read
                   if inv-key not = invde-inv-key
                      exit perform
                   end-if
                   perform PRINT-DETAIL-ROW
                end-perform
           end-start.
           set end-of-invoice  to true.

       PRINT-DETAIL-ROW.

           if num-rows-detail > max-row-detail
              perform CHANGE-PAGE
           end-if.
           add 0.15 to row-position
           add  1  to num-rows-detail
           move invde-product  to field1-p-row12
                                  prod-id
           read product no lock
             invalid
                move space  to prod-description
           end-read
           
           move prod-description  to field2-p-row12
           move "N."              to field3-p-row12
           move invde-qta         to field4-p-row12
           move invde-price       to field5-p-row12
           compute wrk-row-amount = invde-qta * invde-price
           move wrk-row-amount    to field7-p-row12
           move inv-vat           to field8-p-row12
            
           
           add  wrk-row-amount  to wrk-total
           
           initialize wprtdata-draw.                      
           move 0.5 to wprtdata-draw-start-x.
           move row-position to   wprtdata-draw-start-y.
           
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row12
                record-position of field2-p-row12
                record-position of field3-p-row12
                record-position of field4-p-row12
                record-position of field5-p-row12
                record-position of field6-p-row12
                record-position of field7-p-row12
                record-position of field8-p-row12.
           
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-large-font3 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           move wprtunits-inches to winprint-col-units.
           move 1.5 to winprint-col-start.         
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           move wprtunits-inches to winprint-col-units.
           move 4 to winprint-col-start.
           move 0 to winprint-col-indent.
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           move wprtunits-inches to winprint-col-units.
           move 4.3 to winprint-col-start.
           move 0.1 to winprint-col-separation.
           move wprtalign-right to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           move wprtunits-inches to winprint-col-units.
           move 5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           move wprtunits-inches to winprint-col-units.
           move 5.9 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           move wprtunits-inches to winprint-col-units.
           move 6.4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           move wprtunits-inches to winprint-col-units.
           move 7.5 to winprint-col-start.
           move 0 to winprint-col-separation.
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.

           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result
           perform TEST-GIVING.
           
           move p-row12 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.
           
       PRINT-FOOTER.
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 0.5 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 1.5 to wprtdata-draw-start-x.
           move 1.5 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 2.1 to wprtdata-draw-start-x.
           move 2.1 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 3.2 to wprtdata-draw-start-x.
           move 3.2 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.2 to wprtdata-draw-start-x.
           move 4.2 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5.7 to wprtdata-draw-start-x.
           move 5.7 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 6.7 to wprtdata-draw-start-x.
           move 6.7 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 9.030 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row13
                record-position of field2-p-row13
                record-position of field3-p-row13
                record-position of field4-p-row13
                record-position of field5-p-row13
                record-position of field6-p-row13
                record-position of field7-p-row13.
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-small-font2 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 1.5 to winprint-col-start.
           move 0 to winprint-col-indent.
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 2.1 to winprint-col-start.
           move 0.050 to winprint-col-indent.
           move wprtalign-left to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 3.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 4.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 5.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 6.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move p-row13 to p-row.
           write p-row before 1 lines.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 9.125 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row14
                record-position of field2-p-row14
                record-position of field3-p-row14
                record-position of field4-p-row14
                record-position of field5-p-row14
                record-position of field6-p-row14
                record-position of field7-p-row14.
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.
           move 0.050 to winprint-col-separation.
           move wprtalign-right to winprint-col-alignment.
           move h-small-font to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 1.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 2.1 to winprint-col-start.
           move 0.050 to winprint-col-indent.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 3.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 4.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 5.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 6.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           initialize p-row14
           move wrk-total    to wrk-total-ed
           move wrk-total-ed to field1-p-row14
           
           move p-row14 to p-row.
           write p-row before 1 lines.
           perform reset-column.
           
           initialize wprtdata-pen.
           move wprt-pen-solid  to  wprtdata-pen-style.
           move 2 to  wprtdata-pen-width.
           call "WIN$PRINTER"  
                using  winprint-graph-pen, winprint-data
                giving  call-result.
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 10.1 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-pen.
           move wprt-pen-solid  to  wprtdata-pen-style.
           move 1 to  wprtdata-pen-width.
           call "WIN$PRINTER"  
                using  winprint-graph-pen, winprint-data
                giving  call-result.        
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 5.5 to wprtdata-draw-stop-x.
           move 10.7 to wprtdata-draw-start-y.
           move 10.7 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 11 to wprtdata-draw-start-y.
           move 11 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 0.5 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 11 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 11 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 1.3 to wprtdata-draw-start-x.
           move 1.3 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 2.2 to wprtdata-draw-start-x.
           move 2.2 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 3.2 to wprtdata-draw-start-x.
           move 3.2 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.          
           
           initialize wprtdata-pen.
           move wprt-pen-solid  to  wprtdata-pen-style.
           move 1 to  wprtdata-pen-width.
           call "WIN$PRINTER"  
                using  winprint-graph-pen, winprint-data
                giving  call-result.
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 3.6 to wprtdata-draw-start-x.
           move 3.6 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.

           initialize wprtdata-pen.
           move 1 to wprtdata-pen-width.
           call "WIN$PRINTER"  
                using  winprint-graph-pen, winprint-data
                giving  call-result.
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5.5 to wprtdata-draw-start-x.
           move 5.5 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 6.5 to wprtdata-draw-start-x.
           move 6.5 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.                   
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 3.2 to wprtdata-draw-start-x.
           move 3.2 to wprtdata-draw-stop-x.
           move 10.1 to wprtdata-draw-start-y.
           move 10.7 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-pen.
           move 2 to wprtdata-pen-width.
           call "WIN$PRINTER"  
                using  winprint-graph-pen, winprint-data
                giving  call-result.
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5.5 to wprtdata-draw-start-x.
           move 5.5 to wprtdata-draw-stop-x.
           move 10.1 to wprtdata-draw-start-y.
           move 10.7 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 10.7 to wprtdata-draw-start-y.
           move 10.7 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.           
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           perform TEST-GIVING.
           
      *    print-f 15�p-row
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 9.330 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row15
                record-position of field2-p-row15
                record-position of field3-p-row15
                record-position of field4-p-row15
                record-position of field5-p-row15
                record-position of field6-p-row15
                record-position of field7-p-row15.
           
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-small-font2 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 1.3 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 2.2 to winprint-col-start.
           move 0.050 to winprint-col-indent.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 3.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 3.6 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 5.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 6.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move p-row15 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

      *> print-f 16�p-row
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 9.6 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row16
                record-position of field2-p-row16
                record-position of field3-p-row16
                record-position of field4-p-row16
                record-position of field5-p-row16
                record-position of field6-p-row16
                record-position of field7-p-row16.
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-large-font2 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 1.3 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 2.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 3.2 to winprint-col-start.
           move 0 to winprint-col-indent.
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 3.6 to winprint-col-start.
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 5.5 to winprint-col-start.
           move wprtalign-right to winprint-col-alignment.
           move 0.050 to winprint-col-separation.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 6.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           initialize  p-row16
           
           if end-of-invoice
              move inv-vat   to field4-p-row16
              string R"VAT._" delimited by size
                     field4-p-row16   delimited by size
                     "%"              delimited by size
                     into field5-p-row16
                     
              move wrk-total-ed to field6-p-row16
              compute wrk-vat   = wrk-total / 100 * inv-vat
              move wrk-vat   to wrk-total-ed
              move wrk-total-ed to field7-p-row16
           end-if
           
           move p-row16 to p-row.
           write p-row before 1 lines.
           perform reset-column.
           
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 10.150 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row17
                record-position of field2-p-row17
                record-position of field3-p-row17.
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-small-font2 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 3.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 5.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move p-row17 to p-row.
           write p-row before 1 lines.
           perform reset-column.
           
      *>   print-f 18�p-row
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 10.3 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row18
                record-position of field2-p-row18
                record-position of field3-p-row18.
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-separation.
           move wprtalign-right to winprint-col-alignment.
           move h-large-font2 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 3.2 to winprint-col-start.
           move wprtalign-right to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 5.5 to winprint-col-start.
           move wprtalign-right to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           
           if end-of-invoice
           
              move wrk-total    to wrk-total-ed
              move wrk-total-ed to field1-p-row18
           
              move wrk-vat   to wrk-total-ed
              move wrk-total-ed to field2-p-row18
           
              add wrk-VAT  to wrk-total
              move wrk-total    to wrk-total-ed
              move wrk-total-ed to field3-p-row18
           
           end-if
           
           move p-row18 to p-row.
           write p-row before 1 lines.
           perform reset-column.

      *>      * print-f 19�p-row
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 10.725 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row19
                record-position of field2-p-row19.
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-small-font2 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           perform TEST-GIVING.
           move p-row19 to p-row.
           write p-row before 1 lines.
           perform reset-column.

       CHANGE-PAGE.
           perform PRINT-FOOTER
           write p-row from space after page.
           perform PRINT-HEADER.

       PRINT-F-PIC.
           initialize wprtdata-print-bitmap.
           move pic-company to wprtdata-bitmap.
           move 0.4 to wprtdata-bitmap-row.
           move 0.8 to wprtdata-bitmap-col.
           move 1.7 to wprtdata-bitmap-width.
           move 0.8 to wprtdata-bitmap-height.
           move wprtbitmap-scale-inches to wprtdata-bitmap-flags.
           add  wprtbitmap-units-inches to wprtdata-bitmap-flags.  
           call "WIN$PRINTER" using winprint-print-bitmap,
                                    winprint-data.

       LOAD-FONT.
           call "w$createfont" using "fonts/arial.ttf" wrk-arial
           call "w$createfont" using "fonts/ariblk.ttf" wrk-arial-black
           
           initialize wfont-data.
           set wfdevice-win-printer to true.
           move wrk-arial-black to wfont-name.
           move 7 to wfont-size.
           call   "W$FONT" using  wfont-get-font,
                                  h-font-print, 
                                  wfont-data
                           giving call-result.
           perform TEST-GIVING.
           initialize wprtdata-set-font.
           move h-font-print to wprtdata-font.
           call "WIN$PRINTER" using winprint-set-font,
                                    winprint-data
                              giving call-result.
           perform TEST-GIVING.

       LOAD-LARGE-FONT.
           initialize wfont-data.
           set wfdevice-win-printer to true.
           move wrk-arial to wfont-name.
           move 13 to wfont-size.
           set wfont-italic to true.
           set wfont-bold to true.
           call "W$FONT" using  wfont-get-font,
                                h-large-font, 
                                wfont-data
                          giving call-result.
           perform TEST-GIVING.
           if flag = 1
              initialize wprtdata-set-font
              move h-large-font to wprtdata-font
              call "WIN$PRINTER" using winprint-set-font,
                   winprint-data
                   giving call-result
              perform TEST-GIVING
           end-if.
           
       LOAD-LARGE-FONT2.
           initialize wfont-data.
           set wfdevice-win-printer to true.
           move wrk-arial to wfont-name.
           move 10 to wfont-size.
           call "W$FONT"
           using wfont-get-font,
                h-large-font2, wfont-data
                giving call-result.
           perform TEST-GIVING.
           if flag = 1
              initialize wprtdata-set-font
              move h-large-font2 to wprtdata-font
              call "WIN$PRINTER" using winprint-set-font,
                   winprint-data
                   giving call-result
              perform TEST-GIVING
           end-if.

       LOAD-LARGE-FONT3.
           initialize wfont-data.
           set wfdevice-win-printer to true.
           move wrk-arial to wfont-name.
           move 8 to wfont-size.
           call "W$FONT" using  wfont-get-font,
                                h-large-font3, 
                                wfont-data
                         giving call-result.
           perform TEST-GIVING.
           if flag = 1
              initialize wprtdata-set-font
              move h-large-font3 to wprtdata-font
              call "WIN$PRINTER" using winprint-set-font,
                   winprint-data
                   giving call-result
              perform TEST-GIVING
           end-if.

       SET-SMALL-FONT.
           initialize wfont-data.
           set wfdevice-win-printer to true.
           move wrk-arial to wfont-name.
           move 6 to wfont-size.
           set wfont-bold to true.
           call "W$FONT" using  wfont-get-font,
                                h-small-font, 
                                wfont-data
                          giving call-result.
           perform TEST-GIVING.
           initialize wprtdata-set-font.
           move h-small-font to wprtdata-font.
           call "WIN$PRINTER" using  winprint-set-font,
                                     winprint-data
                              giving call-result.
           perform TEST-GIVING.

       SET-SMALL-FONT2.
           initialize wfont-data.
           set wfdevice-win-printer to true.
           move wrk-arial to wfont-name.
           move 5 to wfont-size.
           call "W$FONT" using  wfont-get-font,
                                h-small-font2, 
                                wfont-data
                         giving call-result.
           perform TEST-GIVING.
           if flag = 1
              initialize wprtdata-set-font
              move h-small-font2 to wprtdata-font
              call "WIN$PRINTER" using  winprint-set-font,
                                        winprint-data
                                 giving call-result
              perform TEST-GIVING
           end-if.

       ST-UNDER-LOGO.
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 1.3 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                winprint-data
                giving call-result.
           perform TEST-GIVING.           
           move R"url_mail_address"
                to p-row.
           write p-row before 1 lines.

       RESET-COLUMN.
       call "WIN$PRINTER" using  winprint-clear-data-columns,
                          giving call-result.
       perform TEST-GIVING.
       call "WIN$PRINTER" using  winprint-clear-page-columns,
                          giving call-result.
       perform TEST-GIVING.


       TEST-GIVING.
           if call-result not = 1
              display message box R"Operation_failed!!"
                    icon mb-warning-icon
           end-if.

       DESTROY-RESOURCE.
           call "W$BITMAP" using wbitmap-destroy, pic-company.

           copy "dec-file.prd".