*> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
*> may freely modify and redistribute this program.

*>
 class-id. AssociativeArray            as "AssociativeArray".
 configuration section.
 repository.
    class JVector                      as "java.util.Vector"
    class JObject                      as "java.lang.Object"
    class JString                      as "java.lang.String"
    class JInteger                     as "java.lang.Integer"
    class NumberFormatException        as "java.lang.NumberFormatException"   
    .
 identification division.
 object.
 working-storage section.
 77 wJVector                           object reference JVector.
 77 wJVectorKey                        object reference JVector.
 procedure division.
*>---
 identification division.
 method-id. Cnew                       as "new".
 procedure division.
 main.
   set wJVector to JVector:>new.
   set wJVectorKey to JVector:>new.
   end method.
*>---   
 identification division.
 method-id. Mset                       as "set".
 linkage section.
 77 para1                              object reference JObject.
 procedure division using para1.
 main.
   wJVector:>add(para1).
   wJVectorKey:>add(null).
   end method.
*>---
 identification division.
 method-id. Mset                       as "set".
 working-storage section.
 77 idx                                signed-long.
 linkage section.
 77 para1                              object reference JObject.
 77 para2                              object reference JObject.
 procedure division using para1 para2.
 main.
   try
      set idx to JInteger:>parseInt(para1:>toString)
      if idx >= wJVector:>size
         wJVector:>add(idx para2)
         wJVectorKey:>add(idx null)
      else
         wJVector:>set(idx para2)
      end-if
   catch NumberFormatException
      if para1 not = null
         set idx to wJVectorKey:>indexOf(para1:>toString) 
         if idx not = -1
            wJVector:>set(idx para2)
         else
            wJVector:>add(para2)
            wJVectorKey:>add(para1:>toString)
         end-if
      end-if
   end-try.
   end method.
*>---
 identification division.
 method-id. Mget                       as "get".
 working-storage section.
 77 idx                                signed-long.
 77 rc                                 pic s9(9).
 linkage section.
 77 para1                              object reference JObject.
 procedure division using para1 returning rc.
 main.
   try
      set idx to JInteger:>parseInt(para1:>toString)
      set rc to wJVector:>get(idx)
   catch NumberFormatException
      set rc to null
      if para1 not = null
         set idx to wJVectorKey:>indexOf(para1:>toString) 
         if idx not = -1
            set rc to wJVector:>get(idx)
         end-if
      end-if
   end-try.
   end method.  
*>---
 identification division.
 method-id. MgetKey                    as "getKey".
 working-storage section.
 77 rc                                 pic x any length.
 linkage section.
 77 para1                              object reference "int".
 procedure division using para1 returning rc.
 main.
   set rc to wJVectorKey:>get(para1) as string.
   end method.   
*>---
 identification division.
 method-id. Mremove                    as "remove".
 working-storage section.
 77 idx                                signed-long.
 77 rc                                 object reference JObject.
 linkage section.
 77 para1                              object reference JObject.
 procedure division using para1 returning rc.
 main.
   try
      set idx to JInteger:>parseInt(para1:>toString)
      wJVectorKey:>remove(idx as int)
      set rc to wJVector:>remove(idx as int)
   catch NumberFormatException
      set rc to null
      if para1 not = null
         set idx to wJVectorKey:>indexOf(para1:>toString) 
         if idx not = -1
            wJVectorKey:>remove(idx as int)
            set rc to wJVector:>remove(idx as int)
         end-if
      end-if
   end-try.
   end method. 
*>---
 identification division.
 method-id. Mclear                     as "clear".
 procedure division.
 main.
   wJVector:>clear.
   wJVectorKey:>clear.
   end method.   
*>---
 identification division.
 method-id. Mcapacity                  as "size".
 working-storage section.
 77 rc                                 object reference "int".
 procedure division returning rc.
 main.
   set rc to wJVector:>size.
   end method.   
*>---
 end object.
 