package calendarpanel;

import java.util.Date;
import java.util.EventObject;

public class CalendarPanelEvent extends EventObject {

   public static final int DATE_CHANGED = 1;
   public static final int ITEM_CLICKED = 2;
   public static final int PANEL_CLICKED = 3;
   
   private Date date;
   private String description;
   private int type;
   
   public CalendarPanelEvent(Object source, Date date, String description, int type) {
      super(source);
      this.date = date;
      this.description = description;
      this.type = type;
   }

   public Date getDate() {
      return date;
   }

   public String getDescription() {
      return description;
   }

   public int getType() {
      return type;
   }

}
