      *    Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *    may freely modify and redistribute this program.
      
       PROGRAM-ID. THREAD-BRIDGE.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       DATA DIVISION.
       FILE SECTION.

       WORKING-STORAGE SECTION.
           copy "audit-linkage.wrk".

       01  audit                      pic 9 external.
           88 audit-enabled           value 1 false zero.

       LINKAGE SECTION.
       77  prg-to-launch  pic x(15).

       PROCEDURE DIVISION USING prg-to-launch. 

       MAIN.
      *    Register the start of the execution of a COBOL program   
      *    according to the audit settings
           if audit-enabled
              move prg-to-launch to audit-prg-to-launch
              set audit-register-pgm-start  to true
              call "AUDIT" using audit-link 
           end-if

           call prg-to-launch
              on overflow
                 perform CALL-NOT-FOUND
           end-call

           cancel prg-to-launch 

      *    Register the end of the execution of a COBOL program 
      *    according to the audit settings
           if audit-enabled
              move prg-to-launch to audit-prg-to-launch
              set audit-register-pgm-end to true
              call "AUDIT" using audit-link 
           end-if

           goback.

       CALL-NOT-FOUND.
           display message box R"Program_not_Found!".
       