*> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
*> may freely modify and redistribute this program.
 >> IMP OPTION "-sddp"
 program-id.                 printgui.

 configuration section.
 special-names.   

 input-output section.
 file-control.

 file section.

 working-storage section.
 copy "isfonts.def".
 copy "isgui.def".
 copy "iscobol.def".
 copy "iscrt.def".
 copy "isopensave.def".
 copy "isresize.def".
 copy "isprint.def".
 copy "color.wrk".
 copy "notifprog-link.wrk".
 copy "pdf-attributes.wrk".

 01                          pic 9 value 1.
    88 first-call            value 1 false 0.

 77 key-status               is special-names crt status pic 9(5).

*> handle of windows
 77 h-inde                   handle of window.
 77 h-flo                    handle of window.

*> screen variable
 77 print-mode               pic 9.
    88 pm-preview            value 1.
    88 pm-pdf                value 2.
    88 pm-spooler            value 3.

 77 path-pdf                 pic x(256).

 77 pdf-creation-side        pic 9.
    88 pdf-on-client         value 1.
    88 pdf-on-server         value 2.

 77 spooler-elaboration-side pic 9.
    88 spool-on-client       value 1.
    88 spool-on-server       value 2.

 77 name-c-pdf               pic x(256).
 77 cbopen-pdf               pic 9.

 77 e-encrypt                pic 9.
 
 77 e-spooler                pic 9.

 01 pdf-attributes-buff.
    03 attributes-title-buff                      pic x(64).
    03 attributes-subject-buff                    pic x(64).
    03 attributes-keywords-buff                   pic x(512).
    03 attributes-author-buff                     pic x(32).
    03 attributes-pdf-type-buff                   pic x(20).
       88 attributes-pdf-default-buff             value "Default".
       88 attribute-pdfA-1A-buff                  value "PDF/A-1A".
       88 attribute-pdfA-1B-buff                  value "PDF/A-1B".
    03 attributes-image-type-buff                 pic 9.
       88 attributes-image-raw-buff               value 1.
       88 attributes-image-jpeg-buff              value 2.
    03 attributes-jpeg-quality-buff               pic 9(3).
    03 attributes-encryption-buff                 pic 9.
       88 attributes-encryption-on-buff           value 1.
       88 attributes-encryption-off-buff          value 0.
    03 attributes-encryption-type-buff            pic x(20).
       88 attributes-encrypt-std40-buff           value "Standard 40 bit".
       88 attributes-encrypt-st128-buff           value "Standard 128 bit".
       88 attributes-encrypt-aes128-buff          value "AES 128 bit".
       88 attributes-encrypt-no-meta-buff         value "No metadata".
       88 attributes-encrypt-embeded-only-buff    value "Embedded Files Only".
    03 attributes-encrypt-pwd-buff                pic x(20).
    03 attributes-encrypt-all-permission-buff     pic 9.
    03 attributes-encrypt-print-buff              pic 9.
    03 attributes-encrypt-copy-buff               pic 9.
    03 attributes-encrypt-modify-annotation-buff  pic 9.

*> exception for the print screen
 78 print-pb-pdf-attributes     value 6001.
 78 print-pb-browse-pdf-file    value 6002.

*> other variable
 77 close-window               pic 9 value 0.
 77 auto-layout                handle of layout-manager lm-scale.
 77 cont-separator             pic 9(2).
 77 num-of-client-printers     pic 9(3). 
 77 num-of-server-printers     pic 9(3). 
 77  call-result               signed-int.

 77  lm-zoom-max-font          handle of layout-manager, lm-zoom "max-font-zoom=300 min-font-zoom=50".

 LINKAGE SECTION.
 copy "printgui-link.wrk". 
 screen section.
 01 mask-print.
    03 frame
       line 1 col 2
       lines 14.4 size 50
       engraved
       title "Print Options"
       title-position 3
       height-in-cells
       width-in-cells
       transparent
       .
    03 radio-preview
       Radio-Button 
       col 4 
       line 3 
       size 14  
       group 7
       group-value 1
       value print-mode
       height-in-cells
       width-in-cells
       title "-P PREVIEW"
       id 1001
       event PREVIEW-PDF-SETTINGS
       transparent
       .
    03 push-pdf-attribute
       push-button
       title "PDF attributes"
       line 2.7 
       col 18
       size 19 lines 1.5
       height-in-cells
       width-in-cells
       enabled 0
       exception-value print-pb-pdf-attributes
       .
    03 radio-pdf
       Radio-Button
       title "-P PDF " 
       col 4 
       line 5 
       size 9   
       group 7
       group-value 2
       value print-mode
       height-in-cells
       width-in-cells
       event PDF-PRINT-SETTINGS
       transparent
       .
    03 entry-pdf-path
       entry-field
       line 4.9 
       col 18
       size 28 lines 1.5
       height-in-cells
       width-in-cells
       max-text 256
       enabled 0
       value name-c-pdf
       .
    03 push-browse
       push-button
       title "..."
       line 4.9, col + 1.5
       size 3, lines 1.5  
       height-in-cells
       width-in-cells   
       enabled 0
       exception-value print-pb-browse-pdf-file
       .
    03 radio-pdf-on-client, 
       Radio-Button 
       col 7 
       line 7 
       size 20
       group 8
       group-value 1
       value pdf-creation-side
       enabled 0
       height-in-cells
       width-in-cells
       title "process on client"
       notify 
       event ENABLE-OPEN
       transparent
       .
    03 radio-pdf-on-server, 
       Radio-Button 
       col + 1 
       size 20
       group 8
       group-value 2
       value pdf-creation-side
       enabled 0
       height-in-cells
       width-in-cells
       title "process on server"
       notify
       event DISABLE-OPEN
       transparent
       .
    03 check-show-pdf
       check-box
       col 7 
       line 9
       size 24
       value cbopen-pdf
       enabled 0
       height-in-cells
       width-in-cells
       title "show pdf file when done"
       transparent
       .
    03 radio-spooler
       Radio-Button 
       col 4 
       line 11
       size 14
       group 7
       group-value 3
       value print-mode
       height-in-cells
       width-in-cells
       title "-P SPOOLER"
       event SPOOLER-PRINT-SETTINGS
       enabled e-spooler
       transparent
       .
    03 radio-spooler-on-client
       Radio-Button 
       col 7 
       line 13 
       size 20
       group 9
       group-value 1
       value spooler-elaboration-side
       enabled 0
       height-in-cells
       width-in-cells
       title "process on client"
       notify 
       transparent
       .
    03 radio-spooler-on-server
       Radio-Button 
       col + 1 
       size 20
       group 9
       group-value 2
       value spooler-elaboration-side
       enabled 0
       height-in-cells
       width-in-cells
       title "process on server"
       notify
       transparent
       .
    03 pbok
       push-button
       title "OK"
       line 16 col 2
       exception-value 13
       .
    03 pbex
       push-button
       title "Cancel"
       line 16 col 42.5
       exception-value 27
       .
 01 win-pdf-attributes.
    03 label
       height-in-cells
       width-in-cells
       title "Title"
       line 2 col 3
       lines 1.5
       size 10
       .
    03 entry-field
       height-in-cells
       width-in-cells
       line 2 col + 2
       lines 1.5
       size 30
       max-text 64
       value attributes-title-buff
       .
    03 label
       height-in-cells
       width-in-cells
       title "Subject"
       line 2 col 48
       size 10
       .
    03 entry-field
       height-in-cells
       width-in-cells
       line 2 col + 2
       lines 1.5
       size 30
       max-text 64
       value attributes-subject-buff
       .
    03 label
       height-in-cells
       width-in-cells
       title "Author"
       line 4 col 3
       size 10
       .
    03 entry-field
       height-in-cells
       width-in-cells
       line 4 col + 2
       lines 1.5
       size 30
       max-text 32
       value attributes-author-buff
       .
    03 label
       height-in-cells
       width-in-cells
       title "Keywords"
       line 4 col 48
       size 10
       .
    03 entry-field
       height-in-cells
       width-in-cells
       line 4 col + 2
       lines 1.5
       size 30
       max-text 512
       multiline
       lines 3.5
       value attributes-keywords-buff
       .
    03 label
       height-in-cells
       width-in-cells
       title "Pdf Type"
       line 6 col 3
       size 10
       .
    03 Combo-box
       height-in-cells
       width-in-cells
       line 6 col + 2
       size 30
       Drop-List
       value attributes-pdf-type-buff
       item-to-add ("Default", "PDF/A-1A", "PDF/A-1B")
       .
    03 frame
       line 9 col 3
       lines 7 size 86
       engraved
       title "Image options"
       height-in-cells
       width-in-cells
       .
    03 label
       height-in-cells
       width-in-cells
       title "type"
       line 11 col 5
       size 8
       .
    03 Radio-Button 
       height-in-cells
       width-in-cells
       col + 2
       line 11.1
       size 7
       group 1
       group-value 1
       value attributes-image-type-buff
       title "Raw"
       event DISABLE-SLIDER
       .
    03 Radio-Button 
       height-in-cells
       width-in-cells
       col + 3
       line 11.1
       size 10
       group 1
       group-value 2
       value attributes-image-type-buff
       title "Jpeg"
       event ENABLE-SLIDER
       .
    03 label
       height-in-cells
       width-in-cells
       title "Jpeg quality"
       line 11 col 44
       size 10
       .
    03 win-pdf-slider
       slider
       height-in-cells
       width-in-cells
       show-ticks 
       horizontal 
       line 10.3 
       col + 2
       size 32
       lines 3.5
       max-val 100
       min-val 1
       minor-tick-spacing 5
       major-tick-spacing 10
       value attributes-jpeg-quality-buff
       .
    03 label
       height-in-cells
       width-in-cells
       title "1"
       line 13.5 col 55.3
       size 3
       .
    03 label
       height-in-cells
       width-in-cells
       title "50"
       line 13.5 col 70.2
       size 3
       .
    03 label
       height-in-cells
       width-in-cells
       title "100"
       line 13.5 col 84
       size 3
       .
    03 frame
       line 17 col 3
       lines 6.5 size 86
       engraved
       height-in-cells
       width-in-cells
       .
    03 cb-encrypt
       check-box 
       col 5 
       line 17
       size 19
       height-in-cells
       width-in-cells
       title "Encryption options"
       value attributes-encryption-buff
       event CHECK-ENCRYPT
       .
    03 label
       height-in-cells
       width-in-cells
       title "Type"
       line 19 col 5
       lines 2
       size 10
       .
    03 c-encrypt-type
       Combo-box
       height-in-cells
       width-in-cells
       line 19 col + 2
       size 30
       Drop-List
       unsorted
       value attributes-encryption-type-buff
       item-to-add ("Standard 40 bit", "Standard 128 bit", "AES 128 bit", "No metadata", "Embedded Files Only")
       enabled e-encrypt
       .
    03 label
       height-in-cells
       width-in-cells
       title "Password"
       line 21 col 5
       size 10
       .
    03 ef-encrypt-pwd
       entry-field
       height-in-cells
       width-in-cells
       line 21 col + 2
       lines 1.5
       size 30
       lines 1.5
       value attributes-encrypt-pwd-buff
       enabled e-encrypt
       .
    03 cb-encrypt-all-permission
       check-box 
       col 49
       line 19
       size 18
       height-in-cells
       width-in-cells
       title "All Permission"
       value attributes-encrypt-all-permission-buff
       enabled e-encrypt
       .
    03 cb-encrypt-print
       check-box 
       col  49 
       line 21  
       size 18
       height-in-cells
       width-in-cells
       title "Printing"
       value attributes-encrypt-print-buff
       enabled e-encrypt
       .
    03 cb-encrypt-copy
       check-box 
       col 68  
       line 19
       size 18
       height-in-cells
       width-in-cells
       title "Copy"
       value attributes-encrypt-copy-buff
       enabled e-encrypt
       .
    03 cb-encrypt-annotation
       check-box 
       col 68 
       line 21   
       size 20
       height-in-cells
       width-in-cells
       title "Modify Annotation"
       value attributes-encrypt-modify-annotation-buff
       enabled e-encrypt
       .
    03 push-button
       height-in-cells
       width-in-cells
       title "&Ok"
       line 24.5 col 3
       lines 1.5
       size 10
       termination-value 13
       .
    03 push-button
       height-in-cells
       width-in-cells
       title "&Cancel"
       line 24.5 col 79
       lines 1.5
       size 10
       termination-value 27
       .

 procedure division using printgui-lnk.
 MAIN.
   if first-call
      perform SET-DEFAULT
      set first-call to false
   end-if

   if prng-force-preview
      set pm-preview         to true
      perform PRINT-PROCEDURE
      set prng-force-preview to false
   else
      perform PRINT-INTERFACE
   end-if.
   goback.
   
 PRINT-INTERFACE.   
   display floating graphical window
           system menu 
           title "Print"
           lines 17 size 52
           min-lines 17 min-size 52
           control font prng-h-font
           visible 0
           event CLOSE-WIN
           handle h-inde
           layout-manager lm-zoom-max-font
           resizable
           gradient-color-1 rgb 78-white
           gradient-color-2 rgb 78-gradient
           gradient-orientation gradient-north-to-south.
   display mask-print

   if prng-lines < 17
      move 17 to prng-lines
   end-if
   if prng-size < 52
      move 52 to prng-size
   end-if

   modify h-inde lines prng-lines 
   modify h-inde size prng-size
   if prng-line not = -999 and prng-col not = -999
      modify h-inde line prng-line
      modify h-inde col prng-col
   end-if
   if pm-preview
      modify push-pdf-attribute       enabled 1
   end-if
   if pm-pdf
      if prng-env-code = runenv-web-client
         modify radio-pdf-on-client   enabled 0
         set pdf-on-server            to true
      else
         modify radio-pdf-on-client   enabled 1
      end-if
      modify entry-pdf-path           enabled 1
      modify push-pdf-attribute       enabled 1
      modify check-show-pdf           enabled 1
      if pdf-on-client
         modify push-browse           enabled 1
      end-if
      if is-remote
         modify radio-pdf-on-server   enabled 1
      end-if
   end-if
   if pm-spooler
      modify entry-pdf-path              enabled 0
      modify push-pdf-attribute          enabled 0
      modify radio-spooler-on-client     enabled 1
      if is-remote and num-of-server-printers not = 0
         modify radio-spooler-on-server  enabled 1
      else 
         modify radio-spooler-on-server  enabled 0
      end-if
      modify radio-pdf-on-client         enabled 0
      modify radio-pdf-on-server         enabled 0
      modify push-browse                 enabled 0
      modify check-show-pdf              enabled 0
   end-if
   modify h-inde visible 1
   perform until key-status = 27 or 13
      accept mask-print 
         on exception 
            continue 
      end-accept
      evaluate key-status
      when print-pb-pdf-attributes 
           perform SET-PDF-ATTRIBUTES
      when print-pb-BROWSE-PDF-FILE
           perform BROWSE-PDF-FILE
      end-evaluate
      if close-window = 1
         move 0 to  close-window
         exit perform
      end-if
   end-perform
   inquire h-inde lines prng-lines
   inquire h-inde size  prng-size
   inquire h-inde line  prng-line
   inquire h-inde col   prng-col
   destroy mask-print h-inde
   if key-status = 13
      perform PRINT-PROCEDURE
   end-if
   move 0 to key-status
   .

 PRINT-PROCEDURE.
   perform PROGRESS-GO

   if pm-pdf
      perform NORMALIZE-PDF-NAME
   end-if
   call "PRINTPROG" using print-mode 
                          path-pdf 
                          pdf-creation-side 
                          pdf-attributes
                          spooler-elaboration-side
   perform PROGRESS-STOP
   evaluate true 
   when pm-pdf
        if cbopen-pdf = 1
           if name-c-pdf = spaces
              move "iscobolPrint.pdf" to name-c-pdf
           end-if
           if prng-env-code = runenv-standalone
              call "c$easyopen" using path-pdf
           else
              if pdf-on-client and cbopen-pdf = 1
                 call client "c$easyopen" using path-pdf
              else
                 call "c$easyopen" using path-pdf 1
              end-if
           end-if
        else
           perform SHOW-PRINT-NOTIFICATION
        end-if
   when pm-spooler
        perform SHOW-PRINT-NOTIFICATION
   end-evaluate.
   
 SHOW-PRINT-NOTIFICATION.
   if os-is-mac
      set notif-top-right to true
   else
      set notif-bottom-right to  true
   end-if
   move 500            to notif-before-time
   move 0              to notif-delay
   move prng-h-bmpicon to notif-bmp-handle

   initialize notif-text
   move "Printing completed" to notif-text
   call "NOTIFPROG" using notifprog-lnk
                          notif-text.

 PREVIEW-PDF-SETTINGS.
   evaluate event-type
   when cmd-clicked
        if control-id = 1001
           modify push-pdf-attribute     enabled 1
        else
           modify push-pdf-attribute     enabled 0
        end-if
        modify entry-pdf-path            enabled 0
        modify push-browse               enabled 0
        modify check-show-pdf            enabled 0
        modify radio-pdf-on-client       enabled 0
        modify radio-pdf-on-server       enabled 0
        modify radio-spooler-on-client   enabled 0
        modify radio-spooler-on-server   enabled 0
        set event-action to event-action-continue
   end-evaluate
   .

 PDF-PRINT-SETTINGS.
   evaluate event-type
   when cmd-clicked
        modify entry-pdf-path            enabled 1
        modify push-pdf-attribute        enabled 1
        if prng-env-code = runenv-web-client
           modify radio-pdf-on-client    enabled 0
        else
           modify radio-pdf-on-client    enabled 1
        end-if
        if pdf-on-client
           modify push-browse            enabled 1
        end-if
        modify check-show-pdf            enabled 1
        if is-remote
           modify radio-pdf-on-server    enabled 1
        end-if
        modify radio-spooler-on-client   enabled 0
        modify radio-spooler-on-server   enabled 0
   end-evaluate
   .

 SPOOLER-PRINT-SETTINGS.
   evaluate event-type
   when cmd-clicked
        modify entry-pdf-path               enabled 0
        modify push-pdf-attribute           enabled 0
        modify radio-spooler-on-client      enabled 1
        if is-remote and num-of-server-printers not = 0
           modify radio-spooler-on-server   enabled 1
        else 
           modify radio-spooler-on-server   enabled 0
        end-if
        modify radio-pdf-on-client          enabled 0
        modify radio-pdf-on-server          enabled 0
        modify push-browse                  enabled 0
        modify check-show-pdf               enabled 0
   end-evaluate
   .

 ENABLE-OPEN.
   evaluate event-type
   when cmd-clicked
        modify check-show-pdf   enabled 1
        modify push-browse      enabled 1
   end-evaluate
   .

 DISABLE-OPEN.
   evaluate event-type
   when cmd-clicked
        modify push-browse   enabled 0
   end-evaluate
   .

 BROWSE-PDF-FILE.
   initialize opensave-data
   move "PDF files (*.pdf)|*.pdf" to opnsav-filters
   move name-c-pdf                to opnsav-filename
   call "C$OPENSAVEBOX" using opensave-save-box
                              opensave-data
   if return-code > 0
      move opnsav-filename to name-c-pdf
      display entry-pdf-path
   end-if
   .
 
  PROGRESS-GO.
   modify prng-h-status panel-index 2 panel-bitmap prng-h-progress-go
   .

 PROGRESS-STOP.
   modify prng-h-status panel-index 2 panel-bitmap prng-h-progress-stop
   .
 
 CLOSE-WIN.
   if event-type = msg-close
      move 1 to close-window
      set event-action to event-action-terminate
   end-if
   .
 
 SET-PDF-ATTRIBUTES.
   move pdf-attributes to pdf-attributes-buff

   if attributes-encryption-on
      move 1   to e-encrypt
   else
      move 0  to e-encrypt
   end-if

   display floating graphical window
           system menu 
           title "Attributes"
           lines 26 size 90
           min-lines 26 min-size 90
           control font prng-h-font
           visible 0
           event CLOSE-WIN
           handle h-flo
           resizable
           layout-manager lm-scale
   display win-pdf-attributes

   evaluate true
   when attributes-image-raw-buff
        modify win-pdf-slider enabled 0
   when attributes-image-jpeg-buff
        modify win-pdf-slider enabled 1
   end-evaluate.

   modify h-flo visible 1
   perform until key-status = 27 or 13
      accept win-pdf-attributes on exception continue end-accept
      if close-window = 1
         move 0 to  close-window
         exit perform
      end-if
   end-perform
   destroy win-pdf-attributes h-flo
   if key-status = 13
      move pdf-attributes-buff to pdf-attributes
   end-if
   move 0 to key-status
   . 
   
 ENABLE-SLIDER.
   evaluate event-type
   when cmd-clicked
        modify win-pdf-slider enabled 1
   end-evaluate
   .

 DISABLE-SLIDER.
   evaluate event-type
   when cmd-clicked
        modify win-pdf-slider enabled zero
   end-evaluate
   .

 CHECK-ENCRYPT.
   evaluate event-type
   when cmd-clicked
        if attributes-encryption-buff = 0
           move 1 to attributes-encryption-buff
                     e-encrypt 
        else
           move 0 to attributes-encryption-buff
                     e-encrypt 
        end-if
        perform ENABLE-DISABLE-ENCRYPT
   end-evaluate
   .

 ENABLE-DISABLE-ENCRYPT.
   modify c-encrypt-type enabled e-encrypt
   modify ef-encrypt-pwd enabled e-encrypt
   modify cb-encrypt-all-permission enabled e-encrypt
   modify cb-encrypt-print enabled e-encrypt
   modify cb-encrypt-copy enabled e-encrypt
   modify cb-encrypt-annotation enabled e-encrypt
   .
   
 SET-DEFAULT.
   accept terminal-abilities from terminal-info.
   set  pm-preview             to true
   move "Report_test.pdf"      to name-c-pdf

   if prng-env-code = runenv-web-client
      set pdf-on-server        to true
   else   
      set pdf-on-client        to true
   end-if.
   set spool-on-client         to true
   move "PDF Sample"           to attributes-title
   move "created with isCOBOL" to attributes-subject
   move "Veryant,isCOBOL,-P PDF,winprint-set-attribute"  to attributes-keywords 
   move "Veryant"              to attributes-author
   move "Default"              to attributes-pdf-type
   move 2                      to attributes-image-type
   move 51                     to attributes-jpeg-quality
   move 0                      to attributes-encryption
   move "AES 128 bit"          to attributes-encryption-type
   move space                  to attributes-encrypt-pwd
   move 1                      to attributes-encrypt-all-permission
   move 0                      to attributes-encrypt-print
   move 0                      to attributes-encrypt-copy
   move 0                      to attributes-encrypt-modify-annotation.
   move 0                      to cbopen-pdf
   move 0                      to e-encrypt.

   perform GET-NUM-OF-PRINTERS.
   if num-of-client-printers = 0 and
      num-of-server-printers = 0
      move 0 to e-spooler
   else
      move 1 to e-spooler
   end-if.   

 GET-NUM-OF-PRINTERS.
   if prng-env-code = runenv-web-client
      move 1 to num-of-client-printers
   else
      call "WIN$PRINTER" using WINPRINT-GET-NO-PRINTERS
                               WINPRINT-SELECTION
                        giving call-result
      move winprint-no-of-printers  to num-of-client-printers
   end-if.
   
   if prng-env-code = runenv-thin-client or prng-env-code = runenv-web-client
      set wprt-as-server to true
      call "WIN$PRINTER" using winprint-set-printer-as 
                               winprint-as

      call "WIN$PRINTER" using WINPRINT-GET-NO-PRINTERS
                               WINPRINT-SELECTION
                        giving call-result
      move winprint-no-of-printers  to num-of-server-printers

      set wprt-as-client to true
      call "WIN$PRINTER" using winprint-set-printer-as 
                               winprint-as
   else
      move 0 to num-of-server-printers
   end-if.

 NORMALIZE-PDF-NAME.
   move zero     to cont-separator
   inspect name-c-pdf tallying cont-separator for all "\"
   if cont-separator = zero
      inspect name-c-pdf tallying cont-separator for all "/"
   end-if
   if cont-separator = zero
      initialize path-pdf
      if pdf-on-client
         CALL CLIENT "C$GETENV" USING "user.home"
                                       path-pdf
      else
         CALL "C$GETENV" USING "user.home"
                               path-pdf
      end-if

      string path-pdf   delimited by trailing space
             "/"        delimited by size
             name-c-pdf delimited by size
          into path-pdf
   else
      move name-c-pdf to path-pdf
   end-if.