      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    TRIM.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isfonts.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  the-string              pic x(12).
       77  str-size                pic 9(9).

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              title                "Original string"
              .
           03 label
              line                 4
              col                  2 
              title                "Original string size:"
              .                    
           03 lb-osz
              label
              line                 4
              col                  26 
              size                 10 cells
              .
           03 push-button
              line                 7
              col                  2
              size                 8 cells
              title                "TRIM"
              exception-value      101
              self-act
              .
           03 push-button
              line                 7
              col                  12
              size                 8 cells
              title                "TRIML"
              exception-value      102
              self-act
              .
           03 push-button
              line                 7
              col                  22
              size                 8 cells
              title                "TRIMR"
              exception-value      103
              self-act
              .
           03 label
              line                 10
              col                  2
              title                "String after trim:"
              .
           03 label
              line                 12
              col                  2
              title                "String size after trim:"
              .
           03 lb-nsz
              label
              line                 12
              col                  26
              size                 10
              .
           03 Pb-exit  
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.       
           move "   abc123   "  to the-string
           display standard graphical window
                   background-low  
                   line 2
                   col 65
                   title  "TRIM, TRIML & TRIMR Functions"
                   lines 21 
                   size 70 
                   control font fixed-font 
                   font fixed-font
                   handle hWin 
                   event  WIN-EVT

           display Mask

           display the-string 
                   col 26 line 2 
                   size 12 
                   background-color rgb x#FFFF80.

           modify lb-osz title function length (the-string)

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    evaluate crt-status
                    when 101
                         perform TRIM
                    when 102
                         perform TRIML
                    when 103
                         perform TRIMR
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move EVENT-ACTION-FAIL-TERMINATE to EVENT-ACTION 
                move 1 to close-win
           end-evaluate
           .

       TRIM.
           move function length (function trim(the-string))  
                                      to str-size
           modify lb-nsz title str-size

           display space line 10 col 26 size 15
           display function trim(the-string)
                   col 26 line 10 
                   size str-size
                   background-color rgb x#FFFF80
           .

       TRIML.
           move function length (function triml(the-string))
                                      to str-size
           modify lb-nsz title str-size
           display space line 10 col 26 size 15
           display function triml(the-string)
                   col 26 line 10 
                   size str-size
                   background-color rgb x#FFFF80.
           .

       TRIMR.
           move function length (function trimr(the-string))  
                                      to str-size
           modify lb-nsz title str-size
           display space line 10 col 26 size 15
           display function trimr(the-string)
                   col 26 line 10 
                   size str-size
                   background-color rgb x#FFFF80
           .

