      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CLOCKPID.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select file1 assign to path-file1
           organization indexed
           access dynamic
           record key f1-cod
           status file-status
           .

       FILE SECTION.

       FD  file1.
       01  f1-rec.
           03 f1-cod               pic 9(9).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  file-status             pic x(2).
       77  path-file1              pic x any length.
       77  taskID                  pic 9(5).
       77  file-status-type        pic x any length.
       77  rec-locked-code         pic x(2).
       77  file-locked-code        pic x(2).

       SCREEN SECTION.
       01  Mask.
           03  push-button
               line                3 
               col                 2
               size                17 cells
               title               "Check Record Lock" 
               exception-value     101
               .
           03  push-button
               line                5
               col                 2
               size                17 cells
               title               "Check File Lock" 
               exception-value     102
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.

       INI.   
           set environment "file.index" to "ctreej".
           set environment "file.errors_ok" to 1.

           perform CHECK-FILE-STATUS-CODE
           
           perform CREATE-FILE.

           perform CALL-LOCK-FILE.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title "C$LOCKPID Routine"
                   control font control-font
                   lines 21
                   min-lines 21
                   size 70
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception
                    continue
              end-accept
              evaluate crt-status
              when 101
                   open I-O file1
                   move 1 to f1-cod
                   read file1 with lock
                   if file-status = rec-locked-code
                      call "C$LOCKPID" giving taskID
                      display message "Record locked by ctID " taskID
                   else
                      display message "No record locked"
                   end-if
                   close file1
              when 102
                   open exclusive I-O file1
                   if file-status = file-locked-code 
                      call "C$LOCKPID" giving taskID
                      display message "File locked by ctID " taskID
                   else
                      display message "No file locked"
                   end-if
                   close file1
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       CREATE-FILE.
           call  "C$GETENV" USING "user.home"
                                  path-file1.

           string path-file1       delimited by trailing space
                  "/CLOCKPID-FILE" delimited by size
                  into path-file1.
                  
           open I-O file1
           if file-status not = "00"
              open output file1
           end-if
           move 1   to f1-cod
           write f1-rec.
           close file1
           .

       CALL-LOCK-FILE.
           call run "CLOCKPID2"
           .

       CHECK-FILE-STATUS-CODE.
           accept file-status-type from environment "file.status" 

           evaluate file-status-type
           when "com.iscobol.io.FileStatus85"
           when "com.iscobol.io.FileStatus74"
                move "99" to rec-locked-code
                move "93" to file-locked-code
           when "com.iscobol.io.FileStatusDG"
           when "com.iscobol.io.FileStatusMS"
                move "94" to rec-locked-code
                move "94" to file-locked-code
           when "com.iscobol.io.FileStatusVax"
                move "91" to rec-locked-code
                move "91" to file-locked-code
           when "com.iscobol.io.FileStatusIBM"
                move "23" to rec-locked-code
                move "93" to file-locked-code
           when "com.iscobol.io.FileStatusMF"
                move "9D" to rec-locked-code
                move "9A" to file-locked-code
           when "com.iscobol.io.FileStatusDefault"
           when other
                move "51" to rec-locked-code
                move "61" to file-locked-code
           end-evaluate.
           
