      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CPARSEEFD.

       CONFIGURATION SECTION.

       WORKING-STORAGE SECTION.
       copy "isparseefd.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       copy "isopensave.def".

       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.
       77  xmlfile                 pic x any length.
       01  xmlinfo.
           03 xmlsize              pic x(8) comp-x.
           03 xmldate              pic 9(8) comp-x.
           03 xmltime              pic 9(8) comp-x.
       77  opensave-status         pic s9.
       01  t-Ptr                   unsigned-int occurs 3.
       01  vis-g-info              pic 9 value 0.
       01  vis-g-info-key          pic 9 value 0.
       01  vis-g-info-cond         pic 9 value 0.
       01  vis-g-info-fld          pic 9 value 0.
       01  vis-g-info-allfld       pic 9 value 0.
       01  var-t                   pic x(20) value spaces.
       01  w-flag                  pic 9 value 0.
       01  row-num                 pic 9(6) value 2.
       01  idx-key                 pic 9(3) value 0.
       01  idx-field               pic 9(6) value 0.
       01  idx-part                pic 9(3) value 0.
       01  idx-cond                pic 9(3) value 0.
       01  idx-simple-cond         pic 9(3) value 0.
       01  idx-main-cond           pic 9(3) value 0.

       01  descr-part              pic x any length.
       01  bak-condition-tablename pic x(30).

       77  field-num               pic 9(6) value 0.
       77  e-local                 pic 9.

       77  efd-handle              handle.
       77  filename                pic x(50).

       77  parseefd-flags          pic 99.
       77  wrk-field-type          pic x(50).

       SCREEN SECTION.
       01  Mask.
           03 label 
              title               "Parse of XML file generated by iscobo
      -                           "l from -efd compiler option"
              line                 2 
              col                  3
              .
           03 frame 
              line                 3 
              col                  2 
              engraved 
              lines                3 
              size                 68
              height-in-cells 
              width-in-cells
              .
           03 label 
              title                "Enter XML file: " 
              line                 4 
              col                  4
              height-in-cells 
              width-in-cells
              .
           03 e1 
              entry-field 
              value                xmlfile
              line                 4 
              col                  + 2 
              size                 40  cells
              id                   101
              max-text             256
              .
           03 push-button 
              title                "..." 
              line                 4 
              col                  + 1.2
              size                 3  cells
              exception-value      101     
              enabled              e-local
              self-act
              .
           03 push-button 
              title                "Parse" 
              line                 4 
              col                  + 1 
              exception-value      102 
              id                   101
              self-act
              .
           03 t-efd-info
              tree-View 
              col                  3 
              line                 7
              lines                12.5
              size                 20 
              id                   102 
              enabled              0
              buttons 
              height-in-cells 
              width-in-cells
              lines-at-root
              show-lines 
              show-sel-always
              event procedure      t-event-proc
              .
           03 l-info 
              frame 
              line                 6 
              col                  2 
              engraved
              lines                14
              size                 68
              height-in-cells
              width-in-cells
              .
           03 g-info 
              grid
              line                 7 
              col                  24
              data-columns         (1, 25)
              display-columns      (1, 27)
              lines                7 
              size                 45
              virtual-width        42
              width-in-cells
              adjustable-columns
              column-headings
              tiled-headings
              heading-color        257
              vscroll
              hscroll
              cursor-frame-width   2
              protection           1
              visible              vis-g-info
              heading-menu-popup   60
              .
           03 g-info-key 
              grid 
              line                 7
              col                  24
              data-columns         (1, 25)
              display-columns      (1, 27)
              lines                7 
              size                 45
              virtual-width        42
              width-in-cells
              adjustable-columns
              column-headings 
              tiled-headings 
              heading-color        257
              vscroll
              hscroll
              cursor-frame-width   2
              protection           1
              visible              vis-g-info-key
              heading-menu-popup   60
              .
           03 g-info-cond 
              grid
              line                 7 
              col                  24
              data-columns         (1, 25)
              display-columns      (1, 27)
              lines                7 
              size                 45
              virtual-width        42
              width-in-cells
              adjustable-columns
              column-headings 
              tiled-headings 
              heading-color        257
              vscroll
              hscroll
              cursor-frame-width   2
              protection           1
              visible              vis-g-info-cond
              heading-menu-popup   60
              .
           03 g-info-field 
              grid
              line                 7
              col                  24
              data-columns         (1, 25)
              display-columns      (1, 27)
              lines                7 
              size                 45
              virtual-width        42
              width-in-cells
              adjustable-columns
              column-headings 
              tiled-headings 
              heading-color        257
              vscroll
              hscroll
              cursor-frame-width   2
              protection           1
              visible              vis-g-info-fld
              heading-menu-popup   60
              .
           03 g-info-allfield 
              grid
              line                 7
              col                  24
              data-columns         (1, 25)
              display-columns      (1, 27)
              lines                7 
              size                 45
              virtual-width        42
              width-in-cells
              adjustable-columns
              column-headings 
              tiled-headings 
              heading-color        257
              vscroll
              hscroll
              cursor-frame-width   2
              protection           1
              visible              vis-g-info-allfld
              heading-menu-popup   60
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept terminal-abilities from terminal-info.
           if is-remote
              move zero   to e-local
           else
              move 1      to e-local
           end-if
           move "./files/orders.xml"  to xmlfile
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   lines  21
                   min-lines  21
                   size   70
                   min-size   70
                   title  "C$PARSEEFD"
                   control font control-font
                   handle hWin
                   event  WIN-EVT

           display mask.
           perform init-data.

           perform until crt-status = 27 or close-win = 1
              accept mask 
                 on exception
                    continue
              end-accept
              evaluate crt-status
              when 101
                   perform SEARCH-XML
              when 102
                   perform INIT-GRID
                   perform BROWSE-XML-DESCRIPTION
              end-evaluate
              if w-flag = 1
                 move 0   to w-flag
                 perform  EVALUATE-VAR-T
                 move 102 to control-id
              end-if
              move 4      to accept-control
           end-perform
           
           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       SEARCH-XML.
           move "XML file (*.xml)|*.xml" to opnsav-filters.
           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data
                               giving opensave-status.
           if opensave-status > 0
              move opnsav-filename to xmlfile
              modify e1 value xmlfile
           else
              display message "WRONG XML FILE"
              move 0 to crt-status
           end-if
           move opnsav-basename to opnsav-default-dir
           .

       BROWSE-XML-DESCRIPTION.  
           initialize parseefd-description.

           call "c$fileinfo" using xmlfile
                                   xmlinfo
                            giving return-code
           if return-code = 1
              display message "file xml does not exist"
              exit paragraph
           end-if

           move 0   to parseefd-flags
           CALL "C$PARSEEFD" USING parseefd-parse,
                                   xmlfile, 
                                   filename, 
                                   parseefd-flags
                                   parseefd-description
                            GIVING efd-handle

           if efd-handle = 0
              display message "Error parsing EDF file"
              exit paragraph
           end-if

           modify g-info           mass-update 1
           modify g-info-key       mass-update 1
           modify g-info-cond      mass-update 1
           modify g-info-field     mass-update 1
           modify g-info-allfield  mass-update 1

           perform FILE-INFORMATION

           perform KEY-INFORMATION

           perform CONDITION-INFORMATION

           perform FIELD-INFORMATION

           call "C$PARSEEFD" USING parseefd-release, efd-handle 

      *    I open again the file with the flag for see also the hidden fields
           initialize filename parseefd-description.
           add parseefd-flag-include-999 to parseefd-flags
           call "C$PARSEEFD" using parseefd-parse, 
                                   xmlfile, 
                                   filename, 
                                   parseefd-flags
                                   parseefd-description
                            giving efd-handle

           modify g-info y = 9 x = 1
                         cell-data "Total number of fields"
           modify g-info y = 9 x = 2
                         cell-data parseefd-number-fields

           perform ALL-FIELD-INFORMATION.

           modify t-efd-info       enabled 1
           modify g-info           mass-update 0
           modify g-info-key       mass-update 0
           modify g-info-cond      mass-update 0
           modify g-info-field     mass-update 0
           modify g-info-allfield  mass-update 0
           modify g-info           cursor-y = 2 cursor-x = 1
           modify t-efd-info       value 2

           call "C$PARSEEFD" USING parseefd-release, efd-handle 

           move 4   to accept-control
           move 102 to control-id
           .

       FILE-INFORMATION.
           modify g-info y = 2 x = 1
                         cell-data "Select-name"
           modify g-info y = 2 x = 2
                         cell-data parseefd-select-name

           modify g-info y = 3 x = 1
                         cell-data "Filetype"
           evaluate true
           when parseefd-sequential-file
                modify g-info y = 3 x = 2
                              cell-data "Sequential"
           when parseefd-relative-file
                modify g-info y = 3 x = 2
                              cell-data "Relative"
           when parseefd-indexed-file
                modify g-info y = 3 x = 2
                              cell-data "Indexed"
           end-evaluate 
           modify g-info y = 4 x = 1
                         cell-data "Max rec-size"
           modify g-info y = 4 x = 2
                         cell-data parseefd-max-rec-size

           modify g-info y = 5 x = 1
                         cell-data "Min rec-size"
           modify g-info y = 5 x = 2
                         cell-data parseefd-min-rec-size

           modify g-info y = 6 x = 1
                         cell-data "Number of keys"
           modify g-info y = 6 x = 2
                         cell-data parseefd-num-keys

           modify g-info y = 7 x = 1
                         cell-data "Number of conditions"
           modify g-info y = 7 x = 2
                         cell-data parseefd-number-conditions

           modify g-info y = 8 x = 1
                         cell-data "Number of visible fields"
           modify g-info y = 8 x = 2
                        cell-data parseefd-number-fields
           .

       KEY-INFORMATION.
           move 2 to row-num.
           perform varying idx-key from 0 by 1 
                                     until idx-key = parseefd-num-keys

              initialize parseefd-key-description
              call "C$PARSEEFD"  using parseefd-get-key-info, 
                                       efd-handle, 
                                       idx-key, 
                                       parseefd-key-description
              if return-code not = 1
                 exit paragraph
              end-if
              perform ADD-TO-KEY-INFO-GRID
              add 1 to row-num
           end-perform.

       ADD-TO-KEY-INFO-GRID.
           modify g-info-key insert-rows 1
           modify g-info-key y = row-num
                             Row-Background-Color rgb x#FFFFBF 
           modify g-info-key y = row-num x = 1
                             cell-data "Key number:"
           modify g-info-key y = row-num x = 2
                             cell-data idx-key

           add 1 to row-num
           modify g-info-key insert-rows 1

           modify g-info-key y = row-num x = 1
                             cell-data "Number of segments"
           modify g-info-key y = row-num x = 2
                             cell-data parseefd-number-segments

           add 1 to row-num
           modify g-info-key insert-rows 1
           modify g-info-key y = row-num x = 1
                             cell-data "Allow duplicate"
           modify g-info-key y = row-num x = 2
                             cell-data parseefd-dup-flag

           add 1 to row-num
           modify g-info-key insert-rows 1
           modify g-info-key y = row-num
                             Row-Background-Color rgb x#DFEDEE
           modify g-info-key y = row-num x = 1
                             cell-data "Segment "
           modify g-info-key y = row-num x = 2
                             cell-data parseefd-number-segments

           perform varying idx-part from 1 by 1 
                          until idx-part > parseefd-number-key-fields
              add 1 to row-num
              string "Part n." delimited by size
                     idx-part  delimited by size
                               into descr-part
              modify g-info-key y = row-num x = 1
                                cell-data descr-part
              call "C$PARSEEFD" using parseefd-get-field-info 
                                      efd-handle 
                                      parseefd-key-field-num(idx-part)
                                      parseefd-field-description
              modify g-info-key y = row-num x = 2
                                cell-data
                                parseefd-field-name
              modify g-info-key insert-rows 1
              add 1 to row-num
              modify g-info-key y = row-num x = 1
                                cell-data "Offset"
              modify g-info-key y = row-num x = 2
                                cell-data parseefd-field-offset
              add 1 to row-num
              modify g-info-key insert-rows 1
              modify g-info-key y = row-num x = 1
                                cell-data "Length"
              modify g-info-key y = row-num x = 2
                                cell-data
                                parseefd-field-length
           end-perform
           add 1 to row-num
           .
       CONDITION-INFORMATION.
           move 2 to row-num
           move 0 to idx-simple-cond idx-main-cond 

           perform varying idx-cond from 0 by 1 
                             until idx-cond = parseefd-number-conditions

              call "C$PARSEEFD" USING parseefd-get-cond-info, 
                                      efd-handle,
                                      idx-cond
                                      parseefd-condition-description

              if parseefd-condition-tablename = bak-condition-tablename
                 add 1 to idx-simple-cond
      
                 modify g-info-cond insert-rows 1
                 modify g-info-cond y = row-num
                                    Row-Background-Color rgb x#DFEDEE
                 modify g-info-cond y = row-num x = 1
                                    cell-data "Simple condition n."
                 modify g-info-cond y = row-num x = 2
                                    cell-data idx-simple-cond
                 add 1 to row-num
                 modify g-info-cond insert-rows 1
                 modify g-info-cond y = row-num x = 1
                                    cell-data "Name"
                 modify g-info-cond y = row-num x = 2
                                    cell-data
                                    parseefd-other-fieldname
                 add 1 to row-num
                 modify g-info-cond insert-rows 1
                 modify g-info-cond y = row-num x = 1
                                    cell-data "Operation"
                 modify g-info-cond y = row-num x = 2
                                    cell-data parseefd-condition-type
                 add 1 to row-num     
                 modify g-info-cond insert-rows 1
                 modify g-info-cond y = row-num x = 1
                                    cell-data "value"
                 modify g-info-cond y = row-num x = 2
                                    cell-data parseefd-comp-fieldname
              else
                 if idx-main-cond not = 0
                    add 1 to row-num
                 end-if   
                 add 1 to idx-main-cond  
                 modify g-info-cond insert-rows 1
                 modify g-info-cond y = row-num
                                    Row-Background-Color rgb x#FFFFBF 
                 modify g-info-cond y = row-num x = 1
                                    cell-data "Condition n."
                 modify g-info-cond y = row-num x = 2
                                    cell-data idx-main-cond
                 add 1 to row-num
                 modify g-info-cond insert-rows 1
                 modify g-info-cond y = row-num x = 1
                                    cell-data "Tablename"
                 modify g-info-cond y = row-num x = 2
                                    cell-data 
                                            parseefd-condition-tablename
                 add 1 to row-num
                 if parseefd-other-fieldname not = spaces
                    modify g-info-cond insert-rows 1
                    modify g-info-cond y = row-num x = 1
                                       cell-data "Name"
                    modify g-info-cond y = row-num x = 2
                                       cell-data 
                                            parseefd-other-fieldname
                    add 1 to row-num
                    modify g-info-cond insert-rows 1
                    modify g-info-cond y = row-num x = 1
                                       cell-data "Operation"
                    modify g-info-cond y = row-num x = 2
                                       cell-data parseefd-condition-type
                    add 1 to row-num
                    modify g-info-cond insert-rows 1
                    modify g-info-cond y = row-num x = 1
                                       cell-data "value"
                    modify g-info-cond y = row-num x = 2
                                       cell-data parseefd-comp-field-val
                 end-if
              end-if
              move parseefd-condition-tablename 
                                            to bak-condition-tablename
           end-perform
           .

       FIELD-INFORMATION.
           move 2 to row-num
           move 0 to field-num

           perform varying idx-field from 0 by 1
                   until idx-field = PARSEEFD-NUMBER-FIELDS
              CALL "C$PARSEEFD" USING PARSEEFD-GET-FIELD-INFO, 
                                      efd-handle, 
                                      idx-field, 
                                      PARSEEFD-FIELD-DESCRIPTION 

              if return-code not = 1
                 exit paragraph
              end-if

              add 1 to field-num
              modify g-info-field insert-rows 1
              modify g-info-field y = row-num
                                  row-background-color rgb x#DFEDEE
              modify g-info-field y = row-num x = 1
                                  cell-data "Field n. "
              modify g-info-field y = row-num x = 2
                                  cell-data field-num
              add 1 to row-num
              modify g-info-field insert-rows 1
              modify g-info-field y = row-num x = 1
                                  cell-data "Name"
              modify g-info-field y = row-num x = 2
                                  cell-data parseefd-field-name
              add 1 to row-num
              modify g-info-field insert-rows 1
              modify g-info-field y = row-num x = 1
                                  cell-data "Offset"
              modify g-info-field y = row-num x = 2
                                  cell-data parseefd-field-offset
              add 1 to row-num
              modify g-info-field insert-rows 1
              modify g-info-field y = row-num x = 1
                                  cell-data "Length"
              modify g-info-field y = row-num x = 2
                                  cell-data parseefd-field-length
              add 1 to row-num
              modify g-info-field insert-rows 1
              modify g-info-field y = row-num x = 1
                                  cell-data "Type"
              perform DECODE-FIELD-TYPE
              modify g-info-field y = row-num x = 2
                                  cell-data wrk-field-type
              add 1 to row-num
              if parseefd-field-format not = spaces
                 modify g-info-field insert-rows 1
                 modify g-info-field y = row-num x = 1
                                     cell-data "Format"
                 modify g-info-field y = row-num x = 2
                                     cell-data parseefd-field-format
                 add 1 to row-num
              end-if
              if parseefd-field-condition not = zero
                 modify g-info-field insert-rows 1
                 modify g-info-field y = row-num x = 1
                                     cell-data "Condition"
                 modify g-info-field y = row-num x = 2
                                     cell-data parseefd-field-condition
                 add 1 to row-num
              end-if
           end-perform.

       DECODE-FIELD-TYPE.
           evaluate parseefd-field-type
           when parseefd-numedited
                move "Numeric Edited"                to wrk-field-type
           when parseefd-numunsigned
                move "Unsigned numeric"              to wrk-field-type
           when parseefd-numsignsep
                move "Signed numeric (trail sep)"    TO wrk-field-type
           when parseefd-numsigned
                move "Signed numeric (trail comb)"   TO wrk-field-type
           when parseefd-numseplead
                move "Signed numeric (lead sep)"     TO wrk-field-type
           when parseefd-numleading
                move "Signed numeric (lead comb)"    TO wrk-field-type
           when parseefd-compsigned
                move "Signed computational"          TO wrk-field-type
           when parseefd-compunsigned
                move "Unsigned computational"        TO wrk-field-type
           when parseefd-packedpositive
                move "Positive packed-decimal"       TO wrk-field-type
           when parseefd-packedsigned
                move "Signed packed-decimal"         TO wrk-field-type
           when parseefd-packedunsigned
                move "Computational-6"               TO wrk-field-type
           when parseefd-binarysigned
                move "Signed binary"                 TO wrk-field-type
           when parseefd-binaryunsigned
                move "Unsigned binary"               TO wrk-field-type
           when parseefd-nativesigned
                move "Signed native-order binary"    TO wrk-field-type
           when parseefd-nativeunsigned
                move "Unsigned native-order binary"  TO wrk-field-type
           when parseefd-alphanum
                move "Alphanumeric"                  TO wrk-field-type
           when parseefd-justan
                move "Alphanumeric (justified)"      TO wrk-field-type
           when parseefd-alphbetic
                move "Alphabetic"                    TO wrk-field-type
           when parseefd-justalpha
                move "Alphabetic (justified)"        TO wrk-field-type
           when parseefd-alphaedited
                move "Alphanumeric Edited"           TO wrk-field-type
           when parseefd-Group
                move "Group"                         TO wrk-field-type
           when parseefd-flt
                move "Float or Double"               TO wrk-field-type
           when parseefd-nat-type
                move "National"                      TO wrk-field-type
           when parseefd-justnat
                move "National (justified)"          TO wrk-field-type
           when parseefd-natedited
                move "National edited"               TO wrk-field-type
           when parseefd-wide-type
                move "Wide"                          TO wrk-field-type
           when parseefd-justwide
                move "Wide (justified)"              TO wrk-field-type
           when parseefd-wideedited
                move "Wide edited"                   TO wrk-field-type
           when parseefd-nativevsigned
                move "Signed var-len native-order binary" 
                                                     to wrk-field-type
           when parseefd-nativevunsigned
                move "Signed var-len native-order binary" 
                                                     TO wrk-field-type
           end-evaluate.

       ALL-FIELD-INFORMATION.
           move 2 to row-num
           move 0 to field-num

           perform varying idx-field from 0 by 1
                   until idx-field = PARSEEFD-NUMBER-FIELDS
              CALL "C$PARSEEFD" USING PARSEEFD-GET-FIELD-INFO, 
                                      efd-handle, 
                                      idx-field, 
                                      PARSEEFD-FIELD-DESCRIPTION 

              if return-code not = 1
                 exit paragraph
              end-if

              add 1 to field-num
              modify g-info-allfield insert-rows 1
              modify g-info-allfield y = row-num
                                     row-background-color rgb x#DFEDEE
              modify g-info-allfield y = row-num x = 1
                                     cell-data "Field n. "
              modify g-info-allfield y = row-num x = 2
                                     cell-data field-num
              add 1 to row-num
              modify g-info-allfield insert-rows 1
              modify g-info-allfield y = row-num x = 1
                                     cell-data "Name"
              modify g-info-allfield y = row-num x = 2
                                     cell-data parseefd-field-name
              add 1 to row-num
              modify g-info-allfield insert-rows 1
              modify g-info-allfield y = row-num x = 1
                                     cell-data "Offset"
              modify g-info-allfield y = row-num x = 2
                                     cell-data parseefd-field-offset
              add 1 to row-num
              modify g-info-allfield insert-rows 1
              modify g-info-allfield y = row-num x = 1
                                     cell-data "Length"
              modify g-info-allfield y = row-num x = 2
                                     cell-data parseefd-field-length
              add 1 to row-num
              modify g-info-allfield insert-rows 1
              modify g-info-allfield y = row-num x = 1
                                     cell-data "Type"
              perform DECODE-FIELD-TYPE
              modify g-info-allfield y = row-num x = 2
                                     cell-data wrk-field-type
              add 1 to row-num
              if parseefd-field-format not = spaces
                 modify g-info-allfield insert-rows 1
                 modify g-info-allfield y = row-num x = 1
                                        cell-data "Format"
                 modify g-info-allfield y = row-num x = 2
                                        cell-data parseefd-field-format
                 add 1 to row-num
              end-if
              if parseefd-field-condition not = zero
                 modify g-info-allfield insert-rows 1
                 modify g-info-allfield y = row-num x = 1
                                        cell-data "Condition"
                 modify g-info-allfield y = row-num x = 2
                                        cell-data 
                                               parseefd-field-condition
                 add 1 to row-num
              end-if
              modify g-info-allfield insert-rows 1
              modify g-info-allfield y = row-num x = 1
                                     cell-data "Hidden"
              if parseefd-field-is-hidden
                 modify g-info-allfield y = row-num x = 2
                                        cell-data "yes"
              else
                 modify g-info-allfield y = row-num x = 2
                                        cell-data "no"
              end-if
              add 1 to row-num


           end-perform.

       INIT-DATA.
           initialize t-ptr(1)
           modify t-efd-info reset-list = 1
           modify t-efd-info parent t-ptr(1) 
                             item-to-add = "Efd"
                             giving t-ptr(2)
                             parent t-ptr(2) 
                             item-to-add = "Description"
                             giving t-ptr(3)
                             parent t-ptr(2) 
                             item-to-add = "KeyInfo"
                             giving t-ptr(3)
                             parent t-ptr(2) 
                             item-to-add = "CondInfo"
                             giving t-ptr(3)
                             parent t-ptr(2) 
                             item-to-add = "FieldInfo"
                             giving t-ptr(3)
                             parent t-ptr(2) 
                             item-to-add = "FieldAllInfo"
                             giving t-ptr(3)
                             .
           
       INIT-GRID.
           modify g-info           reset-grid 1
           modify g-info-key       reset-grid 1
           modify g-info-cond      reset-grid 1
           modify g-info-field     reset-grid 1
           modify g-info-allfield  reset-grid 1
           modify g-info y = 1 x = 1
                         cell-data = "Description"
           modify g-info y = 1 x = 2
                         cell-data = "Value"
           modify g-info-key y = 1 x = 1
                             cell-data = "Description"
           modify g-info-key y = 1 x = 2
                             cell-data = "Value"    
           modify g-info-cond y = 1 x = 1
                              cell-data = "Description"
           modify g-info-cond y = 1 x = 2
                              cell-data = "Value"    
           modify g-info-field y = 1 x = 1
                               cell-data = "Description"
           modify g-info-field y = 1 x = 2
                               cell-data = "Value"
           modify g-info-allfield y = 1 x = 1
                                  cell-data = "Description"
           modify g-info-allfield y = 1 x = 2
                                  cell-data = "Value"
           .

       T-EVENT-PROC.
           evaluate event-type
           when msg-tv-selchanging 
                inquire t-efd-info(event-data-2), item-text in var-t
                move 1 to w-flag
                set event-action to event-action-terminate
           end-evaluate
           .

       EVALUATE-VAR-T.
           modify l-info title ""
           move 0 to vis-g-info vis-g-info-key vis-g-info-cond
                     vis-g-info-fld vis-g-info-allfld 
           evaluate var-t
           when "Description" 
                modify l-info title "EFD general information"
                move 1 to vis-g-info
           when "KeyInfo"
                modify l-info title "EFD key information"
                move 1 to vis-g-info-key
           when "CondInfo"
                modify l-info title "EFD condition information"
                move 1 to vis-g-info-cond
           when "FieldInfo"
                modify l-info title  "EFD field information"
                move 1 to vis-g-info-fld
           when "FieldAllInfo"
                modify l-info title "EFD All field information"
                move 1 to vis-g-info-allfld
           end-evaluate
           modify g-info           visible vis-g-info
           modify g-info-key       visible vis-g-info-key
           modify g-info-cond      visible vis-g-info-cond
           modify g-info-field     visible vis-g-info-fld
           modify g-info-allfield  visible vis-g-info-allfld
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
