      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    CPROGINMEM.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  cprog-flag              pic 9.
       77  close-win               pic 9 value 0.

       SCREEN SECTION.
       01  Mask.
           03  push-button
               line                2 
               col                 2
               size                20 cells
               title               "Call child program" 
               exception-value     102
               .
           03  push-button
               line                2 
               col                 23
               size                20 cells
               title               "Cancel child program" 
               exception-value     103
               .
           03  push-button
               line                5 
               col                 2
               size                20 cells
               title               "C$PROGINMEM" 
               exception-value     101
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$PROGINMEM Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status 
              when 101
                   perform PERFORM-CPROGINMEM
              when 102
                   call "PROGCHILD"
              when 103
                   cancel "PROGCHILD"
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       PERFORM-CPROGINMEM.
           call "C$PROGINMEM" using "PROGCHILD"

           if return-code = 1
              display message 
                      "The program 'PROGCHILD' is loaded in memory"
                      icon mb-default-icon
           else
              display message 
                      "The program 'PROGCHILD' is not loaded in memory"
                      icon mb-warning-icon
           end-if
           .       