      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WHINT.
       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "isprint.def".


       77  crt-status                       special-names 
                                            crt status pic 9(5).
       77  hWin                             handle of window.
       77  close-win                        pic 9 value 0.
       77  control-font                     handle of font.

       77  p-hint                           pic x any length.
       77  p-timeout                        pic 9(5).
       77  p-pos-col                        pic 9(5).
       77  p-pos-row                        pic 9(5).

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              title                "Hint text:"
              line                 2
              col                  2
              lines                6
              size                 68
              .
           03 EF-HINT
              entry-field
              line                 4
              lines                3
              col                  4
              size                 64 cells
              value p-hint
              .
           03 frame
              engraved
              title                "Position in CELLS:"
              line                 9
              col                  2
              lines                4
              size                 68
              .
           03 label
              line                 11
              col                  4
              size                 10 cells
              title                "Column:"
              .
           03 EF-pos-col 
              entry-field
              numeric
              line                 11
              col                  13
              size                 8 cells
              value p-pos-col
              max-text             5
              right
              .
           03 label
              line                 11
              col                  26
              size                 10 cells
              title                "Row:"
              .
           03 EF-pos-row 
              entry-field
              numeric
              line                 11
              col                  36
              size                 8 cells
              value p-pos-row
              max-text             5
              right
              .
           03 frame
              engraved
              title                "Hint timeout in millisecond:"
              line                 14
              col                  2
              lines                4
              size                 68
              .
           03 EF-timeout
              entry-field
              numeric
              line                 16
              col                  13
              size                 8 cells
              value p-timeout
              max-text             5
              right
              .
           03 push-button
              line                 20
              col                  3
              title                "Show Hint"
              size 15              cells
              exception-value      101
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       main. 

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$HINT"
                   handle hWin
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   event  WIN-EVT

           perform INTIAL-SETTINGS
           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              evaluate crt-status
              when 101  
                   perform SHOW-HINT
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           GOBACK
           .
              
       INTIAL-SETTINGS.
           move "This hint is showed using the W$HINT routine" to p-hint
           move 0   to p-timeout
           move 10  to p-pos-col
                       p-pos-row
           .

       SHOW-HINT.

           if p-pos-col = zero and 
              p-pos-row = zero and
              p-timeout = zero
              call "w$hint" using p-hint 
           else
              if p-timeout = zero
                 call "w$hint" using p-hint 
                                     p-pos-col
                                     p-pos-row
              else
                 call "w$hint" using p-hint 
                                     p-pos-col
                                     p-pos-row
                                     p-timeout
              end-if
           end-if.


       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
