      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. menu.
       configuration section.
       special-names.   

       REPOSITORY. 
           class json-stream     as "com.iscobol.rts.JSONStream"
           class j-string-buffer as "java.lang.StringBuffer"
           .

       WORKING-STORAGE SECTION.
       copy "isfonts.def".
       copy "isgui.def".
       copy "iscrt.def".
       
       copy "iwc.wrk".

       77  wrk-return-code   pic s9.

       77  my-stream         object reference json-stream.
       77  buffer            object reference j-string-buffer.


       77  pgm-to-call                      pic x(30).

       77  save-indent       pic s9.
       77  save-rtrim        pic s9.
       77  save-omit-empty   pic s9.

       01  UserMenu identified by 'userMenu'.
           03 Level1 identified by 'level1' 
                                   occurs dynamic capacity L1-count.
           05 L1-prog-id identified by 'prog-id'.
              07 L1-prog-id-data pic x any length.
           05 L1-type identified by 'type'.
              07 L1-type-data pic x any length.
           05 L1-descripton identified by 'description'.
              07 L1-descripton-data pic x any length.
           05 Level2 identified by 'children' 
                                   occurs dynamic capacity L2-count.
              07 L2-prog-id identified by 'progId'.
                 09 L2-prog-id-data pic x any length.
              07 L2-type identified by 'type'.
                 09 L2-type-data pic x any length.
              07 L2-descripton identified by 'description'.
                 09 L2-descripton-data pic x any length.

       SCREEN SECTION.
       PROCEDURE DIVISION.
       MAIN.
       
           perform SET-IWC-COMUNICATION

           perform LOAD-VERSION

           perform LOAD-MENU
       
           perform PROGRAM-EXECUTION

           perform CLOSE-IWC-COMUNICATION

           goback
           .

       SET-IWC-COMUNICATION.
      *    Start the iwc comunication
           call "IWC$INIT" using 78-iwc-crt-status 
                          giving wrk-return-code

           if wrk-return-code not = 0
              display message "Failed to activate IWC communication"
                      icon mb-error-icon
           end-if.

           set environment "hot_key.iwchotkey" to 78-iwc-crt-status
           .

       CLOSE-IWC-COMUNICATION.
           initialize iwc-struct.
           move 78-iwc-close-prog  to iwc-action
           move name-of-main-pgm  to iwc-data
           call "IWC$SEND" using iwc-struct
                          giving wrk-return-code

           if wrk-return-code not = 0
             display message "Failed send IWC communication"
                    icon mb-error-icon
           end-if.
           .

       PROGRAM-EXECUTION.
           perform until 1 = 2
              perform GET-IWC-MESSAGE

              evaluate iwc-action
              when 78-iwc-close-menu
                   exit perform
              when 78-iwc-execute-program
                   perform CALL-PROGRAM
              end-evaluate
           end-perform.

       GET-IWC-MESSAGE.
           initialize iwc-struct.
           call "IWC$GET" using iwc-struct
                          giving wrk-return-code

           if wrk-return-code not = 0
              display message "Failed receive IWC communication"
                    icon mb-error-icon
           end-if
           .
           
       CALL-PROGRAM.
           move iwc-data  to pgm-to-call
           call run "BRIDGE" using pgm-to-call
           .

       LOAD-MENU.

           initialize UserMenu

           move space           to L1-prog-id-data(1).
           move "Modernization" to L1-descripton-data(1).

           move "CUSTOMER"      to L2-prog-id-data(1 1).
           move "gui"           to L2-type-data(1 1)
           move "Customer"      to L2-descripton-data(1 1)

           move "STATE"         to L2-prog-id-data(1 2).
           move "gui"           to L2-type-data(1 2)
           move "State"         to L2-descripton-data(1 2)

           accept save-indent 
                       from environment "jsonstream.indent_number"
           accept save-rtrim 
                       from environment "jsonstream.rtrim"
           accept save-omit-empty 
                       from environment "jsonstream.omit_empty_elements"

           set environment "jsonstream.indent_number"        to -1.
           set environment "jsonstream.rtrim"                to 1.
           set environment "jsonstream.omit_empty_elements"  to 1.

           set my-stream to json-stream:>new(UserMenu)
           set buffer to j-string-buffer:>new
           my-stream:>writeToStringBuffer ( buffer )

           move 78-iwc-load-menu   to iwc-action
           set iwc-data            to buffer:>toString
           move space              to iwc-bytes
           perform SEND-DATA
 
           set environment "jsonstream.indent_number"
                                                     to save-indent
           set environment "jsonstream.rtrim"     to save-rtrim 
           set environment "jsonstream.omit_empty_elements"  
                                                     to save-omit-empty

           set buffer     to null
           set my-stream to null
           .

       LOAD-VERSION.
           initialize iwc-struct.
           move 78-iwc-get-version   to iwc-action.
           call "c$version"  using iwc-data
           move space              to iwc-bytes
           perform SEND-DATA
           .

       SEND-DATA.
           call "IWC$SEND" using iwc-struct
                          giving wrk-return-code

           if wrk-return-code not = 0
             display message "Failed send IWC communication"
                    icon mb-error-icon
           end-if.
           .

