Vue.component('message',{

  props:{
    message:{
      type: Object
    }
  },
  template: `
  <div>
  <a href="#" class="dropdown-item">
    <div class="media">
      <img v-bind:src="'dist/img/' + message.avatar" v-bind:alt="message.sender" class="img-size-50 mr-3 img-circle">
      <div class="media-body">
        <h3 class="dropdown-item-title">
          {{message.sender}}
          <span class="float-right text-sm text-muted"><i alt="view message" title="view message" class="fas fa-external-link-alt"></i></span>
        </h3>
        <p class="text-sm">{{message.titletext}}</p>
        <p class="text-sm text-muted"><i class="far fa-clock mr-1"></i> {{getMessageTimestamp()}}</p>
      </div>
    </div>
  </a>
  <div class="dropdown-divider"></div>
  </div>
  `,
  methods:{
   countMessages: function(){
      return this.countMessages.leng
    },
    getMessageTimestamp: function(){
      const options = {
        weekday: "short",
        year: "numeric",
        month:"short",
        day:"numeric"
      };
      return this.message.timestamp.toLocaleTimeString('en-US',options);
    },
    toggleExpand(event){
      event.preventDefault();
      event.stopPropagation();
      this.message.expanded = !this.notification.expanded;
    }
  }
});