      *>   Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *>   may freely modify and redistribute this program.
      
       PROGRAM-ID. ISPRODUCT.
       configuration section.
       special-names.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "product.sl".
       DATA DIVISION.
       FILE SECTION.
           copy "product.fd".

       WORKING-STORAGE SECTION.

           copy "common.wrk".
           copy "color.wrk".
           copy "iwc.wrk".
           copy "iwc.lks".
           copy "lookup.lks".

       77  STATUS-Product   PIC XX.

       01  screen-value.
           05 scr-id               pic  x(10).
           05 scr-name             pic  x(20).
           05 scr-description      pic  x(150).
           05 scr-price            pic  9(6)V99.

       78  id-ef-scr-id            value 100.
       78  id-ef-scr-name          value 101.
       78  id-ef-scr-description   value 102.
       78  id-ef-scr-price         value 103.
           
       01                          pic 9.
           88 all-ok               value 1 false zero.

       77  choice                  pic x.
       77  wrk-Product             pic x(10).
       77  cont                    pic 9(3).

       screen section.

       01  mask-main.
           05 frame 
              raised
              line 1
              col 2
              lines 3 cells
              size 106 cells
              high-color rgb 78-frame-backback-color
              low-color rgb 78-frame-backback-color
              gradient-color-1 rgb 78-frame-backback-color
              gradient-color-2 rgb 78-frame-backback-color
              transparent
              .
           05 Label
              col 3
              line 2
              title R"Product_id"
              transparent
              .
           05 Label
              col 3
              line 5
              title R"Product_Name"
              transparent
              .
           05 Label
              COL 3
              LINE 7
              TITLE R"Description"
              transparent
              .
           05 Label
              COL 3
              LINE 24
              TITLE R"Price"
              transparent
              .
           05 ef-scr-id 
              Entry-Field
              col 21 
              line 2
              size 10
              max-text 10
              id id-ef-scr-id
              value scr-id
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              after AFT-EF-SCR-ID
              .
           05 ef-scr-name 
              entry-field, 
              col 21
              line 5
              size 85
              max-text 20
              value scr-name
              id id-ef-scr-name
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .
           05 ef-scr-description 
              entry-field, 
              col 21
              line 7
              size 85
              lines 16
              multiline
              use-return
              max-text 150
              value scr-description
              id id-ef-scr-description
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .
           05 ef-scr-price 
              entry-field, 
              col 21
              line 24
              size 10
              max-text 11
              value scr-price
              numeric
              picture zzz,zz9.99
              right
              id id-ef-scr-price
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .

           copy "standard-mask-tool.scr".

       PROCEDURE DIVISION.
       DECLARATIVES.
       PRODUCT-ERR section.
           use after standard error procedure on product.
           perform ERROR-FILE
           .
       END DECLARATIVES.
       
       MAIN.

           perform OPEN-FILES.

           initialize screen-value.

           display independent graphical window
                   title R"isCOBOL_Application_Product"
                   lines 27
                   size 108
                   resizable
                   layout-manager lm-scale
                   line 0
                   col 0
                   control font h-font
                   handle h-sta
                   visible 0
                   system menu
                   link to thread
                   background-color rgb 78-window-independent-back-color
                   min-lines 15
                   min-size 80
                   undecorated
                   .

           display mask-main upon h-sta
           perform DISPLAY-TOOLBAR
           
           modify h-sta action action-maximize 
           modify h-sta visible 1
           
           perform until key-status = 27
              accept mask-main
                 on exception continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform       
           
           perform EXIT-PRG.
           goback
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 78-exe-new
                initialize prod-record
                perform DISPLAY-SCREEN
           when 78-exe-save
                perform SAVE-RECORD
           when 78-exe-delete
                perform DELETE-RECORD
                initialize prod-record
                perform DISPLAY-SCREEN
           when 78-exe-first
                perform READ-FIRST
                perform DISPLAY-SCREEN
           when 78-exe-prev
                perform READ-PREV
                perform DISPLAY-SCREEN
           when 78-exe-next
                perform READ-NEXT
                perform DISPLAY-SCREEN
           when 78-exe-last
                perform READ-LAST
                perform DISPLAY-SCREEN
           when 78-exe-zoom
                PERFORM ZOOM-PARAGRAPH
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           end-evaluate.

           copy "iwc-accept.prd".
           .

       DELETE-RECORD.
           display message box 
                          R"Are_you_sure_to_delete_the_selected_record?"
                   type mb-yes-no
                   default mb-no
                   icon mb-warning-icon 
                   giving choice
           if choice = mb-yes
             inquire ef-scr-id  value scr-id
             move scr-id   to prod-id
             delete Product record
                invalid
                   continue
             end-delete
             move R"Product_deleted"  to iwc-notification
             call "IWC-ADD-NOTIFICATION" using 78-sys-icon 
                                               78-evt-system
                                               iwc-notification
           end-if.

       SAVE-RECORD.
           set all-ok  to true
           perform CONTROL-ALL
           
           if all-ok
              move scr-id          to prod-id
              move scr-name        to prod-name
              move scr-description to prod-description
              move scr-price       to prod-price
           
              rewrite prod-record
                 invalid
                    write prod-record
              end-rewrite
              move R"Information"     to iwc-notification-description
              move R"Product_saved_successfully"  to iwc-notification
              call "IWC-NOTIFY" using 78-notification-success
                                      iwc-notification-description
                                      iwc-notification
           end-if.
 
       CONTROL-ALL.
           inquire ef-scr-id            value prod-id
           inquire ef-scr-name          value prod-name
           inquire ef-scr-description   value prod-description
           inquire ef-scr-price         value prod-price
           
           if prod-id = space
              display message box R"Product_id_is_mandatory!"
                    icon mb-warning-icon
              move id-ef-scr-id  to control-id
              set all-ok          to false
           end-if.
            
           
           if all-ok
              if prod-name = space
                 display message box R"Product_name_is_mandatory!"
                    icon mb-warning-icon
                 move id-ef-scr-name to control-id
                 set all-ok          to false
              end-if
           end-if.

       READ-FIRST.
           move low-value  to prod-id
           start Product key not < prod-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize prod-record
              not invalid
                read Product next no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize prod-record
                end-read
           end-start.
 
       READ-LAST.
           move high-value  to prod-id
           start Product key not > prod-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize prod-record
              not invalid
                read Product previous no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize prod-record
                end-read
           end-start.
 
       READ-PREV.
           inquire ef-scr-id VALUE scr-id.
           if scr-id = space
              perform READ-LAST
           else
              move scr-id  to prod-id
              read Product no lock
                invalid
                   start Product key not < prod-key
                      invalid
                         initialize prod-record
                   end-start
              end-read
              read Product previous no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.

       READ-NEXT.
           inquire ef-scr-id VALUE scr-id.
           if scr-id = space
              perform READ-FIRST
           else
              move scr-id  to prod-id
              read Product no lock
                invalid
                   start Product key not > prod-key
                      invalid
                         initialize prod-record
                   end-start
              end-read
              read Product next no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.
 
       RECORD-NOT-FOUND.
           move "File Product"        to iwc-notification-description
           move R"Record_not_found"   to iwc-notification
           call "IWC-NOTIFY" using 78-notification-warning
                                   iwc-notification-description
                                   iwc-notification
           .

       DISPLAY-SCREEN.
           move prod-id            to scr-id     
           move prod-name          to scr-name  
           move prod-description   to scr-description  
           move prod-price         to scr-price   
           
           display mask-main.
 
       OPEN-FILES.
           open I-O Product.
           if status-Product = 35
              open output Product
              close Product
              open i-o Product
           end-if.

       EXIT-PRG.
           call "IWC-QUIT-TAB".

           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close Product.

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main mask-tool h-tool 
                   h-sta 
           .

       AFT-EF-SCR-ID.
           if key-status = 13
              perform LOAD-RECORD
           end-if.

       LOAD-RECORD.
           move scr-id  to prod-id
           read Product no lock
              invalid
                 perform RECORD-NOT-FOUND
              not invalid
                 perform DISPLAY-SCREEN
           end-read.

       ZOOM-PARAGRAPH.
           evaluate control-id
           when id-ef-scr-id
                call "ZPRODUCT" using wrk-Product
                                      lookup-status 
                cancel "ZPRODUCT"
                evaluate true
                when ls-record-selected 
                     move wrk-Product   to scr-id
                     perform LOAD-RECORD
                when ls-force-close 
                     move 27 to key-status
                end-evaluate
           end-evaluate.

           copy "dec-file.prd".
           copy "standard-toolbar.prd".