      *    Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *   may freely modify and redistribute this program.
      
       PROGRAM-ID. ZPROG.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "prog.sl".
       DATA DIVISION.
       FILE SECTION.
           copy "prog.fd".
      
       WORKING-STORAGE SECTION.
      
           copy "common.wrk".
           copy "color.wrk".
           copy "iwc.wrk".
           copy "iwc.lks".
      
       77  STATUS-Prog   PIC XX.

       77  choice               pic x.

       01  rec-grid.
           05 rg-menu-level     pic  x(10).
           05 rg-prog-id        pic  x(15).
           05 rg-s-desc         pic  x(30).
           05 rg-prog-type      pic  X(01).
           
       01                       pic 9.
           88 no-record         value 1 false zero.

       01                       pic 9.
           88 record-selected   value 1 false zero.

       77  key-used             pic x.
       77  wrk-y                pic 9(3).
       77  num-row              pic 9(3).
       77  num-bmp              pic 9.

       LINKAGE SECTION.
       77  lnk-user             pic x(20).
       77  lnk-menu-level       pic x(10).
       copy "lookup.lks".
       
       screen section.
       01  mask-main.
           05 h-grid
              grid
              reordering-columns
              sortable-columns
              adjustable-rows
              line 2 col 3
              lines 25
              size 78
              width-in-cells
              height-in-cells
              data-columns (1, 11, 26, 56)
              alignment ( "C", "L", "L", "C")
              data-types ( "I", "I", "I", "I",)
              display-columns (16, 35, 68) 
              color 513  
              vscroll
              centered-headings 
              column-headings
              adjustable-columns
              use-tab
              cursor-frame-width -1
              heading-background-color rgb 78-grid-heading-Back-Color
              heading-background-color rgb 78-grid-heading-Back-Color
              border-color            rgb 78-ef-border-color
              divider-color           rgb 78-ef-border-color
              end-color           rgb 78-grid-end-color
              Row-Cursor-Background-Color 
                               rgb 78-grid-row-cursor-back-color
              Row-Cursor-foreground-Color 
                               rgb 78-grid-row-cursor-fore-color
              Row-Background-Color-Pattern 
                            (0, rgb 78-grid-Row-Back-Color-Pattern)
              event H-GRID-EVENT
              .

           copy "standard-mask-tool-floating.scr".

       PROCEDURE DIVISION using lnk-user
                                lnk-menu-level
                                lookup-status .
       DECLARATIVES.
       PROG-ERR section.
           use after standard error procedure on prog.
           perform ERROR-FILE
           .
       END DECLARATIVES.
       MAIN.

           set record-selected  to false.
           set ls-record-not-selected to true
           initialize lnk-menu-level.

           perform OPEN-FILES.

           display floating graphical window      
                   title R"isCOBOL_Application_List_of_Program"
                   lines 30
                   size 82
                   control font h-font
                   background-low
                   handle h-sta-floating
                   visible 0
                   system menu
                   background-color  rgb 78-window-floating-back-color
                   undecorated
                   .
           
           display mask-main upon h-sta-floating
           perform DISPLAY-TOOLBAR-FLOATING
           
           perform LOAD-GRID

           if no-record
              display message box R"No_record_in_File"
                      icon mb-warning-icon
           else
              perform ACCEPT-SCREEN
           end-if
           perform EXIT-PRG.
           goback
           .

       ACCEPT-SCREEN.
           modify h-sta-floating visible 1
           
           perform until key-status = 27
              accept mask-main
                 on exception continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 78-exe-selected
                set record-selected   to true
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           end-evaluate.

           copy "iwc-accept.prd".

           if record-selected
              inquire h-grid cursor-y = wrk-y
              inquire h-grid(wrk-y ) record-data = rec-grid
              move rg-menu-level   to lnk-menu-level
              move 27  to key-status
              set ls-record-selected  to true
           end-if.

       LOAD-GRID.
           set no-record  to true.

           modify h-grid(1, 1) cell-data R"Menu_Level"
           modify h-grid(1, 2) cell-data R"Prog._Id"
           modify h-grid(1, 3) cell-data R"Description"
           modify h-grid(1, 4) cell-data R"Type"
           
           move 1   to num-row
           move low-value to Prog-menu-level
           move lnk-user  to prog-users-id
           start Prog key not < Prog-key
              invalid
                 continue
              not invalid
                 perform until 1 = 2
                    read Prog next no lock
                       at end
                          exit perform
                       not at end
                          if lnk-user  not = prog-users-id
                             exit perform
                          end-if
                          set no-record        to false
                          initialize rec-grid
                          add 1                to num-row
                          move prog-menu-level to rg-menu-level
                          move prog-id         to rg-prog-id
                          move prog-s-desc     to rg-s-desc
                          modify h-grid record-to-add rec-grid
           
                          evaluate true
                          when prog-non-exec
                               move 1 to num-bmp
                          when prog-graph-prog
                               move 2 to num-bmp
                          when prog-crt-prog
                               move 4 to num-bmp
                          end-evaluate
           
                    end-read
                 end-perform
           end-start.

       OPEN-FILES.
           open input Prog.

       EXIT-PRG.
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close Prog.

       DESTROY-RESOURCE.
           modify h-sta-floating visible 0
           destroy mask-main mask-tool-floating h-tool 
                   h-sta-floating 
           .

       H-GRID-EVENT.
           evaluate event-type
           when MSG-BEGIN-ENTRY
                inquire h-grid entry-reason = key-used
                if key-used = x"0D" or
                   key-used = x"00"
                   set record-selected   to true
                   set event-action   to EVENT-ACTION-FAIL-TERMINATE
                else
                    set event-action   to EVENT-ACTION-FAIL
                end-if
           end-evaluate.

           copy "dec-file.prd".
           copy "standard-toolbar-floating.prd".

 