/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc;
import IT.picosoft.isam.KeyPart;

public class KeyDesc64
extends KeyDesc {
    public static final int NPARTS64 = 16;

    public KeyDesc64() {
        this.k_part = new KeyPart[16];
    }

    @Override
    public void assign(KeyDesc k) {
        int i;
        this.k_flags = k.k_flags;
        this.k_nparts = k.k_nparts;
        for (i = 0; i < this.k_nparts; ++i) {
            this.k_part[i] = new KeyPart(k.k_part[i]);
        }
        while (i < 16) {
            this.k_part[i] = null;
            ++i;
        }
        this.k_len = k.k_len;
        this.k_rootnode = k.k_rootnode;
        if (k instanceof KeyDesc64) {
            this.psz = k.psz;
            this.btksz = k.btksz;
            this.tksz = k.tksz;
        } else {
            this.psz = (this.k_flags & 1) == 1 ? 4 : 0;
            this.btksz = this.k_len + 8;
            this.tksz = this.k_len + 8 + this.psz;
        }
    }

    @Override
    void setRootNode(long rn) {
        this.k_rootnode = rn;
        this.psz = (this.k_flags & 1) == 1 ? 4 : 0;
        this.btksz = this.k_len + 8;
        this.tksz = this.k_len + 8 + this.psz;
    }

    long getRootNode64() {
        return this.k_rootnode;
    }

    @Override
    void check() throws IsamException {
        switch (this.k_flags & 1) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IsamException(103);
            }
        }
        if (this.k_nparts < 0 || this.k_nparts > 16) {
            throw new IsamException(103);
        }
        for (int i = 0; i < this.k_nparts; ++i) {
            if ((this.k_part[i].kp_type & 0xFFFFFF7F) < 2) continue;
            throw new IsamException(103);
        }
    }
}

