/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.DeferredBlock;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.EvaluateSuObject;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SimpleCondition;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class Evaluate
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int EVAL_UNKNOWN = 0;
    public static final int EVAL_TRUE = 1;
    public static final int EVAL_FALSE = 2;
    public static final int EVAL_ANY = 3;
    public static final int EVAL_EXPR = 4;
    public static final int EVAL_COND = 5;
    public static final int EVAL_PARTCOND = 6;
    public static final int EVAL_OTHER = 7;
    static final int OPTIMIZE_INTEGER = 1;
    static final int OPTIMIZE_LEVEL88_INTEGER = 2;
    static final int OPTIMIZE_STRING = 3;
    static final int OPTIMIZE_LEVEL88_STRING = 4;
    private VerbList subjectSet = new VerbList();
    private VerbList objectSet = new VerbList();
    private boolean otherFound;
    private final boolean oeOpt;

    public Evaluate(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk;
        Expression suEx;
        EvaluateSuObject so;
        this.oeOpt = p.getOption("-oe") != null || p.getOption("-xoe") != null;
        while (true) {
            so = new EvaluateSuObject(this.keyWord, this.parent, this.pc, this.tm, this.error, true, null);
            this.subjectSet.addItem(so);
            suEx = so.expr;
            tk = this.tm.getToken();
            if (tk.getToknum() == 811) break;
            if (tk.getToknum() == 271) continue;
            this.tm.ungetToken();
        }
        int nSub = this.subjectSet.getItemNum();
        while (tk.getToknum() == 811) {
            kw = tk;
            if (this.otherFound) {
                throw new GeneralErrorException(118, 4, tk, tk.getWord(), this.error);
            }
            so = new EvaluateSuObject(kw, this.parent, this.pc, this.tm, this.error, false, suEx);
            this.objectSet.addItem(so);
            if (so.type != 7) {
                for (int i = 1; i < nSub; ++i) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 271) {
                        this.tm.ungetToken();
                    }
                    so = new EvaluateSuObject(kw, this.parent, this.pc, this.tm, this.error, false, suEx);
                    this.objectSet.addItem(so);
                }
            } else {
                this.otherFound = true;
            }
            Block b = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
            b.parentSuObj = so;
            so.setBlock(b);
            tk = this.tm.getToken();
        }
        if (tk.getToknum() != 432) {
            if (tk.getToknum() != 10006) {
                this.error.print(154, 3, tk, "END-EVALUATE");
            }
            this.tm.ungetToken();
        }
    }

    private int getOptimizableCode() {
        if (this.isOptimizableInt()) {
            return 1;
        }
        if (this.isOptimizableLev88Int()) {
            return 2;
        }
        if (this.isOptimizableString()) {
            return 3;
        }
        if (this.isOptimizableLev88String()) {
            return 4;
        }
        return 0;
    }

    private boolean isOptimizableInt() {
        if (this.subjectSet.getItemNum() != 1) {
            return false;
        }
        EvaluateSuObject su = (EvaluateSuObject)this.subjectSet.getFirst();
        if (su.isNot() || su.getExprThru() != null || !this.isOptimizableInt(su.getExpr(), false)) {
            return false;
        }
        int i = 0;
        EvaluateSuObject ob = (EvaluateSuObject)this.objectSet.getFirst();
        while (ob != null) {
            switch (ob.getType()) {
                case 4: {
                    if (!ob.isNot() && ob.getExprThru() == null && this.isOptimizableInt(ob.getExpr(), true)) break;
                    return false;
                }
                case 7: {
                    if (i != 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ob = (EvaluateSuObject)this.objectSet.getNext();
            ++i;
        }
        return true;
    }

    private boolean isOptimizableInt(Expression expr, boolean checkLiteral) {
        VariableName vn;
        if (expr == null || !expr.isNumeric()) {
            return false;
        }
        Stack pfx = expr.getPFX();
        if (pfx.size() != 1) {
            return false;
        }
        Expression.ExprItem ei = (Expression.ExprItem)pfx.get(0);
        return !(checkLiteral ? ei.tk == null || !this.isOptimizableInt(ei.tk) : (vn = ei.value) == null || !this.isOptimizableInt(vn.getVarDecl()));
    }

    private boolean isOptimizableString(Expression expr, boolean checkLiteral) {
        VariableName vn;
        if (expr == null || !expr.isString()) {
            return false;
        }
        Stack pfx = expr.getPFX();
        if (pfx.size() != 1) {
            return false;
        }
        Expression.ExprItem ei = (Expression.ExprItem)pfx.get(0);
        return !(checkLiteral ? ei.tk == null || !this.isOptimizableString(ei.tk) : (vn = ei.value) == null || !this.isOptimizableString(vn.getVarDecl()));
    }

    private boolean isOptimizableInt(Token tk) {
        if (tk.getToknum() != 10002) {
            return false;
        }
        try {
            Integer.parseInt(tk.getWord());
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private boolean isOptimizableString(Token tk) {
        return tk.getToknum() == 10001 && !tk.isResource() && !tk.isHexdecimal();
    }

    private boolean isOptimizableInt(VariableDeclaration vd) {
        if (!vd.isInteger()) {
            return false;
        }
        return !(vd.isBinary() ? vd.getPhisicLen() > 3 : vd.getLogicLen() > 9);
    }

    private boolean isOptimizableString(VariableDeclaration vd) {
        return !vd.isNumeric() || vd.isEdited();
    }

    private boolean isOptimizableLev88Int() {
        if (this.subjectSet.getItemNum() != 1) {
            return false;
        }
        EvaluateSuObject su = (EvaluateSuObject)this.subjectSet.getFirst();
        if (su.getType() != 1) {
            return false;
        }
        VariableDeclaration par = null;
        int j = 0;
        EvaluateSuObject ob = (EvaluateSuObject)this.objectSet.getFirst();
        while (ob != null) {
            switch (ob.getType()) {
                case 5: {
                    if (ob.isNot()) {
                        return false;
                    }
                    if (ob.getCond() == null) {
                        return false;
                    }
                    VerbList allItems = ob.getCond().getAllItems();
                    if (allItems.getItemNum() != 1) {
                        return false;
                    }
                    Verb v = allItems.getFirst();
                    if (!(v instanceof SimpleCondition)) {
                        return false;
                    }
                    SimpleCondition sc = (SimpleCondition)v;
                    Expression expr = sc.getLeft();
                    VariableNameList allVars = expr.getAllVars();
                    if (allVars.getItemNum() != 1) {
                        return false;
                    }
                    VariableName vn = allVars.getFirst();
                    if (vn.getLevel() != 88 || vn.getIndexes() != null) {
                        return false;
                    }
                    VariableDeclaration of = vn.getVarDecl().getParent();
                    if (par != null && of != par) {
                        return false;
                    }
                    if (!(par != null || (par = of) != null && this.isOptimizableInt(par))) {
                        return false;
                    }
                    VariableDeclaration vd = vn.getVarDecl();
                    int valuesCount = vd.getValuesCount();
                    for (int i = 0; i < valuesCount; ++i) {
                        if (!this.isOptimizableInt(vd.getLowValue(i))) {
                            return false;
                        }
                        if (vd.getHighValue(i) == null) continue;
                        if (!this.isOptimizableInt(vd.getHighValue(i))) {
                            return false;
                        }
                        int low = Integer.parseInt(vd.getLowValue(i).getWord());
                        int high = Integer.parseInt(vd.getHighValue(i).getWord());
                        if (Math.abs(high - low) <= 10) continue;
                        return false;
                    }
                    break;
                }
                case 7: {
                    if (j != 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ob = (EvaluateSuObject)this.objectSet.getNext();
            ++j;
        }
        return true;
    }

    private boolean isOptimizableString() {
        if (!this.oeOpt) {
            return false;
        }
        if (this.pc.getProgramCollatingSeq() != null) {
            return false;
        }
        if (this.subjectSet.getItemNum() != 1) {
            return false;
        }
        EvaluateSuObject su = (EvaluateSuObject)this.subjectSet.getFirst();
        if (su.isNot() || su.getExprThru() != null || !this.isOptimizableString(su.getExpr(), false)) {
            return false;
        }
        if (this.objectSet.getItemNum() < 10) {
            return false;
        }
        int i = 0;
        EvaluateSuObject ob = (EvaluateSuObject)this.objectSet.getFirst();
        while (ob != null) {
            switch (ob.getType()) {
                case 4: {
                    if (!ob.isNot() && ob.getExprThru() == null && this.isOptimizableString(ob.getExpr(), true)) break;
                    return false;
                }
                case 7: {
                    if (i != 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ob = (EvaluateSuObject)this.objectSet.getNext();
            ++i;
        }
        return true;
    }

    private boolean isOptimizableLev88String() {
        if (!this.oeOpt) {
            return false;
        }
        if (this.pc.getProgramCollatingSeq() != null) {
            return false;
        }
        if (this.subjectSet.getItemNum() != 1) {
            return false;
        }
        EvaluateSuObject su = (EvaluateSuObject)this.subjectSet.getFirst();
        if (su.getType() != 1) {
            return false;
        }
        if (this.objectSet.getItemNum() < 10) {
            return false;
        }
        VariableDeclaration par = null;
        int j = 0;
        EvaluateSuObject ob = (EvaluateSuObject)this.objectSet.getFirst();
        while (ob != null) {
            switch (ob.getType()) {
                case 5: {
                    if (ob.isNot()) {
                        return false;
                    }
                    if (ob.getCond() == null) {
                        return false;
                    }
                    VerbList allItems = ob.getCond().getAllItems();
                    if (allItems.getItemNum() != 1) {
                        return false;
                    }
                    Verb v = allItems.getFirst();
                    if (!(v instanceof SimpleCondition)) {
                        return false;
                    }
                    SimpleCondition sc = (SimpleCondition)v;
                    Expression expr = sc.getLeft();
                    VariableNameList allVars = expr.getAllVars();
                    if (allVars.getItemNum() != 1) {
                        return false;
                    }
                    VariableName vn = allVars.getFirst();
                    if (vn.getLevel() != 88 || vn.getIndexes() != null) {
                        return false;
                    }
                    VariableDeclaration of = vn.getVarDecl().getParent();
                    if (par != null && of != par) {
                        return false;
                    }
                    if (!(par != null || (par = of) != null && this.isOptimizableString(par))) {
                        return false;
                    }
                    VariableDeclaration vd = vn.getVarDecl();
                    int valuesCount = vd.getValuesCount();
                    for (int i = 0; i < valuesCount; ++i) {
                        if (!this.isOptimizableString(vd.getLowValue(i))) {
                            return false;
                        }
                        if (vd.getHighValue(i) == null) continue;
                        return false;
                    }
                    break;
                }
                case 7: {
                    if (j != 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ob = (EvaluateSuObject)this.objectSet.getNext();
            ++j;
        }
        return true;
    }

    @Override
    public void check() throws GeneralErrorException {
        EvaluateSuObject su = (EvaluateSuObject)this.subjectSet.getFirst();
        EvaluateSuObject ob = (EvaluateSuObject)this.objectSet.getFirst();
        while (ob != null) {
            switch (ob.type) {
                case 0: {
                    throw new GeneralErrorException(61, 4, ob.keyWord, ob.keyWord.getWord(), this.error);
                }
                case 1: 
                case 2: 
                case 5: {
                    if (su.type != 1 && su.type != 2 && su.type != 5) {
                        throw new GeneralErrorException(62, 4, ob.keyWord, ob.keyWord.getWord(), this.error);
                    }
                    ob.check();
                    break;
                }
                case 4: {
                    if (su.type != 4) {
                        throw new GeneralErrorException(62, 4, ob.keyWord, ob.keyWord.getWord(), this.error);
                    }
                    SimpleCondition.check(ob, su.getExpr(), 1, ob.getExpr());
                    break;
                }
                case 6: {
                    if (su.type == 4) break;
                    throw new GeneralErrorException(62, 4, ob.keyWord, ob.keyWord.getWord(), this.error);
                }
            }
            su = (EvaluateSuObject)this.subjectSet.getNext();
            if (su == null) {
                su = (EvaluateSuObject)this.subjectSet.getFirst();
            }
            ob = (EvaluateSuObject)this.objectSet.getNext();
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        int optimCode = this.getOptimizableCode();
        switch (optimCode) {
            case 1: {
                this.getCodeOptimized(Return2, false);
                break;
            }
            case 2: {
                this.getCodeOptimizedLevel88(Return2, false);
                break;
            }
            case 3: {
                this.getCodeOptimized(Return2, true);
                break;
            }
            case 4: {
                this.getCodeOptimizedLevel88(Return2, true);
                break;
            }
            default: {
                String evalId = "";
                EvaluateSuObject su = (EvaluateSuObject)this.subjectSet.getFirst();
                while (su != null) {
                    if (su.type == 5) {
                        evalId = "eval$" + Evaluate.getUniqueId();
                        Return2.append(this.parent.getIndent());
                        Return2.append("boolean ");
                        Return2.append(evalId);
                        Return2.append("=");
                        Return2.append(su.getCode());
                        Return2.append(";");
                        Return2.append(eol);
                        su.setBoolVar(evalId);
                    }
                    su = (EvaluateSuObject)this.subjectSet.getNext();
                }
                this.getCode(Return2, 0);
                Return2.append(eol);
            }
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    private void getCodeOptimized(StringBuffer Return2, boolean string) {
        EvaluateSuObject su = (EvaluateSuObject)this.subjectSet.getFirst();
        String evalVar = "eval$" + Evaluate.getUniqueId();
        Return2.append(string ? "String " : "int ");
        Return2.append(evalVar);
        Return2.append(" = ");
        if (string) {
            Return2.append("Factory.rtrim(");
            Return2.append(su.expr.firstVar.getCode());
            Return2.append(".toString());");
        } else {
            Return2.append(su.expr.firstVar.getCode());
            Return2.append(".toint();");
        }
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        Return2.append("switch(");
        Return2.append(evalVar);
        Return2.append(") {");
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        this.writeCases(Return2, string, 0, evalVar, false, false, new HashSet());
        Return2.append("}");
        Return2.append(eol);
    }

    void writeCases(StringBuffer Return2, boolean string, int index, String evalVar, boolean emptyBlock, boolean firstSnsCase, Set labels) {
        EvaluateSuObject ob = (EvaluateSuObject)this.objectSet.getAt(index);
        while (ob != null) {
            if (ob.getDeferredMethodId() > 0 && ob.getDeferredMethodId() != this.deferredMethodId) {
                this.writeDeferredMethodCode(Return2, index, string ? 3 : 1, evalVar, labels, ob.getDeferredMethodId());
                return;
            }
            emptyBlock = this.writeCase(Return2, ob, string, emptyBlock, firstSnsCase, labels);
            firstSnsCase = false;
            if (emptyBlock) {
                ++index;
                ob = (EvaluateSuObject)this.objectSet.getNext();
                while (ob != null) {
                    if (ob.getDeferredMethodId() > 0 && ob.getDeferredMethodId() != this.deferredMethodId) {
                        this.writeDeferredMethodCode(Return2, index, string ? 3 : 1, evalVar, labels, ob.getDeferredMethodId());
                        return;
                    }
                    if (!(emptyBlock = this.writeCase(Return2, ob, string, emptyBlock, firstSnsCase, labels))) break;
                    ob = (EvaluateSuObject)this.objectSet.getNext();
                    ++index;
                }
            }
            ob = (EvaluateSuObject)this.objectSet.getNext();
            ++index;
        }
    }

    private void writeDeferredMethodCode(StringBuffer Return2, int index, int optCode, String evalVar, Set labels, int defMetId) {
        boolean debug = this.pc.getOption("-d") != null;
        boolean pt0_2 = this.pc.getOption("-pt0") != null || this.pc.getOption("-pt2") != null;
        DeferredBlock db = this.parent.parent.getDeferredBlock(defMetId);
        db.setEvaluate(this, index, optCode, evalVar, labels);
        this.parent.parent.deferredBlockList.add(db);
        Return2.append("default:" + eol + this.parent.getIndent());
        Return2.append(db.getCallCode(this.deferredMethodId, this.parent.nDeclares, debug, pt0_2) + eol);
        Return2.append(this.parent.getIndent() + "   break;" + eol);
    }

    private void getCodeOptimizedLevel88(StringBuffer Return2, boolean string) {
        String varcode;
        EvaluateSuObject ob = (EvaluateSuObject)this.objectSet.getFirst();
        VariableName vn = ((SimpleCondition)ob.getCond().getAllItems().getFirst()).getLeft().firstVar;
        VariableDeclaration vd = vn.getVarDecl().getParent();
        String evalVar = "eval$" + Evaluate.getUniqueId();
        Return2.append(string ? "String " : "int ");
        Return2.append(evalVar);
        Return2.append(" = ");
        String string2 = varcode = this.pc.optionMS ? vd.getUnivoqueName() : vd.getDeclUnivoqueName() + vn.getSubscriptCode();
        if (string) {
            Return2.append("Factory.rtrim(");
            Return2.append(varcode);
            Return2.append(".toString());");
        } else {
            Return2.append(varcode);
            Return2.append(".toint();");
        }
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        Return2.append("switch(");
        Return2.append(evalVar);
        Return2.append(") {");
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        this.writeCases(Return2, string, 0, evalVar, false, false, new HashSet());
        Return2.append("}");
        Return2.append(eol);
    }

    private String[] getTokens(EvaluateSuObject ob) {
        String[] Return2 = null;
        switch (ob.getType()) {
            case 7: {
                Return2 = new String[]{};
                break;
            }
            case 5: {
                VariableDeclaration vd = ((SimpleCondition)ob.getCond().getAllItems().getFirst()).getLeft().firstVar.getVarDecl();
                ArrayList<String> tokens = new ArrayList<String>();
                int valuesCount = vd.getValuesCount();
                for (int i = 0; i < valuesCount; ++i) {
                    if (vd.getHighValue(i) != null) {
                        int hv;
                        int lv = Integer.parseInt(vd.getLowValue(i).getWord());
                        if (lv > (hv = Integer.parseInt(vd.getHighValue(i).getWord()))) {
                            int tmp = lv;
                            lv = hv;
                            hv = tmp;
                        }
                        for (int v = lv; v <= hv; ++v) {
                            tokens.add(Integer.toString(v));
                        }
                        continue;
                    }
                    tokens.add(vd.getLowValue(i).getWord());
                }
                Return2 = new String[tokens.size()];
                tokens.toArray(Return2);
                break;
            }
            case 4: {
                Return2 = new String[]{ob.getExpr().firstToken.getWord()};
            }
        }
        return Return2;
    }

    private boolean writeCase(StringBuffer Return2, EvaluateSuObject ob, boolean string, boolean prevIsEmpty, boolean firstSnsCase, Set labels) {
        String[] tokens = this.getTokens(ob);
        boolean duplicate = false;
        if (ob.getType() == 7) {
            Return2.append("default:");
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
        } else {
            duplicate = true;
            for (int i = 0; i < tokens.length; ++i) {
                String lbl = tokens[i];
                lbl = string ? Evaluate.removeTrailingSpacesAndEscape(lbl) : Evaluate.removeLeadingZeros(lbl);
                if (labels.contains(lbl) && (!firstSnsCase || i > 0)) {
                    Return2.append("// ");
                } else {
                    duplicate = false;
                    labels.add(lbl);
                }
                Return2.append("case ");
                Return2.append(lbl);
                Return2.append(":");
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
            }
        }
        Block blk = ob.getBlock();
        if (blk != null) {
            if (!blk.isEmpty()) {
                if (!duplicate || prevIsEmpty) {
                    Return2.append(ob.getBlock().getCode());
                    Return2.append(eol);
                    Return2.append(this.parent.getIndent());
                    Return2.append("   break;");
                    Return2.append(eol);
                    Return2.append(this.parent.getIndent());
                }
                return false;
            }
            if (duplicate) {
                return prevIsEmpty;
            }
            return true;
        }
        if (!duplicate || prevIsEmpty) {
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
            Return2.append("   break;");
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
        }
        return false;
    }

    private static String removeTrailingSpacesAndEscape(String word) {
        int end;
        if (word == null) {
            return word;
        }
        char[] c = word.toCharArray();
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        for (end = c.length - 2; end >= 1 && c[end] == ' '; --end) {
        }
        block9: for (int i = 1; i <= end; ++i) {
            switch (c[i]) {
                case '\"': 
                case '\\': {
                    sb.append('\\').append(c[i]);
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    sb.append(c[i]);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    private static String removeLeadingZeros(String word) {
        if (word == null) {
            return word;
        }
        int start = 0;
        int len = word.length() - 1;
        char sign = word.charAt(0);
        if (sign == '+' || sign == '-') {
            start = 1;
        } else {
            sign = '\u0000';
        }
        while (start < len && word.charAt(start) == '0') {
            ++start;
        }
        if (sign == '\u0000') {
            if (start > 0) {
                return word.substring(start);
            }
            return word;
        }
        if (start > 1) {
            return "" + sign + word.substring(start);
        }
        return word;
    }

    void getCode(StringBuffer Return2, int index) {
        EvaluateSuObject su = (EvaluateSuObject)this.subjectSet.getFirst();
        Return2.append(this.parent.getIndent());
        Return2.append("if (");
        Alphabet cs = this.pc.getProgramCollatingSeq();
        EvaluateSuObject ob = (EvaluateSuObject)this.objectSet.getAt(index);
        while (ob != null) {
            if (ob.getDeferredMethodId() > 0 && ob.getDeferredMethodId() != this.deferredMethodId) {
                boolean debug = this.pc.getOption("-d") != null;
                boolean pt0_2 = this.pc.getOption("-pt0") != null || this.pc.getOption("-pt2") != null;
                DeferredBlock db = this.parent.parent.getDeferredBlock(ob.getDeferredMethodId());
                db.setEvaluate(this, index);
                this.parent.parent.deferredBlockList.add(db);
                Return2.append(" else {" + eol + this.parent.getIndent());
                Return2.append(db.getCallCode(this.deferredMethodId, this.parent.nDeclares, debug, pt0_2) + eol);
                Return2.append(this.parent.getIndent() + " }" + eol);
                break;
            }
            boolean not = ob.not ^ su.not && ob.type != 7;
            if (not) {
                Return2.append("!(");
            }
            switch (ob.type) {
                case 0: {
                    break;
                }
                case 2: {
                    Return2.append("!");
                    Return2.append(su.getCode());
                    break;
                }
                case 1: {
                    Return2.append(su.getCode());
                    break;
                }
                case 5: {
                    Return2.append("(");
                    Return2.append(su.getCode());
                    Return2.append("==");
                    Return2.append(ob.getCode());
                    Return2.append(")");
                    break;
                }
                case 6: {
                    Return2.append("(");
                    Return2.append(ob.getCode());
                    Return2.append(")");
                    break;
                }
                case 4: {
                    boolean cudc1;
                    int op1;
                    int n = op1 = ob.thru ? 3 : 1;
                    if (this.pc.getOption("-cudc") != null && SimpleCondition.isUDisplayCond(su.getExpr(), op1, ob.getExpr(), Return2, cs, this.tm)) {
                        cudc1 = true;
                    } else {
                        cudc1 = false;
                        boolean leftJS = su.expr.isJavaString();
                        boolean rightJS = ob.expr.isJavaString();
                        if (leftJS && rightJS || leftJS && ob.expr.getType() == 2 || rightJS && su.expr.getType() == 2) {
                            Return2.append("ExprUtil.cmp(");
                            Return2.append(su.getCode());
                            Return2.append(", ");
                            Return2.append(ob.getCode());
                        } else {
                            Return2.append(su.getCode());
                            Return2.append(".compareTo(");
                            Return2.append(ob.getCode());
                            if (!su.expr.isNumeric() && !ob.expr.isNumeric() && cs != null) {
                                Return2.append(", " + cs.getDeclUnivoqueName());
                            }
                        }
                        Return2.append(")");
                    }
                    if (ob.thru) {
                        if (!cudc1) {
                            Return2.append(">=0");
                        }
                        Return2.append("&&");
                        if (this.pc.getOption("-cudc") != null && SimpleCondition.isUDisplayCond(su.getExpr(), 4, ob.getExprThru(), Return2, cs, this.tm)) break;
                        Return2.append(su.getCode());
                        Return2.append(".compareTo(");
                        Return2.append(ob.getCodeThru());
                        if (!su.expr.isNumeric() && !ob.exprThru.isNumeric() && cs != null) {
                            Return2.append(", " + cs.getDeclUnivoqueName());
                        }
                        Return2.append(")<=0");
                        break;
                    }
                    if (cudc1) break;
                    Return2.append("==0");
                    break;
                }
                case 3: {
                    Return2.append("true");
                    break;
                }
                case 7: {
                    Return2.append("true");
                    this.subjectSet.getLast();
                }
            }
            if (not) {
                Return2.append(")");
            }
            if ((su = (EvaluateSuObject)this.subjectSet.getNext()) == null) {
                if (ob.block != null && ob.block.isEmpty()) {
                    ob = (EvaluateSuObject)this.objectSet.getNext();
                    ++index;
                    if (ob != null) {
                        su = (EvaluateSuObject)this.subjectSet.getFirst();
                        Return2.append(" ||");
                        Return2.append(eol);
                        Return2.append(this.parent.getIndent());
                        Return2.append("          ");
                        continue;
                    }
                    Return2.append(")");
                    Return2.append("   ;");
                    continue;
                }
                Return2.append(")");
                if (ob.block != null) {
                    Return2.append(ob.block.getCode());
                } else {
                    Return2.append("   ;");
                }
                ob = (EvaluateSuObject)this.objectSet.getNext();
                ++index;
                if (ob == null) continue;
                su = (EvaluateSuObject)this.subjectSet.getFirst();
                if (ob.getDeferredMethodId() != 0 && ob.getDeferredMethodId() != this.deferredMethodId) continue;
                Return2.append(" else if (");
                continue;
            }
            Return2.append("&&");
            ob = (EvaluateSuObject)this.objectSet.getNext();
            ++index;
        }
    }

    public VerbList getSubjectSet() {
        return this.subjectSet;
    }

    public VerbList getObjectSet() {
        return this.objectSet;
    }
}

