/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import java.util.Enumeration;
import java.util.Vector;

public class MyStringTokenizer
implements Enumeration {
    private Vector tokens = new Vector();
    private int curToken;
    private int tokenCount;

    public MyStringTokenizer(String str) {
        char[] cstr = str.toCharArray();
        boolean inQuote = false;
        StringBuffer sb = new StringBuffer();
        block4: for (int i = 0; i < cstr.length; ++i) {
            switch (cstr[i]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (inQuote) {
                        sb.append(cstr[i]);
                        continue block4;
                    }
                    if (sb.length() <= 0) continue block4;
                    this.tokens.addElement(sb.toString());
                    sb.delete(0, sb.length());
                    continue block4;
                }
                case '\"': {
                    if (i + 1 < cstr.length && cstr[i + 1] == '\"') {
                        sb.append(cstr[i++]);
                        continue block4;
                    }
                    inQuote = !inQuote;
                    continue block4;
                }
                default: {
                    sb.append(cstr[i]);
                }
            }
        }
        if (sb.length() > 0) {
            this.tokens.addElement(sb.toString());
        }
        this.tokenCount = this.tokens.size();
    }

    public boolean hasMoreTokens() {
        return this.hasMoreElements();
    }

    @Override
    public boolean hasMoreElements() {
        return this.tokenCount > this.curToken;
    }

    public Object nextElement() {
        return this.tokens.elementAt(this.curToken++);
    }

    public String nextToken() {
        return (String)this.nextElement();
    }

    public int countTokens() {
        return this.tokenCount;
    }
}

