/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.EsqParser;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.FindAllMethods;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlCall;
import com.iscobol.compiler.SqlDelete;
import com.iscobol.compiler.SqlExecute;
import com.iscobol.compiler.SqlFetch;
import com.iscobol.compiler.SqlInsert;
import com.iscobol.compiler.SqlOpen;
import com.iscobol.compiler.SqlSelect;
import com.iscobol.compiler.SqlSet;
import com.iscobol.compiler.SqlUpdate;
import com.iscobol.compiler.SqlValue;
import com.iscobol.compiler.SqlWhenever;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.Config;
import java.util.Hashtable;
import java.util.Vector;

public abstract class SqlStatement
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int OP_WITH_HOLD = 1;
    public static final int OP_WITH_NO_HOLD = 2;
    public final int MAX_LINES = Config.getProperty(".compiler.max_hostvars", 700);
    public final boolean db2Esql;
    public final boolean db2Sqljbin;
    public final VariableName sqlca;
    public final VariableName sqlcode;
    public final VariableName sqlerrd;
    public String iterator = "SqljIter$";
    public String incompleteIterName = "SqljIter$";
    public String sqljSetLostWord = "";
    public static final Hashtable sqlTypes = new Hashtable(){
        {
            this.put("ARRAY", 2003);
            this.put("BIGINT", -5);
            this.put("BINARY", -2);
            this.put("BIT", -7);
            this.put("BLOB", 2004);
            this.put("BOOLEAN", 16);
            this.put("CHAR", 1);
            this.put("CLOB", 2005);
            this.put("DATALINK", 70);
            this.put("DATE", 91);
            this.put("DECIMAL", 3);
            this.put("DATE", 91);
            this.put("DISTINCT", 2001);
            this.put("DOUBLE", 8);
            this.put("FLOAT", 6);
            this.put("INTEGER", 4);
            this.put("INT", 4);
            this.put("JAVA_OBJECT", 2000);
            this.put("LONGVARCHAR", -1);
            this.put("LONGVARBINARY", -4);
            this.put("NCHAR", -15);
            this.put("NCLOB", 2011);
            this.put("NULL", 0);
            this.put("NUMERIC", 2);
            this.put("OTHER", 1111);
            this.put("REAL", 7);
            this.put("REF", 2006);
            this.put("ROWID", -8);
            this.put("SMALLINT", 5);
            this.put("SQLXML", 2009);
            this.put("STRUCT", 2002);
            this.put("TIME", 92);
            this.put("TIMESTAMP", 93);
            this.put("TINYINT", -6);
            this.put("VARBINARY", -3);
            this.put("VARCHAR", 12);
        }
    };
    public static final Hashtable sqlTypesCast = new Hashtable(){
        {
            this.put(2003, "ARRAY");
            this.put(-5, "BIGINT");
            this.put(-2, "BINARY");
            this.put(-7, "BIT");
            this.put(2004, "BLOB");
            this.put(16, "BOOLEAN");
            this.put(1, "CHAR");
            this.put(2005, "CLOB");
            this.put(70, "DATALINK");
            this.put(91, "DATE");
            this.put(3, "DECIMAL");
            this.put(2001, "DISTINCT");
            this.put(8, "DOUBLE");
            this.put(6, "FLOAT");
            this.put(4, "INTEGER");
            this.put(2000, "JAVA_OBJECT");
            this.put(-1, "LONGVARCHAR");
            this.put(-4, "LONGVARBINARY");
            this.put(-15, "NCHAR");
            this.put(2011, "NCLOB");
            this.put(0, "NULL");
            this.put(2, "NUMERIC");
            this.put(1111, "OTHER");
            this.put(7, "REAL");
            this.put(2006, "REF");
            this.put(-8, "ROWID");
            this.put(5, "SMALLINT");
            this.put(2009, "SQLXML");
            this.put(2002, "STRUCT");
            this.put(92, "TIME");
            this.put(93, "TIMESTAMP");
            this.put(-6, "TINYINT");
            this.put(-3, "VARBINARY");
            this.put(12, "VARCHAR");
            this.put(2013, "MONTHS");
            this.put(2014, "HOURS");
        }
    };
    public static final Hashtable db2Functions = new Hashtable(){
        {
            this.put("ADD_DAYS", new int[]{91});
            this.put("ADD_HOURS", new int[]{93});
            this.put("ADD_MINUTES", new int[]{93});
            this.put("ADD_MONTHS", new int[]{91});
            this.put("ADD_SECONDS", new int[]{93});
            this.put("ADD_YEARS", new int[]{91});
            this.put("AGE", new int[]{93});
            this.put("DATE_PART", new int[]{91});
            this.put("DATE_TRUNC", new int[]{93});
            this.put("DAYNAME", new int[]{93});
            this.put("DAYOFMONTH", new int[]{91});
            this.put("DAYOFWEEK", new int[]{91});
            this.put("DAYOFWEEK_ISO", new int[]{91});
            this.put("DAYOFYEAR", new int[]{91});
            this.put("DAYS", new int[]{91});
            this.put("DAYS_BETWEEN", new int[]{91});
            this.put("DAYS_TO_END_OF_MONTH", new int[]{91});
            this.put("DATE", new int[]{91});
            this.put("DECIMAL", new int[]{3});
            this.put("EXTRACT", new int[]{91});
            this.put("FIRST_DAY", new int[]{91});
            this.put("FROM_UTC_TIMESTAMP", new int[]{93});
            this.put("HOUR", new int[]{92});
            this.put("HOURS_BETWEEN", new int[]{92});
            this.put("INT", new int[]{4});
            this.put("INTEGER", new int[]{4});
            this.put("JULIAN_DATE", new int[]{91});
            this.put("MICROSECOND", new int[]{92});
            this.put("MIDNIGHT_SECONDS", new int[]{92});
            this.put("MINUTE", new int[]{92});
            this.put("MINUTES_BETWEEN", new int[]{92});
            this.put("MONTH", new int[]{91});
            this.put("MONTHNAME", new int[]{91});
            this.put("MONTHS_BETWEEN", new int[]{91});
            this.put("NEXT_DAY", new int[]{91});
            this.put("NEXT_MONTH", new int[]{91});
            this.put("NEXT_QUARTER", new int[]{91});
            this.put("NEXT_WEEK", new int[]{91});
            this.put("NEXT_YEAR", new int[]{91});
            this.put("QUARTER", new int[]{91});
            this.put("ROUND", new int[]{91});
            this.put("ROUND_TIMESTAMP", new int[]{93});
            this.put("SECOND", new int[]{92});
            this.put("SECONDS_BETWEEN", new int[]{92});
            this.put("THIS_MONTH", new int[]{91});
            this.put("THIS_QUARTER", new int[]{91});
            this.put("THIS_WEEK", new int[]{91});
            this.put("THIS_YEAR", new int[]{91});
            this.put("TIME", new int[]{92});
            this.put("TIMESTAMP", new int[]{93});
            this.put("TIMESTAMP_FORMAT", new int[]{93});
            this.put("TIMESTAMP_ISO", new int[]{93});
            this.put("TIMESTAMPDIFF", new int[]{93});
            this.put("TIMEZONE", new int[]{91});
            this.put("TO_CHAR", new int[]{93});
            this.put("VARCHAR_FORMAT", new int[]{93});
            this.put("WEEK", new int[]{91});
            this.put("WEEK_ISO", new int[]{91});
            this.put("WEEKS_BETWEEN", new int[]{91});
            this.put("YEAR", new int[]{91});
            this.put("YEARS_BETWEEN", new int[]{91});
            this.put("YMD_BETWEEN", new int[]{91});
        }
    };
    public static final Hashtable db2Registers = new Hashtable(){
        {
            this.put("ACCELERATOR", new String[]{"ACCELERATOR"});
            this.put("APPLICATION", new String[]{"APPLICATION", "COMPATIBILITY"});
            this.put("APPLICATION+ENCODING", new String[]{"APPLICATION", "ENCODING", "SCHEME"});
            this.put("CLIENT_ACCTNG", new String[]{"CLIENT_ACCTNG"});
            this.put("CLIENT_APPLNAME", new String[]{"CLIENT_APPLNAME"});
            this.put("CLIENT_CORR_TOKEN", new String[]{"CLIENT_CORR_TOKEN"});
            this.put("CLIENT_USERID", new String[]{"CLIENT_USERID"});
            this.put("CLIENT_WRKSTNAME", new String[]{"CLIENT_WRKSTNAME"});
            this.put("DATE", new String[]{"DATE"});
            this.put("DATE+BETWEEN", new String[]{"DATE", "BETWEEN", "##username", "AND", "##username"});
            this.put("DEBUG", new String[]{"DEBUG", "MODE"});
            this.put("DECFLOAT", new String[]{"DECFLOAT", "ROUNDING", "MODE"});
            this.put("EXPLAIN", new String[]{"EXPLAIN", "MODE"});
            this.put("GET_ACCEL_ARCHIVE", new String[]{"GET_ACCEL_ARCHIVE"});
            this.put("LC_TYPE", new String[]{"LC_TYPE"});
            this.put("LOCALE", new String[]{"LOCALE", "LC_TYPE"});
            this.put("MAINTEINED", new String[]{"MANTEINED", "TABLE", "@TYPES", "@FOR", "@OPTIMIZATION"});
            this.put("MEMBER", new String[]{"MEMBER"});
            this.put("OPTIMIZATION", new String[]{"OPTIMIZATION", "HINT"});
            this.put("PACKAGE", new String[]{"PACKAGE", "PATH"});
            this.put("PACKAGESET", new String[]{"PACKAGESET"});
            this.put("PATH", new String[]{"PATH"});
            this.put("PRECISION", new String[]{"PRECISION"});
            this.put("QUERY", new String[]{"QUERY", "ACCELERATION", "WAITFORDATA"});
            this.put("REFRESH", new String[]{"REFRESH", "AGE"});
            this.put("ROUTINE", new String[]{"ROUTINE", "VERSION"});
            this.put("RULES", new String[]{"RULES"});
            this.put("SCHEMA", new String[]{"SCHEMA"});
            this.put("SERVER", new String[]{"SERVER"});
            this.put("SQLID", new String[]{"SQLID"});
            this.put("TEMPORAL_BUSINESS_TIME", new String[]{"TEMPORAL_BUSINESS_TIME"});
            this.put("TEMPORAL_SYSTEM_TIME", new String[]{"TEMPORAL_SYSTEM_TIME"});
            this.put("TIME", new String[]{"TIME"});
            this.put("TIME+ZONE", new String[]{"TIME", "ZONE"});
            this.put("TIMESTAMP", new String[]{"TIMESTAMP", "@(", "@##num", "@)", "@WITH/WITHOUT", "@TIME", "@ZONE"});
            this.put("ENCRYPTION", new String[]{"ENCRYPTION", "PASSWORD"});
            this.put("SESSION", new String[]{"SESSION", "TIMEZONE"});
            this.put("SESSION_USER", new String[]{"SESSION_USER"});
            this.put("USER", new String[]{"USER"});
        }
    };
    private VariableName firstFuncParDB2;
    protected final ExecSql exec;
    private SqlWhenever whenError;
    private SqlWhenever whenWarn;
    private SqlWhenever whenNotFound;
    private StringBuffer query = new StringBuffer();
    private String lastWord;
    protected VariableName cursHndl;
    private static final Token bindInd = new Token(10002, "0", 0, 0, "");
    protected VariableName bindType;
    protected VariableName forVar;
    protected int forVal = 0;
    protected String curName;
    protected String curFunc = null;
    protected String operFunc = null;
    protected String saveFunc = null;
    protected Token oldFunc = null;
    protected Token parOpen = null;
    protected Token parClose = null;
    protected Token prevTok = null;
    protected Token prevRealTok = null;
    protected int numPar = 0;
    protected final boolean sqlj;
    protected final boolean checkVars;
    protected final boolean optionXNOCGHV;
    protected final boolean optionXLVNULL;
    protected final boolean optionD64;
    protected final boolean optionCP;
    protected TokenManager tm;
    public boolean isSqljStat;
    public static final String SQLJ_HV_PREF = "sqlj$h$";
    public static final String SQLJ_HP_PREF = "sqlj$p$";
    public static Vector sqlDescribeOracle = new Vector();
    protected String sqlcapfx = "";
    public EsqParser sqlExtraInfo;

    public SqlStatement(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        this(es, kw, par, p, t, null, 0, err, true);
    }

    public SqlStatement(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, VariableName fVar, int fVal, Errors err) throws GeneralErrorException, EndOfProgramException {
        this(es, kw, par, p, t, fVar, fVal, err, true);
    }

    public SqlStatement(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, Errors err, boolean checkVars) throws GeneralErrorException, EndOfProgramException {
        this(es, kw, par, p, t, null, 0, err, checkVars);
    }

    public SqlStatement(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, VariableName fVar, int fVal, Errors err, boolean checkVars) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.tm = t;
        p.setHasExecSql();
        this.setSqlcaprfx();
        this.db2Esql = t.getOptionList().getOption("-csdb2") != null || Config.getProperty(".compiler.esql.db2", false);
        this.db2Sqljbin = t.getOptionList().getOption("-xsqljdb2") != null;
        TokenList xtl = this.tm.delExtraInfo("SQL");
        if (xtl != null) {
            this.sqlExtraInfo = new EsqParser(xtl, this.error);
        }
        this.checkVars = checkVars;
        this.optionXNOCGHV = this.tm.getOptionList().getOption("-xnocghv") != null || this.tm.getOptionList().getOption("-cghv") == null;
        this.optionCP = this.tm.getOptionList().getOption("-cp") != null || this.tm.getOptionList().getOption("-xms") != null;
        this.optionD64 = this.optionCP && this.tm.getOptionList().getOption("-d64") != null;
        this.forVar = fVar;
        this.forVal = fVal;
        this.isSqljStat = this.sqlj = this.pc.getOption("-sqlj") != null;
        this.optionXLVNULL = this.pc.getOption("-xlvnull") != null;
        this.exec = es;
        this.whenError = es.getWhenError();
        this.whenWarn = es.getWhenWarn();
        this.whenNotFound = es.getWhenNotFound();
        this.query.append(kw.getWord());
        if ((this.pc.warning != null && this.pc.warning.hasGoto() || this.pc.werror != null && this.pc.werror.hasGoto() || this.pc.notFound != null && this.pc.notFound.hasGoto()) && this.parent != null) {
            this.parent.parent.setHasGoto(true);
        }
        if (checkVars) {
            VariableDeclaration vd;
            this.sqlca = new VariableName(new Token(10009, "SQLCA", kw.getFLN(), kw.getOffset(), kw.getFileName()));
            if (this.isSqljStat && (vd = this.pc.getAny(this.sqlca, true, true)) != null) {
                vd.setUsedAll();
            }
            if (!kw.getWord().equalsIgnoreCase("DECLARE")) {
                this.sqlca.check(this.pc);
            }
            this.sqlcode = new VariableName(new Token(10009, "SQLCODE", kw.getFLN(), kw.getOffset(), kw.getFileName()));
            if (!kw.getWord().equalsIgnoreCase("DECLARE")) {
                this.sqlcode.check(this.pc);
            }
            this.sqlerrd = new VariableName(new Token(10009, "SQLERRD", kw.getFLN(), kw.getOffset(), kw.getFileName()));
            if (!kw.getWord().equalsIgnoreCase("DECLARE")) {
                this.sqlerrd.check(this.pc, false, true, GetVarOpts.NO_OPTS);
            }
        } else {
            this.sqlca = null;
            this.sqlcode = null;
            this.sqlerrd = null;
        }
    }

    void createCursHndl(Pcc ppcc) {
        if (this.cursHndl == null && this.curName != null && !(ppcc instanceof FindAllMethods)) {
            try {
                String name = "ESQL-HNDL-" + this.curName;
                Token tk = new Token(10009, name, 0, 0, this.tm.getFileName());
                VariableDeclaration vd = VariableDeclaration.getHandle(ppcc, this.tm, tk);
                ppcc.fixedVars.addItem(vd);
                ppcc.loadVariable(vd);
                vd.setUsed();
                this.cursHndl = new VariableName(new Token(10009, name, this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()));
                this.cursHndl.check(ppcc);
            }
            catch (GeneralErrorException _ex) {
                throw new RuntimeException(_ex.getMessage());
            }
        }
    }

    void createVars(Pcc ppcc) {
        try {
            if (this.cursHndl == null && this.curName == null) {
                this.cursHndl = new VariableName(new Token(10009, "ESQL-CURS-HNDL", this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()));
                this.cursHndl.check(ppcc);
            }
            this.bindType = new VariableName(new Token(10009, "ESQL-BIND-TYPE", this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()));
            this.bindType.check(ppcc);
        }
        catch (GeneralErrorException _ex) {
            throw new RuntimeException(_ex.getMessage());
        }
    }

    void addWhenever(StringBuffer sb) {
        if (this.whenWarn != null) {
            sb.append(this.whenWarn.getCode());
        }
        if (this.whenNotFound != null) {
            sb.append(this.whenNotFound.getCode());
        }
        if (this.whenError != null) {
            sb.append(this.whenError.getCode());
        }
    }

    Token getSqlToken() throws EndOfProgramException, GeneralErrorException {
        return this.getSqlToken(false, '_');
    }

    Token getSqlToken(boolean immediate) throws EndOfProgramException, GeneralErrorException {
        return this.getSqlToken(immediate, '_');
    }

    Token getSqlToken(boolean immediate, char hyphenRepl) throws EndOfProgramException, GeneralErrorException {
        Token Return2;
        Token tk = Return2 = this.tm.getAllToken();
        Token tk1 = Return2;
        try {
            if (this.db2Esql && tk.getToknum() == 40 && this.prevTok != null && (db2Functions.containsKey(this.prevTok.getWord()) || Config.getProperty(".compiler.esql.db2.fun." + this.prevTok.getWord(), null) != null)) {
                this.curFunc = this.prevTok.getWord();
                this.oldFunc = this.prevTok;
                this.operFunc = this.prevTok.getWord();
                this.parOpen = tk;
                this.numPar = 1;
                this.firstFuncParDB2 = null;
            } else if (this.db2Esql && tk.getToknum() == 40 && this.curFunc != null) {
                ++this.numPar;
            } else if (this.db2Esql && tk.getToknum() == 41 && this.curFunc != null) {
                --this.numPar;
                if (this.numPar == 0) {
                    this.curFunc = null;
                    this.parClose = tk;
                }
            }
            if (Return2.getToknum() == 10009) {
                tk1 = this.tm.getAllToken();
                if (tk1.getToknum() == 36) {
                    tk = this.tm.getAllToken();
                    if (tk.getFLN() == Return2.getFLN() && tk1.getOffset() == Return2.getOffset() + Return2.getWord().length() && tk.getOffset() == tk1.getOffset() + 1) {
                        tk.setWord(Return2.getWord() + "$" + tk.getWord());
                        tk.setOffset(Return2.getOffset());
                        this.ungetAllSqlToken();
                        this.prevTok = Return2;
                        return this.getSqlToken(immediate);
                    }
                    this.ungetAllSqlToken();
                    this.ungetAllSqlToken();
                } else {
                    this.ungetAllSqlToken();
                }
                Return2.setWord(Return2.getWord().replace('-', hyphenRepl));
            } else if (Return2.getToknum() == 10001 && Return2.getWord().charAt(0) != '\\') {
                char quote = Return2.getWord().charAt(0);
                String s = Return2.getWord().substring(1, Return2.getWord().length() - 1);
                int i = s.indexOf(92, 0);
                while (i >= 0) {
                    s = s.substring(0, i) + '\\' + s.substring(i, s.length());
                    i = s.indexOf(92, i + 2);
                }
                i = s.indexOf(34, 0);
                while (i >= 0) {
                    s = s.substring(0, i) + '\\' + s.substring(i, s.length());
                    i = s.indexOf(34, i + 2);
                }
                if (this.tm.getOptionList().getOption("-csqq") != null) {
                    if (quote == '\"') {
                        if (!immediate) {
                            Return2.setWord("\\\"" + s + "\\\"");
                        }
                    } else {
                        Return2.setWord("'" + s + "'");
                    }
                } else if (Return2 != this.prevTok && this.tm.getOptionList().getOption("-csqq2") != null) {
                    if (quote == '\"') {
                        Return2.setWord("'" + s + "'");
                    } else {
                        Return2.setWord("\\\"" + s + "\\\"");
                    }
                } else {
                    if (quote == '\"') {
                        i = s.indexOf(39, 0);
                        while (i >= 0) {
                            s = s.substring(0, i) + '\'' + s.substring(i, s.length());
                            i = s.indexOf(39, i + 2);
                        }
                        s = s.replaceAll("\\\\\"\\\\\"", "\\\\\"");
                    }
                    Return2.setWord("'" + s + "'");
                }
            } else if (Return2.getToknum() == 58) {
                if (this.tm.getAllToken().getToknum() == 61) {
                    Return2.setToknum(10128);
                    Return2.setWord(":=");
                    this.tm.removeLastToken();
                } else {
                    this.ungetAllSqlToken();
                }
            } else if (Return2.getToknum() == 124) {
                if (this.tm.getAllToken().getToknum() == 124) {
                    Return2.setToknum(10129);
                    Return2.setWord("||");
                    this.tm.removeLastToken();
                } else {
                    this.ungetAllSqlToken();
                }
            } else if (Return2.getToknum() == 47) {
                if (this.tm.getAllToken().getToknum() == 42) {
                    Return2.setWord("/*");
                    this.tm.removeLastToken();
                    this.addToken(Return2);
                    while (true) {
                        if ((Return2 = this.tm.getAllToken()).getToknum() == 42) {
                            if (this.tm.getAllToken().getToknum() == 47) {
                                Return2.setWord("*/");
                                this.tm.removeLastToken();
                                this.addToken(Return2);
                                this.prevTok = Return2;
                                return this.getSqlToken(immediate);
                            }
                            this.ungetAllSqlToken();
                            this.addToken(Return2);
                            continue;
                        }
                        if (Return2.getToknum() == 10021) continue;
                        if (Return2.getToknum() == 10001 && Return2.getWord().charAt(0) != '\\') {
                            char quote = Return2.getWord().charAt(0);
                            String s = Return2.getWord().substring(1, Return2.getWord().length() - 1);
                            int i = s.indexOf(92, 0);
                            while (i >= 0) {
                                s = s.substring(0, i) + '\\' + s.substring(i, s.length());
                                i = s.indexOf(92, i + 2);
                            }
                            i = s.indexOf(34, 0);
                            while (i >= 0) {
                                s = s.substring(0, i) + '\\' + s.substring(i, s.length());
                                i = s.indexOf(34, i + 2);
                            }
                            if (this.tm.getOptionList().getOption("-csqq") != null) {
                                if (quote == '\"') {
                                    if (!immediate) {
                                        Return2.setWord("\\\"" + s + "\\\"");
                                    }
                                } else {
                                    Return2.setWord("'" + s + "'");
                                }
                            } else if (Return2 != this.prevTok && this.tm.getOptionList().getOption("-csqq2") != null) {
                                if (quote == '\"') {
                                    Return2.setWord("'" + s + "'");
                                } else {
                                    Return2.setWord("\\\"" + s + "\\\"");
                                }
                            } else {
                                if (quote == '\"') {
                                    i = s.indexOf(39, 0);
                                    while (i >= 0) {
                                        s = s.substring(0, i) + '\'' + s.substring(i, s.length());
                                        i = s.indexOf(39, i + 2);
                                    }
                                    s = s.replaceAll("\\\\\"\\\\\"", "\\\\\"");
                                }
                                Return2.setWord("'" + s + "'");
                            }
                        } else {
                            Return2.setWord(Return2.getWord().replace('-', hyphenRepl));
                        }
                        this.addToken(Return2);
                    }
                }
                this.ungetAllSqlToken();
            } else if (Return2.getToknum() == 45) {
                if (this.tm.getAllToken().getToknum() == 45) {
                    Return2.setWord("/*");
                    this.tm.removeLastToken();
                    this.addToken(Return2);
                    while (true) {
                        if ((Return2 = this.tm.getAllToken()).getToknum() == 10021) {
                            Return2.setWord("*/");
                            this.tm.removeLastToken();
                            this.addToken(Return2);
                            this.prevTok = Return2;
                            return this.getSqlToken(immediate);
                        }
                        this.addToken(Return2);
                    }
                }
                this.ungetAllSqlToken();
            } else if (Return2.getToknum() == 35) {
                tk = this.tm.getAllToken();
                if (tk.getFLN() == Return2.getFLN() && tk.getOffset() == Return2.getOffset() + 1) {
                    tk.setWord("#" + tk.getWord());
                    this.ungetAllSqlToken();
                    this.prevTok = Return2;
                    return this.getSqlToken(immediate);
                }
                this.ungetAllSqlToken();
            } else if (Return2.getToknum() == 10021) {
                this.prevTok = Return2;
                return this.getSqlToken(immediate);
            }
            if (this.prevTok != null && this.prevTok.getToknum() == 41 && tk.getToknum() != 45 && tk.getToknum() != 43 && tk.getToknum() != 42 && tk.getToknum() != 47 && this.numPar == 0) {
                this.operFunc = null;
            } else if (tk.getWord().equalsIgnoreCase("AND") || tk.getWord().equalsIgnoreCase("BETWEEN") || tk.getWord().equalsIgnoreCase("OR")) {
                this.saveFunc = this.operFunc;
                this.operFunc = null;
            }
            this.prevTok = Return2;
            return Return2;
        }
        catch (EndOfProgramException _ex) {
            throw new GeneralErrorException(197, 4, tk, tk.getWord(), this.error);
        }
    }

    void ungetAllSqlToken() throws EndOfProgramException {
        if (this.prevTok != null && (this.prevTok.getWord().equalsIgnoreCase("AND") || this.prevTok.getWord().equalsIgnoreCase("BETWEEN") || this.prevTok.getWord().equalsIgnoreCase("OR"))) {
            this.operFunc = this.saveFunc;
        }
        this.tm.ungetAllToken();
    }

    void ungetSqlToken() throws EndOfProgramException {
        if (this.prevTok != null && (this.prevTok.getWord().equalsIgnoreCase("AND") || this.prevTok.getWord().equalsIgnoreCase("BETWEEN") || this.prevTok.getWord().equalsIgnoreCase("OR"))) {
            this.operFunc = this.saveFunc;
        }
        this.tm.ungetToken();
    }

    void toLower() {
        this.query = new StringBuffer(this.query.toString().toLowerCase());
    }

    void resetQuery() {
        this.query = new StringBuffer();
    }

    void setQuery(String newQuery) {
        this.query = new StringBuffer(newQuery);
    }

    void addToken(Token tk) {
        this.addToken(tk, true);
    }

    void addToken(Token tk, boolean sep) {
        switch (tk.getToknum()) {
            case 42: 
            case 10001: 
            case 10002: 
            case 10017: {
                this.query.append(" ");
                break;
            }
            default: {
                int lenQuery;
                if (!tk.isWord()) break;
                if (sep && (lenQuery = this.query.length()) > 0) {
                    switch (this.query.charAt(lenQuery - 1)) {
                        case '(': 
                        case '[': 
                        case '{': {
                            break;
                        }
                        default: {
                            this.query.append(" ");
                        }
                    }
                }
                this.lastWord = tk.getWord();
            }
        }
        this.query.append(tk.getWord());
    }

    public Token buildSQLJToken(VariableName vn, boolean param) {
        VariableDeclaration vd = vn.getVarDecl();
        String prfx = SQLJ_HV_PREF;
        String name = vn.getCode().replace(".at (new int[] {", "$").replace(".num().intValue()", "$").replace(",", "").replace("{", "").replace("}", "").replace(")", "").replace("(", "").replace(" ", "").replace(".", "").replace("]", "").replace("[", "");
        if (param) {
            prfx = SQLJ_HP_PREF;
            vn.setSqljParam(prfx + name);
            vd.setSqljParam(prfx + name);
        } else {
            vn.setSqlj(prfx + name);
            vd.setSqlj(prfx + name);
        }
        return new Token(58, " :" + prfx + name, 0, 0, null);
    }

    public VariableDeclarationList splitChildren(VariableName vn) {
        VariableDeclarationList childrenVar = vn.getVarDecl().getChildren();
        if (this.optionXNOCGHV || vn.getVarDecl().isVarying() || vn.getVarDecl().isLob() || childrenVar.getItemNum() < 1 || childrenVar.getFirst().level == 88 || childrenVar.getFirst().level == 78) {
            return null;
        }
        return childrenVar;
    }

    void addSqljHostVar(VariableName vn, VariableName ind, boolean param, Vector vars, Vector inds) {
        VariableDeclarationList childrenVar = this.splitChildren(vn);
        if (childrenVar == null) {
            this.buildSQLJToken(vn, param);
            this.addTokenQuestionMark(vn, param);
            if (ind != null) {
                this.addToken(this.buildSQLJToken(ind, param));
            }
            vars.add(vn);
            inds.add(ind);
        } else {
            boolean firstDone = false;
            VariableDeclaration vd = childrenVar.getFirst();
            while (vd != null) {
                if (vd.redefines == null) {
                    if (firstDone) {
                        this.addToken(new Token(44, ",", 0, 0, null));
                    } else {
                        firstDone = true;
                    }
                    VariableName vnI = new VariableName(vd);
                    this.buildSQLJToken(vnI, param);
                    this.addTokenQuestionMark(vnI, param);
                    if (ind != null) {
                        this.addToken(this.buildSQLJToken(ind, param));
                    }
                    vars.add(vnI);
                    inds.add(ind);
                    vd.setUsed();
                }
                vd = childrenVar.getNext();
            }
        }
    }

    void addToQuery(String s) {
        this.query.append(s);
    }

    void setAsCall() {
        this.query.insert(0, '{');
        this.query.append('}');
    }

    void setAsCall(Vector parmVars, Vector parmInds) {
        parmVars.insertElementAt(parmVars.remove(parmVars.size() - 1), 0);
        parmInds.insertElementAt(parmInds.remove(parmVars.size() - 1), 0);
        String str = this.query.toString();
        int idx = str.lastIndexOf(63);
        if (idx > 0) {
            this.query = new StringBuffer("?= " + str.substring(0, idx));
        }
        this.setAsCall();
    }

    VariableName getHostVariable() throws GeneralErrorException, EndOfProgramException {
        return this.getHostVariable(false);
    }

    VariableName getHostVariable(boolean isInd) throws GeneralErrorException, EndOfProgramException {
        return this.getHostVariable(isInd, false);
    }

    VariableName getHostVariable(boolean isInd, boolean isInto) throws GeneralErrorException, EndOfProgramException {
        return this.getHostVariable(isInd, isInto, false);
    }

    VariableName getHostVariable(boolean isInd, boolean isInto, boolean isNameCall) throws GeneralErrorException, EndOfProgramException {
        VariableName vn;
        String saveOperFunc;
        VariableName Return2;
        block31: {
            Token tk;
            block30: {
                block29: {
                    Return2 = null;
                    saveOperFunc = this.operFunc;
                    tk = this.getSqlToken(false, Pcc.hyphenRepl);
                    if (tk.getToknum() != 10009) break block30;
                    do {
                        tk.setWord(tk.getWord().replace(Pcc.hyphenRepl, '-'));
                        Token isItComma = this.tm.getAllToken();
                        if (isItComma.getToknum() == 44) {
                            isItComma.setToknum(0);
                        } else if (isItComma.getToknum() == 527) {
                            isItComma.setToknum(10009);
                        }
                        this.ungetAllSqlToken();
                        this.ungetSqlToken();
                        vn = !isNameCall ? VariableName.get(this.tm, this.error, null, this.pc, false, false, false, true) : VariableName.get(this.tm, this.error, null, this.pc, false, false, false, true, GetVarOpts.NO_OPTS, true);
                        if (isItComma.getToknum() == 0) {
                            isItComma.setToknum(44);
                        }
                        if (vn == null) {
                            throw new GeneralErrorException(196, 4, tk, tk.getWord(), this.error);
                        }
                        if (Return2 == null) {
                            Return2 = vn;
                        } else {
                            vn.setOf(Return2);
                            Return2 = vn;
                        }
                        tk = this.getSqlToken();
                        if (tk.getToknum() != 10006) break block29;
                    } while ((tk = this.getSqlToken()).getToknum() == 10009);
                    this.ungetSqlToken();
                    this.ungetSqlToken();
                    break block31;
                }
                if (sqlTypesCast.contains(tk.getWord().toUpperCase())) {
                    vn.sqlTypeCast = true;
                    this.ungetSqlToken();
                } else {
                    this.ungetSqlToken();
                }
                break block31;
            }
            throw new GeneralErrorException(196, 4, tk, tk.getWord(), this.error);
        }
        boolean checkDim = true;
        if (this.forVal != 0 || this.forVar != null || isInto || this instanceof SqlCall || this instanceof SqlExecute && ((SqlExecute)this).isPlsql()) {
            checkDim = false;
        }
        VariableDeclaration vd = null;
        if (!(Return2 == null || this.pc == null || isInd && (vd = this.pc.getAny(Return2, checkDim, true)) == null)) {
            Return2.check(this.pc, checkDim, true, GetVarOpts.NO_OPTS);
        } else if (isInd && this.pc != null && Return2 != null) {
            vd = VariableDeclaration.getIndicator(this.pc, Return2, this.tm, this.error);
            this.error.print(265, 2, vd.name, vd.getName());
            Return2.setVarDecl(vd);
            this.pc.fixedVars.addItem(vd);
            this.pc.loadVariable(vd);
            vd.setUsed();
        }
        if (isInto && vd == null && Return2 != null) {
            vd = this.pc.getAny(Return2, false, true);
        }
        if (isInto && Return2 != null && !Return2.hasIndexes() && vd != null && (this.forVal == 0 || this.forVal > vd.getOccursAll()) && this.forVar == null) {
            this.forVal = vd.getOccursAll();
        }
        if (this.db2Esql) {
            if (!db2Functions.containsKey(this.getSqlToken().getWord().toUpperCase())) {
                if (this.curFunc != null) {
                    Return2.sqlTypeFunc = Config.getProperty(".compiler.esql.db2.fun." + this.curFunc, null) != null ? Config.getProperty(".compiler.esql.db2.fun." + this.curFunc, -1) : ((int[])db2Functions.get(this.curFunc))[0];
                } else if (saveOperFunc != null && this.numPar == 0) {
                    Return2.sqlTypeFunc = Config.getProperty(".compiler.esql.db2.fun." + saveOperFunc, null) != null ? Config.getProperty(".compiler.esql.db2.fun." + saveOperFunc, -1) : ((int[])db2Functions.get(saveOperFunc))[0];
                } else if (this.parOpen != null && this.parClose != null && (vn.name.getFLN() > this.parOpen.getFLN() || this.parOpen.getFLN() == vn.name.getFLN() && this.parOpen.getOffset() < vn.name.getOffset()) && (vn.name.getFLN() < this.parClose.getFLN() || this.parClose.getFLN() == vn.name.getFLN() && this.parClose.getOffset() > vn.name.getOffset())) {
                    Return2.sqlTypeFunc = Config.getProperty(".compiler.esql.db2.fun." + this.oldFunc, null) != null ? Config.getProperty(".compiler.esql.db2.fun." + this.oldFunc, -1) : ((int[])db2Functions.get(this.oldFunc.getWord()))[0];
                }
            }
            if (Return2.sqlTypeFunc == 91) {
                if (Return2.getVarDecl().phisicLen > 10) {
                    Return2.sqlTypeFunc = 93;
                }
            } else if (Return2.sqlTypeFunc == 92 && Return2.getVarDecl().phisicLen > 8) {
                Return2.sqlTypeFunc = 93;
            }
            if (this.oldFunc != null && this.oldFunc.getWord().equals("TIMESTAMP") && this.firstFuncParDB2 != null && this.prevTok.getWord().equals(")") && this.firstFuncParDB2 != Return2 && !Return2.isNumeric()) {
                this.firstFuncParDB2.sqlTypeFunc = 91;
                Return2.sqlTypeFunc = 92;
            }
            if (this.numPar == 1 && this.curFunc.equals("TIMESTAMP") && this.firstFuncParDB2 == null) {
                this.firstFuncParDB2 = Return2;
            }
            this.ungetSqlToken();
        }
        this.operFunc = saveOperFunc;
        return Return2;
    }

    void where(Vector parmVars, Vector parmInds) throws GeneralErrorException, EndOfProgramException {
        int parCnt = 0;
        boolean unionToExit = false;
        boolean groupNotAllowed = true;
        this.operFunc = null;
        this.saveFunc = null;
        Token tk = this.getSqlToken();
        while (tk.getToknum() != 433 && tk.getToknum() != 695 && tk.getToknum() != 694 && !unionToExit && tk.getToknum() != 543) {
            switch (tk.getToknum()) {
                case 59: {
                    this.addToken(tk);
                    return;
                }
                case 495: {
                    if (this.getSqlToken().getToknum() == 794) {
                        this.ungetAllSqlToken();
                        this.ungetAllSqlToken();
                        return;
                    }
                    this.ungetAllSqlToken();
                    this.addToken(tk);
                    break;
                }
                case 527: {
                    this.addToken(tk);
                    groupNotAllowed = false;
                    break;
                }
                case 40: {
                    this.addToken(tk);
                    ++parCnt;
                    break;
                }
                case 41: {
                    groupNotAllowed = true;
                    if (parCnt == 0) {
                        this.ungetAllSqlToken();
                        return;
                    }
                    this.addToken(tk);
                    --parCnt;
                    break;
                }
                case 58: {
                    this.value(parmVars, parmInds, false, groupNotAllowed);
                    break;
                }
                case 10006: {
                    this.addToken(tk);
                    this.addToken(this.getSqlToken(), false);
                    break;
                }
                case 10017: {
                    if (this.isSqljStat) {
                        this.query.append(" " + this.getSqlDecimal(tk.getWord()));
                        break;
                    }
                    parmVars.add(tk);
                    this.query.append(" ?");
                    parmInds.add(null);
                    break;
                }
                default: {
                    if (parCnt == 0) {
                        this.saveFunc = null;
                    }
                    this.addToken(tk);
                }
            }
            tk = this.getSqlToken();
            if (parCnt != 0 || !tk.getWord().equals("UNION")) continue;
            unionToExit = true;
        }
        this.ungetAllSqlToken();
    }

    void bindCols(Pcc ppcc, StringBuffer sb, Vector bindVars, Vector bindInds) {
        this.createVars(ppcc);
        this.bindCols(sb, bindVars, bindInds, false);
    }

    void bindCols(Pcc ppcc, StringBuffer sb, Vector bindVars, Vector bindInds, boolean select) {
        this.createVars(ppcc);
        this.bindCols(sb, bindVars, bindInds, select);
    }

    private void bindCols(StringBuffer sb, Vector bindVars, Vector bindInds, boolean select) {
        if (bindVars != null) {
            int i = bindVars.size() - 1;
            int j = 0;
            while (i >= 0) {
                VariableName vn = (VariableName)bindVars.elementAt(i);
                if (vn.getVarDecl().isLobLocator()) {
                    sb.append(this.parent.getIndent());
                    sb.append("ESQL_BIND_TYPE.set(99999);" + eol);
                }
                sb.append(this.parent.getIndent());
                if (j > 0 && j % this.MAX_LINES == 0) {
                    if (j > this.MAX_LINES) {
                        sb.append(" } }; ");
                    }
                    sb.append(" new Object() { { ");
                }
                sb.append(this.getReturnCode());
                if (select) {
                    sb.append(".set(Esql.GET_OBJECT(new Object[] {");
                } else if (this.tm.getOptionList().getOption("-csora") != null && (this instanceof SqlInsert || this instanceof SqlDelete || this instanceof SqlUpdate)) {
                    sb.append(".set(Esql.BIND_COL_ORA(new Object[] {");
                } else {
                    sb.append(".set(Esql.BIND_COL(new Object[] {");
                }
                sb.append(this.cursHndl.getCode());
                sb.append(", ");
                if ((vn.getVarDecl().isVarying() || vn.getVarDecl().isVarChar() || vn.getVarDecl().isLob()) && !vn.getVarDecl().isLobLocator()) {
                    sb.append(vn.getVarDecl().getChildren().getLast().getUnivoqueName());
                    if (vn.hasIndexes()) {
                        sb.append(vn.getIndexes().getCode(vn.getVarDecl().isObjectReference(), vn.getVarDecl().getOccurs() > 0, vn.isEdited() && vn.isNumeric()));
                    }
                } else {
                    sb.append(vn.getCode());
                    if (!(vn.getVarDecl().getOccursAll() == 0 || vn.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                        sb.append(".at(j$j$j)");
                    }
                }
                sb.append(",");
                sb.append(this.bindType.getCode());
                sb.append(",");
                sb.append("Factory.getNumLiteral(");
                sb.append(i + 1);
                sb.append(", 4, 0, false),");
                if (vn.getVarDecl().isVarying() || vn.getVarDecl().isVarChar() || vn.getVarDecl().isLob()) {
                    sb.append(vn.getVarDecl().getChildren().getFirst().getUnivoqueName());
                    if (vn.hasIndexes()) {
                        sb.append(vn.getIndexes().getCode(vn.getVarDecl().isObjectReference(), vn.getVarDecl().getOccurs() > 0, vn.isEdited() && vn.isNumeric()));
                    }
                } else {
                    sb.append("null");
                }
                sb.append(" , null, ");
                if (bindInds.elementAt(i) == null) {
                    if (this.tm.getOptionList().getOption("-csqn") == null) {
                        sb.append(this.getBindIndCode());
                    } else {
                        sb.append("null");
                    }
                } else {
                    VariableName vN = (VariableName)bindInds.elementAt(i);
                    sb.append(vN.getCode());
                    if (!(vN.getVarDecl().getOccursAll() == 0 || vN.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                        sb.append(".at(j$j$j)");
                    }
                }
                if (this.pc.getOption("-xcsqc") != null) {
                    sb.append(", " + this.getInstanceName());
                }
                sb.append("}));");
                sb.append(eol);
                --i;
                ++j;
            }
            if (bindVars.size() > this.MAX_LINES) {
                sb.append(this.parent.getIndent() + " } };" + eol);
            }
        }
    }

    void setParams(Pcc ppcc, StringBuffer sb, Vector parmVars, Vector parmInds) {
        this.createVars(ppcc);
        this.setParams(sb, parmVars, parmInds, false);
    }

    void setParams(Pcc ppcc, StringBuffer sb, Vector parmVars, Vector parmInds, boolean select) {
        this.createVars(ppcc);
        this.setParams(sb, parmVars, parmInds, select, null);
    }

    private void setParams(StringBuffer sb, Vector parmVars, Vector parmInds, boolean select) {
        this.setParams(sb, parmVars, parmInds, select, null);
    }

    private void setParams(StringBuffer sb, Vector parmVars, Vector parmInds, boolean select, Vector bindVars) {
        if (parmVars != null) {
            int i = parmVars.size() - 1;
            int j = 0;
            while (i >= 0) {
                VariableName vn;
                Object obj = parmVars.elementAt(i);
                VariableDeclaration vd = null;
                if (parmInds.elementAt(i) != null && obj instanceof VariableName) {
                    if (obj instanceof VariableName) {
                        vd = ((VariableName)obj).getVarDecl();
                    }
                    if (vd == null) {
                        return;
                    }
                    vn = (VariableName)obj;
                    VariableName vI = (VariableName)parmInds.elementAt(i);
                    if (this.optionXLVNULL && vd.isNumeric()) {
                        if (vI.getName().startsWith("$$IND$$_")) {
                            sb.append(this.parent.getIndent());
                            sb.append(vI.getName() + ".setAllZero();" + eol);
                        }
                        sb.append(this.parent.getIndent());
                        sb.append("if (");
                        if (vd.isVarying() || vd.isLob() || vd.isVarChar()) {
                            sb.append(vd.getChildren().getLast().getUnivoqueName());
                            if (vn.hasIndexes()) {
                                sb.append(vn.getIndexes().getCode(vn.getVarDecl().isObjectReference(), vn.getVarDecl().getOccurs() > 0, vn.isEdited() && vn.isNumeric()));
                            }
                        } else {
                            sb.append(vn.getCode());
                            if (!(vn.getVarDecl().getOccursAll() == 0 || vn.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                                sb.append(".at(j$j$j)");
                            }
                        }
                        sb.append(".compareTo($lowVal$)==0)" + eol);
                        sb.append(this.parent.getIndent() + "   ");
                        if (vI.getName().startsWith("$$IND$$_")) {
                            sb.append(vI.getName());
                        } else if (vd.isVarying() || vd.isLob() || vd.isVarChar()) {
                            sb.append(vd.getChildren().getLast().getUnivoqueName());
                            if (vI.hasIndexes()) {
                                sb.append(vI.getIndexes().getCode(vd.isObjectReference(), vd.getOccurs() > 0, vI.isEdited() && vI.isNumeric()));
                            }
                        } else {
                            sb.append(vI.getCode());
                            if (!(vd.getOccursAll() == 0 || vI.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                                sb.append(".at(j$j$j)");
                            }
                        }
                        sb.append(".set(-1L);" + eol);
                    }
                }
                sb.append(this.parent.getIndent());
                if (j > 0 && j % this.MAX_LINES == 0) {
                    if (j > this.MAX_LINES) {
                        sb.append(" } }; ");
                    }
                    sb.append(" new Object() { { ");
                }
                sb.append(this.getReturnCode());
                if (select) {
                    sb.append(".set(Esql.SET_PARAMQ(new Object[] {");
                } else if (bindVars != null && this.tm.getOptionList().getOption("-csora") != null && (this instanceof SqlInsert || this instanceof SqlDelete || this instanceof SqlUpdate)) {
                    sb.append(".set(Esql.SET_PARAM_ORA(new Object[] {");
                } else {
                    sb.append(".set(Esql.SET_PARAM(new Object[] {");
                }
                sb.append(this.cursHndl.getCode());
                sb.append(", ");
                vn = null;
                if (obj instanceof Token) {
                    sb.append(this.getCodeLiteral((Token)obj));
                } else {
                    vn = (VariableName)obj;
                    if (vn.getVarDecl().isVarying() || vn.getVarDecl().isLob() || vn.getVarDecl().isVarChar()) {
                        sb.append(vn.getVarDecl().getChildren().getLast().getUnivoqueName());
                        if (vn.hasIndexes()) {
                            sb.append(vn.getIndexes().getCode(vn.getVarDecl().isObjectReference(), vn.getVarDecl().getOccurs() > 0, vn.isEdited() && vn.isNumeric()));
                        }
                    } else {
                        sb.append(vn.getCode());
                        if (!(vn.getVarDecl().getOccursAll() == 0 || vn.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                            sb.append(".at(j$j$j)");
                        }
                    }
                }
                sb.append(",");
                sb.append(this.bindType.getCode());
                sb.append(",");
                sb.append("Factory.getNumLiteral(");
                sb.append(i + 1);
                sb.append(", 4, 0, false),");
                if (vn != null && (vn.getVarDecl().isVarying() || vn.getVarDecl().isVarChar() || vn.getVarDecl().isVarChar() || vn.getVarDecl().isLob())) {
                    sb.append(vn.getVarDecl().getChildren().getFirst().getUnivoqueName());
                    if (vn.hasIndexes()) {
                        sb.append(vn.getIndexes().getCode(vn.getVarDecl().isObjectReference(), vn.getVarDecl().getOccurs() > 0, vn.isEdited() && vn.isNumeric()));
                    }
                } else {
                    sb.append("null");
                }
                sb.append(", null, ");
                if (parmInds.elementAt(i) == null) {
                    sb.append(this.getBindIndCode());
                } else {
                    VariableName vN = (VariableName)parmInds.elementAt(i);
                    sb.append(vN.getCode());
                    if (!(vN.getVarDecl().getOccursAll() == 0 || vN.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                        sb.append(".at(j$j$j)");
                    }
                }
                if (vn != null && vn.getSqlCallMode() != null) {
                    sb.append(",\"");
                    sb.append(vn.getSqlCallMode());
                    sb.append("\"");
                } else if (vn != null && this instanceof SqlCall && vn.getSqlCallMode() == null) {
                    sb.append(",\"INOUT\"");
                } else if (this.db2Esql) {
                    sb.append(",\"INOUT\"");
                } else {
                    sb.append(",null");
                }
                if (vn != null && vn.getVarDecl().isLob()) {
                    if (vn.getVarDecl().getUsageString() != null && (vn.getVarDecl().getUsageString().equals("CLOB") || vn.getVarDecl().getUsageString().equals("DBCLOB"))) {
                        sb.append(",null,(short)2005");
                    } else if (vn.getVarDecl().getUsageString() != null && vn.getVarDecl().getUsageString().equals("BLOB")) {
                        sb.append(",null,(short)2004");
                    }
                }
                if (vn != null && vn.getVarDecl().isLobLocator()) {
                    sb.append(",null,(short)99999");
                }
                sb.append("}));");
                sb.append(eol);
                --i;
                ++j;
            }
            if (parmVars.size() > this.MAX_LINES) {
                sb.append(this.parent.getIndent() + " } };" + eol);
            }
        }
    }

    private void setSqljParams(StringBuffer sb, Vector parmVars, Vector parmInds) {
        this.setSqljParams(sb, parmVars, parmInds, true);
    }

    private void setSqljParams(StringBuffer sb, Vector parmVars, Vector parmInds, boolean param) {
        if (parmVars != null) {
            int i = parmVars.size() - 1;
            int j = 0;
            while (i >= 0) {
                VariableName vn;
                Object obj = parmVars.elementAt(i);
                VariableDeclaration vd = null;
                if (parmInds.elementAt(i) != null && obj instanceof VariableName && (vd = ((VariableName)obj).getVarDecl()) != null) {
                    vn = (VariableName)obj;
                    VariableName vI = (VariableName)parmInds.elementAt(i);
                    sb.append(this.parent.getIndent());
                    if (param) {
                        sb.append(vI.getSqljNameParam() + " = ");
                    } else {
                        sb.append(vI.getSqljName() + " = ");
                    }
                    if (vI.getVarDecl().isVarying() || vI.getVarDecl().isLob() || vI.getVarDecl().isVarChar()) {
                        sb.append(vI.getVarDecl().getChildren().getLast().getUnivoqueName());
                        if (vI.hasIndexes()) {
                            sb.append(vI.getIndexes().getCode(vI.getVarDecl().isObjectReference(), vI.getVarDecl().getOccurs() > 0, vI.isEdited() && vn.isNumeric()));
                        }
                    } else {
                        sb.append(vI.getCode());
                        if (!(vI.getVarDecl().getOccursAll() == 0 || vI.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                            sb.append(".at(j$j$j)");
                        }
                    }
                    sb.append(".toshort();" + eol);
                }
                sb.append(this.parent.getIndent());
                if (j > 0 && j % this.MAX_LINES == 0) {
                    if (j > this.MAX_LINES) {
                        sb.append(" } }; ");
                    }
                    sb.append(" new Object() { { ");
                }
                vn = null;
                if (!(obj instanceof Token)) {
                    vn = (VariableName)obj;
                    if (param) {
                        sb.append(vn.getSqljNameParam() + " = ");
                    } else {
                        sb.append(vn.getSqljName() + " = ");
                    }
                    if (vn.getVarDecl().isVarying() || vn.getVarDecl().isLob() || vn.getVarDecl().isVarChar()) {
                        sb.append(vn.getVarDecl().getChildren().getLast().getUnivoqueName());
                        if (vn.hasIndexes()) {
                            sb.append(vn.getIndexes().getCode(vn.getVarDecl().isObjectReference(), vn.getVarDecl().getOccurs() > 0, vn.isEdited() && vn.isNumeric()));
                        }
                    } else {
                        sb.append(vn.getCode());
                        if (!(vn.getVarDecl().getOccursAll() == 0 || vn.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                            sb.append(".at(j$j$j)");
                        }
                    }
                }
                if (vn.isNumeric()) {
                    sb.append(".todouble();" + eol);
                } else if (this.db2Esql && this.db2Sqljbin && vn.getVarDecl().phisicLen != 10 && vn.getVarDecl().phisicLen != 26 && vn.getVarDecl().phisicLen != 8) {
                    sb.append(".getMyMemory(");
                    if (vn.getVarDecl().isVarying() || vn.getVarDecl().isLob() || vn.getVarDecl().isVarChar()) {
                        sb.append(vn.getVarDecl().getChildren().getFirst().getUnivoqueName());
                        if (vn.hasIndexes()) {
                            sb.append(vn.getIndexes().getCode(vn.getVarDecl().isObjectReference(), vn.getVarDecl().getOccurs() > 0, vn.isEdited() && vn.isNumeric()));
                        }
                        sb.append(".toint()");
                    } else {
                        sb.append(vn.getVarDecl().phisicLen);
                    }
                    sb.append(");" + eol);
                } else {
                    sb.append(".toString();" + eol);
                }
                sb.append("Esql.LOG_SQLJ(\"SQLJStat: setParam " + vn.getVarDecl().getName() + "=\" +  " + vn.getVarDecl().getName().replace('-', Pcc.hyphenRepl) + ".toString());" + eol);
                --i;
                ++j;
            }
        }
    }

    void bindSqljVars(StringBuffer sb, Vector parmVars, Vector parmInds) {
        if (parmVars != null) {
            if (this.db2Esql && (this.db2Sqljbin || this instanceof SqlSet || this instanceof SqlFetch)) {
                sb.append(this.parent.getIndent());
                sb.append("try {" + eol);
            }
            int i = parmVars.size() - 1;
            int j = 0;
            while (i >= 0) {
                Object obj = parmVars.elementAt(i);
                VariableDeclaration vd = null;
                if (j == 0 && this.db2Esql && this instanceof SqlSet) {
                    sb.append(this.parent.getIndent());
                    sb.append("clearSqlca(" + this.sqlcapfx + this.pc.sqlca.SQLCA + ");" + eol);
                    sb.append(this.parent.getIndent());
                    sb.append("if (automaticConnection && ctx" + this.pc.getClassName() + " == null)" + eol);
                    sb.append(this.parent.getIndent());
                    sb.append("   setSqljConnection();" + eol);
                    sb.append(this.parent.getIndent());
                    sb.append("try {" + eol);
                    sb.append(this.parent.getIndent());
                    sb.append("if (" + ((SqlSet)this).getIterName() + " != null)");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("   rs = (DB2ResultSet)");
                    sb.append(((SqlSet)this).getIterName());
                    sb.append(".getResultSet();");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("if (rs == null || rs.next() == false)");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("   throw new SQLException(\"IsCOBOLNotFound\");");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("}" + eol);
                    sb.append(this.parent.getIndent());
                    sb.append("catch (SQLException e) {" + eol);
                    sb.append(this.parent.getIndent());
                    sb.append("   fillSqlcaSqlj(e, " + this.sqlcapfx + this.pc.sqlca.SQLCA + ");" + eol);
                    sb.append(this.parent.getIndent());
                    sb.append("}" + eol);
                }
                if (j == 0 && this.db2Esql && this.db2Sqljbin && (this instanceof SqlSelect || this instanceof SqlOpen || this instanceof SqlValue)) {
                    sb.append(this.parent.getIndent());
                    sb.append("try {" + eol);
                    sb.append(this.parent.getIndent());
                    if (this instanceof SqlOpen) {
                        sb.append(this.curName + " = (DB2ResultSet)");
                    } else {
                        sb.append("rs = (DB2ResultSet)");
                    }
                    if (this instanceof SqlSelect) {
                        sb.append(((SqlSelect)this).getIterName());
                    } else if (this instanceof SqlValue) {
                        sb.append(((SqlValue)this).getIterName());
                    } else {
                        sb.append(((SqlOpen)this).getIterName());
                    }
                    sb.append(".getResultSet();");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("}" + eol);
                    sb.append(this.parent.getIndent());
                    sb.append("catch (SQLException e) {" + eol);
                    sb.append(this.parent.getIndent());
                    sb.append("   fillSqlcaSqlj(e, " + this.sqlcapfx + this.pc.sqlca.SQLCA + ");" + eol);
                    sb.append(this.parent.getIndent());
                    sb.append("}" + eol);
                }
                if (j == 0 && this.db2Esql && this.db2Sqljbin && (this instanceof SqlSelect || this instanceof SqlFetch || this instanceof SqlValue)) {
                    if (this instanceof SqlFetch) {
                        sb.append(this.parent.getIndent());
                        sb.append("clearSqlca(" + this.sqlcapfx + this.pc.sqlca.SQLCA + ");" + eol);
                        sb.append(this.parent.getIndent());
                        sb.append("if (automaticConnection && ctx" + this.pc.getClassName() + " == null)" + eol);
                        sb.append(this.parent.getIndent());
                        sb.append("   setSqljConnection();" + eol);
                        sb.append(this.parent.getIndent());
                        sb.append("if (" + this.curName + " == null || " + this.curName + ".next() == false)");
                        sb.append(eol);
                        sb.append(this.parent.getIndent());
                        sb.append("   throw new SQLException(\"IsCOBOLNotFound\");");
                        sb.append(eol);
                        sb.append(this.parent.getIndent());
                        sb.append("rowData = (byte[])" + this.curName + ".getDBRowDataAsBytes()[0];");
                        sb.append(eol);
                        sb.append(this.parent.getIndent());
                        sb.append("rowInfo = (int[])" + this.curName + ".getDBRowDescriptor();");
                        sb.append(eol);
                        sb.append(this.parent.getIndent());
                        sb.append("rowOffs = (int[])" + this.curName + ".getDBRowDataAsBytes()[1];");
                        sb.append(eol);
                    } else {
                        sb.append(this.parent.getIndent());
                        sb.append("clearSqlca(" + this.sqlcapfx + this.pc.sqlca.SQLCA + ");" + eol);
                        sb.append(this.parent.getIndent());
                        sb.append("if (automaticConnection && ctx" + this.pc.getClassName() + " == null)" + eol);
                        sb.append(this.parent.getIndent());
                        sb.append("   setSqljConnection();" + eol);
                        sb.append(this.parent.getIndent());
                        sb.append("if (rs == null || rs.next() == false)");
                        sb.append(eol);
                        sb.append(this.parent.getIndent());
                        sb.append("   throw new SQLException(\"IsCOBOLNotFound\");");
                        sb.append(eol);
                        sb.append(this.parent.getIndent());
                        sb.append("rowData = (byte[])rs.getDBRowDataAsBytes()[0];");
                        sb.append(eol);
                        sb.append(this.parent.getIndent());
                        sb.append("rowInfo = (int[])rs.getDBRowDescriptor();");
                        sb.append(eol);
                        sb.append(this.parent.getIndent());
                        sb.append("rowOffs = (int[])rs.getDBRowDataAsBytes()[1];");
                        sb.append(eol);
                    }
                }
                VariableName vn = obj instanceof VariableName ? (VariableName)obj : null;
                if (this.db2Esql && this.db2Sqljbin && (this instanceof SqlSelect || this instanceof SqlOpen || this instanceof SqlValue || this instanceof SqlFetch) && vn != null && !vn.isNumeric()) {
                    sb.append(this.parent.getIndent());
                    sb.append("offs = rowOffs[" + i + "] + 2;");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("colSqlType = rowInfo != null ? rowInfo[(4*(" + i + "))+1] : 0;");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("if (colSqlType == EsqlRuntime.DB2_VARCHAR ||");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("    colSqlType == (EsqlRuntime.DB2_VARCHAR + 1)) {");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("   System.arraycopy(rowData, offs, num, 0, 2);");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("   len  = (num[0]<< 8)&0x0000ff00|");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("          (num[1]<< 0)&0x000000ff;");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("   offs = offs + 2;");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("}");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("else");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("   len = rowInfo[(4*(" + i + "))+3];");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("bytearr = new byte[len];");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("if (rowData[rowOffs[(" + i + ")]] == 0 &&");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("    rowData[rowOffs[(" + i + ")] +1] == 0)");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("   System.arraycopy(rowData, offs,");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("                    bytearr, 0, bytearr.length);");
                    sb.append(eol);
                    if (this instanceof SqlSelect && this.tm.getOptionList().getOption("-csqn") != null) {
                        sb.append(this.parent.getIndent());
                        sb.append("else");
                        sb.append(eol);
                        sb.append(this.parent.getIndent());
                        sb.append("   throw new SQLException(\"IsCOBOLNull\", \"\");");
                        sb.append(eol);
                    }
                    if (vn.getVarDecl().isVarying() || vn.getVarDecl().isLob() || vn.getVarDecl().isVarChar()) {
                        sb.append(this.parent.getIndent());
                        sb.append(vn.getVarDecl().getChildren().getLast().getUnivoqueName());
                        if (vn.hasIndexes()) {
                            sb.append(vn.getIndexes().getCode(vn.getVarDecl().isObjectReference(), vn.getVarDecl().getOccurs() > 0, vn.isEdited() && vn.isNumeric()));
                        }
                    } else {
                        sb.append(this.parent.getIndent());
                        sb.append(vn.getCode());
                        if (!(vn.getVarDecl().getOccursAll() == 0 || vn.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                            sb.append(".at(j$j$j)");
                        }
                    }
                    sb.append(".sqlSetBytes(bytearr);");
                    sb.append(eol);
                    if (vn.getVarDecl().isVarying() || vn.getVarDecl().isLob() || vn.getVarDecl().isVarChar()) {
                        sb.append(this.parent.getIndent());
                        sb.append(vn.getVarDecl().getChildren().getFirst().getUnivoqueName());
                        if (vn.hasIndexes()) {
                            sb.append(vn.getIndexes().getCode(vn.getVarDecl().isObjectReference(), vn.getVarDecl().getOccurs() > 0, vn.isEdited() && vn.isNumeric()));
                        }
                        sb.append(".set(bytearr.length);");
                        sb.append(eol);
                    }
                } else if (this.db2Esql && this.db2Sqljbin && (this instanceof SqlSelect || this instanceof SqlValue || this instanceof SqlOpen || this instanceof SqlFetch) && vn != null && vn.isNumeric()) {
                    sb.append(this.parent.getIndent());
                    if (this instanceof SqlFetch) {
                        sb.append("obj = " + this.curName + ".getObject(" + (i + 1) + ");");
                    } else {
                        sb.append("obj = rs.getObject(" + (i + 1) + ");");
                    }
                    vn = (VariableName)obj;
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("if (obj == null) {");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("   " + vn.getCode());
                    if (!(vn.getVarDecl().getOccursAll() == 0 || vn.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                        sb.append(".at(j$j$j)");
                    }
                    sb.append(".set(");
                    if (vn.isNumeric()) {
                        sb.append("0);");
                    } else {
                        sb.append("\" \");");
                    }
                    if (this.tm.getOptionList().getOption("-csqn") == null || this instanceof SqlOpen || this instanceof SqlFetch) {
                        sb.append(eol);
                        sb.append(this.parent.getIndent());
                        sb.append("   ;");
                    } else {
                        sb.append(eol);
                        sb.append(this.parent.getIndent());
                        sb.append("   throw new SQLException(\"IsCOBOLNull\", \"\");");
                    }
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("} else if (obj instanceof BigDecimal)");
                    sb.append(eol);
                    sb.append(this.parent.getIndent() + "   ");
                    sb.append(vn.getCode());
                    if (!(vn.getVarDecl().getOccursAll() == 0 || vn.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                        sb.append(".at(j$j$j)");
                    }
                    sb.append(".set((BigDecimal)obj);");
                    sb.append(eol);
                    sb.append(this.parent.getIndent());
                    sb.append("else");
                    sb.append(eol);
                    sb.append(this.parent.getIndent() + "   ");
                    sb.append(vn.getCode());
                    if (!(vn.getVarDecl().getOccursAll() == 0 || vn.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                        sb.append(".at(j$j$j)");
                    }
                    sb.append(".set(obj.toString());");
                    sb.append(eol);
                } else {
                    sb.append(this.parent.getIndent());
                    if (j > 0 && j % this.MAX_LINES == 0) {
                        if (j > this.MAX_LINES) {
                            sb.append(" } }; ");
                        }
                        sb.append(" new Object() { { ");
                    }
                    vn = null;
                    if (!(obj instanceof Token)) {
                        vn = (VariableName)obj;
                        if (vn.getVarDecl().isVarying() || vn.getVarDecl().isLob() || vn.getVarDecl().isVarChar()) {
                            sb.append(vn.getVarDecl().getChildren().getLast().getUnivoqueName());
                            if (vn.hasIndexes()) {
                                sb.append(vn.getIndexes().getCode(vn.getVarDecl().isObjectReference(), vn.getVarDecl().getOccurs() > 0, vn.isEdited() && vn.isNumeric()));
                            }
                        } else {
                            sb.append(vn.getCode());
                            if (!(vn.getVarDecl().getOccursAll() == 0 || vn.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                                sb.append(".at(j$j$j)");
                            }
                        }
                    }
                    sb.append(".set(");
                    if (this.db2Esql && (this instanceof SqlFetch || this instanceof SqlSet)) {
                        if (vn.isNumeric()) {
                            sb.append("rs.getLong(" + (j + 1) + "));" + eol);
                        } else {
                            sb.append("rs.getString(" + (j + 1) + "));" + eol);
                        }
                    } else if (!this.db2Esql && (this instanceof SqlSelect || this instanceof SqlValue)) {
                        sb.append(vn.getSqljNameParam() + ");" + eol);
                    } else {
                        sb.append(vn.getSqljName() + ");" + eol);
                    }
                }
                if (parmInds.elementAt(i) != null && obj instanceof VariableName) {
                    if (obj instanceof VariableName) {
                        vd = ((VariableName)obj).getVarDecl();
                    }
                    if (vd != null) {
                        sb.append(this.parent.getIndent());
                        vn = (VariableName)obj;
                        VariableName vI = (VariableName)parmInds.elementAt(i);
                        if (vI.getVarDecl().isVarying() || vI.getVarDecl().isLob() || vI.getVarDecl().isVarChar()) {
                            sb.append(vI.getVarDecl().getChildren().getLast().getUnivoqueName());
                            if (vI.hasIndexes()) {
                                sb.append(vI.getIndexes().getCode(vI.getVarDecl().isObjectReference(), vI.getVarDecl().getOccurs() > 0, vI.isEdited() && vn.isNumeric()));
                            }
                        } else {
                            sb.append(vI.getCode());
                            if (!(vI.getVarDecl().getOccursAll() == 0 || vI.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                                sb.append(".at(j$j$j)");
                            }
                        }
                        sb.append(".set(");
                        if (!this.db2Esql && (this instanceof SqlSelect || this instanceof SqlValue)) {
                            sb.append(vI.getSqljNameParam());
                        } else {
                            sb.append(vI.getSqljName());
                        }
                        if (!(vI.getVarDecl().getOccursAll() == 0 || vI.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                            sb.append(".at(j$j$j)");
                        }
                        sb.append(");" + eol);
                    }
                }
                sb.append(this.parent.getIndent());
                sb.append("Esql.LOG_SQLJ(\"SQLJStat: bind " + vn.getVarDecl().getName() + "=\" +  " + vn.getVarDecl().getName().replace('-', Pcc.hyphenRepl) + ".toString());" + eol);
                --i;
                ++j;
            }
            if (this instanceof SqlSet || (this instanceof SqlSelect || this instanceof SqlValue) && this.db2Sqljbin && this.db2Esql) {
                sb.append(this.parent.getIndent());
                sb.append("rs.close();");
                sb.append(eol);
            }
            if (this.db2Esql && (this.db2Sqljbin || this instanceof SqlSet || this instanceof SqlFetch)) {
                sb.append(this.parent.getIndent());
                sb.append("}" + eol);
                sb.append(this.parent.getIndent());
                sb.append("catch (SQLException e) {" + eol);
                sb.append(this.parent.getIndent());
                sb.append("   fillSqlcaSqlj(e, " + this.sqlcapfx + this.pc.sqlca.SQLCA + ");" + eol);
                sb.append(this.parent.getIndent());
                sb.append("}" + eol);
            }
        }
    }

    void into(Vector bindVars, Vector bindInds) throws GeneralErrorException, EndOfProgramException {
        this.into(bindVars, bindInds, false);
    }

    void into(Vector bindVars, Vector bindInds, boolean returning) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        this.operFunc = null;
        this.saveFunc = null;
        while ((tk = this.getSqlToken()).getToknum() == 58) {
            VariableName intoInd;
            VariableName intoVar = this.getHostVariable(false, true);
            tk = this.getSqlToken();
            if (tk.getWord().equalsIgnoreCase("INDICATOR")) {
                tk = this.getSqlToken();
            }
            if (tk.getToknum() == 58) {
                intoInd = this.getHostVariable(true, true);
                if (intoInd == null) {
                    this.ungetAllSqlToken();
                } else if (!intoInd.getVarDecl().isNumeric() || intoInd.getVarDecl().isEdited()) {
                    throw new GeneralErrorException(23, 4, intoInd.name, intoInd.name.getWord(), this.error);
                }
                tk = this.getSqlToken();
            } else {
                intoInd = null;
            }
            if (this.isSqljStat && this.checkVars && (!this.db2Esql || this.db2Esql && !this.db2Sqljbin)) {
                if (!this.db2Esql && (this instanceof SqlSelect || this instanceof SqlValue)) {
                    this.addSqljHostVar(intoVar, intoInd, true, bindVars, bindInds);
                } else {
                    this.addSqljHostVar(intoVar, intoInd, false, bindVars, bindInds);
                }
                if (tk.getToknum() == 44) {
                    this.addToken(tk);
                }
            } else {
                VariableDeclarationList childrenVar = this.splitChildren(intoVar);
                if (childrenVar == null) {
                    bindVars.add(intoVar);
                    bindInds.add(intoInd);
                } else {
                    VariableDeclaration vd = childrenVar.getFirst();
                    while (vd != null) {
                        if (vd.redefines == null) {
                            bindVars.add(new VariableName(vd));
                            bindInds.add(intoInd);
                            vd.setUsed();
                        }
                        vd = childrenVar.getNext();
                    }
                }
            }
            if (intoInd != null) {
                intoInd.getVarDecl().setEsqlIndicator();
            }
            if (tk.getToknum() == 44) continue;
        }
        this.ungetAllSqlToken();
    }

    void attribute(Token tk) throws GeneralErrorException, EndOfProgramException {
        this.query.append(" ");
        while (true) {
            this.query.append(tk.getWord());
            tk = this.getSqlToken();
            if (tk.getToknum() != 10006) break;
            this.query.append(".");
            tk = this.getSqlToken();
        }
        this.ungetAllSqlToken();
    }

    void value(Token tk, Vector parmVars, Vector parmInds) throws GeneralErrorException, EndOfProgramException {
        this.value(tk, parmVars, parmInds, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void value(Token tk, Vector parmVars, Vector parmInds, boolean isInto) throws GeneralErrorException, EndOfProgramException {
        while (true) {
            switch (tk.getToknum()) {
                case 58: {
                    this.value(parmVars, parmInds, isInto);
                    break;
                }
                case 10017: {
                    if (this.isSqljStat) {
                        this.query.append(" " + this.getSqlDecimal(tk.getWord()));
                        break;
                    }
                    parmVars.add(tk);
                    this.query.append(" ?");
                    parmInds.add(null);
                    if (!(this instanceof SqlUpdate)) break;
                    SqlUpdate upd = (SqlUpdate)this;
                    upd.valCols.add(tk);
                    upd.valInds.add(null);
                    break;
                }
                case 40: {
                    if (this.isSqljStat) {
                        this.sqljSetLostWord = "";
                    }
                    this.addToken(tk);
                    tk = this.getSqlToken();
                    int par = 1;
                    if (tk.getWord().equalsIgnoreCase("SELECT")) {
                        do {
                            this.addToken(tk);
                            tk = this.getSqlToken();
                            if (tk.getToknum() == 41) {
                                --par;
                                continue;
                            }
                            if (tk.getToknum() == 40) {
                                ++par;
                                continue;
                            }
                            if (tk.getToknum() != 58) continue;
                            this.value(parmVars, parmInds, isInto);
                            tk = this.getSqlToken();
                            if (tk.getToknum() == 41) {
                                --par;
                                continue;
                            }
                            if (tk.getToknum() != 40) continue;
                            ++par;
                        } while (par != 0 && tk.getToknum() != 433);
                    } else {
                        do {
                            this.value(tk, parmVars, parmInds, isInto);
                            tk = this.getSqlToken();
                            if (tk.getToknum() != 44) continue;
                            this.addToken(tk);
                            tk = this.getSqlToken();
                        } while (tk.getToknum() != 41 && tk.getToknum() != 433 && !tk.getWord().equalsIgnoreCase("WHERE"));
                    }
                    if (tk.getToknum() != 433) {
                        this.addToken(tk);
                        break;
                    }
                    this.ungetAllSqlToken();
                    break;
                }
                case 10006: {
                    this.addToken(tk);
                    this.addToken(this.getSqlToken(), false);
                    break;
                }
                case 41: 
                case 44: 
                case 433: {
                    this.ungetAllSqlToken();
                    return;
                }
                default: {
                    SqlUpdate upd;
                    if (this instanceof SqlSet && !tk.isNull()) {
                        this.ungetAllSqlToken();
                        return;
                    }
                    if ("WHERE".equals(tk.getWord())) {
                        this.ungetAllSqlToken();
                        return;
                    }
                    if (this instanceof SqlUpdate && !tk.isNull()) {
                        if (this.db2Esql && (tk.getWord().equals("CURRENT") || tk.getWord().equals("ENCRYPTION") || tk.getWord().equals("SESSION") || tk.getWord().equals("SESSION_USER") || tk.getWord().equals("USER") || tk.getWord().equals("CURRENT_DATE") || tk.getWord().equals("CURRENT_PATH") || tk.getWord().equals("CURRENT_SCHEMA") || tk.getWord().equals("CURRENT_TIME") || tk.getWord().equals("CURRENT_TIMESTAMP"))) {
                            Token tok;
                            if (tk.getWord().equals("CURRENT")) {
                                this.addToken(tk);
                                tk = this.getSqlToken();
                            } else if (tk.getWord().startsWith("CURRENT")) {
                                String tokWord = tk.getWord().replace("-", "_");
                                tk = new Token(10001, "CURRENT", 0, 0, null);
                                this.addToken(tk);
                                tk = new Token(10001, tokWord.substring(tokWord.lastIndexOf("_") + 1), 0, 0, null);
                            } else {
                                this.addToken(tk);
                            }
                            if (db2Registers.containsKey(tk.getWord().toUpperCase())) {
                                upd = (SqlUpdate)this;
                                tok = new Token(10001, "##" + tk.getWord() + "##", 0, 0, null);
                                String[] regToken = (String[])db2Registers.get(tk.getWord());
                                String selVal = tok.getWord() + "=select current " + tk.getWord() + " ";
                                for (int i = 1; i < regToken.length && tk != null && tk.getToknum() != 433 && tk.getWord().equalsIgnoreCase("WHERE"); ++i) {
                                    boolean optional;
                                    String actWord = regToken[i];
                                    if (actWord.startsWith("@")) {
                                        optional = true;
                                        actWord = actWord.substring(1);
                                    } else {
                                        optional = false;
                                    }
                                    if (actWord.equalsIgnoreCase(tk.getWord())) {
                                        this.addToken(tk);
                                        selVal = tk.getWord() + " ";
                                        tk = this.getSqlToken();
                                        continue;
                                    }
                                    if (optional) continue;
                                    throw new GeneralErrorException(15, 4, tk, " DB2 REGISTER " + regToken[0], this.error);
                                }
                                selVal = selVal + " from sysibm.sysdummy1";
                                tok = new Token(10199, selVal, 0, 0, null);
                                upd.valCols.add(tok);
                                upd.valInds.add(null);
                            } else if (tk.getWord().equals("ENCRYPTION") || tk.getWord().equals("SESSION") || tk.getWord().equals("SESSION_USER") || tk.getWord().equals("USER")) {
                                upd = (SqlUpdate)this;
                                tok = new Token(10001, "##" + tk.getWord() + "##", 0, 0, null);
                                String selVal = tok.getWord() + "=select " + tk.getWord() + " ";
                                if (tk.getWord().equals("ENCRYPTION")) {
                                    tk = this.getSqlToken();
                                    if (!tk.getWord().equals("PASSWORD")) throw new GeneralErrorException(15, 4, tk, " DB2 REGISTER ENCRYPTION", this.error);
                                    selVal = selVal + " encryption password from sysibm.sysdummy1";
                                } else if (tk.getWord().equals("SESSION")) {
                                    tk = this.getSqlToken();
                                    if (!tk.getWord().equals("TIME")) throw new GeneralErrorException(15, 4, tk, " DB2 REGISTER SESSION", this.error);
                                    tk = this.getSqlToken();
                                    if (!tk.getWord().equals("ZONE")) throw new GeneralErrorException(15, 4, tk, " DB2 REGISTER SESSION", this.error);
                                    selVal = selVal + " session time zone from sysibm.sysdummy1";
                                } else if (tk.getWord().equals("SESSION_USER")) {
                                    selVal = selVal + " session_user from sysibm.sysdummy1";
                                } else if (tk.getWord().equals("USER")) {
                                    selVal = selVal + " user from sysibm.sysdummy1";
                                }
                                tok = new Token(10199, selVal, 0, 0, null);
                                upd.valCols.add(tok);
                                upd.valInds.add(null);
                            } else {
                                upd = (SqlUpdate)this;
                                upd.valCols.add(tk);
                                upd.valInds.add(null);
                            }
                        } else {
                            upd = (SqlUpdate)this;
                            upd.valCols.add(tk);
                            upd.valInds.add(null);
                        }
                    }
                    if (this.isSqljStat) {
                        this.sqljSetLostWord = " " + tk.getWord();
                    }
                    this.addToken(tk);
                }
            }
            tk = this.getSqlToken();
        }
    }

    void value(Vector parmVars, Vector parmInds) throws GeneralErrorException, EndOfProgramException {
        this.value(parmVars, parmInds, false);
    }

    void value(Vector parmVars, Vector parmInds, boolean isInto) throws GeneralErrorException, EndOfProgramException {
        this.value(parmVars, parmInds, false, false);
    }

    void value(Vector parmVars, Vector parmInds, boolean isInto, boolean groupNotAllowed) throws GeneralErrorException, EndOfProgramException {
        VariableName vnInd;
        VariableName vn = this.getHostVariable(false, isInto);
        Token tk = this.getSqlToken();
        if (tk.getWord().equalsIgnoreCase("INDICATOR")) {
            tk = this.getSqlToken();
        }
        if (tk.getToknum() == 58) {
            vnInd = this.getHostVariable(true, isInto);
            if (vnInd == null) {
                this.ungetAllSqlToken();
            } else if (!vnInd.getVarDecl().isNumeric() || vnInd.getVarDecl().isEdited()) {
                throw new GeneralErrorException(23, 4, vn.name, vn.name.getWord(), this.error);
            }
        } else {
            vnInd = null;
            this.ungetAllSqlToken();
        }
        if (this instanceof SqlCall) {
            tk = this.getSqlToken();
            String mode = tk.getWord();
            if ("IN".equals(mode) || "OUT".equals(mode) || "INOUT".equals(mode)) {
                vn.setSqlCallMode(mode);
            } else {
                this.ungetAllSqlToken();
            }
        }
        if (this.isSqljStat) {
            this.addSqljHostVar(vn, vnInd, !isInto, parmVars, parmInds);
        } else {
            VariableDeclarationList childrenVar = this.splitChildren(vn);
            if (childrenVar == null) {
                parmVars.add(vn);
                if (this.db2Esql) {
                    int vnLen = vn.getVarDecl().getLogicLen();
                    if (vnLen == 0 && vn.getVarDecl().value != null) {
                        vnLen = vn.getVarDecl().value.getWord().length() - 2;
                    }
                    if (vn.sqlTypeFunc == -1 || vn.sqlTypeCast || this.prevTok == null || this.prevTok.getWord().equalsIgnoreCase("CAST")) {
                        this.query.append(" ?");
                    } else if (vn.sqlTypeFunc == 93) {
                        if (vnLen > 10) {
                            this.query.append(" CAST(? AS TIMESTAMP)");
                        } else {
                            this.query.append(" CAST(? AS DATE)");
                        }
                    } else if (vn.sqlTypeFunc == 3 && !vn.isNumeric() && vnLen > 4) {
                        this.query.append(" CAST(? AS INT)");
                    } else if (vn.sqlTypeFunc == 91 && vn.getVarDecl().phisicLen == 7) {
                        this.query.append(" CAST(? AS VARCHAR(7))");
                    } else if (sqlTypesCast.get(vn.sqlTypeFunc).equals("VARCHAR")) {
                        this.query.append(" CAST(? AS VARCHAR(" + vn.getVarDecl().phisicLen + "))");
                    } else if (sqlTypesCast.get(vn.sqlTypeFunc).equals("CHAR")) {
                        this.query.append(" CAST(? AS CHAR(" + vn.getVarDecl().phisicLen + "))");
                    } else if (sqlTypesCast.get(vn.sqlTypeFunc).equals("DECIMAL")) {
                        this.query.append(" CAST(? AS DECIMAL(" + vn.getVarDecl().phisicLen + "," + vn.getVarDecl().getDecimals() + "))");
                    } else {
                        this.query.append(" CAST(? AS " + sqlTypesCast.get(vn.sqlTypeFunc) + ")");
                    }
                } else if (groupNotAllowed && vn.getVarDecl().isVarying() && this.pc.getOption("-xsqlrt") != null) {
                    if (this.lastWord != null) {
                        String s = this.lastWord + "=";
                        if (this.query.toString().endsWith(s)) {
                            this.query.replace(this.query.length() - s.length(), this.query.length(), "RTRIM(" + this.lastWord + ")=");
                        }
                    }
                    this.query.append(" RTRIM(?)");
                    parmVars.setElementAt(new VariableName(vn.getVarDecl().getChildren().getLast()), parmVars.size() - 1);
                } else {
                    this.query.append(" ?");
                }
                parmInds.add(vnInd);
                if (vnInd != null) {
                    vnInd.getVarDecl().setEsqlIndicator();
                }
                if (this instanceof SqlUpdate) {
                    SqlUpdate upd = (SqlUpdate)this;
                    upd.valCols.add(vn);
                    upd.valInds.add(vnInd);
                }
            } else {
                if (groupNotAllowed) {
                    throw new GeneralErrorException(273, 4, vn.getNameToken(), vn.getName(), this.error);
                }
                int i = 0;
                VariableDeclaration vd = childrenVar.getFirst();
                while (vd != null) {
                    if (vd.redefines == null) {
                        VariableName newVn = new VariableName(vd);
                        vd.setUsed();
                        newVn.setSqlCallMode(vn.getSqlCallMode());
                        parmVars.add(newVn);
                        if (i != 0) {
                            this.query.append(",");
                        }
                        this.query.append(" ?");
                        parmInds.add(vnInd);
                        if (vnInd != null) {
                            vnInd.getVarDecl().setEsqlIndicator();
                        }
                        if (this instanceof SqlUpdate) {
                            SqlUpdate upd = (SqlUpdate)this;
                            upd.valCols.add(new VariableName(vd));
                            upd.valInds.add(vnInd);
                        }
                    }
                    vd = childrenVar.getNext();
                    ++i;
                }
            }
        }
    }

    void getCodeGeneric(Pcc ppcc, StringBuffer Return2, String name, String prepStat, VariableName prepHndl, boolean exec, Vector bindVars, Vector bindInds, Vector parmVars, Vector parmInds) {
        this.getCodeGeneric(ppcc, Return2, name, prepStat, prepHndl, exec, bindVars, bindInds, parmVars, parmInds, 0);
    }

    void getCodeGeneric(Pcc ppcc, StringBuffer Return2, String name, String prepStat, VariableName prepHndl, boolean exec, Vector bindVars, Vector bindInds, Vector parmVars, Vector parmInds, int holdOption) {
        this.getCodeGeneric(ppcc, Return2, name, prepStat, prepHndl, exec, bindVars, bindInds, parmVars, parmInds, holdOption, false);
    }

    void getCodeGeneric(Pcc ppcc, StringBuffer Return2, String name, String prepStat, VariableName prepHndl, boolean exec, Vector bindVars, Vector bindInds, Vector parmVars, Vector parmInds, int holdOption, boolean currentOf) {
        this.getCodeGeneric(ppcc, Return2, name, prepStat, prepHndl, exec, bindVars, bindInds, parmVars, parmInds, holdOption, false, 0);
    }

    void getCodeGeneric(Pcc ppcc, StringBuffer Return2, String name, String prepStat, VariableName prepHndl, boolean exec, Vector bindVars, Vector bindInds, Vector parmVars, Vector parmInds, int holdOption, boolean currentOf, int cursorType) {
        this.getCodeGeneric(ppcc, Return2, name, prepStat, prepHndl, exec, bindVars, bindInds, parmVars, parmInds, holdOption, currentOf, cursorType, 0, null);
    }

    void getCodeGeneric(Pcc ppcc, StringBuffer Return2, String name, String prepStat, VariableName prepHndl, boolean exec, Vector bindVars, Vector bindInds, Vector parmVars, Vector parmInds, int holdOption, boolean currentOf, int cursorType, int withReturn, VariableName vn) {
        if (this.isSqljStat) {
            this.getSqljCodeGeneric(ppcc, Return2, name, prepStat, prepHndl, exec, bindVars, bindInds, parmVars, parmInds, holdOption, currentOf, cursorType, vn);
            return;
        }
        this.createVars(ppcc);
        this.createVars(ppcc);
        if (prepStat == null && prepHndl == null) {
            Return2.append(this.cursHndl.getCode());
            if (currentOf) {
                Return2.append(".set(Esql.DECLARE_UPDT(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ",");
            } else if (bindVars != null && this.tm.getOptionList().getOption("-csora") != null && (this instanceof SqlInsert || this instanceof SqlDelete || this instanceof SqlUpdate)) {
                Return2.append(".set(Esql.DECLARE_STMT_ORA(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ",");
            } else {
                Return2.append(".set(Esql.DECLARE_STMT(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ",");
            }
            if (name != null) {
                Return2.append("\"");
                Return2.append(name);
                Return2.append("\"");
            } else {
                Return2.append("null");
            }
            Return2.append(", null, \"");
            if (vn != null) {
                Return2.append(this.query + "\".replace(\"call?\", \"call \" + " + vn.getCode() + ".toString().trim())");
            } else {
                Return2.append(this.query + "\"");
            }
            Return2.append(", null, \"");
            Return2.append(holdOption);
            if (name != null) {
                Return2.append("\", " + this.getInstanceName(ppcc));
                if (currentOf) {
                    Return2.append("}));");
                } else {
                    Return2.append(", \"" + cursorType + "\"");
                    if (withReturn > 0) {
                        Return2.append(", Integer.valueOf(" + withReturn + ")");
                    }
                    Return2.append("}));");
                }
            } else if (currentOf) {
                Return2.append("\", null}));");
            } else {
                Return2.append("\", null, \"" + cursorType + "\"");
                if (withReturn > 0) {
                    Return2.append(", Integer.valueOf(" + withReturn + ")");
                }
                Return2.append("}));");
            }
            Return2.append(eol);
        } else {
            Return2.append(this.cursHndl.getCode());
            Return2.append(".set(Esql.DECLARE(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ",");
            if (name != null) {
                Return2.append("\"");
                Return2.append(name);
                Return2.append("\"");
            } else {
                Return2.append("null");
            }
            Return2.append(", null, ");
            if (prepHndl == null) {
                Return2.append("\"");
                Return2.append(prepStat);
                Return2.append("\"");
            } else {
                Return2.append(prepHndl.getCode());
            }
            Return2.append(", null, \"");
            Return2.append(holdOption);
            Return2.append("\", ");
            if (name != null) {
                Return2.append(this.getInstanceName(ppcc));
            } else {
                Return2.append("null");
            }
            if (withReturn > 0) {
                Return2.append(", Integer.valueOf(" + withReturn + ")");
            }
            Return2.append(" }));");
            Return2.append(eol);
        }
        if (exec || bindVars != null || parmVars != null) {
            if (parmVars != null) {
                this.setParams(Return2, parmVars, parmInds, false, bindVars);
            }
            if (bindVars != null) {
                this.bindCols(Return2, bindVars, bindInds, false);
            }
        }
        if (exec) {
            Return2.append(this.parent.getIndent());
            Return2.append(this.getReturnCode());
            if (bindVars != null && this.tm.getOptionList().getOption("-csora") != null && (this instanceof SqlInsert || this instanceof SqlDelete || this instanceof SqlUpdate)) {
                Return2.append(".set(Esql.EXECUTE_ORA(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ", ");
            } else {
                Return2.append(".set(Esql.EXECUTE(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ", ");
            }
            Return2.append(this.cursHndl.getCode());
            Return2.append("}));");
            Return2.append(eol);
        }
        this.addWhenever(Return2);
    }

    void getSqljCodeGeneric(Pcc ppcc, StringBuffer Return2, String name, String prepStat, VariableName prepHndl, boolean exec, Vector bindVars, Vector bindInds, Vector parmVars, Vector parmInds, int holdOption, boolean currentOf, int cursorType, VariableName vn) {
        this.setSqljParams(Return2, parmVars, parmInds);
        Return2.append(this.parent.getIndent());
        if ((this instanceof SqlSelect || this instanceof SqlValue || this instanceof SqlSet && this.db2Esql) && (bindVars == null || bindVars != null && bindVars.size() == 0)) {
            if (this instanceof SqlSelect) {
                if (this.pc.addIterDeclaration(((SqlSelect)this).getIterDecl())) {
                    this.pc.addResultSet(((SqlSelect)this).getIterDecl());
                }
            } else if (this instanceof SqlValue) {
                if (this.pc.addIterDeclaration(((SqlValue)this).getIterDecl())) {
                    this.pc.addResultSet(((SqlValue)this).getIterDecl());
                }
            } else if (this.pc.addIterDeclaration(((SqlSet)this).getIterDecl())) {
                this.pc.addResultSet(((SqlSet)this).getIterDecl());
            }
        }
        Return2.append(this.parent.getIndent());
        Return2.append("clearSqlca(" + this.sqlcapfx + this.pc.sqlca.SQLCA + ");" + eol);
        Return2.append(this.parent.getIndent());
        Return2.append("try {" + eol);
        Return2.append(this.parent.getIndent());
        Return2.append("if (automaticConnection && ctx" + this.pc.getClassName() + " == null)" + eol);
        Return2.append(this.parent.getIndent());
        Return2.append("   setSqljConnection();" + eol);
        Return2.append(this.parent.getIndent());
        if (this instanceof SqlSelect && (this.db2Sqljbin || bindVars == null || bindVars != null && bindVars.size() == 0)) {
            if (this.pc.iterDeclContains(((SqlSelect)this).getIterName().substring(1))) {
                Return2.append("#sql [ctx" + this.pc.getClassName() + "] " + ((SqlSelect)this).getIterName() + " = {" + this.query + "};" + eol);
            } else {
                Return2.append("#sql [ctx" + this.pc.getClassName() + "] {" + this.query + "};" + eol);
            }
        } else if (this instanceof SqlValue && (this.db2Sqljbin || bindVars == null || bindVars != null && bindVars.size() == 0)) {
            if (this.pc.iterDeclContains(((SqlValue)this).getIterName().substring(1))) {
                Return2.append("#sql [ctx" + this.pc.getClassName() + "] " + ((SqlValue)this).getIterName() + " = {" + this.query + "};" + eol);
            } else {
                Return2.append("#sql [ctx" + this.pc.getClassName() + "] {" + this.query + "};" + eol);
            }
        } else if (this instanceof SqlSet) {
            Return2.append("#sql [ctx" + this.pc.getClassName() + "] " + ((SqlSet)this).getIterName() + " = {" + this.query + "};" + eol);
        } else {
            Return2.append("#sql [ctx" + this.pc.getClassName() + "] {" + this.query + "};" + eol);
        }
        this.bindSqljVars(Return2, bindVars, bindInds);
        if (this instanceof SqlUpdate || this instanceof SqlDelete) {
            Return2.append(this.parent.getIndent());
            Return2.append(this.sqlcapfx + this.pc.sqlca.SQLERRD + ".at(3).set(ctx" + this.pc.getClassName() + ".getExecutionContext().getUpdateCount());");
            Return2.append(eol);
        }
        if (this instanceof SqlUpdate || this instanceof SqlInsert || this instanceof SqlDelete) {
            Return2.append(this.parent.getIndent());
            Return2.append("if (EsqlRuntime.noData != 0 && ctx" + this.pc.getClassName() + ".getExecutionContext().getUpdateCount() == 0)");
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
            Return2.append("   throw new SQLException(\"IsCOBOLNoData\");");
            Return2.append(eol);
        }
        Return2.append(this.parent.getIndent());
        Return2.append("}" + eol);
        Return2.append(this.parent.getIndent());
        Return2.append("catch (SQLException e) {" + eol);
        Return2.append(this.parent.getIndent());
        Return2.append("   fillSqlcaSqlj(e, " + this.sqlcapfx + this.pc.sqlca.SQLCA + ");" + eol);
        Return2.append(this.parent.getIndent());
        Return2.append("}" + eol);
        Return2.append(this.parent.getIndent());
        Return2.append("Esql.LOG_SQLJ(\"SQLJStat:" + this.query + " SQLCODE=\" + " + this.sqlcapfx + this.pc.sqlca.SQLCODE + ".toString() + \" SQLERRMC=\" + " + this.sqlcapfx + this.pc.sqlca.SQLERRMC + ".toString());" + eol);
        this.addWhenever(Return2);
    }

    public String getQuery() {
        return this.query.toString();
    }

    public Vector getParmVars() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Vector getParmInds() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public VariableName getCursorHandle() {
        return this.cursHndl;
    }

    protected String getBindIndCode() {
        return this.getCodeLiteral(bindInd);
    }

    public SqlWhenever getWhenError() {
        return this.whenError;
    }

    public SqlWhenever getWhenWarn() {
        return this.whenWarn;
    }

    public SqlWhenever getWhenNotFound() {
        return this.whenNotFound;
    }

    public String getSqlDecimal(String word) {
        int comma;
        if (this.tm.getDecimalPoint() == ',' && (comma = word.indexOf(44)) >= 0) {
            return word.substring(0, comma) + "." + word.substring(comma + 1);
        }
        return word;
    }

    void startForClause(StringBuffer sb) {
        if (this.forVal != 0) {
            sb.append(this.parent.getIndent() + this.sqlcapfx + this.pc.sqlca.SQLERRD + ".atNC (3 ).set(0);" + eol);
            sb.append(this.parent.getIndent() + "for (int j$j$j = 1; j$j$j <= " + this.forVal + "; j$j$j++) {" + eol);
            ++this.parent.nesting;
        } else if (this.forVar != null) {
            sb.append(this.parent.getIndent() + this.sqlcapfx + this.pc.sqlca.SQLERRD + ".atNC (3 ).set(0);" + eol);
            sb.append(this.parent.getIndent() + "for (int j$j$j = 1; j$j$j <= " + this.forVar.getVarDecl().getUnivoqueName() + ".toint(); j$j$j++) {" + eol);
            ++this.parent.nesting;
        }
    }

    void endForClause(StringBuffer sb) {
        this.endForClause(sb, false);
    }

    void endForClause(StringBuffer sb, boolean isFetch) {
        Object Return2 = null;
        if (this.forVar != null || this.forVal != 0) {
            if (isFetch) {
                sb.append(this.parent.getIndent() + "if (" + this.sqlcapfx + this.pc.sqlca.SQLCODE + ".toint() != 0)" + eol);
                sb.append(this.parent.getIndent() + "   break;" + eol);
            } else {
                sb.append(this.parent.getIndent() + "if (" + this.sqlcapfx + this.pc.sqlca.SQLCODE + ".toint() == 0)" + eol);
                sb.append(this.parent.getIndent() + "   " + this.sqlcapfx + this.pc.sqlca.SQLERRD + ".atNC (3 ).set(j$j$j);" + eol);
                sb.append(this.parent.getIndent() + "else {" + eol);
                sb.append(this.parent.getIndent() + "   " + this.sqlcapfx + this.pc.sqlca.SQLERRD + ".atNC (3 ).set(j$j$j - 1);" + eol);
                sb.append(this.parent.getIndent() + "   break;" + eol);
                sb.append(this.parent.getIndent() + "}" + eol);
            }
            --this.parent.nesting;
            sb.append(this.parent.getIndent() + "}" + eol);
        }
    }

    void returningClause(Vector parmVars, Vector parmInds, Vector bindVars, Vector bindInds) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        this.addToQuery(" RETURNING");
        while ((tk = this.getSqlToken()).getToknum() != 433 && tk.getToknum() != 543) {
            if (tk.getToknum() == 58) {
                VariableName vn = this.getHostVariable();
                if (parmVars == null) {
                    parmVars = new Vector<VariableName>();
                    parmInds = new Vector<Object>();
                }
                parmVars.add(vn);
                parmInds.add(null);
                this.addToken(new Token(63, " ?", 0, 0, null));
                continue;
            }
            this.addToken(tk);
        }
        if (tk.getToknum() == 543) {
            if (this.tm.getOptionList().getOption("-csora") != null) {
                this.addToken(tk);
            }
            this.into(bindVars, bindInds);
            if (this.tm.getOptionList().getOption("-csora") != null) {
                for (int i = 0; i < bindVars.size(); ++i) {
                    if (i > 0) {
                        this.addToQuery(",");
                    }
                    this.addToQuery(" ?");
                }
            }
        } else {
            throw new GeneralErrorException(15, 4, tk, tk.getWord(), this.error);
        }
    }

    public void fillParmInds(Vector parmInds, Vector parmVars) throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        int internalNumInd = 0;
        for (int i = 0; i < parmInds.size(); ++i) {
            if (parmInds.elementAt(i) != null) continue;
            VariableDeclaration vd = null;
            Object obj = parmVars.elementAt(i);
            if (obj instanceof VariableName) {
                vd = ((VariableName)obj).getVarDecl();
            } else if (((Token)obj).getToknum() == 10009) {
                vd = this.pc.getAllVariables().get(((Token)obj).getWord()).getFirst();
            }
            if (vd == null || !vd.isNumeric()) continue;
            VariableName vn = new VariableName(new Token(10009, "$$IND$$_" + internalNumInd++, tk.getFLN(), tk.getOffset(), tk.getFileName()));
            if (internalNumInd > this.pc.indCount) {
                vd = VariableDeclaration.getIndicator(this.pc, vn, this.tm, this.error);
                this.pc.fixedVars.addItem(vd);
                this.pc.loadVariable(vd);
                vd.setUsed();
                ++this.pc.indCount;
            }
            vn.setVarDecl(vd);
            parmInds.setElementAt(vn, i);
            vn.check(this.pc);
        }
        this.ungetSqlToken();
    }

    protected String getInstanceName() {
        return this.getInstanceName(this.pc);
    }

    protected String getInstanceName(Pcc pc) {
        if (pc.isFactory()) {
            return pc.getClassName() + ".class";
        }
        if (pc.isDefault()) {
            return "$This$";
        }
        return pc.getClassName() + ".this";
    }

    public void addTokenQuestionMark(VariableName vn) {
        this.addTokenQuestionMark(vn, false);
    }

    public void addTokenQuestionMark(VariableName vn, boolean param) {
        if (this.db2Esql) {
            int vnLen = vn.getVarDecl().getLogicLen();
            if (vnLen == 0 && vn.getVarDecl().value != null) {
                vnLen = vn.getVarDecl().value.getWord().length() - 2;
            }
            if (vn.sqlTypeFunc == -1 || vn.sqlTypeCast || this.prevRealTok == null || this.prevRealTok.getWord().equalsIgnoreCase("CAST")) {
                if (this instanceof SqlSelect && ((SqlSelect)this).isBeforeFromInto() && !((SqlSelect)this).isNextTokFun() && (this.prevRealTok == null || !this.prevRealTok.getWord().equalsIgnoreCase("CAST"))) {
                    if (this.isSqljStat) {
                        if (param) {
                            this.addToken(new Token(10009, " CAST( :" + vn.getSqljNameParam() + " AS VARCHAR(" + vn.getVarDecl().phisicLen + "))", 0, 0, null));
                        } else {
                            this.addToken(new Token(10009, " CAST( :" + vn.getSqljName() + " AS VARCHAR(" + vn.getVarDecl().phisicLen + "))", 0, 0, null));
                        }
                    } else {
                        this.addToken(new Token(10009, " CAST(? AS VARCHAR(" + vn.getVarDecl().phisicLen + "))", 0, 0, null));
                    }
                } else if (this.isSqljStat) {
                    if (param) {
                        this.addToken(new Token(10009, " :" + vn.getSqljNameParam(), 0, 0, null));
                    } else {
                        this.addToken(new Token(10009, " :" + vn.getSqljName(), 0, 0, null));
                    }
                } else {
                    this.addToken(new Token(63, " ?", 0, 0, null));
                }
            } else if (vn.sqlTypeFunc == 93) {
                this.addToken(new Token(10009, " CAST(", 0, 0, null));
                if (this.isSqljStat) {
                    if (param) {
                        this.addToken(new Token(10009, " :" + vn.getSqljNameParam(), 0, 0, null));
                    } else {
                        this.addToken(new Token(10009, " :" + vn.getSqljName(), 0, 0, null));
                    }
                } else {
                    this.addToken(new Token(63, " ?", 0, 0, null));
                }
                if (vnLen > 10) {
                    this.addToken(new Token(10009, " AS TIMESTAMP)", 0, 0, null));
                } else {
                    this.addToken(new Token(10009, " AS DATE)", 0, 0, null));
                }
            } else if (vn.sqlTypeFunc == 3 && !vn.isNumeric() && vnLen > 4) {
                this.addToken(new Token(10009, " CAST(", 0, 0, null));
                if (this.isSqljStat) {
                    if (param) {
                        this.addToken(new Token(10009, " :" + vn.getSqljNameParam(), 0, 0, null));
                    } else {
                        this.addToken(new Token(10009, " :" + vn.getSqljName(), 0, 0, null));
                    }
                } else {
                    this.addToken(new Token(63, " ?", 0, 0, null));
                }
                this.addToken(new Token(10009, " AS INT)", 0, 0, null));
            } else if (vn.sqlTypeFunc != -1) {
                this.addToken(new Token(10009, " CAST(", 0, 0, null));
                if (this.isSqljStat) {
                    if (param) {
                        this.addToken(new Token(10009, " :" + vn.getSqljNameParam(), 0, 0, null));
                    } else {
                        this.addToken(new Token(10009, " :" + vn.getSqljName(), 0, 0, null));
                    }
                } else {
                    this.addToken(new Token(63, " ?", 0, 0, null));
                }
                if (vn.sqlTypeFunc == 91 && vn.getVarDecl().phisicLen == 7) {
                    this.addToken(new Token(10009, " AS VARCHAR(7))", 0, 0, null));
                } else if (sqlTypesCast.get(vn.sqlTypeFunc).equals("VARCHAR") || sqlTypesCast.get(vn.sqlTypeFunc).equals("CHAR")) {
                    this.addToken(new Token(10009, " AS " + sqlTypesCast.get(vn.sqlTypeFunc) + "(" + vn.getVarDecl().phisicLen + "))", 0, 0, null));
                } else if (sqlTypesCast.get(vn.sqlTypeFunc).equals("DECIMAL")) {
                    this.addToken(new Token(10009, " AS " + sqlTypesCast.get(vn.sqlTypeFunc) + "(" + vn.getVarDecl().phisicLen + "," + vn.getVarDecl().getDecimals() + "))", 0, 0, null));
                } else {
                    this.addToken(new Token(10009, " AS " + sqlTypesCast.get(vn.sqlTypeFunc) + ")", 0, 0, null));
                }
            } else if (this instanceof SqlSelect && ((SqlSelect)this).isBeforeFromInto() && !((SqlSelect)this).isNextTokFun()) {
                if (this.isSqljStat) {
                    this.addToken(new Token(10009, " CAST(? AS VARCHAR" + vn.getVarDecl().phisicLen + "))", 0, 0, null));
                } else if (this.isSqljStat) {
                    if (param) {
                        this.addToken(new Token(10009, " :" + vn.getSqljNameParam(), 0, 0, null));
                    } else {
                        this.addToken(new Token(10009, " :" + vn.getSqljName(), 0, 0, null));
                    }
                } else {
                    this.addToken(new Token(63, " ?", 0, 0, null));
                }
            }
        } else if (this.isSqljStat) {
            if (param) {
                this.addToken(new Token(10009, " :" + vn.getSqljNameParam(), 0, 0, null));
            } else {
                this.addToken(new Token(10009, " :" + vn.getSqljName(), 0, 0, null));
            }
        } else {
            this.addToken(new Token(63, " ?", 0, 0, null));
        }
    }

    public boolean isTypeCast(Token tk) {
        return sqlTypesCast.contains(tk.getWord().toUpperCase()) || tk.getWord().toUpperCase().equals("DAYS") || tk.getWord().toUpperCase().equals("DAY") || tk.getWord().toUpperCase().equals("MINUTE") || tk.getWord().toUpperCase().equals("MINUTES") || tk.getWord().toUpperCase().equals("SECOND") || tk.getWord().toUpperCase().equals("SECONDS") || tk.getWord().toUpperCase().equals("HOUR") || tk.getWord().toUpperCase().equals("YEARS") || tk.getWord().toUpperCase().equals("YEAR") || tk.getWord().toUpperCase().equals("MONTH");
    }

    public void setIteratotName(Token kw) {
        String str = kw.getFileName().replace("\\", "/").replace(":", "");
        if (str.contains("/")) {
            str = str.substring(str.lastIndexOf("/") + 1);
        }
        this.iterator = this.iterator + str.replace(".", "_").replace("/", "_").replace("/", "_").replace("-", "_") + kw.getFLN();
    }

    public void setSqlcaprfx() {
        this.sqlcapfx = this.pc.getSqlcaCobolClassPrefix();
    }
}

