/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.interfaces.compiler.ISubscript;

public class Subscript
implements CobolToken,
ErrorsNumbers,
ISubscript {
    private Expression expIdx;
    private boolean all;
    char operator;
    private String index;

    public static Subscript get(TokenManager tm, Errors err, Pcc pc, Token tk) throws EndOfProgramException, GeneralErrorException {
        Subscript Return2 = Subscript.get(tm, err, pc);
        return Return2;
    }

    public static Subscript get(TokenManager tm, Errors err, Pcc pc) throws EndOfProgramException, GeneralErrorException {
        Subscript Return2 = new Subscript();
        Return2.expIdx = new Expression(new int[]{0}, null, null, pc, tm, err);
        if (Return2.expIdx.isVoid()) {
            Return2 = null;
        }
        return Return2;
    }

    public static Subscript getWithAll(TokenManager tm, Errors err, Pcc pc) throws EndOfProgramException, GeneralErrorException {
        Subscript Return2;
        if (tm.getToken(false).getToknum() == 262) {
            Return2 = new Subscript();
            Return2.all = true;
        } else {
            tm.ungetToken();
            Return2 = Subscript.get(tm, err, pc);
        }
        return Return2;
    }

    static Subscript get(String index) {
        Subscript Return2 = new Subscript();
        Return2.index = index;
        return Return2;
    }

    void check(Token tk, Errors err, Pcc pc) throws GeneralErrorException {
        if (!this.all && this.index == null) {
            if (!this.expIdx.isNumeric() && !this.expIdx.isPrimitiveInteger()) {
                throw new GeneralErrorException(49, 4, tk, this.expIdx.toString(), err);
            }
            tk = this.expIdx.getAsToken();
            if (tk != null && tk.getToknum() != 10002) {
                throw new GeneralErrorException(22, 4, tk, tk.getWord(), err);
            }
        }
    }

    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        if (this.all) {
            Return2.append('0');
        } else {
            if (this.index != null) {
                return this.index;
            }
            Token tk = this.expIdx.getAsToken();
            if (tk != null && tk.getToknum() == 10002) {
                Return2.append(tk.getAsInt());
            } else {
                boolean ni = this.expIdx.couldBeNativeInt();
                if (ni) {
                    Return2.append("(int) ");
                    Return2.append(this.expIdx.getCode(true));
                } else {
                    Return2.append(this.expIdx.getCode(false));
                    Return2.append(".intValue()");
                }
            }
        }
        return Return2.toString();
    }

    @Override
    public Expression getExpression() {
        return this.expIdx;
    }

    public String getIndex() {
        return this.index;
    }

    @Override
    public boolean isLiteral() {
        if (this.all) {
            return false;
        }
        return this.index != null || this.expIdx.getAsToken() != null;
    }

    @Override
    public boolean isAll() {
        return this.all;
    }
}

