/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.LabelName;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.StringList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Use
extends Verb
implements CobolToken,
ErrorsNumbers {
    boolean global;
    TokenList typeTok = new TokenList();
    StringList typeVar = new StringList();
    Paragraph parag;
    private LabelName debuggingParagraph;
    private boolean debuggingAllProcedures;

    public Use(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.parag = this.parent.parent;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 503) {
            this.global = true;
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 299) {
            this.rwUse();
            return;
        }
        if (tk.getToknum() == 284 || tk.getToknum() == 654) {
            this.prgUse(tk);
            return;
        }
        if (tk.getToknum() == 495) {
            if (this.pc.getOption("-cv") == null) {
                throw new UnexpectedTokenException(tk, this.error);
            }
            this.forUse(this.tm.getToken());
            return;
        }
        if (tk.getWord().equals("DEBUGGING")) {
            if (this.pc.getOption("-cv") == null) {
                throw new UnexpectedTokenException(tk, this.error);
            }
            this.forUse(tk);
            return;
        }
        if (tk.getToknum() == 261) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 740) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() != 473 && tk.getToknum() != 466) {
            throw new ExpectedFoundException(tk, this.error, "ERROR/EXCEPTION");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 652) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 614) {
            tk = this.tm.getToken();
        }
        boolean goOn = true;
        block8: while (goOn) {
            switch (tk.getToknum()) {
                case 535: {
                    if (this.pc.declInput != null) {
                        throw new GeneralErrorException(65, 4, this.keyWord, "INPUT", this.error);
                    }
                    this.pc.declInput = this.parag.getName();
                    this.typeTok.addItem(tk);
                    tk = this.tm.getToken();
                    continue block8;
                }
                case 624: {
                    if (this.pc.declOutput != null) {
                        throw new GeneralErrorException(65, 4, this.keyWord, "OUTPUT", this.error);
                    }
                    this.pc.declOutput = this.parag.getName();
                    this.typeTok.addItem(tk);
                    tk = this.tm.getToken();
                    continue block8;
                }
                case 519: {
                    if (this.pc.declIO != null) {
                        throw new GeneralErrorException(65, 4, this.keyWord, "I-O", this.error);
                    }
                    this.pc.declIO = this.parag.getName();
                    this.typeTok.addItem(tk);
                    tk = this.tm.getToken();
                    continue block8;
                }
                case 478: {
                    if (this.pc.declExtend != null) {
                        throw new GeneralErrorException(65, 4, this.keyWord, "EXTEND", this.error);
                    }
                    this.pc.declExtend = this.parag.getName();
                    this.typeTok.addItem(tk);
                    tk = this.tm.getToken();
                    continue block8;
                }
                case 778: {
                    if (this.pc.declTransaction != null) {
                        throw new GeneralErrorException(65, 4, this.keyWord, "TRANSACTION", this.error);
                    }
                    this.pc.declTransaction = this.parag.getName();
                    this.typeTok.addItem(tk);
                    tk = this.tm.getToken();
                    continue block8;
                }
                case 10009: {
                    Select sel = this.pc.getSelect(tk.getWord());
                    if (sel == null) {
                        throw new GeneralErrorException(53, 4, this.keyWord, tk.getWord(), this.error);
                    }
                    if (this.pc.getDeclarative(sel) != null) {
                        throw new GeneralErrorException(65, 4, this.keyWord, this.pc.getDeclarative(sel), this.error);
                    }
                    this.pc.putDeclarative(sel, this.parag.getName());
                    this.typeVar.addItem(tk.getWord());
                    tk = this.tm.getToken();
                    if (this.pc.getOption("-cv") == null || tk.getToknum() != 506) continue block8;
                    sel.useGiving = VariableName.get(this.tm, this.error, this.pc);
                    if (sel.useGiving == null) {
                        tk = this.tm.getToken();
                        throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
                    }
                    tk = this.tm.getToken();
                    continue block8;
                }
            }
            this.tm.ungetToken();
            goOn = false;
        }
        if (this.typeVar.getItemNum() + this.typeTok.getItemNum() == 0) {
            throw new UnexpectedTokenException(tk, this.error);
        }
        if (!this.parag.isSection || this.parent.verbs.getItemNum() > 0) {
            throw new GeneralErrorException(64, 4, this.keyWord, "", this.error);
        }
    }

    private void rwUse() throws GeneralErrorException, EndOfProgramException {
        ReportGroup rg = null;
        Token tk = this.tm.getToken();
        if (!tk.getWord().equals("REPORTING")) {
            throw new ExpectedFoundException(tk, this.error, "REPORTING");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        Token name = tk;
        tk = this.tm.getToken();
        if (tk.getToknum() == 610 || tk.getToknum() == 527) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            ReportDescriptor rd = this.pc.getReport(tk);
            if (rd == null) {
                throw new GeneralErrorException(181, 4, tk, tk.getWord(), this.error);
            }
            rg = rd.getReportGroup(name);
            if (rg == null) {
                throw new GeneralErrorException(181, 4, name, name.getWord(), this.error);
            }
        } else {
            this.tm.ungetToken();
            ReportDescriptor rd = this.pc.getReport(name);
            if (rd == null) {
                rg = this.pc.getReportGroup(name);
                if (rg == null) {
                    throw new GeneralErrorException(181, 4, name, name.getWord(), this.error);
                }
                rd = rg.rd;
            }
        }
        if (rg != null) {
            if (rg.use != null) {
                throw new GeneralErrorException(65, 4, this.keyWord, "REPORTING", this.error);
            }
            rg.use = this;
        }
    }

    private void prgUse(Token tk) throws GeneralErrorException, EndOfProgramException {
        if (!(this.pc instanceof CobolProgram)) {
            throw new GeneralErrorException(209, 4, this.keyWord, "USE PROGRAM", this.error);
        }
        CobolProgram cp = (CobolProgram)this.pc;
        if (tk.getToknum() == 284) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() != 654) {
            throw new ExpectedFoundException(tk, this.error, "PROGRAM");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 742) {
            if (!cp.setAtProgramStart(this)) {
                throw new GeneralErrorException(65, 4, this.keyWord, "PROGRAM START", this.error);
            }
        } else if (tk.getToknum() == 423) {
            if (!cp.setAtProgramEnd(this)) {
                throw new GeneralErrorException(65, 4, this.keyWord, "PROGRAM END", this.error);
            }
        } else {
            throw new ExpectedFoundException(tk, this.error, "START|END");
        }
        if (!this.parag.isSection || this.parent.verbs.getItemNum() > 0) {
            throw new GeneralErrorException(64, 4, this.keyWord, "", this.error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void forUse(Token tk) throws GeneralErrorException, EndOfProgramException {
        if (!tk.getWord().equals("DEBUGGING")) throw new ExpectedFoundException(tk, this.error, "DEBUGGING");
        tk = this.tm.getToken();
        if (tk.getToknum() == 614) {
            tk = this.tm.getToken();
        }
        if (tk.isAll()) {
            if (!tk.getWord().equals("PROCEDURES")) throw new ExpectedFoundException(tk, this.error, "PROCEDURES");
            this.debuggingAllProcedures = true;
        } else {
            if (tk.getToknum() != 10009) throw new ExpectedFoundException(tk, this.error, "ALL|PARAGRAPH NAME");
            this.tm.ungetToken();
            this.debuggingParagraph = LabelName.get(null, this.tm, this.error, this.pc);
        }
        if (this.parag.isSection && this.parent.verbs.getItemNum() <= 0) return;
        throw new GeneralErrorException(64, 4, this.keyWord, "", this.error);
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.debuggingAllProcedures) {
            if (!this.pc.addUseForDebugging(this.parag, Integer.MAX_VALUE)) {
                throw new GeneralErrorException(65, 4, this.keyWord, "", this.error);
            }
        } else if (this.debuggingParagraph != null) {
            int[] num = new int[2];
            String s = Perform.check(this.debuggingParagraph, null, num, false, false, this.pc);
            if ("declaratives".equals(s)) {
                num[0] = -num[0];
            }
            if (!this.pc.addUseForDebugging(this.parag, num[0])) {
                throw new GeneralErrorException(65, 4, this.keyWord, "", this.error);
            }
        }
    }

    @Override
    public String getCode() {
        return "";
    }

    static void putDeclaratives(StringBuffer buf, Pcc pc, Select sel, String indent, boolean hasDecl) {
        Use.putDeclaratives(buf, pc, sel, indent, sel.getName() + ".getOpenMode()", hasDecl);
    }

    static void putFileStatus(StringBuffer buf, Select sel, String indent) {
        if (sel.getFileStatus() != null) {
            buf.append(eol);
            buf.append(indent);
            buf.append(sel.getFileStatus().getCode());
            buf.append(".set (");
            buf.append(sel.getName());
            buf.append(".getFileStatus());");
        }
    }

    static void putDeclaratives(StringBuffer buf, Pcc pc, Select sel, String indent, String openMode, boolean hasDecl) {
        boolean hasFileStatus = sel.getFileStatus() != null;
        buf.append(eol);
        buf.append(indent);
        buf.append("} catch (CobolIOException dex$) {");
        Use.putFileStatus(buf, sel, indent);
        buf.append(eol);
        buf.append(indent);
        if (hasDecl) {
            if (pc.getDeclarative(sel) != null) {
                if (sel.useGiving != null) {
                    buf.append(sel.useGiving.getCode());
                    buf.append(".set (Functions.vsUseGiving(dex$.getErrNum()));");
                    buf.append(eol);
                    buf.append(indent);
                }
                Paragraph p = pc.getDeclParagraph(pc.getDeclarative(sel), null);
                int startNum = p.getIdNumber();
                p = p.getLastParagraphInSameSection();
                int endNum = p.getIdNumber();
                buf.append("declaratives (");
                buf.append(startNum);
                buf.append(",");
                buf.append(endNum);
                buf.append(");");
            } else {
                int endNum;
                int startNum;
                Paragraph p;
                buf.append("switch (");
                buf.append(openMode);
                buf.append(") {");
                if (pc.declInput != null) {
                    p = pc.getDeclParagraph(pc.declInput, null);
                    startNum = p.getIdNumber();
                    p = p.getLastParagraphInSameSection();
                    endNum = p.getIdNumber();
                    buf.append(eol);
                    buf.append(indent);
                    buf.append("case CobolFile.OPEN_INPUT: declaratives (");
                    buf.append(startNum);
                    buf.append(",");
                    buf.append(endNum);
                    buf.append("); break;");
                }
                if (pc.declOutput != null) {
                    p = pc.getDeclParagraph(pc.declOutput, null);
                    startNum = p.getIdNumber();
                    p = p.getLastParagraphInSameSection();
                    endNum = p.getIdNumber();
                    buf.append(eol);
                    buf.append(indent);
                    buf.append("case CobolFile.OPEN_OUTPUT: declaratives (");
                    buf.append(startNum);
                    buf.append(",");
                    buf.append(endNum);
                    buf.append("); break;");
                }
                if (pc.declIO != null) {
                    p = pc.getDeclParagraph(pc.declIO, null);
                    startNum = p.getIdNumber();
                    p = p.getLastParagraphInSameSection();
                    endNum = p.getIdNumber();
                    buf.append(eol);
                    buf.append(indent);
                    buf.append("case CobolFile.OPEN_IO: declaratives (");
                    buf.append(startNum);
                    buf.append(",");
                    buf.append(endNum);
                    buf.append("); break;");
                }
                if (pc.declExtend != null) {
                    p = pc.getDeclParagraph(pc.declExtend, null);
                    startNum = p.getIdNumber();
                    p = p.getLastParagraphInSameSection();
                    endNum = p.getIdNumber();
                    buf.append(eol);
                    buf.append(indent);
                    buf.append("case CobolFile.OPEN_EXTEND: declaratives (");
                    buf.append(startNum);
                    buf.append(",");
                    buf.append(endNum);
                    buf.append("); break;");
                    buf.append(eol);
                    buf.append(indent);
                }
                buf.append(eol);
                buf.append(indent);
                buf.append("default: if (!CobolIOException.isErrorsOk(");
                buf.append(hasFileStatus);
                buf.append(")) throw new CobolIOException(dex$);");
                buf.append(eol);
                buf.append(indent);
                buf.append("}");
            }
        } else {
            buf.append(eol);
            buf.append(indent);
            buf.append("if (!CobolIOException.isErrorsOk(");
            buf.append(hasFileStatus);
            buf.append(")) throw new CobolIOException(dex$);");
        }
        buf.append(eol);
        buf.append(indent);
        buf.append("}");
        buf.append(eol);
    }

    static void putDeclTransaction(StringBuffer buf, Pcc pc, String indent) {
        buf.append(indent);
        buf.append(Verb.getLocalVar("TRANSACTION-STATUS", pc.capitalizeNames) + ".set (\"00\");");
        buf.append(eol);
        buf.append(indent);
        buf.append("} catch (TransactionException dex$) {");
        buf.append(eol);
        buf.append(indent);
        buf.append(Verb.getLocalVar("TRANSACTION-STATUS", pc.capitalizeNames) + ".set (dex$.getTransactionStatus());");
        buf.append(eol);
        buf.append(indent);
        if (pc.declTransaction != null) {
            Paragraph p = pc.getDeclParagraph(pc.declTransaction, null);
            int startNum = p.getIdNumber();
            p = p.getLastParagraphInSameSection();
            int endNum = p.getIdNumber();
            buf.append(eol);
            buf.append(indent);
            buf.append("declaratives (");
            buf.append(startNum);
            buf.append(",");
            buf.append(endNum);
            buf.append(");");
            buf.append(eol);
            buf.append(indent);
        } else {
            buf.append(eol);
            buf.append(indent);
            buf.append("if (!CobolIOException.isErrorsOk(true)) throw new CobolIOException(dex$);");
        }
        buf.append(eol);
        buf.append(indent);
        buf.append("}");
        buf.append(eol);
    }

    public Paragraph getParagraph() {
        return this.parag;
    }
}

