/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.bincode;

import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.bincode.AbstractJavaCompiler;
import com.iscobol.compiler.bincode.Callable;
import com.iscobol.compiler.remote.server.RemoteCompilerClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExternalJavaCompiler
extends AbstractJavaCompiler {
    private final List options;

    public ExternalJavaCompiler(OptionList ol, String javac) {
        super(ol);
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(javac);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl instanceof RemoteCompilerClassLoader) {
            StringBuffer classPath = new StringBuffer();
            String cp = System.getProperty("java.class.path");
            if (cp != null && cp.length() > 0) {
                classPath.append(cp);
            }
            for (File f : ((RemoteCompilerClassLoader)cl).getPaths()) {
                if (classPath.length() > 0) {
                    classPath.append(File.pathSeparator);
                }
                classPath.append(f.getPath());
            }
            cmdLine.add("-classpath");
            cmdLine.add(classPath.toString());
        }
        this.addCompilerOptions(cmdLine);
        this.options = Collections.unmodifiableList(cmdLine);
    }

    @Override
    protected Callable getCompilationTaskImpl(String[] sourceUnits) {
        return () -> {
            ArrayList<String> cmdLineList = new ArrayList<String>();
            cmdLineList.addAll(this.options);
            this.addSourcePathOption(cmdLineList, sourceUnits);
            for (String sourceUnit : sourceUnits) {
                cmdLineList.add(sourceUnit);
            }
            String[] cmdLine = cmdLineList.toArray(new String[0]);
            Process p = Runtime.getRuntime().exec(cmdLine);
            new StreamDrainer(p.getInputStream(), System.out).start();
            new StreamDrainer(p.getErrorStream(), System.err).start();
            int ret = p.waitFor();
            return new Integer(ret);
        };
    }

    private static class StreamDrainer
    extends Thread {
        private final InputStream input;
        private final PrintStream output;

        public StreamDrainer(InputStream input, PrintStream output) {
            this.input = input;
            this.output = output;
        }

        @Override
        public void run() {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.input));
            try {
                String s;
                while ((s = in.readLine()) != null) {
                    this.output.println(s);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

