/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.interfaces.debugger.IDebugInfoExtension2;
import com.iscobol.interfaces.debugger.IDebugResponseExtension2;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;

public class DebugResponse
implements IDebugResponseExtension2,
DataExternalizable {
    private static final long serialVersionUID = 1000007L;
    public static final int NO_INFO = 0;
    public static final int FILENAMES_INFO = 1;
    public static final int LINES_INFO = 2;
    public static final int PARAGRAPH_INFO = 4;
    public static final int COPYFILES_INFO = 8;
    public static final int SOURCEFILE_INFO = 16;
    public static final int COPYPATH_INFO = 32;
    public static final int TIMESTAMP_INFO = 64;
    public static final int COMPILER_OPTIONS_INFO = 128;
    public static final int FILE_SEPARATORS_INFO = 256;
    public static final int LISTING_INFO = 512;
    public static final int DEFAULT_INFO = 991;
    private DebugInfo dInfo;
    private int returnCode;
    private int lineNo;
    private String file = "";
    private int fileIndex;
    private String progFile = "";
    private int lastCmd = -1;
    private String varFullname;
    private String varValue;
    private int varType;
    private int varOffset;
    private int varLength;
    private Breakpoint[] breakpoints;
    private Watch[] watches;
    private ThreadObject[] threads;
    private int curThreadIdx;
    private boolean jumpCommandAllowed;
    private long totalMemory;
    private long freeMemory;
    private long timestamp;
    private Tree[] trees;
    private String message;
    private int oldLineNo;
    private String oldFile;
    private int oldFileIndex;
    private String oldProgram;
    private int firstBlockMode;

    public DebugResponse() {
    }

    public DebugResponse(DebugInfo info) {
        this.dInfo = info;
    }

    public DebugResponse(int returnCode, String message) {
        this(returnCode, 0, null, null, null, -1, 0L, 0L, "", -1, "", 0L, -1, null, (Tree[])null, message);
    }

    public DebugResponse(int returnCode, String message, int lastCmd) {
        this(returnCode, message);
        this.lastCmd = lastCmd;
    }

    public DebugResponse(int returnCode, int lastLine, String lastFile, int lastFileIndex, VarName varname, String message) {
        this(returnCode, lastLine, null, null, null, -1, 0L, 0L, lastFile, lastFileIndex, "", 0L, -1, varname, (Tree[])null, message);
    }

    public DebugResponse(int returnCode, int lastLine, Breakpoint[] breakpoints, Watch[] monitors, ThreadObject[] threads, int curThreadIdx, long totalMemory, long freeMemory, String lastFile, int lastFileIndex, String lastProgramFile, int lastCmd, VarName varname, Tree tree, String message) {
        this(returnCode, lastLine, breakpoints, monitors, threads, curThreadIdx, totalMemory, freeMemory, lastFile, lastFileIndex, lastProgramFile, 0L, lastCmd, varname, new Tree[]{tree}, message);
    }

    public DebugResponse(int returnCode, int lastLine, Breakpoint[] breakpoints, Watch[] monitors, ThreadObject[] threads, int curThreadIdx, long totalMemory, long freeMemory, String lastFile, int lastFileIndex, String lastProgramFile, long lastProgTimestamp, int lastCmd, VarName varname, Tree tree, String message) {
        this(returnCode, lastLine, breakpoints, monitors, threads, curThreadIdx, totalMemory, freeMemory, lastFile, lastFileIndex, lastProgramFile, lastProgTimestamp, lastCmd, varname, new Tree[]{tree}, message);
    }

    public DebugResponse(int returnCode, int lastLine, Breakpoint[] breakpoints, Watch[] monitors, ThreadObject[] threads, int curThreadIdx, long totalMemory, long freeMemory, String lastFile, int lastFileIndex, String lastProgramFile, long lastProgTimestamp, int lastCmd, VarName varname, Tree[] tree, String message) {
        this.returnCode = returnCode;
        this.lineNo = lastLine;
        this.breakpoints = breakpoints;
        this.watches = monitors;
        this.threads = threads;
        this.curThreadIdx = curThreadIdx;
        this.totalMemory = totalMemory;
        this.freeMemory = freeMemory;
        this.file = lastFile;
        this.fileIndex = lastFileIndex;
        if (lastProgramFile != null) {
            this.progFile = lastProgramFile;
            this.timestamp = lastProgTimestamp;
        }
        this.setVarName(varname);
        this.trees = tree;
        this.lastCmd = lastCmd;
        this.message = message;
    }

    public void setInfo(DebugInfo info) {
        this.dInfo = info;
    }

    @Override
    public DebugInfo getInfo() {
        return this.dInfo;
    }

    @Override
    public boolean isJumpCommandAllowed() {
        return this.jumpCommandAllowed;
    }

    public void setJumpCommandAllowed(boolean jumpCommandAllowed) {
        this.jumpCommandAllowed = jumpCommandAllowed;
    }

    public Watch[] getMonitors() {
        return this.watches;
    }

    public void setMonitors(Watch[] ws) {
        this.watches = ws;
    }

    @Override
    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int rc) {
        this.returnCode = rc;
    }

    @Override
    public int getLastCmd() {
        return this.lastCmd;
    }

    public void setLastCmd(int lcmd) {
        this.lastCmd = lcmd;
    }

    public Breakpoint[] getBreakpoints() {
        return this.breakpoints;
    }

    public void setBreakpoints(Breakpoint[] bps) {
        this.breakpoints = bps;
    }

    public ThreadObject[] getThreads() {
        return this.threads;
    }

    public void setThreads(ThreadObject[] tobs) {
        this.threads = tobs;
    }

    @Override
    public ThreadObject getCurrentThread() {
        if (this.threads != null && this.curThreadIdx >= 0 && this.curThreadIdx < this.threads.length) {
            return this.threads[this.curThreadIdx];
        }
        return null;
    }

    public void setCurThreadIdx(int i) {
        this.curThreadIdx = i;
    }

    @Override
    public int getCurThreadIdx() {
        return this.curThreadIdx;
    }

    @Override
    public long getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(long tm) {
        this.totalMemory = tm;
    }

    @Override
    public long getFreeMemory() {
        return this.freeMemory;
    }

    public void setFreeMemory(long fm) {
        this.freeMemory = fm;
    }

    public Tree[] getTrees() {
        return this.trees;
    }

    @Override
    public Tree getTree() {
        return this.trees != null && this.trees.length > 0 ? this.trees[0] : null;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    @Override
    public int getLine() {
        return this.lineNo;
    }

    public void setLine(int ln) {
        this.lineNo = ln;
    }

    @Override
    public String getLastFile() {
        return this.file;
    }

    @Override
    public int getLastFileIndex() {
        return this.fileIndex;
    }

    public void setLastFileIndex(int f) {
        this.fileIndex = f;
    }

    public void setLastFile(String s) {
        this.file = s;
    }

    @Override
    public String getLastProgram() {
        return this.progFile;
    }

    @Override
    public long getLastProgramTimestamp() {
        return this.timestamp;
    }

    public void setLastProgram(String s) {
        this.progFile = s;
    }

    public ParagraphObject[] getParStack() {
        if (this.threads != null && this.curThreadIdx >= 0 && this.curThreadIdx < this.threads.length) {
            return this.threads[this.curThreadIdx].getParStack();
        }
        return null;
    }

    @Override
    public String getLastClass() {
        ParagraphObject[] parStack = this.getParStack();
        if (parStack != null && parStack.length > 0) {
            return parStack[parStack.length - 1].getProgName();
        }
        return null;
    }

    public void setVarName(VarName v) {
        if (v != null) {
            this.varFullname = v.getFullName();
            this.varValue = v.getValue();
            this.varType = v.getType();
            this.varLength = v.getLength();
            this.varOffset = v.getOffset();
        }
    }

    @Override
    public int getVarType() {
        return this.varType;
    }

    @Override
    public int getVarLength() {
        return this.varLength;
    }

    @Override
    public int getVarOffset() {
        return this.varOffset;
    }

    @Override
    public String getVarName() {
        return this.varFullname;
    }

    @Override
    public String getVarValue() {
        return this.varValue;
    }

    protected void setVarValue(String val) {
        this.varValue = val;
    }

    public void setOldLine(int l) {
        this.oldLineNo = l;
    }

    public void setOldFile(String f) {
        this.oldFile = f;
    }

    @Override
    public int getOldLine() {
        return this.oldLineNo;
    }

    @Override
    public String getOldFile() {
        return this.oldFile;
    }

    @Override
    public int getOldFileIndex() {
        return this.oldFileIndex;
    }

    public void setOldFileIndex(int oldFileIndex) {
        this.oldFileIndex = oldFileIndex;
    }

    @Override
    public String getOldProgram() {
        return this.oldProgram;
    }

    public void setOldProgram(String oldProgram) {
        this.oldProgram = oldProgram;
    }

    public void setTrees(Tree[] trees) {
        this.trees = trees;
    }

    @Override
    public boolean isErrorCode() {
        return DebugResponse.isErrorCode(this.returnCode);
    }

    public static boolean isErrorCode(int returnCode) {
        switch (returnCode) {
            case 103: 
            case 106: 
            case 201: 
            case 202: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getFirstBlockMode() {
        return this.firstBlockMode;
    }

    public void setFirstBlockMode(int firstBlockMode) {
        this.firstBlockMode = firstBlockMode;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.dInfo != null);
        if (this.dInfo != null) {
            this.dInfo.writeExternal(out);
        }
        out.writeInt(this.returnCode);
        out.writeInt(this.lineNo);
        RtsUtil.writeUTFOptmz(this.file, out);
        out.writeInt(this.fileIndex);
        RtsUtil.writeUTFOptmz(this.progFile, out);
        out.writeInt(this.lastCmd);
        RtsUtil.writeUTFOptmz(this.varFullname, out);
        RtsUtil.writeUTF(this.varValue, out);
        out.writeInt(this.varType);
        out.writeInt(this.varOffset);
        out.writeInt(this.varLength);
        if (this.breakpoints != null) {
            out.writeInt(this.breakpoints.length);
            for (DataExternalizable dataExternalizable : this.breakpoints) {
                ((Breakpoint)dataExternalizable).writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
        if (this.watches != null) {
            out.writeInt(this.watches.length);
            for (DataExternalizable dataExternalizable : this.watches) {
                ((Watch)dataExternalizable).writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
        if (this.threads != null) {
            out.writeInt(this.threads.length);
            for (DataExternalizable dataExternalizable : this.threads) {
                ((ThreadObject)dataExternalizable).writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.curThreadIdx);
        out.writeBoolean(this.jumpCommandAllowed);
        out.writeLong(this.totalMemory);
        out.writeLong(this.freeMemory);
        out.writeLong(this.timestamp);
        if (this.trees != null) {
            out.writeInt(this.trees.length);
            for (DataExternalizable dataExternalizable : this.trees) {
                ((Tree)dataExternalizable).writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
        RtsUtil.writeUTF(this.message, out);
        out.writeInt(this.oldLineNo);
        RtsUtil.writeUTFOptmz(this.oldFile, out);
        out.writeInt(this.oldFileIndex);
        RtsUtil.writeUTFOptmz(this.oldProgram, out);
        out.writeInt(this.firstBlockMode);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int i;
        if (in.readBoolean()) {
            this.dInfo = new DebugInfo();
            this.dInfo.readExternal(in);
        }
        this.returnCode = in.readInt();
        this.lineNo = in.readInt();
        this.file = RtsUtil.readUTFOptmz(in);
        this.fileIndex = in.readInt();
        this.progFile = RtsUtil.readUTFOptmz(in);
        this.lastCmd = in.readInt();
        this.varFullname = RtsUtil.readUTFOptmz(in);
        this.varValue = RtsUtil.readUTF(in);
        this.varType = in.readInt();
        this.varOffset = in.readInt();
        this.varLength = in.readInt();
        this.breakpoints = new Breakpoint[in.readInt()];
        for (i = 0; i < this.breakpoints.length; ++i) {
            this.breakpoints[i] = new Breakpoint();
            this.breakpoints[i].readExternal(in);
        }
        this.watches = new Watch[in.readInt()];
        for (i = 0; i < this.watches.length; ++i) {
            this.watches[i] = new Watch();
            this.watches[i].readExternal(in);
        }
        this.threads = new ThreadObject[in.readInt()];
        for (i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new ThreadObject();
            this.threads[i].readExternal(in);
        }
        this.curThreadIdx = in.readInt();
        this.jumpCommandAllowed = in.readBoolean();
        this.totalMemory = in.readLong();
        this.freeMemory = in.readLong();
        this.timestamp = in.readLong();
        this.trees = new Tree[in.readInt()];
        for (i = 0; i < this.trees.length; ++i) {
            this.trees[i] = new Tree();
            this.trees[i].readExternal(in);
        }
        this.message = RtsUtil.readUTF(in);
        this.oldLineNo = in.readInt();
        this.oldFile = RtsUtil.readUTFOptmz(in);
        this.oldFileIndex = in.readInt();
        this.oldProgram = RtsUtil.readUTFOptmz(in);
        this.firstBlockMode = in.readInt();
    }

    public static class DebugInfo
    implements IDebugInfoExtension2,
    DataExternalizable {
        private static final long serialVersionUID = 1000007L;
        private String[] filenames;
        private DebugLine[] lines;
        private DebugParagraph[] paragraphs;
        private DebugCopyFile[] copyfiles;
        private String sourcefile;
        private String copypath;
        private String className;
        private String errorString;
        private long timestamp;
        private boolean jumpCommandSupported;
        private String[] compilerOptions;
        private String[] compilerProps;
        private byte[] listingInfos;
        private int infoFormat;
        protected String[] fileSeparators;

        public DebugInfo() {
        }

        public DebugInfo(String clazz, String[] filenames, DebugLine[] lines, DebugParagraph[] paragraphs, DebugCopyFile[] copyfiles, String sourcefile, String copypath, long timestamp, boolean jumpSupported, String[] compilerOptions, String[] fileSeparators, String[] compilerProps, byte[] listingInfos, int infoFormat) {
            this.className = clazz;
            this.filenames = filenames;
            this.lines = lines;
            this.paragraphs = paragraphs;
            this.copyfiles = copyfiles;
            this.sourcefile = sourcefile;
            this.copypath = copypath;
            this.timestamp = timestamp;
            this.jumpCommandSupported = jumpSupported;
            this.compilerOptions = compilerOptions;
            this.fileSeparators = fileSeparators;
            this.compilerProps = compilerProps;
            this.infoFormat = infoFormat;
            this.listingInfos = listingInfos;
        }

        public DebugInfo(String error) {
            this("$Dummy$", new String[0], new DebugLine[0], new DebugParagraph[0], new DebugCopyFile[0], "", "", 0L, false, null, null, null, null, 0);
            this.errorString = error;
        }

        @Override
        public byte[] getListingInfos() {
            return this.listingInfos;
        }

        @Override
        public char getHyphenReplacingChar() {
            int Return2 = 95;
            if (this.compilerOptions != null) {
                for (String opt : this.compilerOptions) {
                    if (!"-smfu".equalsIgnoreCase(opt)) continue;
                    Return2 = 36;
                    break;
                }
            }
            return (char)Return2;
        }

        @Override
        public String getFileSeparator() {
            if (this.fileSeparators != null) {
                return this.fileSeparators[0];
            }
            return File.separator;
        }

        @Override
        public String getPathSeparator() {
            if (this.fileSeparators != null) {
                return this.fileSeparators[1];
            }
            return File.pathSeparator;
        }

        @Override
        public boolean isJumpCommandSupported() {
            return this.jumpCommandSupported;
        }

        @Override
        public void setJumpCommandSupported(boolean jumpCommandSupported) {
            this.jumpCommandSupported = jumpCommandSupported;
        }

        @Override
        public String getErrorString() {
            return this.errorString;
        }

        @Override
        public String[] getFilenames() {
            return this.filenames;
        }

        public DebugLine[] getLines() {
            return this.lines;
        }

        @Override
        public String[] getCompilerOptions() {
            return this.compilerOptions;
        }

        @Override
        public String[] getCompilerProps() {
            return this.compilerProps;
        }

        @Override
        public int getInfoFormat() {
            return this.infoFormat;
        }

        public DebugParagraph[] getParagraphs() {
            return this.paragraphs;
        }

        public DebugCopyFile[] getCopyfiles() {
            return this.copyfiles;
        }

        @Override
        public String getSourcefile() {
            return this.sourcefile;
        }

        @Override
        public String getCopyPath() {
            return this.copypath;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            if (this.filenames != null) {
                out.writeInt(this.filenames.length);
                for (String string : this.filenames) {
                    RtsUtil.writeUTFOptmz(string, out);
                }
            } else {
                out.writeInt(0);
            }
            if (this.lines != null) {
                out.writeInt(this.lines.length);
                for (DebugLine debugLine : this.lines) {
                    debugLine.writeExternal(out);
                }
            } else {
                out.writeInt(0);
            }
            if (this.paragraphs != null) {
                out.writeInt(this.paragraphs.length);
                for (DebugParagraph debugParagraph : this.paragraphs) {
                    debugParagraph.writeExternal(out);
                }
            } else {
                out.writeInt(0);
            }
            if (this.copyfiles != null) {
                out.writeInt(this.copyfiles.length);
                for (DebugCopyFile debugCopyFile : this.copyfiles) {
                    debugCopyFile.writeExternal(out);
                }
            } else {
                out.writeInt(0);
            }
            RtsUtil.writeUTFOptmz(this.sourcefile, out);
            RtsUtil.writeUTF(this.copypath, out);
            RtsUtil.writeUTFOptmz(this.className, out);
            RtsUtil.writeUTF(this.errorString, out);
            out.writeLong(this.timestamp);
            out.writeBoolean(this.jumpCommandSupported);
            if (this.compilerOptions != null) {
                out.writeInt(this.compilerOptions.length);
                for (String string : this.compilerOptions) {
                    RtsUtil.writeUTFOptmz(string, out);
                }
            } else {
                out.writeInt(0);
            }
            if (this.fileSeparators != null) {
                out.writeInt(this.fileSeparators.length);
                for (String string : this.fileSeparators) {
                    RtsUtil.writeUTFOptmz(string, out);
                }
            } else {
                out.writeInt(0);
            }
            if (this.listingInfos != null) {
                out.writeInt(this.listingInfos.length);
                out.write(this.listingInfos, 0, this.listingInfos.length);
            } else {
                out.writeInt(0);
            }
            if (this.compilerProps != null) {
                out.writeInt(this.compilerProps.length);
                for (String string : this.compilerProps) {
                    RtsUtil.writeUTFOptmz(string, out);
                }
            } else {
                out.writeInt(0);
            }
            out.writeInt(this.infoFormat);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            int i;
            this.filenames = new String[in.readInt()];
            for (i = 0; i < this.filenames.length; ++i) {
                this.filenames[i] = RtsUtil.readUTFOptmz(in);
            }
            this.lines = new DebugLine[in.readInt()];
            for (i = 0; i < this.lines.length; ++i) {
                this.lines[i] = new DebugLine();
                this.lines[i].readExternal(in);
            }
            this.paragraphs = new DebugParagraph[in.readInt()];
            for (i = 0; i < this.paragraphs.length; ++i) {
                this.paragraphs[i] = new DebugParagraph();
                this.paragraphs[i].readExternal(in);
            }
            this.copyfiles = new DebugCopyFile[in.readInt()];
            for (i = 0; i < this.copyfiles.length; ++i) {
                this.copyfiles[i] = new DebugCopyFile();
                this.copyfiles[i].readExternal(in);
            }
            this.sourcefile = RtsUtil.readUTFOptmz(in);
            this.copypath = RtsUtil.readUTF(in);
            this.className = RtsUtil.readUTFOptmz(in);
            this.errorString = RtsUtil.readUTF(in);
            this.timestamp = in.readLong();
            this.jumpCommandSupported = in.readBoolean();
            this.compilerOptions = new String[in.readInt()];
            for (i = 0; i < this.compilerOptions.length; ++i) {
                this.compilerOptions[i] = RtsUtil.readUTFOptmz(in);
            }
            this.fileSeparators = new String[in.readInt()];
            for (i = 0; i < this.fileSeparators.length; ++i) {
                this.fileSeparators[i] = RtsUtil.readUTFOptmz(in);
            }
            int len = in.readInt();
            if (len > 0) {
                this.listingInfos = new byte[len];
                in.readFully(this.listingInfos, 0, this.listingInfos.length);
            } else {
                this.listingInfos = null;
            }
            this.compilerProps = new String[in.readInt()];
            for (int i2 = 0; i2 < this.compilerProps.length; ++i2) {
                this.compilerProps[i2] = RtsUtil.readUTFOptmz(in);
            }
            this.infoFormat = in.readInt();
        }
    }
}

