/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import com.iscobol.debugger.dialogs.NamesRecorder;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class AcceptVariableDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JComboBox variableCmb;
    private JTextField moduleTxt;
    private JTextField propertyTxt;
    private JTextField valueTxt;
    private JCheckBox hexChk;
    private JButton ok;
    private JButton close;
    NamesRecorder nRec = NamesRecorder.getInstance("varname");

    public AcceptVariableDialog(JFrame parent, String title, String defname, String defmodule, String defvalue, String propname, boolean hex) {
        super(parent, title, true);
        JComponent focus;
        LMResize layout = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(layout);
        this.hexChk = new JCheckBox("Hexadecimal");
        this.hexChk.setMnemonic('h');
        Dimension d = layout.getPreferredSize(this.hexChk);
        this.hexChk.setBounds(10, 10, d.width, d.height);
        this.getContentPane().add(this.hexChk);
        JLabel variableLbl = new JLabel("Variable name:");
        d = layout.getPreferredSize(variableLbl);
        variableLbl.setBounds(LMResize.getLeft(this.hexChk), LMResize.getBottom(this.hexChk) + 15, d.width, d.height);
        this.getContentPane().add(variableLbl);
        this.variableCmb = new JComboBox();
        Component c = this.variableCmb.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            c.addMouseListener(new GraphUtilities.TextFieldDefaultPopup((JTextComponent)c));
        }
        this.variableCmb.setEditable(true);
        JLabel moduleLbl = new JLabel("Method/Program:");
        d = layout.getPreferredSize(moduleLbl);
        moduleLbl.setBounds(LMResize.getLeft(variableLbl), LMResize.getBottom(variableLbl) + 15, d.width, d.height);
        this.getContentPane().add(moduleLbl);
        this.moduleTxt = new JTextField();
        this.moduleTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.moduleTxt));
        this.moduleTxt.setBounds(LMResize.getRight(moduleLbl) + 5, LMResize.getTop(moduleLbl), 200, this.moduleTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.moduleTxt, new LMResizeData(1));
        this.variableCmb.setBounds(LMResize.getRight(moduleLbl) + 5, LMResize.getTop(variableLbl), 200, this.variableCmb.getPreferredSize().height);
        this.getContentPane().add((Component)this.variableCmb, new LMResizeData(1));
        JLabel propertyLbl = new JLabel("Property name:");
        d = layout.getPreferredSize(propertyLbl);
        propertyLbl.setBounds(LMResize.getLeft(variableLbl), LMResize.getBottom(moduleLbl) + 15, d.width, d.height);
        this.getContentPane().add(propertyLbl);
        this.propertyTxt = new JTextField();
        this.propertyTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.propertyTxt));
        this.propertyTxt.setBounds(LMResize.getLeft(this.variableCmb), LMResize.getTop(propertyLbl), 200, this.propertyTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.propertyTxt, new LMResizeData(1));
        JLabel valueLbl = new JLabel("Value:");
        d = layout.getPreferredSize(valueLbl);
        valueLbl.setBounds(LMResize.getLeft(variableLbl), LMResize.getBottom(propertyLbl) + 15, d.width, d.height);
        this.getContentPane().add(valueLbl);
        this.valueTxt = new JTextField();
        this.valueTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.valueTxt));
        this.valueTxt.setBounds(LMResize.getLeft(this.variableCmb), LMResize.getTop(valueLbl), 200, this.valueTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.valueTxt, new LMResizeData(1));
        this.ok = new JButton("OK");
        this.ok.setMnemonic('o');
        this.ok.addActionListener(e -> {
            Object var = this.variableCmb.getEditor().getItem();
            if (var != null) {
                this.nRec.removeAndInsert(var.toString());
            }
            this.makeString();
            this.closeDialog();
        });
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(e -> this.closeDialog());
        d = layout.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(this.valueTxt) - d.width + 5, LMResize.getBottom(this.valueTxt) + 20, d.width, d.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.ok.setBounds(LMResize.getLeft(this.close) - 15 - d.width, LMResize.getTop(this.close), d.width, d.height);
        this.getContentPane().add((Component)this.ok, new LMResizeData(10));
        this.pack();
        this.setDefaultButton(this.ok);
        this.hexChk.setSelected(hex);
        if (defname != null) {
            this.nRec.removeAndInsert(defname);
        }
        Iterator<String> it = this.nRec.names();
        while (it.hasNext()) {
            this.variableCmb.addItem(it.next());
        }
        if (defname != null) {
            this.variableCmb.setSelectedItem(defname);
        }
        if (defmodule != null) {
            this.moduleTxt.setText(defmodule);
        }
        if (propname != null && propname.length() > 0) {
            this.propertyTxt.setText(propname);
        }
        if (defvalue != null) {
            this.valueTxt.setText(defvalue);
            this.valueTxt.select(0, defvalue.length());
        }
        if (defvalue != null && defvalue.length() > 0) {
            focus = this.valueTxt;
            this.valueTxt.selectAll();
        } else {
            focus = this.variableCmb;
        }
        AcceptVariableDialog.setFirstFocusedComponent(focus);
    }

    private void makeString() {
        Object var = this.variableCmb.getEditor().getItem();
        if (var != null) {
            String prop;
            this.commandString = "let";
            if (this.hexChk.isSelected()) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "-x";
            }
            if (this.moduleTxt.getText().length() > 0) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "-c";
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + this.moduleTxt.getText();
            }
            this.commandString = this.commandString + " ";
            this.commandString = this.commandString + var;
            if (this.propertyTxt != null && (prop = this.propertyTxt.getText()).length() > 0) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "property";
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + prop;
            }
            this.commandString = this.commandString + " =" + this.valueTxt.getText();
        } else {
            this.commandString = null;
        }
    }
}

