/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.EditableTextField;
import com.iscobol.gui.client.swing.FromToTransferHandler;
import com.iscobol.gui.client.swing.OutAcceptEvent;
import com.iscobol.gui.client.swing.OutAcceptListener;
import com.iscobol.gui.client.swing.OutDragListener;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.rts.Factory;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ComboBox
extends JComboBox
implements EditableTextField {
    private static final long serialVersionUID = 1L;
    private static final int OK = 0;
    private static final int ABORT = 1;
    private static final int ENTER_KEY = 2;
    private static final int OK_KEY_PRESSED = 3;
    private static final Border NATIVE_BORDER = BorderFactory.createEmptyBorder(0, 2, 0, 0);
    protected String name;
    protected boolean iscontroleditor;
    private int upperLowerMethod;
    private boolean defaultShortcutsEnabled = true;
    private int maxText;
    private boolean upper;
    private boolean lower;
    private boolean fireActionEvent = true;
    protected OutAcceptListener oaListener;
    private boolean drawBorder = true;
    private JComponent editor;
    private ArrayList editorKeyListeners = new ArrayList();
    private LabelCellRenderer renderer = new LabelCellRenderer();
    private boolean isEditable;
    private Color disabledBackground;
    private Color disabledForeground;
    private Color background;
    private Color foreground;
    private boolean f4DropsCombo = true;
    private JList popupList;
    private boolean documentListenerEnabled = true;
    private boolean textChanged;
    private long time;
    private StringBuffer prefix = new StringBuffer();
    private boolean bufferSelectionKeys;
    private final Long timeFactor = (Long)UIManager.get("ComboBox.timeFactor");
    private boolean isNative;
    private Color selBG;
    private Color selFG;
    private Color noSelBG;
    private Color noSelFG;
    private final UndoManager undoManager = new UndoManager();
    private char[] acceptedControlChars;
    private boolean checkItemIdentity;
    private FromToTransferHandler ftth = null;
    private String inputFilter;

    public ComboBox(boolean isNative, boolean bufferSelectionKeys) {
        this.isNative = isNative;
        this.bufferSelectionKeys = bufferSelectionKeys;
        JTextField target = new JTextField();
        this.selBG = target.getSelectionColor();
        this.selFG = target.getSelectedTextColor();
        this.noSelBG = target.getBackground();
        this.noSelFG = target.getForeground();
        super.setRenderer(this.renderer);
        super.setEditable(!isNative);
        if (this.name != null) {
            this.setName(this.name);
        }
        if (this.bufferSelectionKeys) {
            this.setKeySelectionManager(new JComboBox.KeySelectionManager(){

                public int selectionForKey(char aKey, ComboBoxModel aModel) {
                    int ret;
                    if (ComboBox.this.prefix.length() > 0) {
                        JList targetList = ComboBox.this.popupList != null && ComboBox.this.isPopupVisible() ? ComboBox.this.popupList : new JList(aModel);
                        ret = targetList.getNextMatch(ComboBox.this.prefix.toString(), 0, Position.Bias.Forward);
                    } else {
                        ret = -1;
                    }
                    return ret;
                }
            });
        }
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (ComboBox.this.isEditable) {
                    ComboBox.this.selectAll();
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        if (ComboBox.isWindowsLaf()) {
            try {
                this.setUI((ComboBoxUI)Class.forName("com.iscobol.gui.client.swing.IscobolWindowsComboBoxUI").newInstance());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isNative() {
        return this.isNative;
    }

    public void addItem(Object item) {
        this.documentListenerEnabled = false;
        super.addItem(new Item(item.toString()));
        this.documentListenerEnabled = true;
    }

    public void insertItemAt(Object item, int idx) {
        this.documentListenerEnabled = false;
        super.insertItemAt(new Item(item.toString()), idx);
        this.documentListenerEnabled = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private int intProcessEvent(AWTEvent e) {
        int Return2 = 1;
        block0 : switch (e.getID()) {
            case 401: {
                KeyEvent ke = (KeyEvent)e;
                switch (ke.getKeyCode()) {
                    case 38: 
                    case 40: {
                        if (ke.isAltDown()) {
                            Return2 = 3;
                            break;
                        }
                        int idx = this.getSelectedIndex();
                        if (this.textChanged) {
                            int newIdx = this.itemToIndex(this.getText());
                            if (idx >= 0 && idx == newIdx) {
                                this.select(-1);
                            }
                            this.setSelectedIndex(newIdx);
                            this.textChanged = false;
                            break;
                        }
                        if (ke.getKeyCode() == 38) {
                            if (idx <= 0) break block0;
                            this.setSelectedIndex(idx - 1);
                            break;
                        }
                        if (idx >= this.getItemCount() - 1) break block0;
                        this.setSelectedIndex(idx + 1);
                        break;
                    }
                    case 10: {
                        int idx;
                        Return2 = 2;
                        if (!this.isPopupVisible() || this.popupList == null || (idx = this.popupList.getSelectedIndex()) < 0) break block0;
                        this.setSelectedIndex(idx);
                        break;
                    }
                    case 115: {
                        if (this.isF4DropsCombo()) {
                            Return2 = 3;
                            break;
                        }
                        ListIterator lit = this.editorKeyListeners.listIterator();
                        while (lit.hasNext()) {
                            KeyListener kl = (KeyListener)lit.next();
                            kl.keyPressed((KeyEvent)e);
                        }
                        break block0;
                    }
                    default: {
                        if (this.bufferSelectionKeys) {
                            if (ComboBox.isPrintableChar(ke.getKeyChar())) {
                                long factor;
                                long when = ke.getWhen();
                                long l = factor = this.timeFactor != null ? this.timeFactor : 1000L;
                                if (this.time > 0L && when - this.time >= factor) {
                                    this.prefix = new StringBuffer();
                                }
                                this.time = when;
                                this.prefix.append(ke.getKeyChar());
                            } else {
                                this.time = 0L;
                                this.prefix = new StringBuffer();
                            }
                        }
                        Return2 = 3;
                        break;
                    }
                }
                break;
            }
            default: {
                Return2 = 0;
            }
        }
        return Return2;
    }

    @Override
    public void setEditable(boolean b) {
        this.isEditable = b;
        if (this.isNative && this.isEditable) {
            super.setEditable(true);
        }
        this.editor = this.isEditable ? new EditableComboBoxEditor() : (!this.isNative ? new UneditableComboBoxEditor() : null);
        if (this.editor != null) {
            super.setEditor((ComboBoxEditor)((Object)this.editor));
            this.editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 115 && !ComboBox.this.iscontroleditor) {
                        final boolean popupVisible = !ComboBox.this.isPopupVisible();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ComboBox.this.setPopupVisible(popupVisible);
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (this.getOutAcceptListener() != null && this.getOutAcceptListener().bufferedOutAcceptEvent(new OutAcceptEvent(e))) {
            return;
        }
        if (this.editor == null && this.isNative) {
            switch (this.intProcessEvent(e)) {
                case 0: 
                case 3: {
                    super.processEvent(e);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.fireActionEvent = false;
                    super.processEvent(e);
                    this.fireActionEvent = true;
                }
            }
        } else {
            super.processEvent(e);
        }
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        if (this.editor == null) {
            super.addKeyListener(kl);
            if (this.isNative) {
                this.editorKeyListeners.add(kl);
            }
        } else {
            this.editor.addKeyListener(kl);
            this.editorKeyListeners.add(kl);
        }
    }

    @Override
    public void removeKeyListener(KeyListener kl) {
        if (this.editor == null) {
            super.removeKeyListener(kl);
            if (this.isNative) {
                this.editorKeyListeners.remove(kl);
            }
        } else {
            this.editor.removeKeyListener(kl);
            this.editorKeyListeners.remove(kl);
        }
    }

    @Override
    public void removeAllItems() {
        this.fireActionEvent = false;
        super.removeAllItems();
        this.fireActionEvent = true;
    }

    @Override
    public void removeItemAt(int anIndex) {
        if (this.getSelectedIndex() == -1 || this.getSelectedIndex() == anIndex) {
            this.fireActionEvent = false;
            super.removeItemAt(anIndex);
            this.fireActionEvent = true;
        } else {
            super.removeItemAt(anIndex);
        }
    }

    @Override
    public void addFocusListener(FocusListener kl) {
        if (this.editor == null) {
            super.addFocusListener(kl);
        } else {
            this.editor.addFocusListener(kl);
        }
    }

    @Override
    public void removeFocusListener(FocusListener kl) {
        if (this.editor == null) {
            super.removeFocusListener(kl);
        } else {
            this.editor.removeFocusListener(kl);
        }
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        super.addMouseListener(ml);
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].addMouseListener(ml);
        }
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        super.removeMouseListener(ml);
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].removeMouseListener(ml);
        }
    }

    protected Color background() {
        return this.background;
    }

    @Override
    public void setBackground(Color bg) {
        this.background = bg;
        this.intSetBackground(bg);
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
        if (this.isEditable) {
            ((EditableComboBoxEditor)this.editor).setBorder();
        } else if (this.editor != null) {
            ((UneditableComboBoxEditor)this.editor).setBorder();
        }
    }

    private void intSetBackground(Color c) {
        if (this.editor != null) {
            this.editor.setBackground(c);
        }
        if (this.renderer != null) {
            this.renderer.setNoSelBG(c);
        }
        if (this.isNative && !this.isEditable) {
            super.setBackground(c);
        }
    }

    protected Color foreground() {
        return this.foreground;
    }

    @Override
    public void setForeground(Color fg) {
        this.foreground = fg;
        this.intSetForeground(fg);
    }

    private void intSetForeground(Color c) {
        if (this.editor != null) {
            this.editor.setForeground(c);
        }
        if (this.renderer != null) {
            this.renderer.setNoSelFG(c);
        }
        if (this.isNative && !this.isEditable) {
            super.setForeground(c);
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.editor != null) {
            this.editor.setFont(f);
        }
        if (this.renderer != null) {
            this.renderer.setFont(f);
        }
    }

    @Override
    protected void fireActionEvent() {
        if (this.fireActionEvent) {
            super.fireActionEvent();
        }
    }

    void select(int idx) {
        this.fireActionEvent = false;
        this.setSelectedIndex(idx);
        this.fireActionEvent = true;
    }

    @Override
    public int getSelectedIndex() {
        boolean b = this.checkItemIdentity;
        this.checkItemIdentity = true;
        int Return2 = super.getSelectedIndex();
        this.checkItemIdentity = b;
        return Return2;
    }

    @Override
    public void setSelectedIndex(int idx) {
        this.documentListenerEnabled = false;
        boolean b = this.checkItemIdentity;
        this.checkItemIdentity = true;
        super.setSelectedIndex(idx);
        this.checkItemIdentity = b;
        if (idx < 0) {
            this.clearSelection();
            if (this.editor != null) {
                ((ComboBoxEditor)((Object)this.editor)).setItem(null);
            }
        }
        if (this.isNative) {
            this.repaint();
        }
        this.documentListenerEnabled = true;
    }

    int itemToIndex(String item) {
        int i;
        int n = this.getItemCount();
        for (i = 0; i < n; ++i) {
            if (!this.getItemAt(i).toString().equals(item)) continue;
            return i;
        }
        for (i = 0; i < n; ++i) {
            if (!this.getItemAt(i).toString().equalsIgnoreCase(item)) continue;
            return i;
        }
        item = item.toLowerCase();
        for (i = 0; i < n; ++i) {
            if (!this.getItemAt(i).toString().toLowerCase().startsWith(item)) continue;
            return i;
        }
        return -1;
    }

    public int setSelectedItem(String item) {
        this.documentListenerEnabled = false;
        int Return2 = this.itemToIndex(item);
        if (Return2 >= 0) {
            this.setSelectedIndex(Return2);
        }
        this.documentListenerEnabled = true;
        return Return2;
    }

    @Override
    public void selectAll() {
        if (this.editor != null) {
            this.documentListenerEnabled = false;
            ((ComboBoxEditor)((Object)this.editor)).selectAll();
            this.documentListenerEnabled = true;
        } else if (this.isNative) {
            super.setBackground(this.selBG);
            super.setForeground(this.selFG);
        }
    }

    public boolean isF4DropsCombo() {
        return this.f4DropsCombo;
    }

    public void setF4DropsCombo(boolean f4DropsCombo) {
        this.f4DropsCombo = f4DropsCombo;
    }

    public void clearSelection() {
        if (this.isEditable) {
            this.documentListenerEnabled = false;
            ((EditableComboBoxEditor)this.editor).select(0, 0);
            this.documentListenerEnabled = true;
        } else if (this.editor != null) {
            ((UneditableComboBoxEditor)this.editor).clearSelection();
        } else if (this.isNative) {
            Color disBg = this.getDisabledBackground();
            Color disFg = this.getDisabledForeground();
            super.setBackground(!this.isEnabled() && disBg != null ? disBg : this.background);
            super.setForeground(!this.isEnabled() && disFg != null ? disFg : this.foreground);
        }
    }

    public void setMaxText(int max) {
        this.maxText = max;
    }

    public void setCaretPosition(int cp) {
        if (this.isEditable) {
            ((EditableComboBoxEditor)this.editor).setCaretPosition(cp);
        }
    }

    public int getCaretPosition() {
        return this.isEditable ? ((EditableComboBoxEditor)this.editor).getCaretPosition() : -1;
    }

    @Override
    public String getText() {
        if (this.isEditable) {
            return ((EditableComboBoxEditor)this.editor).getText();
        }
        if (this.editor != null) {
            return ((UneditableComboBoxEditor)this.editor).label.getText();
        }
        int selIdx = this.getSelectedIndex();
        if (selIdx >= 0) {
            return this.getItemAt(selIdx).toString();
        }
        return "";
    }

    public void setText(String t) {
        if (this.isEditable) {
            this.documentListenerEnabled = false;
            ((EditableComboBoxEditor)this.editor).setText(t);
            this.documentListenerEnabled = true;
        }
    }

    public void setUpper(boolean b) {
        this.upper = b;
    }

    public void setLower(boolean b) {
        this.lower = b;
    }

    public void modifyItemAt(int idx, String text) {
        if (idx >= 0 && idx < this.getItemCount()) {
            Item i = (Item)this.getItemAt(idx);
            i.setText(text);
        }
    }

    public void modifyItemAt(int idx, Icon icon) {
        if (idx >= 0 && idx < this.getItemCount()) {
            Item i = (Item)this.getItemAt(idx);
            i.setIcon(icon);
            if (this.getSelectedIndex() == idx) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
                model.removeElement(i);
                model.insertElementAt(i, idx);
                this.setSelectedIndex(idx);
            }
        }
    }

    public void modifyItemAt(int idx, String text, Icon icon) {
        if (idx >= 0 && idx < this.getItemCount()) {
            Item i = (Item)this.getItemAt(idx);
            i.setText(text);
            i.setIcon(icon);
        }
    }

    public void setHiddenDataAt(int idx, Object text) {
        Item i;
        if (idx >= 0 && idx < this.getItemCount() && (i = (Item)this.getItemAt(idx)) != null) {
            i.setHiddenData(text);
        }
    }

    public Object getHiddenDataAt(int idx) {
        Item i;
        Object Return2 = null;
        if (idx >= 0 && idx < this.getItemCount() && (i = (Item)this.getItemAt(idx)) != null && i.getHiddenData() != null) {
            Return2 = i.getHiddenData();
        }
        return Return2;
    }

    public void setColorAt(int idx, int color, Color bg, Color fg) {
        Item i;
        if (idx >= 0 && idx < this.getItemCount() && (i = (Item)this.getItemAt(idx)) != null) {
            i.setColor(color);
            i.setBackground(bg);
            i.setForeground(fg);
        }
    }

    public void setBackgroundColorAt(int idx, int backColor, Color bg) {
        Item i;
        if (idx >= 0 && idx < this.getItemCount() && (i = (Item)this.getItemAt(idx)) != null) {
            i.setBackgroundColor(backColor);
            i.setBackground(bg);
        }
    }

    public void setForegroundColorAt(int idx, int foreColor, Color fg) {
        Item i;
        if (idx >= 0 && idx < this.getItemCount() && (i = (Item)this.getItemAt(idx)) != null) {
            i.setForegroundColor(foreColor);
            i.setForeground(fg);
        }
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (v && this.getItemCount() == 0) {
            this.revalidate();
            this.doLayout();
        }
    }

    public OutAcceptListener getOutAcceptListener() {
        return this.oaListener;
    }

    public boolean hasFocusEditor() {
        return this.editor != null && this.editor.hasFocus();
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledBackground(Color disabledBackground) {
        this.disabledBackground = disabledBackground;
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledForeground(Color disabledForeground) {
        this.disabledForeground = disabledForeground;
    }

    public void myshowPopup() {
        new SwingWorker(false){

            @Override
            public void launch() {
                ComboBox.this.setPopupVisible(true);
            }
        }.start();
    }

    private boolean hasBorder() {
        Insets ins;
        Border b;
        return this.isDrawBorder() && (b = this.getBorder()) != null && (ins = b.getBorderInsets(this)) != null && !ins.equals(new Insets(0, 0, 0, 0));
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        if (this.editor != null) {
            this.editor.setToolTipText(text);
        }
    }

    private static boolean isPrintableChar(int c) {
        return c >= 32 && c <= 126;
    }

    public void copyItems(ComboBox source) {
        int itemCount = source.getItemCount();
        Item newit = null;
        Item tmp = null;
        for (int i = 0; i < itemCount; ++i) {
            tmp = (Item)source.getItemAt(i);
            newit = new Item(tmp.getText(), tmp.getIcon());
            super.addItem(newit);
        }
    }

    @Override
    public void cut() {
        if (this.isEditable) {
            ((EditableComboBoxEditor)this.editor).cut();
        }
    }

    @Override
    public void copy() {
        if (this.isEditable) {
            ((EditableComboBoxEditor)this.editor).copy();
        }
    }

    @Override
    public void paste() {
        if (this.isEditable) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            Transferable clipData = clipboard.getContents(this);
            try {
                String clipString = (String)clipData.getTransferData(DataFlavor.stringFlavor);
                EditableComboBoxEditor textComponent = (EditableComboBoxEditor)this.editor;
                if (this.hasSelection()) {
                    textComponent.replaceSelection(clipString);
                } else {
                    textComponent.getDocument().insertString(textComponent.getCaretPosition(), clipString, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void replaceSelection(String replaceText) {
        if (this.isEditable) {
            ((EditableComboBoxEditor)this.editor).replaceSelection(replaceText);
        }
    }

    @Override
    public boolean hasSelection() {
        if (this.isEditable) {
            EditableComboBoxEditor textComponent = (EditableComboBoxEditor)this.editor;
            return textComponent.getSelectionStart() != textComponent.getSelectionEnd();
        }
        return false;
    }

    @Override
    public void undo() {
        if (this.isEditable && this.undoManager.canUndo()) {
            try {
                this.undoManager.undo();
            }
            catch (CannotUndoException cue) {
                System.err.println(cue);
            }
        }
    }

    @Override
    public void redo() {
        if (this.isEditable && this.undoManager.canRedo()) {
            try {
                this.undoManager.redo();
            }
            catch (CannotRedoException cre) {
                System.err.println(cre);
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.isEditable && this.undoManager.canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.isEditable && this.undoManager.canRedo();
    }

    void setPlaceholder(String ph) {
        if (this.editor != null && this.editor instanceof EditableComboBoxEditor) {
            ((EditableComboBoxEditor)this.editor).placeholder = ph;
            this.repaint();
        }
    }

    void setPlaceholderColor(Color c) {
        if (this.editor != null && this.editor instanceof EditableComboBoxEditor) {
            ((EditableComboBoxEditor)this.editor).placeholderColor = c;
            this.repaint();
        }
    }

    @Override
    public void setName(String n) {
        this.name = n;
        if (this.editor != null) {
            this.editor.setName(this.name);
        } else {
            super.setName(this.name);
        }
    }

    public void setControlEditor(boolean b) {
        this.iscontroleditor = b;
    }

    public int getUpperLowerMethod() {
        return this.upperLowerMethod;
    }

    public void setUpperLowerMethod(int upperLowerMethod) {
        this.upperLowerMethod = upperLowerMethod;
    }

    public boolean isDefaultShortcutsEnabled() {
        return this.defaultShortcutsEnabled;
    }

    public void setDefaultShortcutsEnabled(boolean defaultShortcutsEnabled) {
        this.defaultShortcutsEnabled = defaultShortcutsEnabled;
    }

    protected void setAcceptedControlCharacters(String s) {
        this.acceptedControlChars = s != null ? s.toCharArray() : null;
    }

    public void setSelectionBackground(Color c) {
        this.renderer.setSelBG(c);
    }

    public Color getSelectionBackground() {
        return this.renderer.rendererSelBackground;
    }

    public void setSelectionForeground(Color c) {
        this.renderer.setSelFG(c);
    }

    public Color getSelectionForeground() {
        return this.renderer.rendererSelForeground;
    }

    private static boolean isWindowsLaf() {
        return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
    }

    public JComponent getDragDropComponent() {
        return this.editor;
    }

    public void setDragComponent(OutDragListener odlistener) {
        if (this.isEditable && this.editor != null) {
            if (odlistener != null) {
                ((EditableComboBoxEditor)this.editor).setDropMode(DropMode.INSERT);
                ((EditableComboBoxEditor)this.editor).setDragEnabled(true);
                this.ftth = new FromToTransferHandler(odlistener, 1);
                ((EditableComboBoxEditor)this.editor).setTransferHandler(this.ftth);
            } else {
                ((EditableComboBoxEditor)this.editor).setDragEnabled(false);
                if (this.ftth != null) {
                    ((EditableComboBoxEditor)this.editor).setTransferHandler(null);
                }
            }
        }
    }

    public void setInputFilter(String ifstr) {
        if (this.inputFilter == null || !this.inputFilter.equals(ifstr)) {
            this.inputFilter = ifstr;
        }
    }

    public boolean hasInputFilter() {
        return this.inputFilter != null && this.inputFilter.length() > 0;
    }

    public boolean charInInputFilter(char comp) {
        boolean Return2 = false;
        Pattern regexif = null;
        try {
            regexif = Pattern.compile(this.inputFilter);
        }
        catch (PatternSyntaxException pse) {
            return Return2;
        }
        Matcher matcherif = regexif.matcher("");
        matcherif.reset(String.valueOf(comp));
        Return2 = matcherif.find();
        return Return2;
    }

    private String checkInInputFilter(String str) {
        String Return2 = "";
        if (str != null && str.length() > 0 && this.hasInputFilter()) {
            for (int i = 0; i < str.length(); ++i) {
                char comp = str.charAt(i);
                if (!this.charInInputFilter(comp)) continue;
                Return2 = Return2 + comp;
            }
        } else {
            Return2 = str;
        }
        return Return2;
    }

    private class Item {
        String text;
        Icon icon;
        Object hiddendata;
        private int color;
        private int backgroundColor;
        private int foregroundColor;
        private Color foreground;
        private Color background;

        Item(String text) {
            this.text = text;
        }

        Item(String text, Icon icon) {
            this.text = text;
            this.icon = icon;
        }

        public String toString() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setHiddenData(Object text) {
            this.hiddendata = text;
        }

        public Object getHiddenData() {
            return this.hiddendata;
        }

        public String getText() {
            return this.text;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public boolean equals(Object other) {
            if (ComboBox.this.checkItemIdentity) {
                return other == this;
            }
            if (!(other instanceof Item)) {
                return false;
            }
            Item i = (Item)other;
            boolean Return2 = true;
            Return2 = this.text != null ? (i.text != null ? (Return2 &= this.text.equals(i.text)) : false) : (Return2 &= i.text == null);
            Return2 = this.icon != null ? (i.icon != null ? (Return2 &= this.icon.equals(i.icon)) : false) : (Return2 &= i.icon == null);
            return Return2;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public void setBackgroundColor(int backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public void setForegroundColor(int foregroundColor) {
            this.foregroundColor = foregroundColor;
        }

        public void setForeground(Color foreground) {
            this.foreground = foreground;
        }

        public void setBackground(Color background) {
            this.background = background;
        }
    }

    private class LabelCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private Color rendererBackground;
        private Color rendererForeground;
        private Color rendererSelBackground;
        private Color rendererSelForeground;
        private Item currItem;

        public LabelCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        }

        void setNoSelBG(Color c) {
            this.rendererBackground = c;
        }

        void setNoSelFG(Color c) {
            this.rendererForeground = c;
        }

        void setSelBG(Color c) {
            this.rendererSelBackground = c;
        }

        void setSelFG(Color c) {
            this.rendererSelForeground = c;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ComboBox.this.popupList = list;
            this.setOpaque(true);
            if (value != null) {
                this.currItem = (Item)value;
                String text = this.currItem.getText();
                text = ComboBox.this.checkInInputFilter(text);
                if (ComboBox.this.upper) {
                    text = Factory.toUpperCase(text, ComboBox.this.upperLowerMethod);
                } else if (ComboBox.this.lower) {
                    text = Factory.toLowerCase(text, ComboBox.this.upperLowerMethod);
                }
                this.setText(text);
                this.setIcon(this.currItem.getIcon());
                if (isSelected) {
                    this.setBackground(this.rendererSelBackground != null ? this.rendererSelBackground : list.getSelectionBackground());
                    this.setForeground(this.rendererSelForeground != null ? this.rendererSelForeground : list.getSelectionForeground());
                } else {
                    this.setBackground(this.currItem.getBackground() != null ? this.currItem.getBackground() : this.rendererBackground);
                    this.setForeground(this.currItem.getForeground() != null ? this.currItem.getForeground() : this.rendererForeground);
                }
            } else {
                this.setText("");
                this.setIcon(null);
            }
            return this;
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            String text;
            if (width > 0 && ComboBox.this.editor == null && ComboBox.this.isNative && this.currItem != null && !(text = this.getText()).toLowerCase().startsWith("<html>")) {
                int textLen = text.length();
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int textWidth = fm.stringWidth(text);
                int addWidth = this.currItem.getIcon() != null ? this.currItem.getIcon().getIconWidth() : 0;
                addWidth += this.getIconTextGap();
                int requiredWidth = textWidth + (addWidth += this.getInsets().left + this.getInsets().right);
                while (requiredWidth >= width && text.length() > 1) {
                    text = text.substring(0, text.length() - 1);
                    textWidth = fm.stringWidth(text);
                    requiredWidth = textWidth + addWidth;
                }
                if (text.length() < textLen) {
                    this.setText(text);
                }
            }
            super.setBounds(x, y, width, height);
        }
    }

    private class UneditableComboBoxEditor
    extends JPanel
    implements ComboBoxEditor {
        private static final long serialVersionUID = 1L;
        private Object origItem;
        JLabel label;
        private FontMetrics fm;

        public UneditableComboBoxEditor() {
            this.setLayout(null);
            this.label = new JLabel(){

                @Override
                public Color getBackground() {
                    if (ComboBox.this.isEnabled() || ComboBox.this.disabledBackground == null) {
                        return super.getBackground();
                    }
                    return ComboBox.this.disabledBackground;
                }

                @Override
                public Color getForeground() {
                    if (ComboBox.this.isEnabled() || ComboBox.this.disabledForeground == null) {
                        return super.getForeground();
                    }
                    return ComboBox.this.disabledForeground;
                }

                @Override
                public boolean isEnabled() {
                    return ComboBox.this.isEnabled() || ComboBox.this.disabledForeground != null;
                }
            };
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (ComboBox.this.isEnabled()) {
                        UneditableComboBoxEditor.this.showPopup();
                        UneditableComboBoxEditor.this.requestFocusInWindow();
                    }
                }
            });
            this.label.setOpaque(true);
            this.setBorder();
            this.add(this.label);
        }

        @Override
        public void setToolTipText(String text) {
            super.setToolTipText(text);
            if (this.label != null) {
                this.label.setToolTipText(text);
            }
        }

        private void setBorder() {
            if (!ComboBox.this.hasBorder()) {
                this.label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, Color.lightGray));
            }
        }

        @Override
        public void addMouseListener(MouseListener ml) {
            if (this.label != null) {
                this.label.addMouseListener(ml);
            } else {
                super.addMouseListener(ml);
            }
        }

        @Override
        public void removeMouseListener(MouseListener ml) {
            if (this.label != null) {
                this.label.removeMouseListener(ml);
            } else {
                super.removeMouseListener(ml);
            }
        }

        private void showPopup() {
            if (this.label.isEnabled()) {
                ComboBox.this.setPopupVisible(!ComboBox.this.isPopupVisible());
            }
        }

        @Override
        public void setFont(Font f) {
            super.setFont(f);
            if (this.label != null) {
                this.label.setFont(f);
            }
            this.fm = this.getFontMetrics(f);
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            this.label.setSize(this.getPreferredWidth(w), h);
        }

        @Override
        protected void processEvent(AWTEvent e) {
            if (ComboBox.this.getOutAcceptListener() != null && ComboBox.this.getOutAcceptListener().bufferedOutAcceptEvent(new OutAcceptEvent(e))) {
                return;
            }
            switch (ComboBox.this.intProcessEvent(e)) {
                case 3: {
                    super.processEvent(e);
                    e.setSource(ComboBox.this);
                    ComboBox.this.processEvent(e);
                    break;
                }
                case 0: {
                    super.processEvent(e);
                    break;
                }
                case 128: {
                    break;
                }
                case 2: {
                    ComboBox.this.fireActionEvent = false;
                    super.processEvent(e);
                    ComboBox.this.fireActionEvent = true;
                }
            }
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            return this.origItem;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                Item myitem = (Item)anObject;
                String text = myitem.getText();
                if (text == null) {
                    text = "";
                }
                if (!text.equals(this.label.getText())) {
                    text = ComboBox.this.checkInInputFilter(text);
                    if (ComboBox.this.upper) {
                        text = Factory.toUpperCase(text, ComboBox.this.upperLowerMethod);
                    } else if (ComboBox.this.lower) {
                        text = Factory.toLowerCase(text, ComboBox.this.upperLowerMethod);
                    }
                    this.label.setText(text);
                    this.label.setIcon(myitem.getIcon());
                    this.origItem = new Item(myitem.text, myitem.icon);
                }
            } else {
                this.label.setText("");
                this.origItem = null;
            }
        }

        private int getPreferredWidth(int cmbWidth) {
            if (ComboBox.this.getSelectedIndex() == -1) {
                return cmbWidth;
            }
            int textWidth = 0;
            textWidth += this.fm.stringWidth(this.label.getText()) + 10;
            if (this.label.getIcon() != null) {
                textWidth += this.label.getIcon().getIconWidth();
                textWidth += this.label.getIconTextGap();
            }
            return Math.max(cmbWidth, textWidth);
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public Color getBackground() {
            if (ComboBox.this.noSelBG != null) {
                return ComboBox.this.noSelBG;
            }
            return super.getBackground();
        }

        @Override
        public void setBackground(Color bg) {
            if (this.label != null) {
                this.label.setBackground(bg);
            } else {
                super.setBackground(bg);
            }
            ComboBox.this.noSelBG = bg;
        }

        @Override
        public void setForeground(Color fg) {
            if (this.label != null) {
                this.label.setForeground(fg);
            } else {
                super.setForeground(fg);
            }
            ComboBox.this.noSelFG = fg;
        }

        @Override
        public Color getForeground() {
            if (ComboBox.this.noSelFG != null) {
                return ComboBox.this.noSelFG;
            }
            return super.getForeground();
        }

        @Override
        public void selectAll() {
            if (this.label != null) {
                if (ComboBox.this.selBG != null) {
                    this.label.setBackground(ComboBox.this.selBG);
                }
                if (ComboBox.this.selFG != null) {
                    this.label.setForeground(ComboBox.this.selFG);
                }
            }
        }

        public void clearSelection() {
            this.label.setBackground(ComboBox.this.noSelBG);
            this.label.setForeground(ComboBox.this.noSelFG);
        }
    }

    private class EditableComboBoxEditor
    extends JTextField
    implements ComboBoxEditor {
        private static final long serialVersionUID = 1L;
        private Object origItem;
        private String placeholder;
        private Color placeholderColor;
        private final UndoableEditListener undoEditListener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                ComboBox.this.undoManager.addEdit(e.getEdit());
            }
        };
        private final KeyListener undoKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 90 && ke.isControlDown()) {
                    ComboBox.this.undo();
                }
                if (ke.getKeyCode() == 89 && ke.isControlDown()) {
                    ComboBox.this.redo();
                }
            }
        };

        public EditableComboBoxEditor() {
            this.setDocument(new PlainDocument(){
                private static final long serialVersionUID = 1L;

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    EditableComboBoxEditor This = EditableComboBoxEditor.this;
                    if (ComboBox.this.maxText == 0 || This.getDocument().getLength() < ComboBox.this.maxText) {
                        str = ComboBox.this.checkInInputFilter(str);
                        if (ComboBox.this.upper) {
                            str = Factory.toUpperCase(str, ComboBox.this.upperLowerMethod);
                        } else if (ComboBox.this.lower) {
                            str = Factory.toLowerCase(str, ComboBox.this.upperLowerMethod);
                        }
                        super.insertString(offs, str, a);
                    }
                }
            });
            this.getDocument().addDocumentListener(new DocumentListener(){

                private void handleDocumentEvent() {
                    ComboBox.this.textChanged = true;
                    if (ComboBox.this.popupList == null || !ComboBox.this.isPopupVisible()) {
                        return;
                    }
                    String text = EditableComboBoxEditor.this.getText().toLowerCase();
                    ComboBox cb = ComboBox.this;
                    int itemCount = cb.getItemCount();
                    for (int i = 0; i < itemCount; ++i) {
                        Item item = (Item)ComboBox.this.getItemAt(i);
                        if (!item.text.toLowerCase().startsWith(text)) continue;
                        int firstVisibleIndex = ComboBox.this.popupList.getFirstVisibleIndex();
                        if (i != firstVisibleIndex) {
                            int ensureVisibleIndex = i < firstVisibleIndex ? i : Math.min(itemCount, i + ComboBox.this.getMaximumRowCount()) - 1;
                            ComboBox.this.popupList.ensureIndexIsVisible(ensureVisibleIndex);
                        }
                        return;
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    if (ComboBox.this.documentListenerEnabled) {
                        this.handleDocumentEvent();
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    if (ComboBox.this.documentListenerEnabled) {
                        this.handleDocumentEvent();
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            this.getDocument().addUndoableEditListener(this.undoEditListener);
            this.addKeyListener(this.undoKeyListener);
            this.setBorder();
            if (!ComboBox.this.defaultShortcutsEnabled) {
                RemoteBaseGUIControl.disableDefaultShortcuts(this.getKeymap());
            }
        }

        @Override
        public Color getBackground() {
            if (ComboBox.this.isEnabled() || ComboBox.this.disabledBackground == null) {
                return super.getBackground();
            }
            return ComboBox.this.disabledBackground;
        }

        @Override
        public Color getForeground() {
            if (ComboBox.this.isEnabled() || ComboBox.this.disabledForeground == null) {
                return super.getForeground();
            }
            return ComboBox.this.disabledForeground;
        }

        @Override
        public Color getDisabledTextColor() {
            return ComboBox.this.disabledForeground != null ? ComboBox.this.disabledForeground : super.getDisabledTextColor();
        }

        private void setBorder() {
            if (ComboBox.this.isNative) {
                this.setBorder(NATIVE_BORDER);
            } else if (ComboBox.this.hasBorder()) {
                this.setBorder(null);
            }
        }

        @Override
        protected void processEvent(AWTEvent e) {
            if (ComboBox.this.getOutAcceptListener() != null && ComboBox.this.getOutAcceptListener().bufferedOutAcceptEvent(new OutAcceptEvent(e))) {
                return;
            }
            switch (ComboBox.this.intProcessEvent(e)) {
                case 0: 
                case 3: {
                    if (e.getID() == 400) {
                        RemoteBaseGUIControl.checkControlCharacter((KeyEvent)e, ComboBox.this.acceptedControlChars, this);
                    }
                    super.processEvent(e);
                    break;
                }
                case 128: {
                    break;
                }
                case 2: {
                    ComboBox.this.fireActionEvent = false;
                    super.processEvent(e);
                    ComboBox.this.fireActionEvent = true;
                }
            }
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            return this.origItem;
        }

        @Override
        public void setItem(Object anObject) {
            this.getDocument().removeUndoableEditListener(this.undoEditListener);
            if (anObject != null) {
                Item myitem = (Item)anObject;
                String t = myitem.text;
                if (t == null) {
                    t = "";
                }
                if (!t.equals(this.getText())) {
                    int mt = ComboBox.this.maxText;
                    ComboBox.this.maxText = 0;
                    this.setText(myitem.toString());
                    ComboBox.this.maxText = mt;
                    this.origItem = new Item(myitem.text, myitem.icon);
                }
            } else {
                this.setText("");
                this.origItem = null;
            }
            this.getDocument().addUndoableEditListener(this.undoEditListener);
        }

        @Override
        protected void paintComponent(Graphics g1) {
            super.paintComponent(g1);
            if (this.placeholder == null || this.placeholder.length() == 0 || this.getText().length() > 0) {
                return;
            }
            Graphics2D g = (Graphics2D)g1;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.placeholderColor != null ? this.placeholderColor : this.getDisabledTextColor());
            g.drawString(this.placeholder, this.getInsets().left, g1.getFontMetrics().getMaxAscent() + this.getInsets().top);
        }
    }
}

