/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.DoubleIcon;
import com.iscobol.gui.client.swing.PicobolMenuElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;

public class PicobolMenuItem
extends JMenuItem
implements PicobolMenuElement {
    private static final long serialVersionUID = 1L;
    private static final Icon checkIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(PicobolMenuItem.class.getResource("checkmenuitem.gif")));
    private JLabel rightLabel;
    private boolean checked;
    private Icon disabledCheckIcon;
    private Icon icon;
    private Icon disabledIcon;

    public PicobolMenuItem() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (this.rightLabel != null) {
            this.remove(this.rightLabel);
            this.rightLabel = null;
            this.doLayout();
        }
    }

    @Override
    public void fireActionPerformed(ActionEvent event) {
        super.fireActionPerformed(event);
    }

    public void setText(String text, String rightText) {
        FontMetrics fm;
        if (this.rightLabel != null) {
            this.remove(this.rightLabel);
        }
        String centerText = text;
        int len = rightText.length();
        for (int i = 0; i <= len; ++i) {
            centerText = centerText + " ";
        }
        super.setText(centerText);
        rightText = "         " + rightText + "      ";
        this.rightLabel = new JLabel(rightText, 4);
        this.add((Component)this.rightLabel, "East");
        if (this.getFont() != null && (fm = this.getFontMetrics(this.getFont())) != null) {
            int strlen = fm.stringWidth(centerText) + fm.stringWidth(rightText);
            if (this.getPreferredSize().width < strlen + 10) {
                this.setPreferredSize(new Dimension(strlen + 10, this.getPreferredSize().height));
            } else if (this.getPreferredSize().width < strlen + this.rightLabel.getPreferredSize().width) {
                this.setPreferredSize(new Dimension(strlen + this.rightLabel.getPreferredSize().width, this.getPreferredSize().height));
            }
        }
        this.doLayout();
    }

    private Icon getDisabledCheckIcon() {
        if (this.disabledCheckIcon == null) {
            this.disabledCheckIcon = this.getDisabledIcon(checkIcon);
        }
        return this.disabledCheckIcon;
    }

    private Icon getDisabledIcon(Icon source) {
        LookAndFeel laf;
        if (source != null && (laf = UIManager.getLookAndFeel()) != null) {
            return laf.getDisabledIcon(this, source);
        }
        return source;
    }

    private void setDoubleIcon() {
        super.setIcon(new DoubleIcon(this.icon, checkIcon, 4));
        super.setDisabledIcon(new DoubleIcon(this.disabledIcon, this.getDisabledCheckIcon(), 4));
    }

    private void setCheckIcon() {
        super.setIcon(checkIcon);
        super.setDisabledIcon(this.getDisabledCheckIcon());
    }

    private void setNormalIcon() {
        super.setIcon(this.icon);
        super.setDisabledIcon(this.disabledIcon);
    }

    private void unsetIcon() {
        super.setIcon(null);
        super.setDisabledIcon(null);
    }

    private void updateIcon() {
        if (this.icon != null) {
            if (this.checked) {
                this.setDoubleIcon();
            } else {
                this.setNormalIcon();
            }
        } else if (this.checked) {
            this.setCheckIcon();
        } else {
            this.unsetIcon();
        }
    }

    public void setChecked(boolean c) {
        this.checked = c;
        this.updateIcon();
    }

    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = icon;
        this.disabledIcon = this.icon != null ? this.getDisabledIcon(this.icon) : null;
        this.updateIcon();
    }

    @Override
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        if (this.rightLabel != null) {
            this.rightLabel.setEnabled(e);
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.rightLabel != null) {
            this.rightLabel.setFont(f);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.rightLabel != null) {
            this.rightLabel.setForeground(fg);
        }
    }

    @Override
    public void processEvent(KeyEvent evt) {
        super.processKeyEvent(evt);
        if (evt.getKeyCode() == 10 && evt.getID() == 401) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }
}

