/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.swing.Bar;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolBar;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;

public class RemoteBar
extends RemoteBaseGUIControl {
    public static final String WIDTH = "WIDTH";
    public static final String COLORS = "COLORS";
    public static final String COLORS_RGB = "COLORS-RGB";
    public static final String SHADING = "SHADING";
    public static final String POSITION_SHIFT = "POSITION-SHIFT";
    public static final String LEADING_SHIFT = "LEADING-SHIFT";
    public static final String TRAILING_SHIFT = "TRAILING-SHIFT";
    private int propWidth = 1;
    private int positionShift = 0;
    private Color[] colors = new Color[0];
    private int[] shading = new int[0];
    private int[] leadingShift = new int[0];
    private int[] trailingShift = new int[0];
    private int style = -1;

    public RemoteBar(GuiFactoryImpl gf) {
        super(gf);
    }

    @Override
    public float getDefaultWidth() {
        return 0.0f;
    }

    @Override
    public float getDefaultHeight() {
        return 0.0f;
    }

    @Override
    public void initialize() {
        if (this.getComponent() != null) {
            return;
        }
        this.setComponent(new PicobolBar());
        super.intInitialize();
        this.setPropWidth(this.propWidth);
        this.intSetStyle(this.style);
        this.intSetting(true);
    }

    @Override
    public int getGUIControlHeight(float h) {
        int Return2 = (int)((float)this.font.getHeight() * h);
        return Return2;
    }

    @Override
    public int getGUIControlWidth(float w) {
        int Return2 = (int)((float)this.font.getWidth() * w);
        return Return2;
    }

    @Override
    public String getValue() {
        return null;
    }

    public void getAllData() {
    }

    private void addLeadingShift(int val) {
        if (this.leadingShift.length == 0) {
            this.leadingShift = new int[]{val};
        } else {
            int n = this.leadingShift.length;
            int[] nc = new int[n + 1];
            System.arraycopy(this.leadingShift, 0, nc, 0, n);
            this.leadingShift = nc;
            this.leadingShift[n] = val;
        }
    }

    private void addTrailingShift(int val) {
        if (this.trailingShift.length == 0) {
            this.trailingShift = new int[]{val};
        } else {
            int n = this.trailingShift.length;
            int[] nc = new int[n + 1];
            System.arraycopy(this.trailingShift, 0, nc, 0, n);
            this.trailingShift = nc;
            this.trailingShift[n] = val;
        }
    }

    private void addColor(Color val) {
        if (this.colors.length == 0) {
            this.colors = new Color[]{val};
        } else {
            int n = this.colors.length;
            Color[] nc = new Color[n + 1];
            System.arraycopy(this.colors, 0, nc, 0, n);
            this.colors = nc;
            this.colors[n] = val;
        }
    }

    private void addShading(int val) {
        if (this.shading.length == 0) {
            this.shading = new int[]{val};
        } else {
            int n = this.shading.length;
            int[] nc = new int[n + 1];
            System.arraycopy(this.shading, 0, nc, 0, n);
            this.shading = nc;
            this.shading[n] = val;
        }
    }

    private void addPositionShift(int val) {
        this.positionShift = val;
    }

    private void setPropWidth(int val) {
        this.propWidth = val;
    }

    private void setColors(int v) {
        if (v < 0) {
            ColorCmp cc = new ColorCmp(true);
            cc.setForeRGB(v);
            this.addColor(this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cc.getForeground(), false)));
        } else {
            this.addColor(this.gf.getRemotePalette().getDefaultColor(new ColorCmp(v).getForeground()));
        }
    }

    private void setColorsRgb(int v) {
        ColorCmp cc = new ColorCmp(true);
        cc.setForeRGB(v);
        this.addColor(this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cc.getForeground(), false)));
    }

    @Override
    public String setProp(Integer key, byte[] values, int length) {
        int[] parint = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            parint[i] = values[i];
        }
        return this.setProp((int)key, parint);
    }

    @Override
    public String setProp(int key, int[] values) {
        int i = 0;
        switch (key) {
            case 40: {
                for (i = 0; i < values.length; ++i) {
                    this.setColors(values[i]);
                }
                break;
            }
            case 41: {
                for (i = 0; i < values.length; ++i) {
                    this.setColorsRgb(values[i]);
                }
                break;
            }
            case 218: {
                for (i = 0; i < values.length; ++i) {
                    this.addShading(values[i]);
                }
                break;
            }
            case 137: {
                for (i = 0; i < values.length; ++i) {
                    this.addLeadingShift(values[i]);
                }
                break;
            }
            case 241: {
                for (i = 0; i < values.length; ++i) {
                    this.addTrailingShift(values[i]);
                }
                break;
            }
        }
        return "";
    }

    @Override
    public String setProp(Integer key, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.setProp(key, values[i], values[i].length());
        }
        return "";
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        int v = -1;
        boolean error = false;
        try {
            v = (int)Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        if (!error) {
            switch (key) {
                case 250: {
                    this.setPropWidth(v);
                    break;
                }
                case 40: {
                    this.setColors(v);
                    break;
                }
                case 41: {
                    this.setColorsRgb(v);
                    break;
                }
                case 218: {
                    this.addShading(v);
                    break;
                }
                case 174: {
                    this.addPositionShift(v);
                    break;
                }
                case 137: {
                    this.addLeadingShift(v);
                    break;
                }
                case 241: {
                    this.addTrailingShift(v);
                    break;
                }
                default: {
                    return super.setProp(key, value, length);
                }
            }
            return "";
        }
        return super.setProp(key, value, length);
    }

    private void intSetStyle(int st) {
        PicobolBar pb;
        this.style = st;
        if (st != -1 && (pb = (PicobolBar)this.getComponent()) != null) {
            pb.setStyle(st);
        }
    }

    @Override
    public void setStyle(int s, boolean set) {
        if (set) {
            switch (s) {
                case 2: {
                    this.intSetStyle(1);
                    break;
                }
                case 1: {
                    this.intSetStyle(2);
                    break;
                }
                case 3: {
                    this.intSetStyle(3);
                }
            }
        } else {
            this.intSetStyle(-1);
        }
    }

    private void intSetting(boolean init) {
        PicobolBar pb = (PicobolBar)this.getComponent();
        if (pb != null) {
            int i;
            int[] ls = new int[Math.max(this.leadingShift.length, this.propWidth)];
            int[] ts = new int[Math.max(this.trailingShift.length, this.propWidth)];
            int minLeadingShift = 0;
            int maxLeadingShift = 0;
            int minTrailingShift = 0;
            int maxTrailingShift = 0;
            int len = 0;
            for (i = 0; i < this.leadingShift.length; ++i) {
                if (this.leadingShift[i] < minLeadingShift) {
                    minLeadingShift = this.leadingShift[i];
                }
                if (this.leadingShift[i] <= maxLeadingShift) continue;
                maxLeadingShift = this.leadingShift[i];
            }
            for (i = 0; i < this.leadingShift.length; ++i) {
                ls[i] = this.leadingShift[i] - minLeadingShift;
            }
            while (i < this.propWidth) {
                ls[i] = -minLeadingShift;
                ++i;
            }
            pb.setLeadingShift(ls);
            for (i = 0; i < this.trailingShift.length; ++i) {
                if (this.trailingShift[i] < minTrailingShift) {
                    minTrailingShift = this.trailingShift[i];
                }
                if (this.trailingShift[i] <= maxTrailingShift) continue;
                maxTrailingShift = this.trailingShift[i];
            }
            for (i = 0; i < this.trailingShift.length; ++i) {
                ts[i] = maxTrailingShift - this.trailingShift[i];
            }
            while (i < this.propWidth) {
                ts[i] = maxTrailingShift;
                ++i;
            }
            pb.setTrailingShift(ts);
            pb.setShading(this.shading);
            pb.setColors(this.colors);
            if (init || pb.getParent() == null || !(pb.getParent().getLayout() instanceof IscobolLayout)) {
                len = this.height;
                if (len > 0 && len > this.width) {
                    pb.setVertical();
                    pb.setSize(this.propWidth, len + maxTrailingShift - minLeadingShift);
                    if (this.positionShift != 0) {
                        Point p = pb.getLocation();
                        pb.setLocation(p.x + this.positionShift, p.y);
                    }
                } else {
                    pb.setHorizontal();
                    len = this.width;
                    pb.setSize(len + maxTrailingShift - minLeadingShift, this.propWidth);
                    if (this.positionShift != 0) {
                        Point p = pb.getLocation();
                        pb.setLocation(p.x, p.y + this.positionShift);
                    }
                }
            }
            this.colors = new Color[0];
            this.shading = new int[0];
            this.leadingShift = new int[0];
            this.trailingShift = new int[0];
        }
    }

    @Override
    public void displayProp() {
        if (this.getComponent() != null) {
            this.intSetting(false);
        }
    }

    @Override
    public boolean isInputField() {
        return false;
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    protected void intFocusGained(boolean restore) {
    }

    @Override
    public void setBorder(boolean v) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
    }

    @Override
    public void setRowsCols(float rows, float cols) {
    }

    @Override
    public String setValue(String v) {
        return v;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public void setTitle(String v) {
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
    }

    @Override
    public void setCols(float c) {
    }

    @Override
    public void setRows(float r) {
    }

    @Override
    public Rectangle getRealBounds() {
        Rectangle rect = super.getRealBounds();
        if (this.height > 0) {
            rect.width = this.propWidth;
        } else {
            rect.height = this.propWidth;
        }
        return rect;
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        if (ps.sizes > 0.0f) {
            return ps.sizes;
        }
        return super.paramgetDefaultWidth(ps, origWidth);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle Return2 = super.getBounds();
        if (Return2 == null) {
            Return2 = new Rectangle();
        }
        Return2.width = this.propWidth;
        return Return2;
    }

    @Override
    public String getType() {
        if (this.guiComponent == null || ((Bar)((Object)this.guiComponent)).isHorizontal()) {
            return "hbar";
        }
        return "vbar";
    }

    @Override
    protected String getDefaultLayoutData(IscobolLayout l) {
        if (l.hasDefaultLayoutData(this.getType()) || !l.hasDefaultLayoutData("bar")) {
            return l.getDefaultLayoutDataString(this.getType());
        }
        return l.getDefaultLayoutDataString("bar");
    }

    @Override
    public void adjustBounds(Rectangle Return2) {
        Return2.width = this.propWidth;
    }
}

