/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.CobolFocusable;
import com.iscobol.gui.Constants;
import com.iscobol.gui.Events;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.LocLinkedList;
import com.iscobol.gui.MouseInfo;
import com.iscobol.gui.ParamElementIntInt;
import com.iscobol.gui.ParamElementIntString;
import com.iscobol.gui.ParamElementWindowLocation;
import com.iscobol.gui.ParamVElement;
import com.iscobol.gui.ParamVector;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenInfo;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.Client;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.gui.client.Terminal;
import com.iscobol.gui.client.TerminalModel;
import com.iscobol.gui.client.ZoomLayout;
import com.iscobol.gui.client.swing.BorderedFrame;
import com.iscobol.gui.client.swing.BorderedScrollPane;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.MainPanel;
import com.iscobol.gui.client.swing.MsgBoxEvent;
import com.iscobol.gui.client.swing.MsgBoxListener;
import com.iscobol.gui.client.swing.MyToolBar;
import com.iscobol.gui.client.swing.PopupListener;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteBaseGUIWindow;
import com.iscobol.gui.client.swing.RemoteBitmap;
import com.iscobol.gui.client.swing.RemoteDisplayToolBar;
import com.iscobol.gui.client.swing.RemoteFrame;
import com.iscobol.gui.client.swing.RemoteMenu;
import com.iscobol.gui.client.swing.RemotePushButton;
import com.iscobol.gui.client.swing.RemoteStatusBar;
import com.iscobol.gui.client.swing.RemoteSubWindow;
import com.iscobol.gui.client.swing.RemoteTab;
import com.iscobol.gui.client.swing.RemoteTerminalAccept;
import com.iscobol.gui.client.swing.RemoteTerminalDisplay;
import com.iscobol.gui.client.swing.SwingFontCmp;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.gui.client.swing.WebClientListener;
import com.iscobol.gui.client.swing.WebClientUtility;
import com.iscobol.logger.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.basic.ComboPopup;

public class RemoteDisplayWindow
extends RemoteBaseGUIWindow
implements Constants,
MsgBoxListener {
    public static final boolean DEF_ACCEPT_BEFORE_TIME_REPEAT = false;
    public static final int TITLE_TOP_LEFT = 1;
    public static final int TITLE_TOP_CENTER = 2;
    public static final int TITLE_TOP_RIGHT = 3;
    public static final int TITLE_BOTTOM_LEFT = 4;
    public static final int TITLE_BOTTOM_CENTER = 5;
    public static final int TITLE_BOTTOM_RIGHT = 6;
    public static final int TITLE_FULL_CENTER = 7;
    private WebClientListener wcListener;
    private PicobolTimer pTimer;
    protected int type = -1;
    protected boolean resizable;
    protected boolean autoResize;
    protected float maxColumns;
    protected float maxLines;
    protected float minColumns;
    protected float minLines;
    protected boolean withSystemMenu;
    protected int fontId = -1;
    protected LocalFontCmp font;
    protected float cellWidth = 1.0f;
    protected float cellHeight = 1.0f;
    int waitCursorDelay;
    private MouseInfo mouseInfo = new MouseInfo();
    public BorderedFrame mainWindow;
    private StringSelection selectedText;
    protected RemoteDisplayWindow parent;
    PopupListener popupListener;
    protected RemoteMenu menu;
    RemoteMenu popupMenu;
    private int modalWindowChildren;
    private int foregroundIndex = -1;
    private int backgroundIndex = -1;
    private Rectangle maxBounds;
    private int mouseFlags;
    private boolean enabledkb;
    private ComponentListener resizeListener;
    private int width;
    private int height;
    private LocLinkedList childSubWindow;
    private boolean noCloseStyle;
    private CobolFocusable focusOwner;
    private CobolFocusable previousFocusOwner;
    private Hashtable mnemonicTable = new Hashtable();
    private boolean firstActivation = true;
    private boolean visible = true;
    private PropertyChangeListener pcListener;
    private boolean acceptbeforetimerepeat;
    private long beforetimehs = -1L;
    private CobolFocusable newLocalFocusOwner;
    private ParamVector oldfocusvalues;
    private Hashtable oldfocushnd;
    boolean fixedAutoResizeDim;
    private boolean updown_like_prevnext;
    private NtfResizeTimer ntfResizeTimer;
    private boolean keyboardenabwhendestroy;
    private ComponentListener ca;
    private MouseStopTimer mouseStopTimer;
    private RemoteSubWindow rswcurrent;
    private KeyListener kl;
    private MouseListener ml;
    private MouseMotionListener mml;
    private WindowAdapter wListener;
    private boolean massupdate = false;
    private boolean actionmaximizepostponed = false;
    private boolean hasinmenu;
    private static final int INVALID_COOR = -99999;

    public RemoteDisplayWindow(Events evs, GuiFactoryImpl gf, int t, int pwId) {
        super(gf);
        WebClientUtility wcu;
        this.childSubWindow = new LocLinkedList();
        this.waitCursorDelay = gf.getCsProperty().get("iscobol.gui.waitcursordelay", 0);
        this.acceptbeforetimerepeat = gf.getCsProperty().get("iscobol.gui.accept.before_time.repeat", false);
        this.fixedAutoResizeDim = gf.getCsProperty().get("iscobol.gui.window.auto_resize.fixed_dim", true);
        this.updown_like_prevnext = gf.getCsProperty().get("iscobol.keystroke.updown_like_prevnext", false);
        this.keyboardenabwhendestroy = gf.getCsProperty().get("iscobol.gui.keyboard_enab_when_destroy", false);
        this.pcListener = evt -> {
            if (gf != null) {
                String key = evt.getPropertyName();
                if (key.equals("iscobol.gui.waitcursordelay")) {
                    this.waitCursorDelay = gf.getCsProperty().get("iscobol.gui.waitcursordelay", 0);
                } else if (key.equals("iscobol.gui.accept.before_time.repeat")) {
                    this.acceptbeforetimerepeat = gf.getCsProperty().get("iscobol.gui.accept.before_time.repeat", false);
                } else if (key.equals("iscobol.gui.window.auto_resize.fixed_dim")) {
                    this.fixedAutoResizeDim = gf.getCsProperty().get("iscobol.gui.window.auto_resize.fixed_dim", true);
                    if (this.mainWindow != null) {
                        this.mainWindow.setFixedAutoResizeDim(this.fixedAutoResizeDim);
                    }
                } else if (key.equals("iscobol.gui.ntf_resized_delay")) {
                    this.ntfResizeTimer.setInitialDelay(gf.getCsProperty().get("iscobol.gui.ntf_resized_delay", 0));
                } else if (key.equals("iscobol.gui.keyboard_enab_when_destroy")) {
                    this.keyboardenabwhendestroy = gf.getCsProperty().get("iscobol.gui.keyboard_enab_when_destroy", false);
                } else if (key.equals("iscobol.help_program_mouse_stop_delay")) {
                    int d = gf.getCsProperty().get("iscobol.help_program_mouse_stop_delay", 0);
                    if (d > 0) {
                        if (this.mouseStopTimer == null) {
                            this.mouseStopTimer = new MouseStopTimer(d);
                        } else {
                            this.mouseStopTimer.setInitialDelay(d);
                        }
                    } else {
                        if (this.mouseStopTimer != null) {
                            this.mouseStopTimer.cancel();
                        }
                        this.mouseStopTimer = null;
                    }
                }
            }
        };
        this.ntfResizeTimer = new NtfResizeTimer(gf.getCsProperty().get("iscobol.gui.ntf_resized_delay", 0));
        int d = gf.getCsProperty().get("iscobol.help_program_mouse_stop_delay", 0);
        if (d > 0) {
            this.mouseStopTimer = new MouseStopTimer(d);
        }
        if ((wcu = gf.getWebClient()) != null) {
            this.wcListener = e -> {
                RemoteRecordAccept rra = new RemoteRecordAccept(4, WebClientUtility.getCommunicationStatusValue(), 0, true, true);
                this.mainWindow.push(new CobolEventCouple(this, rra));
            };
            wcu.addWebClientListener(this.wcListener);
        }
        gf.getCsProperty().addPropertyChangeListener(this.pcListener);
        this.initW(evs, t, pwId);
        this.setDefaultLayoutManager();
    }

    public void setId(int wId) {
        this.theObject = wId;
    }

    public int getId() {
        return this.theObject;
    }

    public void setFocusOwner(CobolFocusable cf) {
        if (this.focusOwner != null) {
            this.previousFocusOwner = this.focusOwner;
        }
        this.focusOwner = cf;
    }

    @Override
    public CobolFocusable getFocusOwner() {
        return this.focusOwner;
    }

    public CobolFocusable getPreviousFocusOwner() {
        return this.previousFocusOwner;
    }

    void setPreviousFocusOwner(CobolFocusable pfo) {
        this.previousFocusOwner = pfo;
    }

    @Override
    public void addMnemonic(char c, RemoteBaseGUIControl comp) {
        Character key = new Character(Character.toUpperCase(c));
        Vector<RemoteBaseGUIControl> v = (Vector<RemoteBaseGUIControl>)this.mnemonicTable.get(key);
        if (v == null) {
            v = new Vector<RemoteBaseGUIControl>();
            this.mnemonicTable.put(key, v);
        }
        v.addElement(comp);
    }

    public void removeMnemonic(char c, RemoteBaseGUIControl comp) {
        Object[] keys = this.mnemonicTable.keySet().toArray();
        RemoteBaseGUIControl rbgc = null;
        ListIterator ctlLI = null;
        for (int i = 0; i < keys.length; ++i) {
            Vector v;
            if (c != '\u0000' && ((Character)keys[i]).charValue() != Character.toUpperCase(c) || (v = (Vector)this.mnemonicTable.get(keys[i])) == null) continue;
            RemoteBaseGUIControl[] comps = new RemoteBaseGUIControl[v.size()];
            v.toArray(comps);
            ctlLI = v.listIterator();
            while (ctlLI.hasNext()) {
                rbgc = (RemoteBaseGUIControl)ctlLI.next();
                if (rbgc != comp) continue;
                ctlLI.remove();
            }
            if (v.size() != 0) continue;
            this.mnemonicTable.remove(keys[i]);
        }
    }

    @Override
    public void removeMnemonic(RemoteBaseGUIControl comp) {
        this.removeMnemonic('\u0000', comp);
    }

    public RemoteBaseGUIControl getMnemonic(char c) {
        Character key = new Character(Character.toUpperCase(c));
        Vector v = (Vector)this.mnemonicTable.get(key);
        if (v == null) {
            return null;
        }
        RemoteBaseGUIControl rbgcok = null;
        RemoteBaseGUIControl rbgcexc = null;
        RemoteBaseGUIControl rbgctmp = null;
        int i = 0;
        for (i = 0; (rbgcok == null || rbgcexc == null) && i < v.size(); ++i) {
            rbgctmp = (RemoteBaseGUIControl)v.elementAt(i);
            if (!rbgctmp.isVisible() || !rbgctmp.isEnabled()) continue;
            if (rbgcexc == null && rbgctmp.hasExcValue()) {
                rbgcexc = rbgctmp;
                continue;
            }
            if (rbgcok != null) continue;
            rbgcok = rbgctmp;
        }
        return rbgcexc != null ? rbgcexc : rbgcok;
    }

    public RemoteBaseGUIControl checkMnemonic(KeyEvent evt) {
        RemoteBaseGUIControl comp = null;
        if (evt.isAltDown() && evt.getKeyLocation() != 4 && (comp = this.getMnemonic(evt.getKeyChar())) != null) {
            comp.processMnemonic(evt.getKeyChar());
        }
        return comp;
    }

    @Override
    public void clearFocusOwner() {
        if (this.focusOwner != null) {
            this.previousFocusOwner = this.focusOwner;
            this.focusOwner.processCobolFocusEvent(new CobolFocusEvent(this.focusOwner, null, 1, false));
            this.focusOwner = null;
        }
        this.isonexceptionaccept = false;
    }

    private int getMouseExc(MouseEvent me, int code) {
        return VirtualKeyboard.exception(this.gf.getRemoteVirtualKeyboard().mapMouseEvent(me, code));
    }

    protected final void handleMouseEvents(MouseEvent evt) {
        this.handleMouseEvents(evt, null, false, true);
    }

    protected final void handleMouseEvents(MouseEvent evt, RemoteBaseGUIControl rbgc, boolean stopTimer, boolean handleMouseFlags) {
        if (this.mouseStopTimer != null && rbgc != null) {
            if (stopTimer) {
                this.mouseStopTimer.cancel();
            } else {
                this.mouseStopTimer.restart(rbgc);
            }
        }
        if (!handleMouseFlags || this.mouseFlags == 0 || this.mainWindow == null) {
            return;
        }
        switch (evt.getID()) {
            case 501: {
                switch (evt.getButton()) {
                    case 1: {
                        if ((this.mouseFlags & 2) != 2) break;
                        this.mainWindow.push(new CobolEventCouple(this, RemoteRecordAccept.getRemoteMouseEvent(this.getMouseExc(evt, 10002), this.getMouseStatus())));
                        break;
                    }
                    case 2: {
                        if ((this.mouseFlags & 0x10) != 16) break;
                        this.mainWindow.push(new CobolEventCouple(this, RemoteRecordAccept.getRemoteMouseEvent(this.getMouseExc(evt, 10005), this.getMouseStatus())));
                        break;
                    }
                    case 3: {
                        if ((this.mouseFlags & 0x80) != 128) break;
                        this.mainWindow.push(new CobolEventCouple(this, RemoteRecordAccept.getRemoteMouseEvent(this.getMouseExc(evt, 10008), this.getMouseStatus())));
                    }
                }
                break;
            }
            case 502: {
                switch (evt.getButton()) {
                    case 1: {
                        if ((this.mouseFlags & 4) != 4) break;
                        this.mainWindow.push(new CobolEventCouple(this, RemoteRecordAccept.getRemoteMouseEvent(this.getMouseExc(evt, 10003), this.getMouseStatus())));
                        break;
                    }
                    case 2: {
                        if ((this.mouseFlags & 0x20) != 32) break;
                        this.mainWindow.push(new CobolEventCouple(this, RemoteRecordAccept.getRemoteMouseEvent(this.getMouseExc(evt, 10006), this.getMouseStatus())));
                        break;
                    }
                    case 3: {
                        if ((this.mouseFlags & 0x100) != 256) break;
                        this.mainWindow.push(new CobolEventCouple(this, RemoteRecordAccept.getRemoteMouseEvent(this.getMouseExc(evt, 10009), this.getMouseStatus())));
                    }
                }
                break;
            }
            case 500: {
                switch (evt.getButton()) {
                    case 1: {
                        if ((this.mouseFlags & 8) != 8) break;
                        this.mainWindow.push(new CobolEventCouple(this, RemoteRecordAccept.getRemoteMouseEvent(this.getMouseExc(evt, 10004), this.getMouseStatus())));
                        break;
                    }
                    case 2: {
                        if ((this.mouseFlags & 0x40) != 64) break;
                        this.mainWindow.push(new CobolEventCouple(this, RemoteRecordAccept.getRemoteMouseEvent(this.getMouseExc(evt, 10007), this.getMouseStatus())));
                        break;
                    }
                    case 3: {
                        if ((this.mouseFlags & 0x200) != 512) break;
                        this.mainWindow.push(new CobolEventCouple(this, RemoteRecordAccept.getRemoteMouseEvent(this.getMouseExc(evt, 10010), this.getMouseStatus())));
                    }
                }
                break;
            }
            case 503: 
            case 506: {
                if ((this.mouseFlags & 0x400) != 1024) break;
                this.mainWindow.push(new CobolEventCouple(this, RemoteRecordAccept.getRemoteMouseEvent(this.getMouseExc(evt, 10001), this.getMouseStatus())));
            }
        }
    }

    public MouseInfo getMouseStatus() {
        if (this.isActiveAccept()) {
            try {
                this.fillMouseInfo();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        return this.mouseInfo;
    }

    private void fillMouseInfo() {
        Point windowLoc = this.mainWindow.getWindow().getLocationOnScreen();
        Point panelScreenLoc = this.mainWindow.getPanel().getLocationOnScreen();
        Dimension panelSize = this.mainWindow.getPanel().getSize();
        int lastX = KeyboardBuffer.getLastCursorX() - panelScreenLoc.x + windowLoc.x;
        int lastY = KeyboardBuffer.getLastCursorY() - panelScreenLoc.y + windowLoc.y;
        if (lastX >= 0 && lastX < panelSize.width && lastY >= 0 && lastY < panelSize.height) {
            this.mouseInfo.setColPx(lastX);
            this.mouseInfo.setRowPx(lastY);
            this.mouseInfo.setColHundredths(lastX * 100 / this.getCellWidth() + 100);
            this.mouseInfo.setRowHundredths(lastY * 100 / this.getCellHeight() + 100);
            this.mouseInfo.setLeftDown(KeyboardBuffer.isLeftButtonDown());
            this.mouseInfo.setMiddleDown(KeyboardBuffer.isMiddleButtonDown());
            this.mouseInfo.setRightDown(KeyboardBuffer.isRightButtonDown());
        } else {
            this.mouseInfo.setColPx(0);
            this.mouseInfo.setRowPx(0);
            this.mouseInfo.setColHundredths(0);
            this.mouseInfo.setRowHundredths(0);
            this.mouseInfo.setLeftDown(false);
            this.mouseInfo.setMiddleDown(false);
            this.mouseInfo.setRightDown(false);
        }
    }

    private void initW(Events evs, int t, int pwId) {
        this.type = t;
        this.events = evs;
        this.parent = (RemoteDisplayWindow)this.gf.getClient().getId(pwId);
        this.mainWindow = this.parent != null ? new BorderedFrame(this, this.parent.getMainWindow(), this.type) : new BorderedFrame(this, null, this.type);
        this.addwlistener();
    }

    void addwlistener() {
        this.wListener = new WindowAdapter(){
            private boolean deiconified;

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (!Client.isWebClient() || e.getOppositeWindow() != null && e.getOppositeWindow().getType() != Window.Type.POPUP) {
                    RemoteDisplayWindow.this.previousFocusOwner = null;
                }
            }

            @Override
            public void windowIconified(WindowEvent e) {
                CobolEventCouple cc = new CobolEventCouple(RemoteDisplayWindow.this, new RemoteRecordAccept(21, 203, 0));
                if (RemoteDisplayWindow.this.mainWindow != null) {
                    RemoteDisplayWindow.this.mainWindow.push(cc);
                }
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                this.deiconified = true;
                CobolEventCouple cc = new CobolEventCouple(RemoteDisplayWindow.this, new RemoteRecordAccept(21, 204, 0));
                if (RemoteDisplayWindow.this.mainWindow != null) {
                    RemoteDisplayWindow.this.mainWindow.push(cc);
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                Logger guiLog = null;
                if (RemoteDisplayWindow.this.mainWindow != null) {
                    guiLog = RemoteDisplayWindow.this.mainWindow.getGuiLog();
                }
                Window opp = e.getOppositeWindow();
                String t = RemoteDisplayWindow.this.getTitle();
                if (guiLog != null) {
                    guiLog.info("windowGainedFocus id [" + e.getID() + "] , windowActivate [" + t + "] activeWindow [" + RemoteDisplayWindow.this.activeWindow + "] deiconified [" + this.deiconified + "] firstActivation [" + RemoteDisplayWindow.this.firstActivation + "] modalWindowChildren [" + RemoteDisplayWindow.this.modalWindowChildren + "] focusOwner [" + RemoteDisplayWindow.this.focusOwner + "] opp [" + opp + "] mainWindow [" + RemoteDisplayWindow.this.mainWindow + "] e [" + e + "] [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() + "]");
                }
                if (!RemoteDisplayWindow.this.firstActivation && RemoteDisplayWindow.this.modalWindowChildren == 0 && RemoteDisplayWindow.this.mainWindow != null && !RemoteDisplayWindow.this.activeWindow) {
                    if (guiLog != null) {
                        guiLog.info("RDW:[" + t + "]----------------------------------- 1");
                    }
                    if (opp == null) {
                        if (guiLog != null) {
                            guiLog.info("RDW:[" + t + "]----------------------------------- 1 + 1");
                        }
                        CobolEventCouple cc = new CobolEventCouple(RemoteDisplayWindow.this, new RemoteRecordAccept(21, 205, this.deiconified ? 0 : 1));
                        cc.sendToServer();
                    } else {
                        if (guiLog != null) {
                            guiLog.info("RDW:[" + t + "]----------------------------------- 1 + 2");
                        }
                        if (opp instanceof BorderedFrame.MyWindow && !((BorderedFrame.MyWindow)((Object)opp)).isDestroyed()) {
                            if (guiLog != null) {
                                guiLog.info("RDW:[" + t + "]----------------------------------- 1 + 2 + 1");
                            }
                            CobolEventCouple cc = new CobolEventCouple(RemoteDisplayWindow.this, new RemoteRecordAccept(21, 205, 0));
                            cc.sendToServer();
                        }
                    }
                } else {
                    if (guiLog != null) {
                        guiLog.info("RDW:[" + t + "]----------------------------------- 2");
                    }
                    if (RemoteDisplayWindow.this.activeWindow && (RemoteDisplayWindow.this.hasControls() && RemoteDisplayWindow.this.getFocusOwner() != null || RemoteDisplayWindow.this.isAcceptOmitted())) {
                        if (guiLog != null) {
                            guiLog.info("RDW:[" + t + "]----------------------------------- 2 + 1 lastactivate [" + KeyboardBuffer.getlastmsgactivate() + "] lastdeactivate [" + KeyboardBuffer.getlastmsgdeactivate() + "]");
                        }
                        if (!(RemoteDisplayWindow.this.enabledkb = KeyboardBuffer.isEnabled()) && RemoteDisplayWindow.this.enableKeyboard() && opp == null) {
                            if (guiLog != null) {
                                guiLog.info("RDW:[" + t + "]----------------------------------- 2 + 1 + 1 lastactivate [" + KeyboardBuffer.getlastmsgactivate() + "] lastdeactivate [" + KeyboardBuffer.getlastmsgdeactivate() + "]");
                            }
                            if (RemoteDisplayWindow.this.focusOwner != null && RemoteDisplayWindow.this.focusOwner instanceof RemoteBaseGUIControl) {
                                RemoteBaseGUIControl rbgc;
                                if (guiLog != null) {
                                    guiLog.info("RDW:[" + t + "]----------------------------------- 2 + 1 + 1 + 1");
                                }
                                if ((rbgc = (RemoteBaseGUIControl)RemoteDisplayWindow.this.focusOwner).getComponent() != null) {
                                    if (guiLog != null) {
                                        guiLog.info("RDW:[" + t + "]----------------------------------- 2 + 1 + 1 + 1 + 1");
                                    }
                                    if (!rbgc.getComponent().hasFocus()) {
                                        if (guiLog != null) {
                                            guiLog.info("RDW:[" + t + "]----------------------------------- 2 + 1 + 1 + 1 + 1 + 1 + RFIW");
                                        }
                                        rbgc.getComponent().requestFocusInWindow();
                                    }
                                } else {
                                    if (guiLog != null) {
                                        guiLog.info("RDW:[" + t + "]----------------------------------- 2 + 1 + 1 + 1 + 2");
                                    }
                                    RemoteDisplayWindow.this.requestFocus();
                                }
                            } else {
                                if (guiLog != null) {
                                    guiLog.info("RDW:[" + t + "]----------------------------------- 2 + 1 + 1 + 2");
                                }
                                RemoteDisplayWindow.this.requestFocus();
                            }
                        } else {
                            RemoteBaseGUIControl rbgc;
                            Component fow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                            if (guiLog != null) {
                                guiLog.info("RDW:[" + t + "]----------DEICONIFIED-------------");
                            }
                            if (this.deiconified && RemoteDisplayWindow.this.enabledkb && opp == null && fow == null && RemoteDisplayWindow.this.focusOwner != null && RemoteDisplayWindow.this.focusOwner instanceof RemoteBaseGUIControl && (rbgc = (RemoteBaseGUIControl)RemoteDisplayWindow.this.focusOwner).getComponent() != null && !rbgc.getComponent().hasFocus()) {
                                Window window = SwingUtilities.getWindowAncestor((Component)((Object)rbgc.getComponent()));
                                if (window != null && window.isShowing() && window.isFocusable() && window.isEnabled() && !window.hasFocus()) {
                                    window.requestFocus();
                                }
                                rbgc.getComponent().requestFocusInWindow();
                            }
                        }
                    }
                }
                RemoteDisplayWindow.this.firstActivation = false;
                this.deiconified = false;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (RemoteDisplayWindow.this.noCloseStyle) {
                    return;
                }
                if (RemoteDisplayWindow.this.modalWindowChildren == 0) {
                    if (RemoteDisplayWindow.this.type != 3 && RemoteDisplayWindow.this.type != 6 && !RemoteDisplayWindow.this.withSystemMenu) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        if (RemoteDisplayWindow.this.getFocusOwner() != null) {
                            ((RemoteBaseGUIControl)RemoteDisplayWindow.this.getFocusOwner()).requestFocusLostComponent(RemoteDisplayWindow.this);
                        }
                        if (RemoteDisplayWindow.this.mainWindow != null) {
                            RemoteDisplayWindow.this.mainWindow.push(new CobolEventCouple(RemoteDisplayWindow.this, new RemoteRecordAccept(21, e.getID(), 0)));
                        }
                    }
                }
            }
        };
        this.mainWindow.getMyWindow().addWindowListener(this.wListener);
        this.mainWindow.getMyWindow().addWindowFocusListener(this.wListener);
        this.kl = IsguiUtility.keyPressedAdapter(evt -> {
            MenuElement[] selPath = MenuSelectionManager.defaultManager().getSelectedPath();
            if (selPath != null && selPath.length > 0) {
                if (evt.getKeyCode() == 10) {
                    RemoteMenu.fireActionEvent(selPath[selPath.length - 1]);
                }
                return;
            }
            if (!evt.isAltDown() && !evt.isControlDown()) {
                this.stopTimer();
            }
            this.checkMnemonic((KeyEvent)evt);
            CobolEventCouple cc = null;
            int cobFun = this.gf.getRemoteVirtualKeyboard().mapKey((KeyEvent)evt);
            if ((cobFun & 0x300000) == 0x300000) {
                return;
            }
            cc = this.checkDefaultButton(cobFun);
            if (cc != null) {
                return;
            }
            cc = this.checkEscapeButton(cobFun);
            if (cc != null) {
                this.mainWindow.push(cc);
                return;
            }
            if (this.mainWindow != null) {
                if (VirtualKeyboard.isHotkey(cobFun)) {
                    this.mainWindow.push(new CobolEventCouple(this, RemoteRecordAccept.getHotkeyEvent(cobFun, false, this.gf.getRemoteVirtualKeyboard().getHotKey(cobFun, evt.isShiftDown(), evt.isControlDown(), evt.isAltDown()))));
                } else if (VirtualKeyboard.exception(cobFun) >= 0 || VirtualKeyboard.isException(cobFun)) {
                    RemoteRecordAccept rra = new RemoteRecordAccept(4, VirtualKeyboard.exception(cobFun), 0, true, true);
                    rra.setWait(false);
                    this.mainWindow.push(new CobolEventCouple(this, rra));
                } else if (VirtualKeyboard.termination(cobFun) >= 0 || VirtualKeyboard.isTermination(cobFun)) {
                    this.mainWindow.push(new CobolEventCouple(this, new RemoteRecordAccept(3, VirtualKeyboard.termination(cobFun), 0, true, false)));
                }
            }
        });
        this.mainWindow.getPanel().addKeyListener(this.kl);
        this.ml = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    RemoteDisplayWindow.this.handleMouseEvents(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Terminal t = RemoteDisplayWindow.this.mainWindow.getCharTerminal();
                int mcode = -1;
                if (e.getButton() == 1) {
                    mcode = 10002;
                } else if (e.getButton() == 2) {
                    mcode = 10005;
                } else if (e.getButton() == 3) {
                    mcode = 10008;
                }
                boolean pasteevent = false;
                int cobExtFun = RemoteDisplayWindow.this.gf.getRemoteVirtualKeyboard().mapMouseExtKey(e, mcode);
                if (cobExtFun > 0 && (cobExtFun & 0x20000) == 131072) {
                    pasteevent = true;
                }
                if (t != null && !t.isEmpty() && t.getTerminalModel() != null && t.getTerminalModel().isDragEnabled()) {
                    TerminalModel tm = t.getTerminalModel();
                    if (e.getButton() == 1) {
                        tm.getSelection().x1 = tm.getSelection().x2 = e.getX() / t.getCharDim().width;
                        tm.getSelection().y1 = tm.getSelection().y2 = e.getY() / t.getCharDim().height;
                        t.myrepaint();
                    } else if (pasteevent) {
                        if (RemoteDisplayWindow.this.getFocusOwner() != null && RemoteDisplayWindow.this.getFocusOwner() instanceof RemoteTerminalAccept) {
                            ((RemoteTerminalAccept)RemoteDisplayWindow.this.getFocusOwner()).clear();
                        }
                        Clipboard clipboard = t.getToolkit().getSystemClipboard();
                        Transferable data = clipboard.getContents(t);
                        try {
                            String text = (String)data.getTransferData(DataFlavor.stringFlavor);
                            KeyboardBuffer.insertString(t, text);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                RemoteDisplayWindow.this.handleMouseEvents(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                String str;
                final Terminal t = RemoteDisplayWindow.this.mainWindow.getCharTerminal();
                if (t != null && !t.isEmpty() && t.getTerminalModel() != null && t.getTerminalModel().isDragEnabled() && e.getButton() == 1 && t.getTerminalModel().getSelection().x1 != -1 && (str = t.getTerminalModel().getSelectedText().toString()).length() > 0) {
                    RemoteDisplayWindow.this.selectedText = new StringSelection(str){

                        @Override
                        public void lostOwnership(Clipboard c, Transferable trnsf) {
                            TerminalModel tm;
                            if (this == RemoteDisplayWindow.this.selectedText && (tm = t.getTerminalModel()) != null) {
                                tm.getSelection().x1 = -1;
                                tm.getSelection().y1 = -1;
                                t.myrepaint();
                            }
                        }
                    };
                    Clipboard clipboard = t.getToolkit().getSystemClipboard();
                    clipboard.setContents(RemoteDisplayWindow.this.selectedText, RemoteDisplayWindow.this.selectedText);
                }
                RemoteDisplayWindow.this.handleMouseEvents(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        this.mainWindow.getPanel().addMouseListener(this.ml);
        this.mml = new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                RemoteDisplayWindow.this.handleMouseEvents(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Terminal t = RemoteDisplayWindow.this.mainWindow.getCharTerminal();
                if (t != null && !t.isEmpty() && t.getTerminalModel() != null && t.getTerminalModel().isDragEnabled()) {
                    TerminalModel tm = t.getTerminalModel();
                    if (tm.getSelection().x1 != -1) {
                        int getx = e.getX() / t.getCharDim().width;
                        int gety = e.getY() / t.getCharDim().height;
                        tm.getSelection().x2 = getx > 0 ? getx : 0;
                        tm.getSelection().y2 = gety > 0 ? gety : 0;
                        t.myrepaint();
                    }
                }
                RemoteDisplayWindow.this.handleMouseEvents(e);
            }
        };
        this.mainWindow.getPanel().addMouseMotionListener(this.mml);
    }

    @Override
    protected void setDefaultButton(RemotePushButton db) {
        super.setDefaultButton(db);
        db = super.getDefaultButton();
        if (db != null) {
            this.mainWindow.setDefaultButton((JButton)((Object)db.getComponent()));
        } else {
            this.mainWindow.setDefaultButton(null);
        }
    }

    @Override
    protected void updateDefaultButton() {
        super.updateDefaultButton();
        RemotePushButton db = super.getDefaultButton();
        if (db != null) {
            this.mainWindow.setDefaultButton((JButton)((Object)db.getComponent()));
        } else {
            this.mainWindow.setDefaultButton(null);
        }
    }

    @Override
    protected void setTemporaryDefaultButton(RemotePushButton db) {
        super.setTemporaryDefaultButton(db);
        if (db != null) {
            this.mainWindow.setDefaultButton((JButton)((Object)db.getComponent()));
        } else if (super.getDefaultButton() != null) {
            this.mainWindow.setDefaultButton((JButton)((Object)super.getDefaultButton().getComponent()));
        } else {
            this.mainWindow.setDefaultButton(null);
        }
    }

    @Override
    public boolean isMainApplicationWindow() {
        return this.type == 3 || this.type == 6;
    }

    public BorderedFrame getMainWindow() {
        return this.mainWindow;
    }

    @Override
    public int setFont(String name, int style, int size) {
        if (this.font != null && LocalFontCmp.equals(this.font, name, style, size)) {
            return this.fontId;
        }
        this.font = new SwingFontCmp(this.gf, name, style, (float)size, false);
        this.fontId = this.gf.getClient().setId(this.font);
        this.setCellWidth(this.font.getWidth());
        this.setCellHeight(this.font.getHeight());
        if (this.mainWindow != null) {
            this.mainWindow.getPanel().setFont(this.font.getFont());
        }
        return this.fontId;
    }

    @Override
    public void setFont(int fi) {
        LocalFontCmp tmpfont = (LocalFontCmp)this.gf.getClient().getId(fi);
        if (this.font != null && this.font.equals(tmpfont)) {
            return;
        }
        this.fontId = fi;
        this.font = tmpfont;
        if (this.font != null) {
            this.setCellWidth(this.font.getWidth());
            this.setCellHeight(this.font.getHeight());
            if (this.mainWindow != null) {
                this.mainWindow.getPanel().setFont(this.font.getFont());
            }
        } else {
            this.fontId = 0;
        }
    }

    @Override
    public Insets getInsets() {
        return this.mainWindow.getInsets();
    }

    @Override
    public void setLocation(int x, int y) {
        this.mainWindow.setLocation(x, y);
    }

    public void setScreenInfoLocation() {
        Rectangle rect = this.gf.getScreenInfo().getPhysicalMonitorBounds(this.screenindex);
        if (rect == null) {
            rect = new Rectangle(0, 0, 0, 0);
        }
        this.mainWindow.setLocation(rect.x, rect.y);
    }

    @Override
    public void setDefaultLocation(int ownerWindowID) {
        Rectangle rwBounds = null;
        Rectangle rect = null;
        GraphicsConfiguration grc = null;
        RemoteDisplayWindow rw = null;
        rw = (RemoteDisplayWindow)this.gf.getClient().getId(ownerWindowID);
        if (rw == null || rw.mainWindow == null || this.mainWindow == null) {
            return;
        }
        if (rw.type == 10) {
            if (rw.parent != null && rw.parent.type == 9) {
                rw = rw.parent;
            } else {
                return;
            }
        }
        rwBounds = rw.mainWindow.getBounds();
        Dimension sz = this.mainWindow.getSize();
        int startX = 0;
        int startY = 0;
        if (this.screenindex == 0 || this.gf != null && this.gf.getScreenInfo() != null && this.screenindex > 0 && rw.getScreenIndex() == this.screenindex) {
            startX = rwBounds.x + (rwBounds.width - sz.width) / 2;
            startY = rwBounds.y + (rwBounds.height - sz.height) / 2;
            if (this.screenindex == 0 && (rect = (grc = rw.mainWindow.getWindow().getGraphicsConfiguration()).getBounds()) != null) {
                if (startX < rect.x) {
                    startX = rect.x;
                } else if (startX + sz.width > rect.x + rect.width) {
                    startX = rect.x + rect.width - sz.width;
                }
                if (startY < rect.y) {
                    startY = rect.y;
                } else if (startY + sz.height > rect.y + rect.height) {
                    startY = rect.y + rect.height - sz.height;
                }
            }
        } else if (this.screenindex > 0 && this.gf != null && this.gf.getScreenInfo() != null) {
            this.setScreenInfoLocation();
            return;
        }
        this.mainWindow.setLocation(startX, startY);
    }

    private void initWH(float cols, float lines) {
        this.width = (int)(cols * (float)this.getCellWidth());
        this.height = (int)(lines * (float)this.getCellHeight());
    }

    @Override
    public void setSize(float cols, float lines) {
        this.initWH(cols, lines);
        this.mainWindow.setInitD(this.width, this.height, cols, lines, this.font);
    }

    @Override
    public void setSizeTH(float cols, float lines) {
        if (this.mainWindow != null && this.mainWindow.isJDialog() && this.gf.getM27901initdcalledineventqueue() && this.mainWindow.getWindow().isVisible()) {
            this.initWH(cols, lines);
            this.mainWindow.setInitD(this.width, this.height, cols, lines, this.font, true);
        } else {
            this.setSize(cols, lines);
        }
    }

    @Override
    public void remove(int controlID) {
        this.remove(controlID, true);
    }

    @Override
    public void remove(int controlID, boolean wait) {
        Object o = this.gf.getClient().getId(controlID);
        if (o instanceof RemoteBaseGUIControl) {
            RemoteBaseGUIControl comp = (RemoteBaseGUIControl)o;
            if (this.mainWindow != null && this.mainWindow.getPanel() != null) {
                if (wait) {
                    new IsguiWorker(true, () -> this.mainWindow.getPanel().remove((Component)((Object)comp.getComponent()))).start();
                } else {
                    this.mainWindow.getPanel().remove((Component)((Object)comp.getComponent()));
                }
            }
            if (this.childGraphics != null) {
                this.childGraphics.remove(comp.getComponent());
            }
            if (comp == this.focusOwner) {
                this.focusOwner.processCobolFocusEvent(new CobolFocusEvent(this.focusOwner, null, 1, false));
                this.focusOwner = null;
            }
        } else if (o instanceof RemoteDisplayToolBar && this.mainWindow != null) {
            this.mainWindow.removeToolBar((RemoteDisplayToolBar)o);
            if (!this.mainWindow.getMassUpdate()) {
                ((RemoteDisplayToolBar)o).destroy();
            }
        }
    }

    @Override
    public void close(int controlID, boolean nodisp) {
        Object o = this.gf.getClient().getId(controlID);
        if (o != null && o instanceof RemoteSubWindow) {
            ((RemoteSubWindow)o).restorePopupArea(nodisp);
            ((RemoteSubWindow)o).destroy();
            this.setDoEraseTerminal(true);
        }
    }

    public static int getZOrder(RemoteBaseGUIControl rbgc) {
        if (rbgc.getType() == "bitmap" && !((RemoteBitmap)rbgc).hasEvents()) {
            return 6;
        }
        if (rbgc.getType() == "tab") {
            return 5;
        }
        if (rbgc.getType() == "frame") {
            if (((RemoteFrame)rbgc).hasFillColor()) {
                return 4;
            }
            return 3;
        }
        if (rbgc.isInputField()) {
            return 1;
        }
        return 2;
    }

    private static boolean intersects(RemoteBaseGUIControl container, RemoteBaseGUIControl contained) {
        return (RemoteDisplayWindow.isTabControl(container) && (RemoteDisplayWindow.isFrame(contained) || RemoteDisplayWindow.isBitmapWithoutEvents(contained)) || RemoteDisplayWindow.isFrame(container) && (RemoteDisplayWindow.isTabControl(contained) || RemoteDisplayWindow.isBitmapWithoutEvents(contained)) || RemoteDisplayWindow.isBitmapWithoutEvents(container) && (RemoteDisplayWindow.isFrame(contained) || RemoteDisplayWindow.isTabControl(contained))) && container.getComponent().getBounds().intersects(contained.getComponent().getBounds());
    }

    private static boolean isTabControl(RemoteBaseGUIControl rbgc) {
        return rbgc.getType() == "tab";
    }

    private static boolean isFrame(RemoteBaseGUIControl rbgc) {
        return rbgc.getType() == "frame";
    }

    private static boolean isBitmapWithoutEvents(RemoteBaseGUIControl rbgc) {
        return rbgc.getType() == "bitmap" && !((RemoteBitmap)rbgc).hasEvents();
    }

    public void reorderComponents(String[] types) {
        Component[] controls = this.mainWindow.getPanel().getComponents();
        for (int i = 0; i < controls.length - 1; ++i) {
            int index;
            RemoteBaseGUIControl rbgc = (RemoteBaseGUIControl)this.childGraphics.get(controls[i]);
            boolean ok = false;
            if (rbgc != null) {
                for (int t = 0; t < types.length; ++t) {
                    if (rbgc.getType() != types[t]) continue;
                    ok = true;
                    break;
                }
            }
            if (!ok) continue;
            int oldIndex = -1;
            for (index = 0; index < controls.length - 1; ++index) {
                if (controls[index] != rbgc.getComponent()) {
                    RemoteBaseGUIControl c = (RemoteBaseGUIControl)this.childGraphics.get(controls[index]);
                    if (!RemoteDisplayWindow.shouldInsertBefore(rbgc, c)) continue;
                    break;
                }
                oldIndex = index;
            }
            if (oldIndex >= 0) {
                --index;
            }
            if (index == oldIndex) continue;
            MainPanel mp = this.mainWindow.getPanel();
            LayoutManager lm = mp.getLayout();
            if (lm instanceof IscobolLayout) {
                Component comp = (Component)((Object)rbgc.getComponent());
                mp.add(comp, ((IscobolLayout)lm).getLayoutData(comp), index);
                continue;
            }
            mp.add((Component)((Object)rbgc.getComponent()), index);
        }
    }

    static boolean shouldInsertBefore(RemoteBaseGUIControl rbgc, RemoteBaseGUIControl c) {
        if (c == null) {
            return false;
        }
        if (RemoteDisplayWindow.intersects(rbgc, c)) {
            return !RemoteDisplayWindow.isTabControl(c) || !((RemoteTab)c).getButtonsBounds().intersects(rbgc.getComponent().getBounds());
        }
        return RemoteDisplayWindow.getZOrder(rbgc) - RemoteDisplayWindow.getZOrder(c) <= 0;
    }

    private void addchild(RemoteBaseGUIControl rbgc, RemoteBaseGUIControl uponCtrl) {
        LayoutManager lm;
        int index;
        if (rbgc instanceof RemoteTerminalDisplay && !rbgc.isInputField() || rbgc.getType() == "statusbar") {
            if (rbgc.getType() == "statusbar") {
                ((RemoteStatusBar)rbgc).saveOrigBounds();
            }
            return;
        }
        if (rbgc instanceof RemoteTab && ((RemoteTab)rbgc).isRibbon() && ((RemoteTab)rbgc).getToolPanel() != null) {
            return;
        }
        if (this.mainWindow == null || this.mainWindow.getPanel() == null) {
            return;
        }
        rbgc.setParentToolbar(null);
        Component[] controls = this.mainWindow.getPanel().getComponents();
        for (index = 0; index < controls.length - 1; ++index) {
            if (controls[index] != rbgc.getComponent()) continue;
            return;
        }
        if (!this.onlycontrolsTDTA) {
            RemoteBaseGUIControl c;
            for (index = 0; index < controls.length - 1 && !RemoteDisplayWindow.shouldInsertBefore(rbgc, c = (RemoteBaseGUIControl)this.childGraphics.get(controls[index])); ++index) {
            }
        }
        if ((lm = this.mainWindow.getPanel().getLayout()) == null || this.mainWindow.getType() == 9) {
            if (uponCtrl == null || !uponCtrl.isContainer()) {
                this.mainWindow.getPanel().add((Component)((Object)rbgc.getComponent()), index);
            } else {
                uponCtrl.add(rbgc, index, this.childGraphics);
            }
        } else if (lm instanceof IscobolLayout) {
            IscobolLayout islm = (IscobolLayout)lm;
            boolean alreadyadd = false;
            for (int i = 0; i < controls.length - 1; ++i) {
                if (controls[i] != rbgc.getComponent()) continue;
                alreadyadd = true;
                break;
            }
            if (!alreadyadd && uponCtrl != null) {
                alreadyadd = uponCtrl.isAlreadyAdd(rbgc);
            }
            if (!alreadyadd) {
                if (uponCtrl == null || !uponCtrl.isContainer()) {
                    this.mainWindow.getPanel().add((Component)((Object)rbgc.getComponent()), index);
                } else {
                    uponCtrl.add(rbgc, index, this.childGraphics);
                    if (uponCtrl instanceof RemoteTab && ((RemoteTab)uponCtrl).isRibbon()) {
                        return;
                    }
                }
                IscobolLayout.LayoutData lData = islm.createLayoutData((Component)((Object)rbgc.getComponent()), rbgc.getMaxWidth() * this.getCellWidth(), rbgc.getMinWidth() * this.getCellWidth(), rbgc.getMaxHeight() * this.getCellHeight(), rbgc.getMinHeight() * this.getCellHeight(), rbgc.getLayoutData(islm), rbgc.getType());
                if (lData instanceof ZoomLayout.ZoomLayoutData) {
                    rbgc.addZoomLayoutDataFonts((ZoomLayout.ZoomLayoutData)lData);
                }
                islm.addLayoutComponent((Component)((Object)rbgc.getComponent()), lData);
                if (!rbgc.isVisible()) {
                    this.mainWindow.getPanel().revalidate();
                }
            }
        }
        this.childGraphics.put(rbgc.getComponent(), rbgc);
    }

    @Override
    public void add(int controlID, RemoteBaseGUIControl uponCtrl) {
        Object o = this.gf.getClient().getId(controlID);
        if (o instanceof RemoteBaseGUIControl) {
            RemoteBaseGUIControl comp = (RemoteBaseGUIControl)o;
            this.addchild(comp, uponCtrl);
        } else if (o instanceof RemoteDisplayToolBar) {
            this.mainWindow.addToolBar((RemoteDisplayToolBar)o);
        } else if (o instanceof RemoteSubWindow) {
            this.childSubWindow.addLast(o);
            if (this.mainWindow != null && this.mainWindow.getPanel() != null) {
                this.mainWindow.getPanel().repaint();
            }
        }
    }

    @Override
    public void add(int controlID, int index, RemoteBaseGUIControl uponCtrl) {
        RemoteBaseGUIControl comp = (RemoteBaseGUIControl)this.gf.getClient().getId(controlID);
        this.addchild(comp, uponCtrl);
    }

    public void setMenu(RemoteMenu m) {
        if (this.mainWindow == null) {
            return;
        }
        if (this.menu != null) {
            this.menu.removeMenuChangeListener();
            this.menu.setParentWindow(-1);
        }
        this.menu = m;
        if (this.menu != null) {
            if (this.menu.getChildren().size() > 0) {
                this.menu.translateToMenuBar();
                if (this.menu.getType() != 4) {
                    this.menu.addMenuChangeListener();
                    this.menu.setMaxWidth(this.getMainBounds().width);
                }
                this.mainWindow.setJMenuBar(this.menu.getMenuBar());
            }
            this.menu.setParentWindow(this.theObject);
        } else {
            this.mainWindow.setJMenuBar(null);
        }
    }

    public RemoteMenu getMenu() {
        return this.menu;
    }

    @Override
    public void setActiveWindow(boolean a) {
        new IsguiWorker(false, () -> {
            this.activeWindow = a;
        }).start();
        if (this.mainWindow != null) {
            this.mainWindow.setActive(a);
        }
    }

    @Override
    public void setTitle(String t) {
        if (this.mainWindow != null) {
            this.mainWindow.setTitle(t);
        }
    }

    @Override
    public void setTitlePosition(int t) {
    }

    @Override
    public void setBackground(int r, int b, int g) {
        if (this.mainWindow != null) {
            Color newC = new Color(r, g, b);
            this.mainWindow.setBackground(newC);
            this.mainWindow.getPanel().setBackground(newC);
        }
    }

    @Override
    public void setBackgroundIdx(int idx) {
        this.setBackgroundIdx(idx, false);
    }

    @Override
    public void setBackgroundIdx(int idx, boolean issubwin) {
        Color newC;
        if (this.mainWindow != null && (newC = this.gf.getRemotePalette().getDefaultColor(idx)) != null) {
            this.backgroundIndex = idx;
            if (!issubwin) {
                this.mainWindow.setBackground(newC);
                if (this.mainWindow.getPanel() != null) {
                    this.mainWindow.getPanel().setBackground(newC);
                }
            } else {
                Terminal charTerminal = this.mainWindow.getCharTerminal();
                charTerminal.setBackColor(newC);
            }
        }
    }

    @Override
    public void setForeground(int r, int b, int g) {
        if (this.mainWindow != null) {
            Color newC = new Color(r, g, b);
            this.mainWindow.setForeground(newC);
            if (this.mainWindow.getPanel() != null) {
                this.mainWindow.getPanel().setForeground(newC);
            }
        }
    }

    @Override
    public void setForegroundIdx(int idx) {
        this.setForegroundIdx(idx, false);
    }

    @Override
    public void setForegroundIdx(int idx, boolean issubwin) {
        Color newC;
        if (this.mainWindow != null && (newC = this.gf.getRemotePalette().getDefaultColor(idx)) != null) {
            this.foregroundIndex = idx;
            if (!issubwin) {
                this.mainWindow.setForeground(newC);
                if (this.mainWindow.getPanel() != null) {
                    this.mainWindow.getPanel().setForeground(newC);
                }
            } else {
                Terminal charTerminal = this.mainWindow.getCharTerminal();
                charTerminal.setForeColor(newC);
            }
        }
    }

    @Override
    public void setScreenSize(int size) {
        if (this.mainWindow != null) {
            Terminal ct = this.mainWindow.getCharTerminal();
            ct.changeWidth(size);
            this.setMaxSize(size);
            Dimension s = ct.getPreferredSize();
            this.setMaximizedBounds();
            this.mainWindow.setInitD(s.width, s.height);
            this.repaintTerminal(null);
        }
    }

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.controlGotoSent = null;
        if (this.childGraphics != null) {
            Hashtable hashtable = this.childGraphics;
            synchronized (hashtable) {
                Enumeration ctlLI = this.childGraphics.elements();
                while (ctlLI.hasMoreElements()) {
                    RemoteBaseGUIControl ctl = (RemoteBaseGUIControl)ctlLI.nextElement();
                    ctl.destroy();
                }
            }
            this.childGraphics = null;
        }
        this.delId(this.terminalDisplayGateId);
        this.mainWindow.getPanel().removeKeyListener(this.kl);
        this.mainWindow.getPanel().removeMouseListener(this.ml);
        this.mainWindow.getPanel().removeMouseMotionListener(this.mml);
        if (this.parent != null && this.mainWindow != null && this.mainWindow.isModal() && this.mainWindow.getWindow().isVisible() && this.parent.modalWindowChildren > 0) {
            --this.parent.modalWindowChildren;
        }
        if (this.menu != null) {
            this.menu.removeMenuChangeListener();
        }
        if (this.ntfResizeTimer != null) {
            this.ntfResizeTimer.cancel();
        }
        this.ntfResizeTimer = null;
        if (this.mouseStopTimer != null) {
            this.mouseStopTimer.cancel(true);
        }
        this.mouseStopTimer = null;
        if (this.mainWindow != null) {
            this.mainWindow.setJMenuBar(null);
            if (this.resizeListener != null && this.mainWindow.getWindow() != null) {
                this.mainWindow.getWindow().removeComponentListener(this.resizeListener);
            }
            this.mainWindow.getMyWindow().removeWindowListener(this.wListener);
            this.mainWindow.getMyWindow().removeWindowFocusListener(this.wListener);
            this.mainWindow.dispose();
            this.mainWindow = null;
        }
        this.wListener = null;
        this.events = null;
        this.resizeListener = null;
        this.popupListener = null;
        this.intstopTimer(true);
        this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        this.pcListener = null;
        this.mml = null;
        this.ml = null;
        this.kl = null;
        this.parent = null;
        this.rswcurrent = null;
        this.font = null;
        this.mnemonicTable = null;
        this.mouseInfo = null;
        this.childSubWindow = null;
        if (this.wcListener != null && this.gf != null) {
            this.gf.getWebClient().removeWebClientListener(this.wcListener);
            this.wcListener = null;
        }
        this.previousFocusOwner = null;
        this.superdestroy();
    }

    public FontRenderContext getFontRenderContext() {
        return this.mainWindow.frc;
    }

    @Override
    public void toFront() {
        if (this.mainWindow != null && this.mainWindow.getWindow() != null) {
            this.mainWindow.getMyWindow().toFront();
        }
    }

    @Override
    public Rectangle getMainBounds() {
        if (this.mainWindow == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.mainWindow.getBounds();
    }

    @Override
    public Rectangle getBounds() {
        if (this.mainWindow != null && this.mainWindow.getPanelScroll() != null) {
            Insets is = this.mainWindow.getPanelScroll().getInsets();
            Rectangle Return2 = this.mainWindow.getPanelScroll().getBounds();
            Return2.width -= is.right + is.left;
            Return2.height -= is.top + is.bottom;
            return Return2;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public Color getBackground() {
        if (this.mainWindow != null && this.mainWindow.getPanel() != null) {
            return this.mainWindow.getPanel().getBackground();
        }
        return Color.gray;
    }

    @Override
    public int getBackgroundIdx() {
        return this.backgroundIndex;
    }

    @Override
    public boolean getBoxed() {
        return false;
    }

    @Override
    public int getFont() {
        LocalFontCmp tmpfont = (LocalFontCmp)this.gf.getClient().getId(this.fontId);
        if (tmpfont != null) {
            this.fontId = 0;
        }
        return this.fontId;
    }

    @Override
    public Color getForeground() {
        if (this.mainWindow != null && this.mainWindow.getPanel() != null) {
            return this.mainWindow.getPanel().getForeground();
        }
        return Color.black;
    }

    @Override
    public int getForegroundIdx() {
        return this.foregroundIndex;
    }

    public int getTheObjectId() {
        return this.theObject;
    }

    @Override
    public String getTitle() {
        if (this.mainWindow == null) {
            return "";
        }
        return this.mainWindow.getTitle();
    }

    @Override
    public boolean getWrap() {
        return false;
    }

    @Override
    public boolean isGraphical() {
        return false;
    }

    @Override
    public void setAutoResize(boolean as) {
        this.autoResize = as;
        if (this.mainWindow != null) {
            this.mainWindow.setAutoResize(as);
            this.mainWindow.setFixedAutoResizeDim(this.fixedAutoResizeDim);
            if (Client.isWebClient() && this.resizeListener == null && this.mainWindow.getWindow() != null) {
                this.resizeListener = this.createResizeListener();
                this.mainWindow.getWindow().addComponentListener(this.resizeListener);
            }
        }
    }

    public boolean getAutoResize() {
        return this.autoResize;
    }

    @Override
    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxColumns = maxSize;
    }

    @Override
    public void setMinLines(int minLines) {
        this.minLines = minLines;
        if (this.mainWindow != null) {
            this.mainWindow.setMinHeight(Math.round(this.minLines * (float)this.getCellHeight()));
        }
    }

    @Override
    public void setMinSize(int minSize) {
        this.minColumns = minSize;
        if (this.mainWindow != null) {
            this.mainWindow.setMinWidth(Math.round(this.minColumns * (float)this.getCellWidth()));
        }
    }

    @Override
    public void setPopupArea() {
    }

    @Override
    public void setResizable(boolean r) {
        this.resizable = r;
        if (this.mainWindow != null) {
            this.mainWindow.setResizable(r);
            if (Client.isWebClient() && this.resizeListener == null && this.mainWindow.getWindow() != null) {
                this.resizeListener = this.createResizeListener();
                this.mainWindow.getWindow().addComponentListener(this.resizeListener);
            }
        }
    }

    public boolean getResizable() {
        return this.resizable;
    }

    public boolean getFixedAndAutoResizeDim() {
        return this.autoResize && !this.fixedAutoResizeDim;
    }

    @Override
    public void setScroll(boolean s) {
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.mainWindow != null) {
            this.mainWindow.setEnabled(b);
        }
    }

    public void debugSetEnabled(boolean b) {
        if (this.mainWindow != null) {
            this.mainWindow.debugSetEnabled(b);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.mainWindow != null) {
            return this.mainWindow.isEnabled();
        }
        return false;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            if (!this.visible) {
                this.firstActivation = true;
            }
            if (this.maxBounds == null) {
                this.setMaximizedBounds();
            }
        }
        if (this.visible != b && this.parent != null && this.mainWindow != null && this.mainWindow.isModal()) {
            if (b) {
                this.addParentModalChildrenCount();
            } else {
                this.removeParentModalChildrenCount();
            }
        }
        this.visible = b;
        if (this.mainWindow != null) {
            this.mainWindow.setVisible(b);
        }
        if (b && this.parent != null && this.parent.getMainWindow() != null && this.parent.getMainWindow().getJFrame() != null && this.parent.getMainWindow().getJFrame().getExtendedState() == 1 && this.mainWindow.getJFrame() != null) {
            new SwingWorker(false, () -> this.getMainWindow().getJFrame().setExtendedState(1)).start();
        }
    }

    private void setMaximizedBounds() {
        if (this.mainWindow != null && this.mainWindow.isJFrame() && (this.maxColumns > 0.0f || this.maxLines > 0.0f)) {
            int maxWidth = (int)(this.maxColumns * (float)this.getCellWidth());
            int maxHeight = (int)(this.maxLines * (float)this.getCellHeight());
            Insets globInsets = new Insets(0, 0, 0, 0);
            for (Container con = this.mainWindow.getPanelScroll(); con != null; con = con.getParent()) {
                Insets is = ((Container)con).getInsets();
                globInsets.top += is.top;
                globInsets.bottom += is.bottom;
                globInsets.right += is.right;
                globInsets.left += is.left;
            }
            this.maxBounds = new Rectangle();
            this.maxBounds.x = Integer.MAX_VALUE;
            this.maxBounds.y = Integer.MAX_VALUE;
            int widthAdd = globInsets.right + globInsets.left;
            int heightAdd = globInsets.top + globInsets.bottom + this.mainWindow.getToolPanel().getSize().height;
            this.maxBounds.width = maxWidth > 0 ? maxWidth + widthAdd : Integer.MAX_VALUE;
            this.maxBounds.height = maxHeight > 0 ? maxHeight + heightAdd : Integer.MAX_VALUE;
            this.mainWindow.getJFrame().setMaximizedBounds(this.maxBounds);
        }
    }

    @Override
    public void setWithSystemMenu(boolean b) {
        this.withSystemMenu = b;
    }

    @Override
    public int getCellHeight() {
        if (this.cellHeight < 1.0f) {
            return 1;
        }
        return (int)this.cellHeight;
    }

    @Override
    public float getCellHeightF() {
        return this.cellHeight;
    }

    @Override
    public int getCellWidth() {
        if (this.cellWidth < 1.0f) {
            return 1;
        }
        return (int)this.cellWidth;
    }

    @Override
    public float getCellWidthF() {
        return this.cellWidth;
    }

    @Override
    public void setCellHeight(float ch) {
        if (ch >= 1.0f) {
            this.cellHeight = ch;
            if (this.minLines > 0.0f && this.mainWindow != null) {
                this.mainWindow.setMinHeight(Math.round(this.minLines * this.cellHeight));
            }
        }
    }

    @Override
    public void setCellWidth(float cw) {
        if (cw >= 1.0f) {
            this.cellWidth = cw;
            if (this.minColumns > 0.0f && this.mainWindow != null) {
                this.mainWindow.setMinWidth(Math.round(this.minColumns * this.cellWidth));
            }
        }
    }

    @Override
    public void setCellWidth(String fontName, int fontStyle, int fontSize) {
        this.setCellWidth(new SwingFontCmp(this.gf, fontName, fontStyle, (float)fontSize, false).getWidth());
    }

    @Override
    public void setCellHeight(String fontName, int fontStyle, int fontSize) {
        this.setCellHeight(new SwingFontCmp(this.gf, fontName, fontStyle, (float)fontSize, false).getHeight());
    }

    @Override
    public void setMouseFlags(int mf) {
        this.mouseFlags = mf;
    }

    @Override
    public int getMouseFlags() {
        return this.mouseFlags;
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra, boolean foo) {
    }

    @Override
    public boolean isInitialized() {
        return this.mainWindow != null;
    }

    void addParentModalChildrenCount() {
        if (this.parent != null) {
            ++this.parent.modalWindowChildren;
        }
    }

    void removeParentModalChildrenCount() {
        if (this.parent != null && this.parent.modalWindowChildren > 0) {
            --this.parent.modalWindowChildren;
        }
    }

    @Override
    public void setModal(boolean m) {
        if ((this.type == 5 || this.type == 10) && this.mainWindow != null) {
            this.mainWindow.setModal(m);
        }
    }

    @Override
    public void setPopupMenu(RemoteMenu pm) {
        if (this.popupMenu != null) {
            this.popupMenu.setParentWindow(-1);
        }
        if (this.mainWindow != null && this.mainWindow.getPanel() != null && this.popupListener != null) {
            this.mainWindow.getPanel().removeMouseListener(this.popupListener);
        }
        this.popupMenu = pm;
        if (this.mainWindow != null && this.mainWindow.getPanel() != null && this.popupMenu != null) {
            this.popupMenu.setParentWindow(this.theObject);
            this.popupListener = new PopupListener(this, this.popupMenu);
            this.mainWindow.getPanel().addMouseListener(this.popupListener);
        } else {
            this.popupListener = null;
        }
    }

    private void setStyle(int s, boolean state) {
        switch (s) {
            case 157: {
                this.noCloseStyle = state;
                break;
            }
            case 313: {
                if (this.mainWindow == null) break;
                this.mainWindow.setUndecoratedStyle(state);
            }
        }
    }

    @Override
    public void setStyle(int s) {
        this.setStyle(s, true);
    }

    @Override
    public void unsetStyle(int s) {
        this.setStyle(s, false);
    }

    public Rectangle getscreeninfo() {
        if (this.screenindex == 0) {
            GraphicsConfiguration grc = this.mainWindow.getWindow().getGraphicsConfiguration();
            grc = this.mainWindow.getWindow().getGraphicsConfiguration();
            return grc.getBounds();
        }
        return this.gf.getScreenInfo().getPhysicalMonitorBounds(this.screenindex);
    }

    @Override
    public void setAction(float cv) {
        if (this.mainWindow != null) {
            switch ((int)cv) {
                case 21: {
                    if (!Client.isWebClient() && this.getLayout() != null && this.getLayout() instanceof ZoomLayout) {
                        Rectangle rectinfo = this.getscreeninfo();
                        Rectangle rectmain = this.mainWindow.getBounds();
                        if (rectinfo != null && rectmain != null && rectmain.contains(rectinfo)) {
                            this.mainWindow.setInitD(rectinfo.width, rectinfo.height);
                        }
                    }
                    this.actionMaximize();
                    break;
                }
                case 20: {
                    this.mainWindow.setState(1);
                    break;
                }
                case 22: {
                    this.mainWindow.setState(0);
                    break;
                }
                case 23: {
                    this.actionmaximizepostponed = true;
                    break;
                }
            }
        }
    }

    @Override
    public void setTitleBar(boolean b) {
        if (this.mainWindow != null) {
            this.mainWindow.setTitleBar(b);
        }
    }

    @Override
    public void startTimer(long hSeconds) {
        this.beforetimehs = hSeconds;
        if (this.pTimer != null) {
            this.pTimer.restart();
        } else {
            this.pTimer = new PicobolTimer(hSeconds);
            this.pTimer.start();
        }
    }

    public void intstopTimer(boolean force) {
        this.stopTimer(force);
        if (this.pTimer != null) {
            this.pTimer.stop();
            this.pTimer = null;
        }
    }

    public void stopTimer() {
        this.stopTimer(false);
    }

    public void stopTimer(boolean force) {
        if (this.pTimer != null) {
            if (this.acceptbeforetimerepeat) {
                if (force) {
                    this.pTimer.stop();
                    this.pTimer = null;
                } else {
                    this.pTimer.restart();
                }
            } else if (!force && this.pTimer != null) {
                this.pTimer.stop();
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void requestFocus() {
        block2: {
            block4: {
                MenuElement[] selPath;
                block3: {
                    if (this.mainWindow == null) break block2;
                    selPath = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (selPath != null && selPath.length != 0) break block3;
                    if (this.mainWindow.getPanel() == null) break block4;
                    this.mainWindow.getPanel().requestFocusInWindow();
                    break block4;
                }
                for (MenuElement me : selPath) {
                    if (!(me instanceof ComboPopup)) continue;
                    if (this.mainWindow.getPanel() == null) break;
                    this.mainWindow.getPanel().requestFocusInWindow();
                    break;
                }
            }
            if (this.focusOwner == null && this.mainWindow.getCharTerminal() != null) {
                this.mainWindow.getCharTerminal().repaint();
            }
        }
        this.clearFocusOwner();
    }

    @Override
    protected void drawCaret(ParamVElement pe) {
        if (this.focusOwner == null && this.mainWindow.getCharTerminal() != null && this.mainWindow.getPanel().getComponentCount() == 1) {
            TerminalModel tm = this.mainWindow.getCharTerminal().getTerminalModel();
            if (pe instanceof ParamElementIntInt) {
                ParamElementIntInt peii = (ParamElementIntInt)pe;
                int caretLine = peii.getValuePar1() - 1;
                int caretCol = peii.getValueInt() - 1;
                if (caretLine >= 0 && caretCol >= 0) {
                    tm.setCaretAt(caretCol, caretLine, null);
                } else {
                    tm.setCaret(null);
                }
            } else {
                tm.setCaret(null);
            }
            if (this.gradientMgr.isPaintGradient()) {
                this.mainWindow.getCharTerminal().myrepaint();
            }
        }
    }

    @Override
    public void setIcon(int id) {
        Object lim = this.gf.getClient().getId(id);
        if (lim instanceof LocalImage && this.mainWindow != null) {
            this.mainWindow.setIcon(((LocalImage)lim).getImage());
        }
    }

    @Override
    public void setActiveAccept(boolean a) {
        if (this.mainWindow != null) {
            if (!a) {
                this.intstopTimer(true);
                this.beforetimehs = -1L;
            }
            this.mainWindow.setActiveAccept(a);
            if (a) {
                RemotePushButton pb = this.getDefaultButton();
                if (pb != null) {
                    this.mainWindow.setDefaultButton((JButton)((Object)pb.getComponent()));
                }
                if (this.resizeListener == null && this.mainWindow.getWindow() != null) {
                    this.resizeListener = this.createResizeListener();
                    this.mainWindow.getWindow().addComponentListener(this.resizeListener);
                }
                try {
                    this.fillMouseInfo();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
                this.mouseInfo.setLeftDown(false);
                this.mouseInfo.setMiddleDown(false);
                this.mouseInfo.setRightDown(false);
            }
        }
    }

    private ComponentListener createResizeListener() {
        return IsguiUtility.componentResizedAdapter(e -> {
            int maxHeight;
            int maxWidth;
            if (!this.resizable && !this.autoResize) {
                return;
            }
            boolean wrongSize = false;
            BorderedScrollPane src = this.mainWindow.getPanelScroll();
            Dimension size = src.getSize();
            Insets insets = src.getInsets();
            if (this.autoResize && this.fixedAutoResizeDim) {
                maxWidth = this.width;
                maxHeight = this.height;
            } else {
                maxWidth = (int)(this.maxColumns * (float)this.getCellWidth());
                maxHeight = (int)(this.maxLines * (float)this.getCellHeight());
            }
            int w = size.width - insets.left - insets.right;
            int h = size.height - insets.bottom - insets.top;
            if (maxWidth > 0 && w > maxWidth) {
                w = maxWidth;
                wrongSize = true;
            }
            if (maxHeight > 0 && h > maxHeight) {
                h = maxHeight;
                wrongSize = true;
            }
            if (wrongSize) {
                JFrame fr = this.mainWindow.getJFrame();
                if (this.autoResize && this.fixedAutoResizeDim && fr != null && fr.getExtendedState() == 6) {
                    fr.setExtendedState(0);
                    this.mainWindow.setInitD(this.width, this.height);
                } else {
                    Dimension d = this.mainWindow.getPanel().myGetSize();
                    this.mainWindow.setInitD(w, h);
                    if (this.autoResize) {
                        this.mainWindow.getPanel().mySetSize(d.width, d.height);
                    }
                }
                return;
            }
            if (w != this.width || h != this.height) {
                if (this.hasLayout) {
                    this.mainWindow.getPanel().setInitD(w, h);
                    this.mainWindow.getPanel().getLayout().layoutContainer(this.mainWindow.getPanel());
                }
                if (!this.autoResize) {
                    this.width = w;
                    this.height = h;
                    short ed1 = (short)((float)h / this.getCellHeightF() * 100.0f);
                    int ed2 = (int)((float)w / this.getCellWidthF() * 100.0f);
                    RemoteRecordAccept rra = new RemoteRecordAccept(6, 96, 4114, ed1, ed2, true, true, true);
                    CobolEventCouple cc = new CobolEventCouple(this, rra);
                    if (this.ntfResizeTimer.getInitialDelay() > 0) {
                        this.ntfResizeTimer.restart(cc);
                    } else {
                        this.mainWindow.push(cc);
                    }
                }
            }
        });
    }

    @Override
    public boolean isActiveAccept() {
        if (this.mainWindow != null) {
            return this.mainWindow.isActiveAccept();
        }
        return false;
    }

    @Override
    public void erase(int flg, int col, int line, Color bgColor) {
        if (this.mainWindow != null) {
            this.mainWindow.erase(flg, col, line, bgColor);
        }
    }

    @Override
    public void display(String str, boolean eol) {
        if (this.mainWindow != null) {
            this.mainWindow.display(str, eol);
        }
    }

    private void setDefaultLocation(ParamElementWindowLocation pwl) {
        if (pwl.parentid != -1) {
            this.setDefaultLocation(pwl.parentid);
            Rectangle mainBounds = this.getMainBounds();
            pwl.screenline = mainBounds.y;
            pwl.screencolumn = mainBounds.x;
        } else if (this.screenindex > 0 && this.gf != null && this.gf.getScreenInfo() != null) {
            this.setScreenInfoLocation();
        }
    }

    private void setLocation(int x, int y, ParamElementWindowLocation pwl) {
        int l = -99999;
        int c = -99999;
        Rectangle myBounds = this.getMainBounds();
        if (x != -99999 && y != -99999) {
            c = x;
            l = y;
        } else {
            c = x == -99999 ? myBounds.x : x;
            l = y == -99999 ? myBounds.y : y;
        }
        RemoteDisplayWindow rw = (RemoteDisplayWindow)this.gf.getClient().getId(pwl.parentid);
        Dimension sz = this.mainWindow.getSize();
        Insets is = null;
        Rectangle rect = null;
        Rectangle rwBounds = null;
        if (!(rw == null || pwl.changescreenlc || pwl.parentid == -1 || this.screenindex != 0 && rw.getScreenIndex() != this.screenindex)) {
            rwBounds = rw.getMainBounds();
            is = rw.getInsets();
            GraphicsConfiguration grc = rw.mainWindow.getWindow().getGraphicsConfiguration();
            grc = rw.mainWindow.getWindow().getGraphicsConfiguration();
            rect = grc.getBounds();
        } else if (this.screenindex > 0 && this.gf != null && this.gf.getScreenInfo() != null) {
            rwBounds = rect = this.gf.getScreenInfo().getPhysicalMonitorBounds(this.screenindex);
        }
        if (is == null) {
            is = new Insets(0, 0, 0, 0);
        }
        if (y == -99999) {
            if (rect != null && y == -99999) {
                l = rwBounds.y + (rwBounds.height - sz.height) / 2;
                if (l < rect.y) {
                    l = rect.y;
                } else if (l + sz.height > rect.y + rect.height) {
                    l = rect.y + rect.height - sz.height;
                }
            }
        } else if (rwBounds != null) {
            float h = pwl.toolbarsheight;
            if ((double)h == 0.0 && this.parent != null && this.parent.getMainWindow() != null && this.parent.getMainWindow().getToolPanel() != null) {
                h = this.parent.getMainWindow().getToolPanel().getPreferredSize().height;
            }
            l = (int)((float)(rwBounds.y + l + is.top) + h);
            if (y == -99999) {
                l = Math.max(0, (rwBounds.height - myBounds.height) / 2);
            }
        }
        if (x == -99999) {
            if (rect != null && x == -99999) {
                c = rwBounds.x + (rwBounds.width - sz.width) / 2;
                if (c < rect.x) {
                    c = rect.x;
                } else if (c + sz.width > rect.x + rect.width) {
                    c = rect.x + rect.width - sz.width;
                }
            }
        } else if (rwBounds != null) {
            c = rwBounds.x + c + is.left;
            if (x == -99999) {
                c = Math.max(0, (rwBounds.width - myBounds.width) / 2);
            }
        }
        if (this.mainWindow.getType() == 10) {
            this.setLocation(x, y);
        } else {
            this.setLocation(c, l);
        }
    }

    @Override
    public void paramsetLocation(ParamElementWindowLocation pwl) {
        float l = -99999.0f;
        float c = -99999.0f;
        if (pwl.changescreenlc) {
            l = pwl.screenline;
            c = pwl.screencolumn;
        }
        if (l == -99999.0f && c == -99999.0f) {
            l = pwl.getatline;
            c = pwl.getatcolumn;
            if (l != -99999.0f || c != -99999.0f) {
                if (l != -99999.0f) {
                    l -= 1.0f;
                    l = this.parent != null && pwl.firstdisplay ? (l *= (float)this.parent.getCellHeight()) : (l *= (float)this.getCellHeight());
                }
                if (c != -99999.0f) {
                    c -= 1.0f;
                    c = this.parent != null && pwl.firstdisplay ? (c *= (float)this.parent.getCellWidth()) : (c *= (float)this.getCellWidth());
                }
            }
        }
        if (l != -99999.0f || c != -99999.0f) {
            this.setLocation((int)(c + pwl.add_sub_columns), (int)(l + pwl.add_sub_lines), pwl);
        } else if (pwl.firstdisplay && pwl.screenline == -99999.0f && pwl.screencolumn == -99999.0f) {
            this.setDefaultLocation(pwl);
        }
    }

    @Override
    public int[] componentgetControlSamePosition(RemoteBaseGUIControl rbgc) {
        if (this.mainWindow != null) {
            return this.getControlSamePosition(rbgc, this.mainWindow.getPanel());
        }
        return null;
    }

    @Override
    public int[] componentsetErase(int flgerase, int col, int row, Color bgColor, int[] fieldsid) {
        return this.setErase(this.mainWindow.getPanel(), flgerase, col, row, bgColor, fieldsid);
    }

    @Override
    protected void repaintTerminal(Component cc) {
        if (this.mainWindow != null && this.mainWindow.getType() != 9) {
            super.repaintTerminal(this.mainWindow.getCharTerminal());
        }
    }

    @Override
    public int[] componentsetEraseArea(int[] limit) {
        return this.componentsetEraseArea(limit, true);
    }

    public int[] componentsetEraseArea(int[] limit, boolean ismain) {
        if (this.mainWindow != null) {
            this.mainWindow.getCharTerminal().getTerminalModel().clrarea(limit[1], limit[2], limit[3], limit[4]);
            this.mainWindow.getCharTerminal().repaint();
            return this.setEraseArea(this.mainWindow.getPanel(), limit, ismain);
        }
        return null;
    }

    @Override
    public void componentsetScroll(int flg, int col, int line) {
        if (this.mainWindow != null) {
            this.mainWindow.scroll(flg, col, line);
        }
    }

    @Override
    public String acceptFromScreen(int line, int col, int size) {
        if (this.mainWindow != null && this.mainWindow.getCharTerminal() != null) {
            return this.mainWindow.getCharTerminal().acceptFromScreen(line, col, size);
        }
        return "";
    }

    @Override
    public String attrFromScreen(int line, int col, int size) {
        if (this.mainWindow != null && this.mainWindow.getCharTerminal() != null) {
            return this.mainWindow.getCharTerminal().attrFromScreen(line, col, size);
        }
        return "";
    }

    @Override
    public void writeToScreen(int line, int col, int size, String chr, String atr) {
        if (this.mainWindow != null && this.mainWindow.getCharTerminal() != null) {
            this.mainWindow.getCharTerminal().writeToScreen(line, col, size, chr, atr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Integer srvheadid) {
        if (this.childGraphics != null && this.childGraphics.contains(srvheadid)) {
            Hashtable hashtable = this.childGraphics;
            synchronized (hashtable) {
                this.childGraphics.remove(srvheadid);
            }
        }
    }

    public void controlenableKeyboard(RemoteBaseGUIControl rbgc) {
        Logger guiLog = null;
        if (this.mainWindow != null) {
            guiLog = this.mainWindow.getGuiLog();
        }
        if (guiLog != null) {
            guiLog.info("RemoteDisplayWindow:controlenableKeyboard enabledkb [" + this.enabledkb + "] [" + rbgc + "] rgbcname [" + (rbgc != null ? rbgc.getName() : " NULL ") + "] focusOwner [" + this.focusOwner + "] [" + (!this.enabledkb ? KeyboardBuffer.getStackTrace() : "true") + "]");
        }
        if (this.enabledkb) {
            this.intenableKeyboard(rbgc);
        }
    }

    public void controldisableKeyboard(RemoteBaseGUIControl rbgc) {
        this.intdisableKeyboard(rbgc);
    }

    @Override
    public boolean enableKeyboard() {
        this.setEnabledKeyboard(true);
        boolean Return2 = this.intenableKeyboard();
        if (this.acceptbeforetimerepeat && this.pTimer == null && this.beforetimehs > 0L) {
            this.startTimer(this.beforetimehs);
        }
        return Return2;
    }

    private boolean intenableKeyboard() {
        return this.intenableKeyboard(null);
    }

    private boolean intenableKeyboard(RemoteBaseGUIControl rbgc) {
        Logger guiLog = null;
        if (this.mainWindow != null) {
            guiLog = this.mainWindow.getGuiLog();
        }
        if (guiLog != null) {
            guiLog.info("RemoteDisplayWindow:intenableKeyboard rbgc [" + rbgc + "] rgbcname [" + (rbgc != null ? rbgc.getName() : " NULL ") + "] focusOwner [" + this.focusOwner + "]");
        }
        if (this.focusOwner != null) {
            RemoteBaseGUIControl rbgcfo = (RemoteBaseGUIControl)this.focusOwner;
            rbgcfo.setCursorValue(this);
            if (guiLog != null) {
                guiLog.info("RemoteDisplayWindow:intenableKeyboard rbgcfo [" + rbgcfo + "] rgbcname [" + (rbgcfo != null ? rbgcfo.getName() : " NULL ") + "]");
            }
            if (rbgcfo.getWaitAnswer()) {
                if (guiLog != null) {
                    guiLog.info("RemoteDisplayWindow:intenableKeyboard RETURN FALSE rbgc [" + rbgc + "] rgbcname [" + (rbgc != null ? rbgc.getName() : " NULL ") + "] rbgcfo [" + rbgcfo + "] rgbcfoname [" + (rbgcfo != null ? rbgcfo.getName() : " NULL ") + "] [" + KeyboardBuffer.getStackTrace() + "]");
                }
                return false;
            }
            if (guiLog != null) {
                guiLog.info("RemoteDisplayWindow:intenableKeyboard RETURN TRUE rbgc [" + rbgc + "] rgbcname [" + (rbgc != null ? rbgc.getName() : " NULL ") + "] rbgcfo [" + rbgcfo + "] rgbcfoname [" + (rbgcfo != null ? rbgcfo.getName() : " NULL ") + "]");
            }
        }
        if (this.mainWindow != null) {
            KeyboardBuffer.enable(this.mainWindow.getWindow());
        }
        return true;
    }

    public void setEnabledKeyboard(boolean b) {
        this.enabledkb = b;
    }

    @Override
    public void disableKeyboard() {
        this.setEnabledKeyboard(false);
        this.intdisableKeyboard();
    }

    private void intdisableKeyboard() {
        this.intdisableKeyboard(null);
    }

    private void intdisableKeyboard(RemoteBaseGUIControl rbgc) {
        if (this.mainWindow != null) {
            Logger guiLog = this.mainWindow.getGuiLog();
            if (guiLog != null) {
                guiLog.info("RemoteDisplayWindow:intdisableKeyboard [" + rbgc + "] rgbcname [" + (rbgc != null ? rbgc.getName() : " NULL ") + "]");
            }
            KeyboardBuffer.disable(this.mainWindow.getMyWindow().getRootWindow(), this.waitCursorDelay);
        }
    }

    @Override
    public void destroyChild(Vector destroyvect) {
        boolean dorepaint = destroyvect != null && destroyvect.size() > 0;
        super.destroyChild(destroyvect);
        if (dorepaint && this.mainWindow != null && this.mainWindow.getPanel() != null) {
            this.mainWindow.getPanel().repaint();
        }
    }

    @Override
    public void destroyChildnoSW(Vector destroyvect) {
        boolean dorepaint = destroyvect != null && destroyvect.size() > 0;
        super.destroyChildnoSW(destroyvect);
        if (dorepaint && this.mainWindow != null && this.mainWindow.getPanel() != null) {
            this.mainWindow.getPanel().repaint();
        }
    }

    @Override
    public int getLastFocusOwnerID() {
        if (this.previousFocusOwner != null) {
            return ((RemoteBaseGUIControl)this.previousFocusOwner).getServerId();
        }
        return 0;
    }

    @Override
    public void setDockInfo(String i) {
        if (this.mainWindow != null) {
            this.mainWindow.setDockInfo(i);
        }
    }

    @Override
    public String getDockInfo() {
        if (this.mainWindow != null) {
            return this.mainWindow.getDockInfo();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParamVector getOldFocusValues() {
        RemoteDisplayWindow remoteDisplayWindow = this;
        synchronized (remoteDisplayWindow) {
            return this.oldfocusvalues;
        }
    }

    protected boolean hasControls() {
        boolean hc = false;
        if (this.mainWindow != null) {
            boolean bl = hc = this.mainWindow.getJMenuBar() != null;
            if (!hc) {
                Component[] c = this.mainWindow.getPanel().getComponents();
                for (int i = 0; i < c.length && !hc; hc |= !(c[i] instanceof Terminal) && c[i].isVisible(), ++i) {
                }
            }
            if (!hc) {
                Component[] tb = this.mainWindow.getToolPanel().getComponents();
                for (int j = 0; j < tb.length && !hc; ++j) {
                    if (!(tb[j] instanceof MyToolBar)) continue;
                    Component[] c = ((MyToolBar)((Object)tb[j])).getComponents();
                    for (int i = 0; i < c.length && !hc; hc |= c[i].isVisible(), ++i) {
                    }
                }
            }
        }
        return hc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetOldFocusValues() {
        RemoteDisplayWindow remoteDisplayWindow = this;
        synchronized (remoteDisplayWindow) {
            this.oldfocusvalues = null;
            if (this.oldfocushnd != null) {
                this.oldfocushnd.clear();
            }
            this.oldfocushnd = null;
        }
    }

    public boolean checkMnemonicMenuWithNewLocalFocusOwner(int mnchar) {
        boolean Return2 = false;
        if (this.focusOwner != null && this.getMnemonic((char)mnchar) == this.focusOwner) {
            Return2 = true;
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewLocalFocusOwner(RemoteBaseGUIControl currfocus, CobolFocusable cf) {
        RemoteDisplayWindow remoteDisplayWindow = this;
        synchronized (remoteDisplayWindow) {
            this.newLocalFocusOwner = cf;
            this.intsetNewLocalFocusOwner(currfocus, cf, (short)1042);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewLocalFocusOwner(RemoteBaseGUIControl currfocus, CobolFocusable cf, short codop) {
        RemoteDisplayWindow remoteDisplayWindow = this;
        synchronized (remoteDisplayWindow) {
            this.intsetNewLocalFocusOwner(currfocus, cf, codop);
        }
    }

    private void intsetNewLocalFocusOwner(RemoteBaseGUIControl currfocus, CobolFocusable cf, short codop) {
        if (currfocus != null && currfocus.getActiveAccept() && currfocus.isInputField()) {
            ParamElementIntString peis = null;
            if (this.oldfocusvalues == null) {
                this.oldfocusvalues = new ParamVector();
                this.oldfocushnd = new Hashtable();
            }
            this.removeFocusInOldValues(currfocus.getServerId());
            if (currfocus.getValue() != null) {
                peis = new ParamElementIntString(codop, currfocus.getServerId(), currfocus.getValue());
                this.oldfocusvalues.add(peis);
                this.oldfocushnd.put(new Integer(currfocus.getServerId()), peis);
            }
        }
        this.setFocusOwner(cf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFocusInOldValues(int sid) {
        if (this.oldfocusvalues != null && this.oldfocushnd != null) {
            RemoteDisplayWindow remoteDisplayWindow = this;
            synchronized (remoteDisplayWindow) {
                Integer srvid = new Integer(sid);
                ParamElementIntString peis = null;
                peis = (ParamElementIntString)this.oldfocushnd.get(srvid);
                if (peis != null) {
                    this.oldfocushnd.remove(srvid);
                    this.oldfocusvalues.remove(peis);
                }
            }
        }
    }

    public RemoteBaseGUIControl getNewLocalFocusOwner() {
        return (RemoteBaseGUIControl)this.newLocalFocusOwner;
    }

    public void resetNewLocalFocusOwner() {
        this.newLocalFocusOwner = null;
    }

    @Override
    public Dimension getCharDim() {
        if (this.mainWindow != null && this.mainWindow.getCharTerminal() != null) {
            return this.mainWindow.getCharTerminal().getCharDim();
        }
        return new Dimension(0, 0);
    }

    public void removeChildSubWindow(RemoteSubWindow rsw) {
        if (this.childSubWindow != null && this.childSubWindow.contains(rsw)) {
            this.childSubWindow.remove(rsw);
            if (rsw == this.rswcurrent) {
                this.rswcurrent = null;
            }
        }
    }

    public boolean getUpdownLikePrevnext() {
        return this.updown_like_prevnext;
    }

    @Override
    protected Container getPanel() {
        return this.mainWindow != null ? this.mainWindow.getPanel() : null;
    }

    public boolean isKeyboardEnabWhenDestroy() {
        return this.keyboardenabwhendestroy;
    }

    @Override
    public void centerScreen(int idx) {
        if (idx == -1 && this.screenindex > 0) {
            idx = this.screenindex;
        }
        if (idx == 0) {
            idx = 1;
        }
        if (this.mainWindow != null) {
            this.mainWindow.centerScreen(idx);
        }
    }

    @Override
    protected void setTopNotificationWindow(String t) {
        if (this.mainWindow != null && this.mainWindow.getType() == 11) {
            this.mainWindow.setTopNotificationWindow("TOP".equalsIgnoreCase(t));
        }
    }

    @Override
    protected void setLeftNotificationWindow(String l) {
        if (this.mainWindow != null && this.mainWindow.getType() == 11) {
            this.mainWindow.setLeftNotificationWindow("LEFT".equalsIgnoreCase(l));
        }
    }

    @Override
    protected void setNotificationWindowTimeout(int t) {
        if (this.mainWindow != null && this.mainWindow.getType() == 11) {
            this.mainWindow.setNotificationWindowTimeout(t);
        }
    }

    @Override
    protected void changeScreenIndex(int newidx, ScreenInfo si) {
        Rectangle rect = null;
        Rectangle rwBounds = this.mainWindow.getBounds();
        int startX = rwBounds.x;
        int startY = rwBounds.y;
        if (this.screenindex <= 0) {
            int i = 0;
            while ((rect = si.getPhysicalMonitorBounds(i + 1)) != null && !rect.contains(startX, startY)) {
                ++i;
            }
        } else {
            rect = si.getPhysicalMonitorBounds(this.screenindex);
        }
        if (rect != null) {
            startX -= rect.x;
            startY -= rect.y;
        }
        if (newidx == 0) {
            newidx = 1;
        }
        if (newidx > 0 && si != null && (rect = si.getPhysicalMonitorBounds(newidx)) != null) {
            startX += rect.x;
            startY += rect.y;
        }
        this.mainWindow.setLocation(startX, startY);
    }

    @Override
    protected void setScreenIndex(int value) {
        ScreenInfo si;
        if (this.mainWindow != null && this.mainWindow.getType() == 11) {
            this.screenindex = value;
            return;
        }
        if (value == this.screenindex || this.gf == null) {
            return;
        }
        if (value <= 0) {
            value = 0;
            if (this.ca != null && this.mainWindow != null && this.mainWindow.getWindow() != null) {
                this.mainWindow.getWindow().removeComponentListener(this.ca);
            }
        }
        if ((si = this.gf.getScreenInfo()) != null && value <= si.getNumberOfMonitors()) {
            this.changeScreenIndex(value, si);
            this.screenindex = value;
            if (this.ca == null && this.screenindex > 0) {
                this.ca = IsguiUtility.componentMovedAdapter(e -> {
                    int i = 0;
                    Rectangle rect = null;
                    while ((rect = si.getPhysicalMonitorBounds(i + 1)) != null && !rect.contains(e.getComponent().getX(), e.getComponent().getY())) {
                        ++i;
                    }
                    if (rect != null) {
                        this.screenindex = i + 1;
                    }
                });
                if (this.mainWindow != null && this.mainWindow.getWindow() != null) {
                    this.mainWindow.getWindow().addComponentListener(this.ca);
                }
            }
        }
    }

    public void setCurrentSW(RemoteSubWindow rsw) {
        this.rswcurrent = rsw;
    }

    public RemoteSubWindow getCurrentSW() {
        return this.rswcurrent;
    }

    @Override
    public void setMassUpdate(boolean set) {
        this.massupdate = set;
        if (this.mainWindow != null) {
            this.mainWindow.setMassUpdate(set);
        }
    }

    @Override
    public void setUndecorated() {
        if (this.mainWindow != null) {
            this.mainWindow.setUndecorated();
        }
    }

    @Override
    public void runMaximizePostponed() {
        if (this.actionmaximizepostponed) {
            this.actionMaximize();
            this.actionmaximizepostponed = false;
        }
    }

    private void actionMaximize() {
        if (this.autoResize && this.fixedAutoResizeDim) {
            this.mainWindow.setInitD(this.width, this.height);
        } else if (this.resizable) {
            this.mainWindow.setState(6);
        }
    }

    @Override
    public void sendMsgBox(MsgBoxEvent mbe) {
        try {
            this.gf.getMessageBox(null, this.theObject, this.msgboxfontid >= 0 ? this.msgboxfontid * -1 : this.msgboxfontid, mbe.getMsg(), this.getTitle(), 1, 3, 1, -1, -1, -1L, new String[0], false, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setMenuEntered(boolean b) {
        this.hasinmenu = b;
    }

    public boolean getMenuEntered() {
        return this.hasinmenu;
    }

    public boolean hasSelPathMenu() {
        MenuElement[] selPath = MenuSelectionManager.defaultManager().getSelectedPath();
        return selPath != null && selPath.length > 0;
    }

    private class MouseStopTimer
    extends Timer {
        RemoteBaseGUIControl rbgc;
        ActionListener al;

        MouseStopTimer(int delay) {
            super(delay, null);
            this.al = e -> {
                if (this.rbgc != null && RemoteDisplayWindow.this.mainWindow != null) {
                    RemoteDisplayWindow.this.mainWindow.pushWithPriority(new CobolEventCouple(this.rbgc, new RemoteRecordAccept(28, 0, 0)));
                }
            };
            this.addActionListener(this.al);
            this.setRepeats(false);
        }

        void cancel() {
            this.cancel(false);
        }

        void cancel(boolean removelistener) {
            if (removelistener) {
                this.removeActionListener(this.al);
            }
            this.rbgc = null;
            this.stop();
        }

        void restart(RemoteBaseGUIControl rbgc) {
            this.rbgc = rbgc;
            if (this.isRunning()) {
                this.restart();
            } else {
                this.start();
            }
        }
    }

    private class NtfResizeTimer
    extends Timer {
        CobolEventCouple cc;
        ActionListener al;

        NtfResizeTimer(int delay) {
            super(delay, null);
            this.al = e -> {
                CobolEventCouple cc = this.getCC();
                if (cc != null) {
                    RemoteDisplayWindow.this.mainWindow.push(cc);
                    this.setCC(null);
                }
            };
            this.addActionListener(this.al);
            this.setRepeats(false);
        }

        synchronized void setCC(CobolEventCouple cc) {
            this.cc = cc;
        }

        synchronized CobolEventCouple getCC() {
            return this.cc;
        }

        void restart(CobolEventCouple cc) {
            this.setCC(cc);
            if (this.isRunning()) {
                this.restart();
            } else {
                this.start();
            }
        }

        void cancel() {
            this.removeActionListener(this.al);
            this.cc = null;
            this.stop();
        }
    }

    private class PicobolTimer
    implements ActionListener {
        private long delay;
        private boolean restarted;
        private Timer t;

        public PicobolTimer(long h_seconds) {
            this.delay = h_seconds * 10L;
            this.t = new Timer((int)this.delay, this);
            this.t.setInitialDelay((int)this.delay);
            this.t.setRepeats(true);
        }

        public void start() {
            this.restarted = true;
            this.t.start();
        }

        public void stop() {
            this.restarted = false;
            this.t.stop();
        }

        public void restart() {
            this.restarted = true;
            this.t.restart();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.restarted && RemoteDisplayWindow.this.mainWindow != null) {
                this.restarted = false;
                RemoteDisplayWindow.this.mainWindow.pushWithPriority(new CobolEventCouple(RemoteDisplayWindow.this, new RemoteRecordAccept(19, 90000, 0)));
            }
        }
    }
}

