/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolScrollBar;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;

public class RemoteScrollBar
extends RemoteBaseGUIControl {
    private int minValue = 0;
    private int maxValue = 100;
    private int pageSize = 0;
    private boolean horizontalStyle;
    private boolean thumbTrackStyle;
    private int scrollValue = this.minValue;
    private boolean isProgramEvt;

    public RemoteScrollBar(GuiFactoryImpl gf) {
        super(gf);
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultHeight() {
        if (this.horizontalStyle) {
            return 1.5f;
        }
        return 0.0f;
    }

    @Override
    public float getDefaultWidth() {
        if (this.horizontalStyle) {
            return 0.0f;
        }
        return 2.7f;
    }

    @Override
    public int getGUIControlHeight(float height) {
        if (this.font != null) {
            return (int)((float)this.font.getHeight() * height);
        }
        return 20;
    }

    @Override
    public int getGUIControlWidth(float width) {
        if (this.font != null) {
            return (int)((float)this.font.getWidth() * width);
        }
        return 20;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getValue() {
        if (this.guiComponent == null) {
            return "";
        }
        return Integer.toString(((PicobolScrollBar)this.guiComponent).getValue());
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        this.guiComponent = new PicobolScrollBar();
        this.guiComponent.addKeyListener(this);
        PicobolScrollBar sb = (PicobolScrollBar)this.guiComponent;
        this.setHorizontal(this.horizontalStyle);
        super.intInitialize();
        sb.setMinimum(this.minValue);
        sb.setMaximum(this.maxValue);
        sb.setVisibleAmount(this.pageSize);
        sb.setValue(this.scrollValue);
        sb.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (RemoteScrollBar.this.isProgramEvt) {
                    RemoteScrollBar.this.isProgramEvt = false;
                } else {
                    RemoteScrollBar.this.responseOnAction(e.getValue());
                }
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        switch (ke.getKeyCode()) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return;
            }
        }
        super.keyPressed(ke);
    }

    private void responseOnAction(int val) {
        PicobolScrollBar sb = (PicobolScrollBar)this.guiComponent;
        ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        if (val != this.scrollValue) {
            CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(7, 0, 16389, 0, val, false, false, true));
            this.pushEvent(cc);
        }
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        PicobolScrollBar sb = (PicobolScrollBar)this.guiComponent;
        String Return2 = "0";
        int intValue = -1;
        boolean error = false;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        switch (key) {
            case 148: {
                if (error) break;
                this.maxValue = intValue;
                if (sb != null) {
                    sb.setMaximum(this.maxValue);
                }
                Return2 = "1";
                break;
            }
            case 152: {
                if (error) break;
                this.minValue = intValue;
                if (sb != null) {
                    sb.setMinimum(this.minValue);
                }
                Return2 = "1";
                break;
            }
            case 162: {
                if (error) break;
                this.pageSize = intValue;
                if (sb != null) {
                    sb.setVisibleAmount(this.pageSize);
                }
                Return2 = "1";
                break;
            }
            default: {
                return super.setProp(key, value, length);
            }
        }
        return Return2;
    }

    @Override
    public void setRowsCols(float r, float c) {
    }

    @Override
    public void setStyle(int s, boolean set) {
        if ((s & 1) == 1) {
            this.setHorizontal(set);
        }
        if ((s & 2) == 2) {
            this.thumbTrackStyle = set;
        }
    }

    @Override
    public void setTitle(String v) {
    }

    private void setHorizontal(boolean h) {
        this.horizontalStyle = h;
        PicobolScrollBar sb = (PicobolScrollBar)this.guiComponent;
        if (sb != null) {
            sb.setOrientation(this.horizontalStyle ? 0 : 1);
        }
    }

    @Override
    public String setValue(String v) {
        try {
            this.scrollValue = Integer.parseInt(v.trim());
            this.setValue(this.scrollValue);
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void setValue(int v) {
        PicobolScrollBar sb = (PicobolScrollBar)this.guiComponent;
        if (sb != null && sb.getValue() != this.scrollValue) {
            this.isProgramEvt = true;
            ((PicobolScrollBar)this.guiComponent).setValue(this.scrollValue);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
        PicobolScrollBar sb = (PicobolScrollBar)this.guiComponent;
        if (sb != null && sb.getValue() != this.scrollValue) {
            this.isProgramEvt = true;
            sb.setValue(this.scrollValue);
        }
    }

    @Override
    public void setCols(float cols) {
    }

    @Override
    public void setRows(float cols) {
    }

    @Override
    public void intFocusGained(boolean restore) {
    }

    @Override
    public void setSize(int w, int h, boolean setOnComp) {
        super.setSize(w, h, setOnComp);
        if (this.guiComponent != null && setOnComp) {
            this.guiComponent.doLayout();
        }
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (v && this.parentWindow != null && (this.width == 0 || this.height == 0)) {
            Rectangle r = ((RemoteDisplayWindow)this.parentWindow).getBounds();
            if (this.width == 0) {
                this.width = r.width - this.x;
            }
            if (this.height == 0) {
                this.height = r.height - this.y;
            }
            this.setSize(this.width, this.height);
        }
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    public String getType() {
        if (this.horizontalStyle) {
            return "hscrollbar";
        }
        return "vscrollbar";
    }
}

