/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.ZoomLayout;
import com.iscobol.gui.client.swing.Filterable;
import com.iscobol.gui.client.swing.IsTreeViewModel;
import com.iscobol.gui.client.swing.PopupListener;
import com.iscobol.gui.client.swing.TreeTableViewModel;
import com.iscobol.gui.client.swing.TreeView;
import com.iscobol.gui.client.swing.TreeViewNode;
import com.iscobol.gui.client.swing.treetable.JTreeTable;
import com.iscobol.gui.client.swing.treetable.TreeTableModel;
import com.iscobol.gui.client.swing.treetable.TreeTableModelAdapter;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeTableView
extends JTreeTable {
    public static final int NO_SORT = 0;
    public static final int ALPHANUMERIC_CASE_SENSITIVE_SORT = 1;
    public static final int ALPHANUMERIC_CASE_INSENSITIVE_SORT = 2;
    public static final int NUMERIC_SORT = 3;
    public static final int DATE_MDY_SORT = 4;
    public static final int DATE_DMY_SORT = 5;
    public static final int DATE_YMD_SORT = 6;
    private static final boolean decPointComma = VirtualKeyboard.LOCALE_DECIMAL_SEPARATOR == ',';
    private boolean adjustableColumns;
    private float cellWidth;
    private float resizeDelta = 1.0f;
    private TreeView tree;
    private IsTreeViewModel treeModel;
    private Vector<ColumnInfo> columnInfos;
    private int hiddenColumnCount;
    private boolean lmOnColumns;
    private int[] displayColumns;
    private int virtualWidth;
    private Font headingFont;
    private Color headingBackground;
    private Color headingForeground;
    private boolean sortableColumns;
    private boolean centerHeadings;
    private boolean tiledHeadings;
    private boolean columnHeadings;
    private JTableHeader tableHeader;
    private JPopupMenu headerPopup;
    private MyRowSorter rowSorter;
    private int sortColumn = -1;
    private int lastW;
    private boolean changedRowSelection;
    private MouseListener headingMenuListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TreeTableView.this.headerPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    };
    private PopupListener popupListener;
    private boolean headingMenuPopup;
    private Map<TreeViewNode, TreeViewNode[]> sortedChildren;

    public TreeTableView(TreeView tree, IsTreeViewModel treeModel) {
        super(tree, treeModel);
        this.tree = tree;
        this.treeModel = treeModel;
        this.rowSorter = new MyRowSorter((TreeTableModelAdapter)this.getModel());
        tree.setTreeTable(this);
        this.setAutoResizeMode(0);
        this.setAutoCreateColumnsFromModel(false);
        this.setSelectionMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.tableHeader = this.getTableHeader();
        this.headerPopup = new JPopupMenu();
        this.columnInfos = new Vector();
        this.setTableHeader(null);
        this.setDefaultRenderer(String.class, new CellRenderer());
        this.tableHeader.setDefaultRenderer(new HeaderCellRenderer());
        this.treeModel.setTreeTableModel(new TreeTableViewModel(){

            @Override
            public boolean isCellEditable(Object node, int column) {
                return this.getColumnClass(column) == TreeTableModel.class;
            }

            @Override
            public Object getValueAt(Object node, int column) {
                TreeViewNode tvn = (TreeViewNode)node;
                if (tvn != null) {
                    return tvn.getText(column);
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                return TreeTableView.this.displayColumns != null ? TreeTableView.this.displayColumns.length + 1 - TreeTableView.this.hiddenColumnCount : 1;
            }

            @Override
            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return TreeTableModel.class;
                    }
                }
                return String.class;
            }

            @Override
            public int[] nodesChanged(TreeNode n, int[] idxs) {
                TreeViewNode[] children;
                if (TreeTableView.this.sortedChildren != null && (children = (TreeViewNode[])TreeTableView.this.sortedChildren.get(n)) != null) {
                    return this.getNewIdxs(n, children, idxs);
                }
                return null;
            }

            private int[] getNewIdxs(TreeNode parent, TreeViewNode[] sortedChildren, int[] idxs) {
                int[] newIdxs = new int[idxs.length];
                block0: for (int i = 0; i < idxs.length; ++i) {
                    TreeViewNode c = (TreeViewNode)parent.getChildAt(idxs[i]);
                    for (int j = 0; j < sortedChildren.length; ++j) {
                        if (c != sortedChildren[j]) continue;
                        newIdxs[i] = j;
                        continue block0;
                    }
                }
                return newIdxs;
            }

            @Override
            public int[] nodesWereInserted(TreeNode n, int[] idxs) {
                if (TreeTableView.this.sortedChildren != null) {
                    TreeViewNode[] children = new TreeViewNode[n.getChildCount()];
                    for (int i = 0; i < children.length; ++i) {
                        children[i] = (TreeViewNode)n.getChildAt(i);
                    }
                    if (children.length > 1) {
                        TreeViewNode[] tmp = new TreeViewNode[children.length];
                        System.arraycopy(children, 0, tmp, 0, children.length);
                        Arrays.sort(children, TreeTableView.this.rowSorter.getComparator(TreeTableView.this.sortColumn));
                        TreeTableView.this.sortedChildren.put((TreeViewNode)n, children);
                        return this.getNewIdxs(n, children, idxs);
                    }
                    return idxs;
                }
                return null;
            }

            @Override
            public int[] nodesWereRemoved(TreeNode n, int[] idxs, Object[] childs) {
                TreeViewNode[] children;
                if (TreeTableView.this.sortedChildren != null && (children = (TreeViewNode[])TreeTableView.this.sortedChildren.get(n)) != null) {
                    int[] newIdxs = this.getNewIdxs(n, children, idxs);
                    for (int i = 0; i < newIdxs.length; ++i) {
                        children[newIdxs[i]] = null;
                    }
                    ArrayList<TreeViewNode> newChildren = new ArrayList<TreeViewNode>();
                    for (int i = 0; i < children.length; ++i) {
                        if (children[i] == null) continue;
                        newChildren.add(children[i]);
                    }
                    TreeTableView.this.sortedChildren.put((TreeViewNode)n, newChildren.toArray(new TreeViewNode[newChildren.size()]));
                    return newIdxs;
                }
                return null;
            }

            @Override
            public int getIndexOfChild(Object parent, Object child) {
                TreeViewNode[] children;
                if (TreeTableView.this.sortedChildren != null && (children = (TreeViewNode[])TreeTableView.this.sortedChildren.get(parent)) != null) {
                    for (int i = 0; i < children.length; ++i) {
                        if (child != children[i]) continue;
                        return i;
                    }
                }
                return -1;
            }

            @Override
            public int getChildCount(Object parent) {
                TreeViewNode[] children;
                if (TreeTableView.this.sortedChildren != null && (children = (TreeViewNode[])TreeTableView.this.sortedChildren.get(parent)) != null) {
                    return children.length;
                }
                return -1;
            }

            @Override
            public Object getChild(Object parent, int index) {
                TreeViewNode[] children;
                if (TreeTableView.this.sortedChildren != null && (children = (TreeViewNode[])TreeTableView.this.sortedChildren.get(parent)) != null && index < children.length) {
                    return children[index];
                }
                return null;
            }
        });
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                JTableHeader h = TreeTableView.this.getTableHeader();
                if (TreeTableView.this.lmOnColumns && TreeTableView.this.displayColumns != null && h != null && h.getResizingColumn() != null) {
                    TableColumn tc = h.getResizingColumn();
                    for (ColumnInfo ci : TreeTableView.this.columnInfos) {
                        if (ci.column != tc) continue;
                        int cIdx = ci.columnIndex;
                        if (cIdx >= TreeTableView.this.displayColumns.length) break;
                        float w = ci.column.getWidth();
                        int cellCount = Math.round(w / TreeTableView.this.cellWidth / TreeTableView.this.resizeDelta);
                        int prev = cIdx > 0 ? TreeTableView.this.displayColumns[cIdx - 1] : 0;
                        int diff = prev + cellCount - TreeTableView.this.displayColumns[cIdx];
                        ((TreeTableView)TreeTableView.this).displayColumns[cIdx] = prev + cellCount;
                        int i = cIdx + 1;
                        while (i < TreeTableView.this.displayColumns.length) {
                            int[] nArray = TreeTableView.this.displayColumns;
                            int n = i++;
                            nArray[n] = nArray[n] + diff;
                        }
                        break block0;
                    }
                }
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }
        });
    }

    public void setReorderingColumns(boolean b) {
        this.tableHeader.setReorderingAllowed(b);
    }

    public void setAdjustableColumns(boolean b) {
        this.adjustableColumns = b;
        for (int i = 0; i < this.columnInfos.size(); ++i) {
            this.columnInfos.elementAt((int)i).column.setResizable(b);
        }
    }

    public static int[] getSortType(String sortType) {
        sortType = sortType.trim().toUpperCase();
        int[] ret = new int[]{0, 0};
        if (sortType.length() == 0) {
            return ret;
        }
        switch (sortType.charAt(0)) {
            case 'X': 
            case 'x': {
                if (sortType.length() == 1) {
                    ret[0] = 2;
                    break;
                }
                if (sortType.length() != 2 || sortType.charAt(1) != '^') break;
                ret[0] = 2;
                ret[1] = 1;
                break;
            }
            case 'L': 
            case 'U': 
            case 'l': 
            case 'u': {
                if (sortType.length() == 1) {
                    ret[0] = 1;
                    break;
                }
                if (sortType.length() != 2 || sortType.charAt(1) != '^') break;
                ret[0] = 1;
                ret[1] = 1;
                break;
            }
            case '9': {
                if (sortType.length() == 1) {
                    ret[0] = 3;
                    break;
                }
                if (sortType.length() != 2 || sortType.charAt(1) != '^') break;
                ret[0] = 3;
                ret[1] = 1;
                break;
            }
            case '-': {
                if (sortType.length() != 1) break;
                ret[0] = 0;
                break;
            }
            case 'D': 
            case 'E': 
            case 'd': 
            case 'e': {
                if (sortType.length() == 1) {
                    ret[0] = 4;
                    break;
                }
                if (sortType.charAt(1) == '^') {
                    ret[1] = 1;
                    sortType = sortType.substring(2);
                } else {
                    sortType = sortType.substring(1);
                }
                if (sortType.length() > 0) {
                    if ("(MDY)".equals(sortType)) {
                        ret[0] = 4;
                        break;
                    }
                    if ("(DMY)".equals(sortType)) {
                        ret[0] = 5;
                        break;
                    }
                    if (!"(YMD)".equals(sortType)) break;
                    ret[0] = 6;
                    break;
                }
                ret[0] = 4;
            }
        }
        return ret;
    }

    public void setSortTypes(int[] sortTypes, boolean[] sortDesc) {
        for (int i = 0; i < sortTypes.length && i < this.columnInfos.size(); ++i) {
            ColumnInfo info = this.columnInfos.elementAt(i);
            info.sortType = sortTypes[i];
            info.initialSortState = sortDesc[i] ? SortState.DESCENDING : SortState.ASCENDING;
        }
    }

    public void setAlignments(String[] a) {
        for (int i = 0; i < a.length && i < this.columnInfos.size(); ++i) {
            ColumnInfo info = this.columnInfos.elementAt(i);
            info.alignment = a[i];
        }
    }

    public void setDisplayColumns(int[] displayColumns, int[] sortTypes, boolean[] sortDesc) {
        this.displayColumns = displayColumns;
        this.hiddenColumnCount = 0;
        this.columnInfos.clear();
        this.headerPopup.removeAll();
        this.createDefaultColumnsFromModel();
        int columnCount = this.getColumnModel().getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn tc = this.getColumnModel().getColumn(i);
            ColumnInfo info = new ColumnInfo(tc, i);
            if (i < sortTypes.length) {
                info.sortType = sortTypes[i];
            }
            if (i < sortDesc.length) {
                info.initialSortState = sortDesc[i] ? SortState.DESCENDING : SortState.ASCENDING;
            }
            this.columnInfos.addElement(info);
            if (i <= 0) continue;
            Object colName = tc.getHeaderValue();
            info.item = new JCheckBoxMenuItem(colName != null ? colName.toString() : "");
            info.item.setSelected(true);
            info.item.setActionCommand("" + i);
            info.item.addActionListener(e -> {
                if (info.item.isSelected()) {
                    this.addColumn(Integer.parseInt(info.item.getActionCommand()));
                } else if (this.hiddenColumnCount < columnCount - 1) {
                    this.removeColumn(Integer.parseInt(info.item.getActionCommand()));
                } else {
                    info.item.setSelected(true);
                }
            });
            this.headerPopup.add(info.item);
        }
        this.setupColumns();
    }

    private void setupColumns() {
        if (this.displayColumns != null && this.displayColumns.length > 0) {
            int i;
            int prev = 0;
            for (i = 0; i < this.displayColumns.length && i < this.columnInfos.size() && (this.virtualWidth == 0 || this.displayColumns[i] < this.virtualWidth); ++i) {
                int dc = this.displayColumns[i] - 1;
                this.columnInfos.elementAt((int)i).column.setPreferredWidth(Math.round((float)(dc - prev) * this.cellWidth * this.resizeDelta));
                prev = dc;
            }
            this.adjustLastColumnWidth(i);
            this.setAdjustableColumns(this.adjustableColumns);
        } else if (this.virtualWidth == 0) {
            this.adjustLastColumnWidth(0);
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.tree != null) {
            this.tree.setFont(f);
            if (this.headingFont == null) {
                this.tableHeader.setFont(f);
            }
            if (!this.isZoomLayingOut()) {
                FontMetrics fm = this.getFontMetrics(f);
                this.cellWidth = fm.stringWidth("0");
                this.setupColumns();
            }
        }
    }

    public int getVirtualWidth() {
        return this.virtualWidth;
    }

    public void setVirtualWidth(int virtualWidth) {
        this.virtualWidth = virtualWidth;
        if (this.displayColumns != null && this.displayColumns.length > 0) {
            int i;
            for (i = 0; i < this.displayColumns.length && (virtualWidth == 0 || this.displayColumns[i] < virtualWidth); ++i) {
            }
            this.adjustLastColumnWidth(i);
        }
    }

    private void adjustLastColumnWidth(int lastColIdx) {
        if (this.displayColumns == null || this.columnInfos == null || this.displayColumns.length + 1 != this.columnInfos.size()) {
            return;
        }
        if (this.virtualWidth > 0) {
            int dc = this.virtualWidth - this.displayColumns[lastColIdx - 1] + 1;
            if (dc > 0) {
                this.columnInfos.elementAt((int)lastColIdx).column.setPreferredWidth(Math.round(this.cellWidth * this.resizeDelta * (float)dc));
            }
        } else if (lastColIdx > 0) {
            int colWidth = Math.round((float)(this.displayColumns[lastColIdx - 1] - 1) * this.cellWidth * this.resizeDelta);
            if (this.lastW > colWidth) {
                this.columnInfos.elementAt((int)lastColIdx).column.setPreferredWidth(this.lastW - colWidth);
            }
        } else if (this.columnInfos.size() > 0) {
            this.columnInfos.elementAt((int)0).column.setPreferredWidth(this.lastW);
        }
    }

    public void containerWidthChanged(int w) {
        if (w != this.lastW) {
            this.lastW = w;
            if (this.virtualWidth == 0) {
                this.adjustLastColumnWidth(this.displayColumns != null ? this.displayColumns.length : 0);
            }
        }
    }

    public Font getHeadingFont() {
        return this.headingFont;
    }

    public void setHeadingFont(Font headingFont) {
        this.headingFont = headingFont;
        this.repaint();
    }

    protected void setResizeWidthDelta(float d) {
        this.resizeDelta = d;
        this.setupColumns();
    }

    public Color getHeadingBackground() {
        return this.headingBackground;
    }

    public void setHeadingBackground(Color headingBackground) {
        this.headingBackground = headingBackground;
        this.repaint();
    }

    public Color getHeadingForeground() {
        return this.headingForeground;
    }

    public void setHeadingForeground(Color headingForeground) {
        this.headingForeground = headingForeground;
        this.repaint();
    }

    public boolean isCenterHeadings() {
        return this.centerHeadings;
    }

    public void setCenterHeadings(boolean centerHeadings) {
        this.centerHeadings = centerHeadings;
        this.repaint();
    }

    public boolean isTiledHeadings() {
        return this.tiledHeadings;
    }

    public void setTiledHeadings(boolean tiledHeadings) {
        this.tiledHeadings = tiledHeadings;
        this.repaint();
    }

    public boolean isColumnHeadings() {
        return this.columnHeadings;
    }

    public void setColumnHeadings(boolean columnHeadings) {
        this.columnHeadings = columnHeadings;
        this.setTableHeader(columnHeadings ? this.tableHeader : null);
    }

    public void setColumnName(int colIdx, String name) {
        if (colIdx < this.columnInfos.size()) {
            ColumnInfo info = this.columnInfos.elementAt(colIdx);
            info.column.setHeaderValue(name);
            if (info.item != null) {
                info.item.setText(name);
            }
        }
    }

    @Override
    protected void processEvent(AWTEvent e) {
        switch (e.getID()) {
            case 400: 
            case 401: 
            case 402: {
                e.setSource(this.tree);
                this.tree.processEvent(e);
                break;
            }
            default: {
                super.processEvent(e);
            }
        }
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        super.addMouseListener(ml);
        if (this.tree != null) {
            this.tree.addMouseListener(ml);
        }
        if (ml instanceof PopupListener) {
            this.popupListener = (PopupListener)ml;
        }
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(ml);
        }
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        super.removeMouseListener(ml);
        if (this.tree != null) {
            this.tree.removeMouseListener(ml);
        }
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(ml);
        }
    }

    @Override
    public void clearSelection() {
    }

    public TreeView getTree() {
        return this.tree;
    }

    public void addColumn(int i) {
        if (i > 0 && i < this.columnInfos.size()) {
            ColumnInfo info = this.columnInfos.elementAt(i);
            if (info.hidden) {
                TableColumnModel tcm = this.getColumnModel();
                --this.hiddenColumnCount;
                tcm.addColumn(info.column);
                if (info.insertionIndex < tcm.getColumnCount() - 1) {
                    tcm.moveColumn(tcm.getColumnCount() - 1, info.insertionIndex);
                }
                info.hidden = false;
                if (info.item != null) {
                    info.item.setSelected(true);
                }
                this.doLayout();
            }
        }
    }

    public void removeColumn(int i) {
        if (i > 0 && i < this.columnInfos.size()) {
            ColumnInfo info = this.columnInfos.elementAt(i);
            if (!info.hidden) {
                info.insertionIndex = this.convertColumnIndexToView(i);
                TableColumnModel tcm = this.getColumnModel();
                ++this.hiddenColumnCount;
                tcm.removeColumn(info.column);
                info.hidden = true;
                if (info.item != null) {
                    info.item.setSelected(false);
                }
                this.doLayout();
            }
        }
    }

    public boolean isHeadingMenuPopup() {
        return this.headingMenuPopup;
    }

    public void setHeadingMenuPopup(boolean headingMenuPopup) {
        if (this.headingMenuPopup != headingMenuPopup) {
            this.headingMenuPopup = headingMenuPopup;
            if (this.tableHeader != null) {
                if (this.headingMenuPopup) {
                    if (this.popupListener != null) {
                        this.tableHeader.removeMouseListener(this.popupListener);
                    }
                    this.tableHeader.addMouseListener(this.headingMenuListener);
                } else {
                    if (this.popupListener != null) {
                        this.tableHeader.addMouseListener(this.popupListener);
                    }
                    this.tableHeader.removeMouseListener(this.headingMenuListener);
                }
            }
        }
    }

    public JPopupMenu getHeaderPopup() {
        return this.headerPopup;
    }

    private boolean isZoomLayingOut() {
        for (Container cnt = this.getParent(); cnt != null; cnt = cnt.getParent()) {
            if (!(cnt.getLayout() instanceof ZoomLayout)) continue;
            return ((ZoomLayout)cnt.getLayout()).isLayingOut();
        }
        return false;
    }

    public boolean isSortableColumns() {
        return this.sortableColumns;
    }

    public void setSortableColumns(boolean sortableColumns) {
        if (this.sortableColumns != sortableColumns) {
            this.sortableColumns = sortableColumns;
            this.setRowSorter(this.sortableColumns ? this.rowSorter : null);
        }
    }

    @Override
    protected boolean shouldFireMouseEventsInEditor() {
        return !this.tree.isProcessingEvent();
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel(){

            @Override
            public void moveColumn(int columnIndex, int newIndex) {
                if (columnIndex > 0 && newIndex > 0) {
                    super.moveColumn(columnIndex, newIndex);
                } else {
                    TreeTableView.this.getTableHeader().repaint();
                }
            }
        };
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        this.changedRowSelection = this.getSelectedRow() != rowIndex;
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    boolean isChangedRowSelection() {
        return this.changedRowSelection;
    }

    void setChangedRowSelection(boolean b) {
        this.changedRowSelection = b;
    }

    public boolean isLmOnColumns() {
        return this.lmOnColumns;
    }

    public void setLmOnColumns(boolean lmOnColumns) {
        this.lmOnColumns = lmOnColumns;
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() != 506) {
            super.processMouseMotionEvent(e);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TreeViewNode node;
        String h;
        String Return2 = super.getToolTipText();
        int r = this.rowAtPoint(event.getPoint());
        int c = this.columnAtPoint(event.getPoint());
        TreePath path = this.tree.getPathForRow(r);
        if (path != null && (h = (node = (TreeViewNode)path.getLastPathComponent()).getHint(c)) != null) {
            Return2 = h;
        }
        return Return2;
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ColumnInfo info;
            int modelIdx = TreeTableView.this.convertColumnIndexToModel(column);
            ColumnInfo columnInfo = info = modelIdx < TreeTableView.this.columnInfos.size() ? (ColumnInfo)TreeTableView.this.columnInfos.elementAt(modelIdx) : null;
            if (info != null && info.alignment != null && !"U".equalsIgnoreCase(info.alignment) && value instanceof String) {
                value = value.toString().trim();
            }
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel lbl = (JLabel)c;
            TreeViewNode node = null;
            TreePath path = TreeTableView.this.tree.getPathForRow(row);
            if (path != null) {
                node = (TreeViewNode)path.getLastPathComponent();
            }
            if (value != null && node != null && node.getRoot() instanceof Filterable) {
                String htext;
                int fslen;
                int m = Integer.MIN_VALUE;
                String fs = ((Filterable)((Object)node.getRoot())).getFilterString();
                boolean cs = ((Filterable)((Object)node.getRoot())).isFilterCaseSensitive();
                if (fs != null && (fslen = fs.length()) > 0) {
                    if (!cs) {
                        fs = fs.toLowerCase();
                    }
                    if (node == TreeTableView.this.tree.getCurrentMatchNode()) {
                        m = 0;
                        for (int i = 0; i < column; ++i) {
                            String t = node.getText(i);
                            if (!cs) {
                                t = t.toLowerCase();
                            }
                            int idx = 0;
                            while ((idx = t.indexOf(fs, idx)) >= 0) {
                                ++m;
                                idx += fslen;
                            }
                        }
                    }
                }
                if ((htext = TreeTableView.this.tree.getTextWithHighlight(value.toString(), m, fs, cs)) != null) {
                    lbl.setText(htext);
                }
            }
            if (info != null) {
                if ("C".equalsIgnoreCase(info.alignment)) {
                    lbl.setHorizontalAlignment(0);
                } else if ("R".equalsIgnoreCase(info.alignment)) {
                    lbl.setHorizontalAlignment(4);
                } else {
                    lbl.setHorizontalAlignment(2);
                }
            }
            lbl.setOpaque(isSelected);
            if (node != null) {
                if (!isSelected) {
                    if (node.getForeground() != null) {
                        c.setForeground(node.getForeground());
                    }
                    if (node.getBackground() != null) {
                        lbl.setOpaque(true);
                        c.setBackground(node.getBackground());
                    }
                }
                lbl.setIcon(node.getIcon(column));
                if (node.getImgTrailing(column) != 0) {
                    lbl.setHorizontalTextPosition(2);
                } else {
                    lbl.setHorizontalTextPosition(4);
                }
            }
            return c;
        }
    }

    private class HeaderCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private Color defBackground = UIManager.getColor("TableHeader.background");
        private Color defForeground = UIManager.getColor("TableHeader.foreground");
        private Border defBorder = UIManager.getBorder("TableHeader.cellBorder");
        private JLabel label;
        private Icon descIcon = UIManager.getIcon("Table.descendingSortIcon");
        private Icon ascIcon;
        private Icon unsortedIcon;
        private Icon sortIcon;

        HeaderCellRenderer() {
            if (this.descIcon != null) {
                this.ascIcon = UIManager.getIcon("Table.ascendingSortIcon");
                final int iconW = this.descIcon.getIconWidth();
                final int iconH = this.descIcon.getIconHeight();
                this.unsortedIcon = new Icon(){

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                    }

                    @Override
                    public int getIconWidth() {
                        return iconW;
                    }

                    @Override
                    public int getIconHeight() {
                        return iconH;
                    }
                };
            }
            this.setLayout(new BorderLayout(2, 2));
            this.label = new JLabel(){

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (HeaderCellRenderer.this.sortIcon != null) {
                        HeaderCellRenderer.this.sortIcon.paintIcon(this, g, this.getWidth() - HeaderCellRenderer.this.sortIcon.getIconWidth() - 5, (this.getHeight() - HeaderCellRenderer.this.sortIcon.getIconHeight()) / 2);
                    }
                }
            };
            this.label.setVerticalTextPosition(0);
            this.add((Component)this.label, "Center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String align;
            if (TreeTableView.this.centerHeadings) {
                align = "C";
            } else {
                ColumnInfo info;
                align = "U";
                if (column < TreeTableView.this.columnInfos.size() && (info = (ColumnInfo)TreeTableView.this.columnInfos.get(column)) != null && info.alignment != null) {
                    align = info.alignment;
                }
            }
            String s = !"U".equalsIgnoreCase(align) && value instanceof String ? value.toString().trim() : (value != null ? value.toString() : "");
            this.label.setText(s);
            if ("C".equalsIgnoreCase(align)) {
                this.label.setHorizontalAlignment(0);
            } else if ("R".equalsIgnoreCase(align)) {
                this.label.setHorizontalAlignment(4);
            } else {
                this.label.setHorizontalAlignment(2);
            }
            if (TreeTableView.this.headingFont != null) {
                this.label.setFont(TreeTableView.this.headingFont);
            } else {
                this.label.setFont(TreeTableView.this.getFont());
            }
            if (TreeTableView.this.headingBackground != null) {
                this.setBackground(TreeTableView.this.headingBackground);
            } else if (this.defBackground != null) {
                this.setBackground(this.defBackground);
            } else {
                this.setBackground(Color.gray);
            }
            if (TreeTableView.this.headingForeground != null) {
                this.label.setForeground(TreeTableView.this.headingForeground);
            } else if (this.defForeground != null) {
                this.label.setForeground(this.defForeground);
            } else {
                this.label.setForeground(Color.black);
            }
            if (TreeTableView.this.tiledHeadings) {
                this.setBorder(BorderFactory.createRaisedBevelBorder());
            } else if (this.defBorder != null) {
                this.setBorder(this.defBorder);
            }
            if (TreeTableView.this.sortableColumns) {
                int modelCol = TreeTableView.this.convertColumnIndexToModel(column);
                if (modelCol == TreeTableView.this.sortColumn && ((ColumnInfo)((TreeTableView)TreeTableView.this).columnInfos.elementAt((int)modelCol)).sortType != 0) {
                    switch (((ColumnInfo)((TreeTableView)TreeTableView.this).columnInfos.elementAt((int)modelCol)).sortState) {
                        case ASCENDING: {
                            this.sortIcon = this.ascIcon;
                            break;
                        }
                        case DESCENDING: {
                            this.sortIcon = this.descIcon;
                            break;
                        }
                        default: {
                            this.sortIcon = this.unsortedIcon;
                            break;
                        }
                    }
                } else {
                    this.sortIcon = this.unsortedIcon;
                }
                TreeTableView.this.tableHeader.repaint();
            } else {
                this.sortIcon = null;
            }
            return this;
        }
    }

    private class MyRowSorter
    extends TableRowSorter<TreeTableModelAdapter> {
        MyRowSorter(TreeTableModelAdapter model) {
            super(model);
        }

        @Override
        public void sort() {
        }

        @Override
        public int convertRowIndexToModel(int index) {
            return index;
        }

        @Override
        public int convertRowIndexToView(int index) {
            return index;
        }

        @Override
        public boolean isSortable(int column) {
            return ((ColumnInfo)((TreeTableView)TreeTableView.this).columnInfos.elementAt((int)column)).sortType != 0;
        }

        @Override
        public Comparator<TreeViewNode> getComparator(int column) {
            return ((ColumnInfo)TreeTableView.this.columnInfos.elementAt(column)).getComparator();
        }

        private void sortChildren(TreeViewNode node) {
            TreeViewNode[] children = new TreeViewNode[node.getChildCount()];
            for (int i = 0; i < children.length; ++i) {
                children[i] = (TreeViewNode)node.getChildAt(i);
                this.sortChildren(children[i]);
            }
            if (children.length > 1) {
                TreeViewNode[] tmp = new TreeViewNode[children.length];
                System.arraycopy(children, 0, tmp, 0, children.length);
                Arrays.sort(children, this.getComparator(TreeTableView.this.sortColumn));
                TreeTableView.this.sortedChildren.put(node, children);
            }
        }

        @Override
        public void toggleSortOrder(int column) {
            if (!this.isSortable(column)) {
                return;
            }
            if (Cursor.getPredefinedCursor(11) == TreeTableView.this.getTableHeader().getCursor()) {
                return;
            }
            for (int i = 0; i < TreeTableView.this.columnInfos.size(); ++i) {
                if (i == column) continue;
                ((ColumnInfo)((TreeTableView)TreeTableView.this).columnInfos.elementAt((int)i)).sortState = SortState.UNSORTED;
            }
            TreeTableView.this.sortColumn = column;
            ColumnInfo info = (ColumnInfo)TreeTableView.this.columnInfos.elementAt(TreeTableView.this.sortColumn);
            switch (info.sortState) {
                case UNSORTED: {
                    info.sortState = info.initialSortState;
                    break;
                }
                case ASCENDING: {
                    if (info.initialSortState == SortState.ASCENDING) {
                        info.sortState = SortState.DESCENDING;
                        break;
                    }
                    info.sortState = SortState.UNSORTED;
                    break;
                }
                case DESCENDING: {
                    info.sortState = info.initialSortState == SortState.DESCENDING ? SortState.ASCENDING : SortState.UNSORTED;
                }
            }
            if (info.sortState == SortState.UNSORTED) {
                if (TreeTableView.this.sortedChildren != null) {
                    TreeTableView.this.sortedChildren.clear();
                }
                TreeTableView.this.sortedChildren = null;
            } else {
                TreeTableView.this.sortedChildren = new HashMap();
                TreeViewNode root = (TreeViewNode)TreeTableView.this.treeModel.getRoot();
                this.sortChildren(root);
            }
            TreeTableView.this.tree.tableSorted();
        }
    }

    private static class ColumnInfo {
        TableColumn column;
        int columnIndex;
        int insertionIndex;
        boolean hidden;
        SortState sortState = SortState.UNSORTED;
        SortState initialSortState = SortState.ASCENDING;
        int sortType = 2;
        Comparator<TreeViewNode> comparator;
        JCheckBoxMenuItem item;
        String alignment = "U";

        ColumnInfo(TableColumn tc, int columnIndex) {
            this.column = tc;
            this.columnIndex = columnIndex;
            this.insertionIndex = columnIndex;
        }

        Comparator<TreeViewNode> getComparator() {
            if (this.comparator == null && this.sortType != 0) {
                Comparator<TreeViewNode> asc;
                switch (this.sortType) {
                    default: {
                        asc = new Comparator<TreeViewNode>(){

                            @Override
                            public int compare(TreeViewNode o1, TreeViewNode o2) {
                                return o1.getText(columnIndex).compareTo(o2.getText(columnIndex));
                            }
                        };
                        break;
                    }
                    case 2: {
                        asc = new Comparator<TreeViewNode>(){

                            @Override
                            public int compare(TreeViewNode o1, TreeViewNode o2) {
                                return o1.getText(columnIndex).compareToIgnoreCase(o2.getText(columnIndex));
                            }
                        };
                        break;
                    }
                    case 3: {
                        asc = new Comparator<TreeViewNode>(){

                            @Override
                            public int compare(TreeViewNode o1, TreeViewNode o2) {
                                String[] txt = new String[]{o1.getText(columnIndex), o2.getText(columnIndex)};
                                double[] d = new double[2];
                                for (int i = 0; i < d.length; ++i) {
                                    try {
                                        char[] c = txt[i].toCharArray();
                                        StringBuilder buf = new StringBuilder();
                                        boolean decFound = false;
                                        boolean digitFound = false;
                                        block9: for (int j = 0; j < c.length; ++j) {
                                            switch (c[j]) {
                                                case '0': 
                                                case '1': 
                                                case '2': 
                                                case '3': 
                                                case '4': 
                                                case '5': 
                                                case '6': 
                                                case '7': 
                                                case '8': 
                                                case '9': {
                                                    buf.append(c[j]);
                                                    digitFound = true;
                                                    continue block9;
                                                }
                                                case '.': {
                                                    if (decPointComma || decFound) continue block9;
                                                    buf.append(c[j]);
                                                    decFound = true;
                                                    continue block9;
                                                }
                                                case ',': {
                                                    if (!decPointComma || decFound) continue block9;
                                                    buf.append('.');
                                                    decFound = true;
                                                    continue block9;
                                                }
                                                case '+': 
                                                case '-': {
                                                    if (digitFound) continue block9;
                                                    buf.append(c[j]);
                                                }
                                            }
                                        }
                                        d[i] = Double.parseDouble(buf.toString());
                                        continue;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (d[0] > d[1]) {
                                    return 1;
                                }
                                if (d[1] > d[0]) {
                                    return -1;
                                }
                                return 0;
                            }
                        };
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        asc = new Comparator<TreeViewNode>(){

                            @Override
                            public int compare(TreeViewNode o1, TreeViewNode o2) {
                                int[] yy;
                                int[] mm;
                                int[] dd;
                                String[] txt = new String[]{o1.getText(columnIndex), o2.getText(columnIndex)};
                                int[] f1 = new int[2];
                                int[] f2 = new int[2];
                                int[] f3 = new int[2];
                                Vector<StringBuilder> ss = new Vector<StringBuilder>();
                                for (int i = 0; i < f1.length; ++i) {
                                    char[] c = txt[i].toCharArray();
                                    StringBuilder buf = new StringBuilder();
                                    block14: for (int j = 0; j < c.length; ++j) {
                                        switch (c[j]) {
                                            case '0': 
                                            case '1': 
                                            case '2': 
                                            case '3': 
                                            case '4': 
                                            case '5': 
                                            case '6': 
                                            case '7': 
                                            case '8': 
                                            case '9': {
                                                buf.append(c[j]);
                                                continue block14;
                                            }
                                            default: {
                                                if (buf.length() <= 0) continue block14;
                                                ss.addElement(buf);
                                                buf = new StringBuilder();
                                            }
                                        }
                                    }
                                    if (buf.length() > 0) {
                                        ss.addElement(buf);
                                    }
                                    if (ss.size() > 0) {
                                        try {
                                            f1[i] = Integer.parseInt(((StringBuilder)ss.elementAt(0)).toString());
                                        }
                                        catch (NumberFormatException j) {
                                            // empty catch block
                                        }
                                    }
                                    if (ss.size() > 1) {
                                        try {
                                            f2[i] = Integer.parseInt(((StringBuilder)ss.elementAt(1)).toString());
                                        }
                                        catch (NumberFormatException j) {
                                            // empty catch block
                                        }
                                    }
                                    if (ss.size() <= 2) continue;
                                    try {
                                        f3[i] = Integer.parseInt(((StringBuilder)ss.elementAt(2)).toString());
                                        continue;
                                    }
                                    catch (NumberFormatException j) {
                                        // empty catch block
                                    }
                                }
                                switch (sortType) {
                                    case 5: {
                                        dd = f1;
                                        mm = f2;
                                        yy = f3;
                                        break;
                                    }
                                    default: {
                                        dd = f2;
                                        mm = f1;
                                        yy = f3;
                                        break;
                                    }
                                    case 6: {
                                        dd = f3;
                                        mm = f2;
                                        yy = f1;
                                    }
                                }
                                for (int i = 0; i < yy.length; ++i) {
                                    if (yy[i] < 30) {
                                        int n = i;
                                        yy[n] = yy[n] + 2000;
                                        continue;
                                    }
                                    if (yy[i] >= 100) continue;
                                    int n = i;
                                    yy[n] = yy[n] + 1900;
                                }
                                int r = yy[0] - yy[1];
                                if (r == 0) {
                                    r = mm[0] - mm[1];
                                }
                                if (r == 0) {
                                    r = dd[0] - dd[1];
                                }
                                return r;
                            }
                        };
                    }
                }
                this.comparator = new Comparator<TreeViewNode>(){

                    @Override
                    public int compare(TreeViewNode o1, TreeViewNode o2) {
                        switch (sortState) {
                            default: {
                                return asc.compare(o1, o2);
                            }
                            case DESCENDING: 
                        }
                        return -asc.compare(o1, o2);
                    }
                };
            }
            return this.comparator;
        }
    }

    private static enum SortState {
        UNSORTED,
        ASCENDING,
        DESCENDING;

    }
}

