/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter;

import com.iscobol.gui.RemoteIO;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.io.RemoteIOImpl;
import com.iscobol.gui.server.CobolGUIJavaBean;
import com.iscobol.htmlexporter.RptExporter;
import com.iscobol.htmlexporter.ss.SSExporter;
import com.iscobol.htmlexporter.xls.XLSExporter;
import com.iscobol.htmlexporter.xlsx.XLSXExporter;
import com.iscobol.htmlrenderer.Drawer;
import com.iscobol.htmlrenderer.HTMLRenderer;
import com.iscobol.preview.PreviewEventsHandler;
import com.iscobol.preview.PreviewEventsImpl;
import com.iscobol.rts.CallOverflowException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.PicX;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class ExtendedHTMLRenderer
extends HTMLRenderer {
    public static final int XLS_EXPORT = 1;
    public static final int XLSX_EXPORT = 2;
    private static final String CLIENT_PREFIX = "@[display]:";
    private NumericVar RETURN_CODE = Factory.getVarBinary(Factory.getMem(8), 0, 8, false, Factory.getNumLiteral(0L, 1, 0, false), null, null, "RETURN-CODE", false, 18, 0, true, false, false);
    private PicX FILENAME = Factory.getVarAlphanum(Factory.getMem(256), 0, 256, false, null, null, null, "FILENAME", false, false);
    private PicX TMPFILENAME = Factory.getVarAlphanum(Factory.getMem(256), 0, 256, false, null, null, null, "TMPFILENAME", false, false);
    private Thread thread;
    private String header;
    private String footer;
    private double leftMargin;
    private double rightMargin;
    private double topMargin;
    private double bottomMargin;
    private boolean landscape;
    private String paperSize;
    private Properties exportProperties = new Properties();
    private Drawer serverDrawer;

    public ExtendedHTMLRenderer() {
        this.thread = Thread.currentThread();
    }

    private Drawer getServerDrawer() throws IOException {
        if (this.serverDrawer == null) {
            this.serverDrawer = new Drawer(new PreviewEventsImpl(), true);
        }
        return this.serverDrawer;
    }

    private RptExporter createExporter(int exportType, String reportName, String inputFile, String outputFile) {
        SSExporter exporter;
        switch (exportType) {
            default: {
                exporter = new XLSExporter(reportName, inputFile, outputFile);
                break;
            }
            case 2: {
                exporter = new XLSXExporter(reportName, inputFile, outputFile);
            }
        }
        exporter.setupPage(this.paperSize, this.topMargin, this.leftMargin, this.bottomMargin, this.rightMargin, this.landscape);
        return exporter;
    }

    private void runInBackground(final Runnable run) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    run.run();
                }
                finally {
                    IscobolSystem.destroyEnv(this);
                }
            }
        };
        IscobolSystem.duplicateEnv(this.thread, t);
        t.start();
    }

    public static boolean checkLock(String fileName) {
        try {
            return ExtendedHTMLRenderer.checkLock0(fileName);
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static boolean checkLock0(String fileName) throws IOException {
        RemoteIO rio;
        if (fileName.toLowerCase().startsWith(CLIENT_PREFIX)) {
            rio = ScreenUtility.getGuiFactory().getRemoteIO();
            fileName = fileName.substring(CLIENT_PREFIX.length());
        } else {
            rio = new RemoteIOImpl();
        }
        return rio.checkLock(fileName, true);
    }

    private void export(int exportType, String filters, String defExt, boolean showDialogs) {
        RptExporter exporter;
        block17: {
            boolean outClient = this.getPaperUrl().toLowerCase().startsWith(CLIENT_PREFIX);
            String outFile = this.getOutputFilename(filters, defExt, showDialogs);
            if (outFile == null) {
                return;
            }
            if (!ExtendedHTMLRenderer.checkLock(outClient ? CLIENT_PREFIX + outFile : outFile)) {
                return;
            }
            exporter = null;
            if (IscobolSystem.isAS() && (showDialogs || outClient)) {
                block16: {
                    try {
                        Factory.call("c$create_tmp_file", null, new Object[]{this.TMPFILENAME.byRef(), Factory.getStrLiteral("rpt").byVal(), Factory.getStrLiteral("." + defExt).byVal()});
                    }
                    catch (CallOverflowException e) {
                        if (!showDialogs) break block16;
                        ExtendedHTMLRenderer.showMessageDialog(e.getMessage(), e.getClass().getName(), 0);
                    }
                }
                exporter = this.createExporter(exportType, this.getBasename(), this.getPaperUrl(), this.TMPFILENAME.toString().trim());
                try {
                    exporter.export();
                    this.FILENAME.set("@[DISPLAY]:" + outFile);
                    try {
                        this.RETURN_CODE.set(Factory.call("c$copy", null, new CobolVar[]{this.TMPFILENAME.byRef(), this.FILENAME.byRef()}));
                        if (showDialogs) {
                            ExtendedHTMLRenderer.showMessageDialog("Created file '" + outFile + "'");
                        }
                        break block17;
                    }
                    catch (CallOverflowException e) {
                        if (showDialogs) {
                            ExtendedHTMLRenderer.showMessageDialog(e.getMessage(), e.getClass().getName(), 0);
                        }
                        break block17;
                    }
                }
                catch (IOException e) {
                    if (showDialogs) {
                        ExtendedHTMLRenderer.showMessageDialog(e.getMessage(), e.getClass().getName(), 0);
                    }
                    break block17;
                }
            }
            exporter = this.createExporter(exportType, this.getBasename(), this.getPaperUrl(), outFile);
            try {
                exporter.export();
                if (showDialogs) {
                    ExtendedHTMLRenderer.showMessageDialog("Created file '" + outFile + "'");
                }
            }
            catch (IOException e) {
                if (!showDialogs) break block17;
                ExtendedHTMLRenderer.showMessageDialog(e.getMessage(), e.getClass().getName(), 0);
            }
        }
        if (exporter != null) {
            exporter.dispose();
        }
    }

    private static void showMessageDialog(String message) {
        CobolGUIJavaBean.callStaticMethod("javax.swing.JOptionPane", "showMessageDialog", null, message);
    }

    private static void showMessageDialog(String message, String title, int type) {
        CobolGUIJavaBean.callStaticMethod("javax.swing.JOptionPane", "showMessageDialog", null, message, title, new Integer(type));
    }

    private String getBasename() {
        String Return2;
        int idx;
        String fileName = this.getPaperUrl();
        if (fileName.toLowerCase().startsWith(CLIENT_PREFIX)) {
            fileName = fileName.substring(CLIENT_PREFIX.length());
        }
        if ((idx = (Return2 = new File(fileName.replace('\\', '/')).getName()).lastIndexOf(46)) >= 0) {
            Return2 = Return2.substring(0, idx);
        }
        return Return2;
    }

    @Override
    public int open() {
        this.addMenu("export", "Export", null, 0, null);
        this.addMenu("export/xls", "Export to XLS", null, 1, new PreviewEventsHandler(){

            @Override
            public void handleEvent() {
                ExtendedHTMLRenderer.this.runInBackground(new Runnable(){

                    @Override
                    public void run() {
                        ExtendedHTMLRenderer.this.intExportXLS(true);
                    }
                });
            }
        });
        this.addMenu("export/xlsx", "Export to XLSx", null, 2, new PreviewEventsHandler(){

            @Override
            public void handleEvent() {
                ExtendedHTMLRenderer.this.runInBackground(new Runnable(){

                    @Override
                    public void run() {
                        ExtendedHTMLRenderer.this.intExportXLSX(true);
                    }
                });
            }
        });
        int ret = super.open();
        this.removeMenu("export");
        return ret;
    }

    public void exportXLS() {
        this.intExportXLS(false);
    }

    private void intExportXLS(boolean showDialogs) {
        this.export(1, "XLS files (*.xls)|*.xls", "xls", showDialogs);
    }

    private void intExportXLSX(boolean showDialogs) {
        this.export(2, "XLSX files (*.xlsx)|*.xlsx", "xlsx", showDialogs);
    }

    public void exportXLSX() {
        this.intExportXLSX(false);
    }

    public void exportPDF() {
        boolean outClient = this.getPaperUrl().toLowerCase().startsWith(CLIENT_PREFIX);
        String outFile = this.getOutputFilename(null, "pdf", false);
        if (!ExtendedHTMLRenderer.checkLock(outClient ? CLIENT_PREFIX + outFile : outFile)) {
            return;
        }
        Drawer d = this.drawer;
        try {
            if (IscobolSystem.isAS() && !outClient) {
                this.drawer = this.getServerDrawer();
                this.drawer.setUrl(this.getPaperUrl());
                this.drawer.setPaperSize(this.paperSize);
                this.drawer.setLandscape(this.landscape);
                this.drawer.setMargins(this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
                this.drawer.setHeaderFooter(this.header, this.footer);
            }
            this.setPDF(true);
            this.setJobName(outFile, "P");
            super.open();
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        finally {
            this.drawer = d;
        }
    }

    private String getOutputFilename(String filters, String defExt, boolean showDialog) {
        String defFile = null;
        if (showDialog) {
            defFile = (String)CobolGUIJavaBean.callStaticMethod("com.iscobol.rts.print.SpoolPrinter", "getSaveDefaultFilename");
        }
        if (defFile == null) {
            defFile = this.getPaperUrl();
        }
        if (defFile.toLowerCase().startsWith(CLIENT_PREFIX)) {
            defFile = defFile.substring(CLIENT_PREFIX.length());
        } else if (IscobolSystem.isAS() && showDialog) {
            File f = new File(defFile);
            defFile = f.getName();
        }
        int idx = defFile.lastIndexOf(46);
        if (idx >= 0) {
            defFile = defFile.substring(0, idx);
        }
        defFile = defFile + "." + defExt;
        if (showDialog) {
            String Return2 = (String)CobolGUIJavaBean.callStaticMethod("com.iscobol.preview.Preview", "openSaveDialog", new Object[]{null, defExt, filters, defFile});
            if (Return2 != null && !Return2.toUpperCase().endsWith(defExt.toUpperCase())) {
                Return2 = Return2 + "." + defExt;
            }
            return Return2;
        }
        String Return3 = defFile;
        return Return3;
    }

    @Override
    public void setLandscape(boolean lndscp) {
        super.setLandscape(lndscp);
        this.landscape = lndscp;
    }

    @Override
    public void setHeaderFooter(String h, String f) {
        super.setHeaderFooter(h, f);
        this.header = h;
        this.footer = f;
    }

    @Override
    public void setMargins(double left, double right, double top, double bottom) {
        super.setMargins(left, right, top, bottom);
        this.leftMargin = left;
        this.rightMargin = right;
        this.topMargin = top;
        this.bottomMargin = bottom;
    }

    @Override
    public void setPaperSize(String s) {
        super.setPaperSize(s);
        this.paperSize = s;
    }

    @Override
    public void setCustomPaperSize(float width, float height) {
        super.setCustomPaperSize(width, height);
        this.paperSize = "Custom";
    }

    public void setExportProperty(String propName, String value) {
        this.exportProperties.setProperty(propName, value);
    }

    public String getExportProperty(String propName) {
        return this.exportProperties.getProperty(propName);
    }

    public static void main(String[] argv) throws Exception {
        ExtendedHTMLRenderer hr = new ExtendedHTMLRenderer();
        int idx = 0;
        double lm = 0.0;
        double rm = 0.0;
        double tm = 0.0;
        double bm = 0.0;
        float cpw = 0.0f;
        float cph = 0.0f;
        ArrayList<String> hrArgs = new ArrayList<String>();
        for (idx = 0; idx < argv.length; ++idx) {
            if ("-rm".equals(argv[idx])) {
                try {
                    rm = Double.parseDouble(argv[++idx]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-lm".equals(argv[idx])) {
                try {
                    lm = Double.parseDouble(argv[++idx]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-tm".equals(argv[idx])) {
                try {
                    tm = Double.parseDouble(argv[++idx]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-bm".equals(argv[idx])) {
                try {
                    bm = Double.parseDouble(argv[++idx]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-cps".equals(argv[idx])) {
                String cps = argv[++idx];
                try {
                    String[] wh = cps.split("\\,");
                    cpw = Float.parseFloat(wh[0]);
                    cph = Float.parseFloat(wh[1]);
                }
                catch (Exception exception) {}
                continue;
            }
            hrArgs.add(argv[idx]);
        }
        hr.setMargins(lm, rm, tm, bm);
        if (cpw > 0.0f && cph > 0.0f) {
            hr.setCustomPaperSize(cpw, cph);
        }
        ExtendedHTMLRenderer.run(hrArgs.toArray(new String[hrArgs.size()]), hr);
    }
}

