/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.io.BaseFile;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DataStream;
import com.iscobol.io.FileTypeManager;
import com.iscobol.io.JavaToIscobolError;
import com.iscobol.io.LineSeqFile;
import com.iscobol.io.PrinterFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicInput;
import com.iscobol.rts.DynamicOutput;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicN;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.MixingCharAndBytesException;
import com.iscobol.rts.PrintBackgroundMonitor;
import com.iscobol.rts.PrintBackgroundMonitorFactory;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.print.LocalSpoolPrinter;
import com.iscobol.rts.print.SpoolPrinterList;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class DeviceFile
extends BaseFile
implements CobolFile,
RuntimeErrorsNumbers {
    static boolean isMVSPrint = false;
    protected DynamicOutput outFile;
    protected DynamicInput inpFile;
    protected Process proc;
    private boolean spoolPrinter;
    private boolean graphicPrinter;
    private int linageCounter;
    private ICobolVar linage;
    private ICobolVar footing;
    private ICobolVar top;
    private ICobolVar bottom;
    private Object clazz;
    private int[] chnls;

    public static String[] breakCmdLine(String cmdStr) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        char quote = '\u0000';
        block4: for (int i = 0; i < cmdStr.length(); ++i) {
            char c = cmdStr.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\t': 
                case ' ': {
                    if (quote != '\u0000') {
                        sb.append(c);
                        continue block4;
                    }
                    if (sb.length() <= 0) continue block4;
                    args.add(sb.toString());
                    sb.delete(0, sb.length());
                    continue block4;
                }
                case '\"': 
                case '\'': {
                    if (quote == '\u0000') {
                        quote = c;
                        continue block4;
                    }
                    if (quote == c) {
                        args.add(sb.toString());
                        sb.delete(0, sb.length());
                        quote = '\u0000';
                        continue block4;
                    }
                    sb.append(c);
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            args.add(sb.toString());
        }
        return args.toArray(new String[args.size()]);
    }

    public DeviceFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, boolean binary, Class clazz) {
        this(nam, maxLen, memBuf, minLen, opt, binary);
        this.clazz = clazz;
    }

    public DeviceFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, boolean binary, String clazz) {
        this(nam, maxLen, memBuf, minLen, opt, binary);
        this.clazz = clazz;
    }

    public DeviceFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, boolean binary) {
        super(nam, maxLen, memBuf, minLen, opt, 1);
    }

    private DynamicOutput getOutInstance() {
        try {
            if (this.clazz != null) {
                if (this.clazz instanceof Class) {
                    return (DynamicOutput)((Class)this.clazz).newInstance();
                }
                return (DynamicOutput)Class.forName((String)this.clazz).newInstance();
            }
            return (DynamicOutput)FileTypeManager.getOutput().newInstance();
        }
        catch (Exception _ex) {
            throw new IscobolRuntimeException(5, " (" + _ex + ")");
        }
    }

    private DynamicInput getInInstance() {
        try {
            if (this.clazz != null) {
                if (this.clazz instanceof Class) {
                    return (DynamicInput)((Class)this.clazz).newInstance();
                }
                return (DynamicInput)Class.forName((String)this.clazz).newInstance();
            }
            return (DynamicInput)FileTypeManager.getInput().newInstance();
        }
        catch (Exception _ex) {
            throw new IscobolRuntimeException(5, " (" + _ex + ")");
        }
    }

    protected boolean isSpoolPrinter() {
        return this.spoolPrinter;
    }

    protected boolean isGraphicPrinter() {
        return this.graphicPrinter;
    }

    protected void pipedOpen(String name, int openType, int lockType) {
        String effName = name.substring(2, name.length()).trim();
        boolean preview = false;
        boolean direct = false;
        boolean pdf = false;
        boolean bin = this.isBinary();
        String fileName = null;
        if (name.equalsIgnoreCase("PRINTER?") || effName.equalsIgnoreCase("spooler") || (preview = effName.equalsIgnoreCase("preview")) || (pdf = effName.toLowerCase().startsWith("pdf")) || (direct = effName.equalsIgnoreCase("spooler-direct"))) {
            switch (openType) {
                case 2: 
                case 6: {
                    try {
                        fileName = pdf ? (effName.length() > 3 ? effName.substring(3).trim() : null) : name;
                        LocalSpoolPrinter lsp = SpoolPrinterList.get().newSpoolPrinter(preview, direct, pdf, fileName, bin);
                        if (this.printerAttrs != null) {
                            this.printerAttrs.copyTo(lsp);
                            this.printerAttrs = null;
                        }
                        Output o = new Output(lsp, this, bin);
                        o.preview = preview;
                        o.direct = direct;
                        o.pdf = pdf;
                        this.outFile = o;
                    }
                    catch (IOException _re) {
                        ScreenUtility.handleIOException(_re);
                    }
                    this.spoolPrinter = true;
                    this.graphicPrinter = !direct;
                    break;
                }
                case 1: 
                case 3: {
                    CobolIOException.get(142, "", this, 1);
                    break;
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                }
            }
            this.setOpenMode(openType);
        } else {
            try {
                String[] args = DeviceFile.breakCmdLine(effName);
                this.proc = Runtime.getRuntime().exec(args);
                switch (openType) {
                    case 2: 
                    case 6: {
                        this.outFile = new Output(this.proc.getOutputStream(), bin);
                        break;
                    }
                    case 3: {
                        this.outFile = new Output(this.proc.getOutputStream(), bin);
                        this.inpFile = new Input(this.proc.getInputStream(), bin);
                    }
                    case 1: {
                        this.inpFile = new Input(this.proc.getInputStream(), bin);
                        break;
                    }
                    default: {
                        throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                    }
                }
                this.setOpenMode(openType);
            }
            catch (IOException ex) {
                CobolIOException.get(ex, this, 1);
            }
        }
    }

    @Override
    public void peerOpen(String path, int openType, int lockType) {
        this.spoolPrinter = false;
        switch (this.getFileType()) {
            case 1: {
                this.pipedOpen(path, openType, lockType);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.stdOpen(openType);
                break;
            }
            default: {
                this.fileOpen(path, openType, lockType);
            }
        }
        this.linageCounter = 1;
    }

    protected void stdOpen(int openType) {
        block0 : switch (openType) {
            case 2: 
            case 6: {
                switch (this.getFileType()) {
                    case 3: {
                        this.outFile = new Output(System.out, this.isBinary());
                        break block0;
                    }
                    case 4: {
                        this.outFile = new Output(System.err, this.isBinary());
                        break block0;
                    }
                }
                CobolIOException.get(142, "", this, 1);
                break;
            }
            case 1: {
                switch (this.getFileType()) {
                    case 2: {
                        this.inpFile = new Input(System.in, this.isBinary());
                        break block0;
                    }
                }
                CobolIOException.get(142, "", this, 1);
                break;
            }
            case 3: {
                CobolIOException.get(142, "", this, 1);
            }
        }
        this.setOpenMode(openType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileOpen(String f, int openType, int lockType) {
        switch (openType) {
            case 2: {
                this.outFile = this.getOutInstance();
                int rc = this.outFile.open(f, lockType, this.getMaxRecordLen(), 0, this.isBinary(), false, this instanceof LineSeqFile, false, this.assignExt);
                if (rc == 1) break;
                try {
                    CobolIOException.get(this.outFile.getCobErrno(), "", this, 1);
                    break;
                }
                finally {
                    if (rc == 0) {
                        this.outFile = null;
                    }
                }
            }
            case 3: {
                CobolIOException.get(142, "", this, 1);
                break;
            }
            case 6: {
                this.outFile = this.getOutInstance();
                int rc = this.outFile.open(f, lockType, this.getMaxRecordLen(), 0, this.isBinary(), true, this instanceof LineSeqFile, this.isOptional(openType), this.assignExt);
                if (rc == 1) break;
                try {
                    CobolIOException.get(this.outFile.getCobErrno(), "", this, 1);
                    break;
                }
                finally {
                    if (rc == 0) {
                        this.outFile = null;
                    }
                }
            }
            case 1: {
                this.inpFile = this.getInInstance();
                int rc = this.inpFile.open(f, lockType, this.getMaxRecordLen(), 0, this.isBinary(), this instanceof LineSeqFile, this.isOptional(openType), this.assignExt);
                if (rc == 1) break;
                try {
                    if (this.isOptional(openType)) break;
                    CobolIOException.get(this.inpFile.getCobErrno(), "", this, 1);
                    break;
                }
                finally {
                    if (rc == 0) {
                        this.inpFile = null;
                    }
                }
            }
            default: {
                throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
            }
        }
        this.setOpenMode(openType);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void peerClose(int opts) {
        switch (this.getFileType()) {
            case 2: {
                this.inpFile = null;
                break;
            }
            case 3: 
            case 4: {
                if (this.outFile != null && this.outFile.flush() != 1) {
                    CobolIOException.get(this.outFile.getCobErrno(), "", this, 2);
                }
                this.outFile = null;
                break;
            }
            default: {
                if (this.inpFile == null) ** GOTO lbl20
                try {
                    if (this.inpFile.close() == 1) ** GOTO lbl29
                    CobolIOException.get(this.inpFile.getCobErrno(), "", this, 2);
                }
                finally {
                    this.inpFile = null;
                    this.setOpenMode(0);
                }
lbl20:
                // 1 sources

                if (this.outFile != null) {
                    try {
                        if (!(this.outFile instanceof Output && ((Output)this.outFile).printInBackground || this.outFile.close() == 1)) {
                            CobolIOException.get(this.outFile.getCobErrno(), "", this, 2);
                        }
                    }
                    finally {
                        this.outFile = null;
                        this.setOpenMode(0);
                    }
                }
lbl29:
                // 5 sources

                if (this.proc == null) break;
                err = new Thread(){

                    @Override
                    public void run() {
                        Process myProc = DeviceFile.this.proc;
                        if (myProc != null) {
                            try {
                                String s;
                                BufferedReader in = new BufferedReader(new InputStreamReader(myProc.getErrorStream()));
                                while ((s = in.readLine()) != null) {
                                    System.err.println(s);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                };
                err.setDaemon(true);
                err.start();
                try {
                    rc = this.proc.waitFor();
                    if (rc != 0) {
                        CobolIOException.get(205, "" + rc, this, 2);
                    }
                }
                catch (InterruptedException _ex) {
                    CobolIOException.get(_ex, this, 2);
                }
                this.proc = null;
            }
        }
        this.setOpenMode(0);
    }

    @Override
    public boolean advance(int nLines, int opts) {
        boolean Return2 = false;
        int totLinage = this.getTotLinage();
        if ((this.getOpenMode() & 2) != 0) {
            for (int i = 0; i < nLines; ++i) {
                if (this.outFile.write(10) == 0) {
                    CobolIOException.get(this.outFile.getCobErrno(), "", this, 3);
                }
                ++this.linageCounter;
                if (totLinage > 0 && this.linageCounter > totLinage) {
                    Return2 = true;
                    this.linageCounter = 1;
                    continue;
                }
                if (this.footing == null || this.linageCounter < this.footing.toint()) continue;
                Return2 = true;
            }
        }
        return Return2;
    }

    @Override
    public boolean page(int opts) {
        if ((this.getOpenMode() & 2) != 0) {
            int totLinage = this.getTotLinage();
            if (totLinage > 0) {
                this.advance(totLinage - this.linageCounter + 1, opts);
            } else if (this.outFile.write(12) == 0) {
                CobolIOException.get(this.outFile.getCobErrno(), "", this, 3);
            }
            this.linageCounter = 1;
        }
        return false;
    }

    private int getChnlLine(int chnl) {
        if (this.chnls == null) {
            int i;
            this.chnls = new int[13];
            String channels = Config.getProperty(".printer.channels", "");
            StringTokenizer tk = new StringTokenizer(channels, ":", true);
            for (i = 0; tk.hasMoreTokens() && i < this.chnls.length; ++i) {
                String fld = tk.nextToken();
                if (":".equals(fld)) {
                    this.chnls[i] = 1;
                    continue;
                }
                try {
                    this.chnls[i] = Integer.parseInt(fld);
                    if (this.chnls[i] < 1) {
                        this.chnls[i] = 1;
                    }
                }
                catch (NumberFormatException _ex) {
                    this.chnls[i] = 1;
                }
                if (!tk.hasMoreTokens()) continue;
                tk.nextToken();
            }
            while (i < this.chnls.length) {
                this.chnls[i] = 1;
                ++i;
            }
        }
        return this.chnls[chnl - 1];
    }

    @Override
    public boolean writeAdvancing(int kind, int lines, boolean lock, int len, int opts) {
        int rc;
        boolean Return2 = false;
        int totLinage = this.getTotLinage();
        super.write(lock, len);
        if (this.isGraphicPrinter()) {
            opts |= 1;
        }
        if (!isMVSPrint) {
            switch (kind) {
                case 6: {
                    if (this.getChnlLine(lines) != 1) break;
                    kind = 4;
                    break;
                }
                case 5: {
                    if (this.getChnlLine(lines) != 1) break;
                    kind = 3;
                }
            }
        }
        switch (kind) {
            default: {
                rc = this.outFile.writeAdvancing(kind, lines, this.getBufferAsVar(), len, opts);
                break;
            }
            case 1: {
                Return2 = this.checkOverflow(lines);
                if (Return2) {
                    this.newPage(len, opts);
                    rc = this.outFile.writeAdvancing(kind, 1, this.getBufferAsVar(), len, opts);
                    this.linageCounter = 1;
                    break;
                }
                rc = this.outFile.writeAdvancing(kind, lines, this.getBufferAsVar(), len, opts);
                this.linageCounter += lines;
                Return2 = this.checkFooting();
                break;
            }
            case 2: {
                Return2 = this.checkOverflow(lines);
                if (Return2) {
                    rc = this.outFile.writeAdvancing(kind, 1, this.getBufferAsVar(), len, opts);
                    this.newPage(len, opts);
                    this.linageCounter = 1;
                    break;
                }
                rc = this.outFile.writeAdvancing(kind, lines, this.getBufferAsVar(), len, opts);
                this.linageCounter += lines;
                Return2 = this.checkFooting();
                break;
            }
            case 3: {
                rc = totLinage > 0 ? this.outFile.writeAdvancing(1, totLinage - this.linageCounter + 1, this.getBufferAsVar(), len, opts) : this.outFile.writeAdvancing(kind, lines, this.getBufferAsVar(), len, opts);
                this.linageCounter = 1;
                break;
            }
            case 4: {
                totLinage = this.getTotLinage();
                rc = totLinage > 0 ? this.outFile.writeAdvancing(2, totLinage - this.linageCounter + 1, this.getBufferAsVar(), len, opts) : this.outFile.writeAdvancing(kind, lines, this.getBufferAsVar(), len, opts);
                this.linageCounter = 1;
                break;
            }
            case 5: {
                if (isMVSPrint) {
                    rc = this.outFile.writeAdvancing(kind, lines, this.getBufferAsVar(), len, opts);
                    this.linageCounter = this.getChnlLine(lines);
                    break;
                }
                if (this.linageCounter > (lines = this.getChnlLine(lines))) {
                    ICobolVar cv = this.getBufferAsVar();
                    totLinage = this.getTotLinage();
                    if (totLinage > 0) {
                        int adv = totLinage - this.linageCounter + 1 + lines;
                        rc = this.outFile.writeAdvancing(1, adv, cv, len, opts);
                    } else {
                        rc = this.outFile.writeAdvancing(8, 0, cv, 0, 0);
                        rc = this.outFile.writeAdvancing(1, lines - 1, cv, len, opts);
                    }
                } else {
                    ICobolVar cv = this.getBufferAsVar();
                    rc = this.outFile.writeAdvancing(1, lines - this.linageCounter, cv, len, opts);
                }
                this.linageCounter = lines;
                break;
            }
            case 6: {
                if (isMVSPrint) {
                    rc = this.outFile.writeAdvancing(kind, lines, this.getBufferAsVar(), len, opts);
                    this.linageCounter = this.getChnlLine(lines);
                    break;
                }
                if (this.linageCounter >= (lines = this.getChnlLine(lines))) {
                    ICobolVar cv = this.getBufferAsVar();
                    totLinage = this.getTotLinage();
                    if (totLinage > 0) {
                        int adv = totLinage - this.linageCounter + 1 + lines;
                        rc = this.outFile.writeAdvancing(2, adv, cv, len, opts);
                    } else {
                        rc = this.outFile.writeAdvancing(2, 0, cv, len, opts);
                        rc = this.outFile.writeAdvancing(8, 0, cv, 0, 0);
                        rc = this.outFile.writeAdvancing(7, lines - 1, cv, len, opts);
                    }
                } else {
                    ICobolVar cv = this.getBufferAsVar();
                    rc = this.outFile.writeAdvancing(2, lines - this.linageCounter, cv, len, opts);
                }
                this.linageCounter = lines;
            }
        }
        if (rc != 1) {
            CobolIOException.get(this.outFile.getCobErrno(), "", this, 3);
        }
        return Return2;
    }

    @Override
    public CobolFile setLinage(ICobolVar l) {
        return this.setLinage(l, null, null, null);
    }

    @Override
    public CobolFile setLinage(ICobolVar l, ICobolVar f, ICobolVar t, ICobolVar b) {
        this.linage = l;
        this.footing = f;
        this.top = t;
        this.bottom = b;
        return this;
    }

    private int getTotLinage() {
        int Return2 = 0;
        if (this.linage != null) {
            Return2 += this.linage.toint();
        }
        if (this.top != null) {
            Return2 += this.top.toint();
        }
        if (this.bottom != null) {
            Return2 += this.bottom.toint();
        }
        return Return2;
    }

    @Override
    public int linageCounter() {
        return this.linageCounter;
    }

    private boolean checkOverflow(int nLines) {
        return this.linage != null && this.linageCounter + nLines > this.linage.toint();
    }

    private boolean checkFooting() {
        return this.footing != null && this.linageCounter >= this.footing.toint();
    }

    private void newPage(int len, int opts) {
        if (this.linage != null) {
            int rc;
            int ll = this.linage.toint();
            int ln2Adv = 0;
            if (ll > this.linageCounter) {
                ln2Adv += ll - this.linageCounter;
            }
            if (this.bottom != null) {
                ln2Adv += this.bottom.toint();
            }
            if (this.top != null) {
                ln2Adv += this.top.toint();
            }
            if (ln2Adv > 0 && (rc = this.outFile.writeAdvancing(7, ln2Adv, null, len, opts)) != 1) {
                CobolIOException.get(this.outFile.getCobErrno(), "", this, 3);
            }
            this.linageCounter = 1;
        }
    }

    @Override
    public NumericVar getLinageCounter() {
        return Factory.getNumLiteral(this.linageCounter, 10, 0, false);
    }

    @Override
    public void rewrite(boolean lock, int len) {
        if (this.getOpenMode() != 0) {
            CobolIOException.get(101, "01", this, 4);
        } else {
            CobolIOException.get(101, "02", this, 4);
        }
    }

    @Override
    public void delete() {
        if (this.getOpenMode() != 0) {
            CobolIOException.get(101, "01", this, 5);
        } else {
            CobolIOException.get(101, "02", this, 5);
        }
    }

    @Override
    public int readPrev(boolean lock, ICobolVar into) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public int readKey(ICobolVar[] key, boolean lock, ICobolVar into) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public void start(ICobolVar[] key, int type, int keyLen) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public void deleteFile(ICobolVar path) {
        super.deleteFile(path);
        switch (this.getFileType()) {
            default: {
                break;
            }
            case 0: {
                this.outFile = this.getOutInstance();
                if (this.outFile.remove(com.iscobol.rts.File.get(this.getOsPath())) != 1) {
                    CobolIOException.get(this.outFile.getCobErrno(), "", this, 11);
                }
                this.outFile = null;
            }
        }
    }

    public final void print() {
        this.print(0);
    }

    public final void print(int opts) {
        PrintBackgroundMonitor pbm = (PrintBackgroundMonitor)IscobolSystem.get(PrintBackgroundMonitor.class);
        if (pbm != null) {
            try {
                IOException ex;
                block8: {
                    if (Config.getProperty(".file.page_eject_on_close", false) && (opts & 1) == 0) {
                        try {
                            pbm.getSpoolPrinter().write(12);
                        }
                        catch (MixingCharAndBytesException e) {
                            if (!pbm.isDirect()) break block8;
                            if (e.getErrorCode() == 3) {
                                pbm.getSpoolPrinter().write((byte)12);
                            }
                            if (e.getErrorCode() != 4) break block8;
                            pbm.getSpoolPrinter().writeBytes(new byte[]{12});
                        }
                    }
                }
                if ((ex = pbm.getSpoolPrinter().printAndClose()) != null) {
                    throw ex;
                }
            }
            catch (IOException _ex) {
                int cobErrno = JavaToIscobolError.map(_ex);
                CobolIOException.get(cobErrno, "", this, 2);
            }
        }
    }

    public final boolean closeDeferred(Runnable run) {
        if (this.outFile instanceof Output) {
            Output o = (Output)this.outFile;
            if (o.remWriter != null) {
                boolean bl = o.printInBackground = !o.preview && (!o.pdf && Config.getProperty("iscobol.print.spooler_async", true) || o.pdf && Config.getProperty("iscobol.print.pdf_async", false));
                if (o.printInBackground) {
                    PrintBackgroundMonitor pbm = PrintBackgroundMonitorFactory.getInstance(run, o.remWriter, o.direct, o.cp);
                    if (pbm != null) {
                        pbm.start();
                        this.close();
                        return true;
                    }
                    o.printInBackground = false;
                }
            }
        }
        return false;
    }

    public static class Input
    implements DynamicInput {
        BufferedReader inpReader;
        BufferedInputStream inpStream;
        int cobErrno;

        public Input() {
        }

        public Input(InputStream r, boolean bin) {
            if (bin) {
                this.inpStream = new BufferedInputStream(r);
            } else {
                this.inpReader = new BufferedReader(new InputStreamReader(r));
            }
        }

        @Override
        public int getCobErrno() {
            return this.cobErrno;
        }

        @Override
        public int open(String path, int lck, int maxRec, int minRec, boolean binary, boolean ls, boolean optional, boolean assignExt) {
            if (assignExt) {
                path = BaseFile.expandFileName(path);
            }
            File f = new File(path);
            try {
                if (binary) {
                    this.inpStream = new BufferedInputStream(new FileInputStream(f));
                } else {
                    this.inpReader = new BufferedReader(new FileReader(f));
                }
            }
            catch (FileNotFoundException _ex) {
                this.cobErrno = f.exists() ? 131 : 130;
                return 0;
            }
            return 1;
        }

        @Override
        public String readLine() throws IOException {
            return this.inpReader.readLine();
        }

        @Override
        public int read(char[] inc, int offset, int len) throws IOException {
            return this.inpReader.read(inc, offset, len);
        }

        @Override
        public int read(byte[] in, int offset, int len) throws IOException {
            return this.inpStream.read(in, offset, len);
        }

        @Override
        public int close() {
            try {
                if (this.inpReader != null) {
                    this.inpReader.close();
                }
                return 1;
            }
            catch (IOException _ex) {
                this.cobErrno = JavaToIscobolError.map(_ex);
                return 0;
            }
        }

        public boolean exists(File f) {
            return f.exists();
        }
    }

    public static class Output
    implements DynamicOutput {
        private static final int CLOSED = 0;
        private static final int REMOTE = 1;
        private static final int WRITER = 2;
        private static final int STREAM = 3;
        private int type;
        protected boolean printInBackground;
        protected boolean preview;
        protected boolean pdf;
        protected boolean cp;
        protected int maxRecSize;
        protected int minRecSize;
        protected boolean binary;
        protected boolean lineSequential;
        protected boolean direct;
        protected LocalSpoolPrinter remWriter;
        protected Writer outWriter;
        protected OutputStream outStream;
        protected int cobErrno = 0;

        public Output(LocalSpoolPrinter rw, DataStream ds, boolean bin) {
            this.binary = bin;
            this.remWriter = rw;
            this.type = 1;
            if (ds instanceof PrinterFile) {
                this.cp = ((PrinterFile)ds).isCp();
            }
            if (Config.getProperty(".printer.dialog.always", false)) {
                try {
                    if (!this.remWriter.setup()) {
                        CobolIOException.get(142, "", ds, 1);
                    }
                }
                catch (IOException _ex) {
                    CobolIOException.get(JavaToIscobolError.map(_ex), "", ds, 1);
                }
            }
        }

        public Output() {
            this.type = 0;
        }

        public Output(OutputStream os, boolean bin) {
            this.binary = bin;
            if (this.binary) {
                this.outStream = os;
                this.type = 3;
            } else {
                this.outWriter = new OutputStreamWriter(os);
                this.type = 2;
            }
        }

        public Output(OutputStream os) {
            this.binary = true;
            this.outStream = os;
            this.type = 3;
        }

        public boolean isDirect() {
            return this.direct;
        }

        @Override
        public int getCobErrno() {
            return this.cobErrno;
        }

        @Override
        public int open(String path, int lckt, int maxRec, int minRec, boolean bin, boolean append, boolean ls, boolean opt, boolean assExt) {
            int Return2 = 1;
            if (assExt) {
                path = Config.getProperty("." + path.toLowerCase(), path);
            }
            File f = new File(path);
            this.lineSequential = ls;
            this.maxRecSize = maxRec;
            this.minRecSize = minRec;
            if (opt) {
                if (!f.exists()) {
                    this.cobErrno = 202;
                    Return2 = -1;
                    try {
                        f.createNewFile();
                    }
                    catch (IOException _ex) {
                        this.cobErrno = JavaToIscobolError.map(_ex);
                        return 0;
                    }
                }
            } else if (append) {
                if (!f.exists()) {
                    this.cobErrno = 130;
                    Return2 = 0;
                    return Return2;
                }
            } else {
                try {
                    if (f.exists()) {
                        f.delete();
                    }
                    f.createNewFile();
                }
                catch (IOException _ex) {
                    this.cobErrno = JavaToIscobolError.map(_ex);
                    return 0;
                }
            }
            try {
                this.binary = bin;
                if (this.binary) {
                    this.outStream = new FileOutputStream(f.getPath(), append);
                    this.type = 3;
                } else {
                    this.outWriter = new FileWriter(f.getPath(), append);
                    this.type = 2;
                }
            }
            catch (IOException _ex) {
                this.cobErrno = JavaToIscobolError.map(_ex);
                return 0;
            }
            return Return2;
        }

        @Override
        public int close() {
            try {
                switch (this.type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        IOException ex = this.remWriter.printAndClose();
                        if (ex != null) {
                            throw ex;
                        }
                        break;
                    }
                    case 2: {
                        this.outWriter.close();
                        break;
                    }
                    case 3: {
                        this.outStream.close();
                        break;
                    }
                    default: {
                        throw new IscobolRuntimeException(3, "DeviceFile.close type=" + this.type);
                    }
                }
            }
            catch (IOException _ex) {
                this.cobErrno = JavaToIscobolError.map(_ex);
                return 0;
            }
            return 1;
        }

        @Override
        public int flush() {
            try {
                switch (this.type) {
                    case 1: {
                        this.remWriter.flush();
                        break;
                    }
                    case 2: {
                        this.outWriter.flush();
                        break;
                    }
                    case 3: {
                        this.outStream.flush();
                        break;
                    }
                    default: {
                        throw new IscobolRuntimeException(3, "DeviceFile.flush type=" + this.type);
                    }
                }
            }
            catch (IOException _ex) {
                this.cobErrno = JavaToIscobolError.map(_ex);
                return 0;
            }
            return 1;
        }

        @Override
        public void setMinRecSize(int msr) {
            this.minRecSize = msr;
        }

        private int tailTrim(char[] buf, int maxLen) {
            int i;
            for (i = maxLen - 1; i >= 0 && buf[i] == ' '; --i) {
            }
            if (++i < this.minRecSize && (i = this.minRecSize) > maxLen) {
                i = maxLen;
            }
            return i;
        }

        private int tailTrim(byte[] buf, int maxLen) {
            int i;
            for (i = maxLen - 1; i >= 0 && buf[i] == 32; --i) {
            }
            if (++i < this.minRecSize && (i = this.minRecSize) > maxLen) {
                i = maxLen;
            }
            return i;
        }

        private int tailTrimBytes(byte[] buf, int maxLen) {
            int i = maxLen;
            try {
                String s = new String(buf, 0, maxLen, CobolVar.encoding);
                int trailingSpacesCount = 0;
                i = s.length() - 1;
                while (i >= 0 && s.charAt(i) == ' ') {
                    --i;
                    ++trailingSpacesCount;
                }
                i = maxLen - trailingSpacesCount;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (i < this.minRecSize) {
                i = this.minRecSize;
            }
            return i;
        }

        @Override
        public int writeAdvancing(int kind, int lines, ICobolVar cv, int len, int opts) {
            int Return2;
            boolean strip = (opts & 2) == 0;
            boolean cr = (opts & 1) == 0;
            boolean bytes = !(cv instanceof IPicN);
            switch (kind) {
                default: {
                    Return2 = this.write(cv, len, strip, bytes);
                    if (Return2 != 1 || !cr) break;
                    Return2 = this.write(13, bytes);
                    break;
                }
                case 1: {
                    Return2 = this.advance(lines, cr, bytes);
                    if (Return2 != 1 || (Return2 = this.write(cv, len, strip, bytes)) != 1 || !cr) break;
                    Return2 = this.write(13, bytes);
                    break;
                }
                case 2: {
                    Return2 = this.write(cv, len, strip, bytes);
                    if (Return2 != 1) break;
                    if (Return2 == 1 && cr) {
                        Return2 = this.write(13, bytes);
                    }
                    if (Return2 != 1) break;
                    Return2 = this.advance(lines, cr, bytes);
                    break;
                }
                case 3: {
                    Return2 = this.page(bytes);
                    if (Return2 != 1 || (Return2 = this.write(cv, len, strip, bytes)) != 1 || !cr) break;
                    Return2 = this.write(13, bytes);
                    break;
                }
                case 4: {
                    Return2 = this.write(cv, len, strip, bytes);
                    if (Return2 != 1) break;
                    if (Return2 == 1 && cr) {
                        Return2 = this.write(13, bytes);
                    }
                    if (Return2 != 1) break;
                    Return2 = this.page(bytes);
                    break;
                }
                case 8: {
                    Return2 = this.page(bytes);
                    break;
                }
                case 7: {
                    Return2 = this.advance(lines, cr, bytes);
                }
            }
            return Return2;
        }

        private int advance(int nLines, boolean cr, boolean bytes) {
            int Return2 = 1;
            if (cr) {
                for (int i = 0; i < nLines && Return2 == 1; ++i) {
                    Return2 = this.write(10, bytes);
                }
            } else {
                for (int i = 0; i < nLines && Return2 == 1; ++i) {
                    Return2 = this.write(10, bytes);
                }
            }
            return Return2;
        }

        private int page(boolean bytes) {
            return this.write(12, bytes);
        }

        @Override
        public int write(ICobolVar cv, int len, boolean strip) {
            return this.write(cv, len, strip, !(cv instanceof IPicN));
        }

        protected int write(ICobolVar cv, int len, boolean strip, boolean bytes) {
            try {
                switch (this.type) {
                    case 1: {
                        if (this.binary) {
                            byte[] buff = cv.getBytes();
                            int n = len = len < buff.length ? len : buff.length;
                            if (strip) {
                                this.remWriter.write(buff, 0, this.tailTrim(buff, len));
                                break;
                            }
                            this.remWriter.write(buff, 0, len);
                            break;
                        }
                        if (bytes) {
                            byte[] memory = cv.getBytes();
                            byte[] buff = new byte[memory.length];
                            System.arraycopy(memory, 0, buff, 0, memory.length);
                            int n = len = len < buff.length ? len : buff.length;
                            if (strip) {
                                this.remWriter.writeBytes(buff, 0, this.tailTrimBytes(buff, len));
                                break;
                            }
                            this.remWriter.writeBytes(buff, 0, len);
                            break;
                        }
                        char[] buff = cv.basicToString().toCharArray();
                        int n = len = len < buff.length ? len : buff.length;
                        if (strip) {
                            this.remWriter.write(buff, 0, this.tailTrim(buff, len));
                            break;
                        }
                        this.remWriter.write(buff, 0, len);
                        break;
                    }
                    case 2: {
                        char[] buff = cv.basicToString().toCharArray();
                        int n = len = len < buff.length ? len : buff.length;
                        if (strip) {
                            this.outWriter.write(buff, 0, this.tailTrim(buff, len));
                            break;
                        }
                        this.outWriter.write(buff, 0, len);
                        break;
                    }
                    case 3: {
                        byte[] buff = cv.getBytes();
                        int n = len = len < buff.length ? len : buff.length;
                        if (strip) {
                            this.outStream.write(buff, 0, this.tailTrim(buff, len));
                            break;
                        }
                        this.outStream.write(buff, 0, len);
                        break;
                    }
                    default: {
                        throw new IscobolRuntimeException(3, "DeviceFile.write1 type=" + this.type);
                    }
                }
            }
            catch (IOException _ex) {
                this.cobErrno = JavaToIscobolError.map(_ex);
                return 0;
            }
            return 1;
        }

        @Override
        public int write(int c) {
            return this.write(c, false);
        }

        public void writeChar(int c) {
            if (this.remWriter != null) {
                try {
                    this.remWriter.write(c);
                }
                catch (IOException e) {
                    this.cobErrno = JavaToIscobolError.map(e);
                }
            }
        }

        public void writeByte(byte b) {
            if (this.remWriter != null) {
                try {
                    this.remWriter.write(b);
                }
                catch (IOException e) {
                    this.cobErrno = JavaToIscobolError.map(e);
                }
            }
        }

        public void writeCharX(byte b) {
            if (this.remWriter != null) {
                try {
                    this.remWriter.writeBytes(new byte[]{b}, 0, 1);
                }
                catch (IOException e) {
                    this.cobErrno = JavaToIscobolError.map(e);
                }
            }
        }

        protected int write(int c, boolean bytes) {
            try {
                switch (this.type) {
                    case 1: {
                        if (this.binary) {
                            this.remWriter.write((byte)c);
                            break;
                        }
                        if (bytes) {
                            this.remWriter.writeBytes(new byte[]{(byte)c});
                            break;
                        }
                        this.remWriter.write(c);
                        break;
                    }
                    case 2: {
                        this.outWriter.write(c);
                        break;
                    }
                    case 3: {
                        this.outStream.write((byte)c);
                        break;
                    }
                    default: {
                        throw new IscobolRuntimeException(3, "DeviceFile.write3 type=" + this.type);
                    }
                }
            }
            catch (IOException _ex) {
                this.cobErrno = JavaToIscobolError.map(_ex);
                return 0;
            }
            return 1;
        }

        public boolean exists(File f) {
            return f.exists();
        }

        public boolean create(File f) throws IOException {
            return f.createNewFile();
        }

        @Override
        public int remove(File f) {
            if (!f.delete()) {
                this.cobErrno = 203;
                return 0;
            }
            return 1;
        }

        public void setMVSPrint() {
            isMVSPrint = true;
        }
    }
}

