/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.IsamException;
import com.iscobol.io.AtEndException;
import com.iscobol.io.BaseRelative;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.InvalidKeyException;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;

public class SeqVarLenFile
extends BaseRelative {
    private long lastLen;

    public SeqVarLenFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt) {
        super(nam, maxLen, memBuf, minLen, opt, 1);
    }

    @Override
    public void peerOpen(String path, int openType, int lockType) {
        super.peerOpen(path, openType, lockType);
        this.lastLen = 0L;
    }

    @Override
    public boolean write(boolean lock, int len) {
        super.write(lock, len);
        try {
            if (this.getOpenMode() == 6) {
                this.theFile.seek(this.theFile.length());
            }
            this.theFile.writeChar(len);
            this.theFile.write(this.getBufferRO(), 0, len);
            this.lastLen = len;
        }
        catch (IsamException _ex) {
            CobolIOException.get(SeqVarLenFile.cobolErrno(_ex), "", this, 2);
        }
        return false;
    }

    @Override
    public boolean writeAdvancing(int kind, int lines, boolean lock, int len, int opts) {
        return false;
    }

    @Override
    public void rewrite(boolean lock, int len) {
        super.rewrite(lock, len);
        if (this.lastLen != (long)len) {
            InvalidKeyException.get(139, "", this, 4);
            return;
        }
        try {
            this.theFile.seek(this.theFile.tell() - (long)len - 2L);
            this.write(lock, len);
        }
        catch (IsamException _ex) {
            CobolIOException.get(SeqVarLenFile.cobolErrno(_ex), "", this, 2);
        }
    }

    @Override
    public void delete() {
        throw new IscobolRuntimeException(4, "DELETE " + this.getLogicName());
    }

    @Override
    public int readNext(int lock, ICobolVar into) {
        int Return2 = 0;
        if (lock != -1) {
            super.readNext(lock &= this.lockMask, into);
        } else {
            super.readNext(lock &= 0xFFFFFFFF, into);
        }
        if (this.theFile == null) {
            AtEndException.get(this, 6);
            return Return2;
        }
        try {
            char len = this.theFile.readChar();
            if (len < this.getMinRecordLen() || len > this.getMaxRecordLen()) {
                CobolIOException.get(105, "", this, 6);
            } else {
                byte[] in = this.getBufferRO();
                Return2 = this.theFile.read(in, 0, len);
                this.lastLen = Return2;
                this.updateBuffer(in);
                if (into != null) {
                    into.setUsingMaxLen(in);
                }
            }
        }
        catch (IsamException _ex) {
            CobolIOException.get(SeqVarLenFile.cobolErrno(_ex), "", this, 6);
        }
        return Return2;
    }

    @Override
    public int readPrev(int lock, ICobolVar into) {
        throw new IscobolRuntimeException(4, "READ " + this.getLogicName() + " PREVIOUS");
    }

    @Override
    public int readKey(ICobolVar[] key, int lock, ICobolVar into) {
        throw new IscobolRuntimeException(4, "READ " + this.getLogicName());
    }

    @Override
    public void start(ICobolVar[] key, int type, int keyLen) {
        super.start(key, type, keyLen);
        if (this.theFile == null) {
            InvalidKeyException.get(111, "", this, 9);
            return;
        }
        try {
            if (type != 0) {
                throw new IscobolRuntimeException(4, "START " + this.getLogicName());
            }
            this.theFile.seek(0L);
        }
        catch (IsamException _ex) {
            CobolIOException.get(SeqVarLenFile.cobolErrno(_ex), "", this, 2);
        }
    }
}

