/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.BaseFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.XMLStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXParseException;

public class XmlFile
extends BaseFile {
    public static final int WRITE_ALL = 1;
    public static final int WRITE_PROCESSING_INSTRUCTION = 2;
    public static final int WRITE_PLAIN_TEXT = 3;
    private static final String eol = System.getProperty("line.separator", "\n");
    private ICobolVar varString;
    private int varStringOffset = 1;
    private ICobolVar xmlVar;
    private boolean lineAdv;
    private XMLStream xmlStream;
    private boolean createNewStream;
    private String filePath;
    private ICobolVar documentType;
    private PrintWriter outputFile;
    private StringBuffer inputBuffer;

    public XmlFile(String nam, ICobolVar memBuf, ICobolVar var, boolean ladv, ICobolVar docType) {
        super(nam, memBuf.getMemoryLength(), memBuf, 0, false, 1);
        this.varString = var;
        this.lineAdv = ladv;
        this.documentType = docType;
    }

    @Override
    public void peerOpen(String path, int openType, int lockType) {
        ICobolVar buff = this.getBufferAsVar();
        Enumeration en = buff.getChildren();
        while (en.hasMoreElements()) {
            ICobolVar cv = (ICobolVar)en.nextElement();
            if (cv.getIXMLAttributes() == null) continue;
            this.xmlVar = cv;
            break;
        }
        if (this.xmlVar == null) {
            CobolIOException.get(134, "", this, 1);
        }
        this.filePath = path;
        if (this.varString == null) {
            File f = new File(path);
            switch (openType) {
                case 1: {
                    if (f.exists() && f.isFile() && f.canRead()) break;
                    this.setFileStatus("-4");
                    return;
                }
                case 2: 
                case 6: {
                    if (!f.exists() || f.isFile() && f.canWrite()) break;
                    this.setFileStatus("-4");
                    return;
                }
                case 3: {
                    if (!f.exists() || f.isFile() && f.canWrite() && f.canRead()) break;
                    this.setFileStatus("-4");
                    return;
                }
                default: {
                    this.setFileStatus("-4");
                    return;
                }
            }
        }
        this.setOpenMode(openType);
        this.setFileStatus("0");
    }

    @Override
    protected void peerClose(int opts) {
        this.xmlStream = null;
        this.varString = null;
        this.varStringOffset = 1;
        this.documentType = null;
        this.filePath = null;
        this.xmlVar = null;
        this.lineAdv = false;
        if (this.outputFile != null) {
            this.outputFile.close();
            this.outputFile = null;
        }
        this.setOpenMode(0);
    }

    @Override
    public boolean write(boolean lock, int len) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public boolean writeAdvancing(int kind, int lines, boolean lock, int len, int opts) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public int readNext(int lock, ICobolVar into) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readXml(ICobolVar keyName) {
        super.readNext(0, keyName);
        if (keyName == null) {
            if (this.xmlStream == null || this.createNewStream) {
                this.xmlStream = new XMLStream(this.xmlVar, true, this.lineAdv);
                this.createNewStream = false;
            }
            if (this.inputBuffer == null) {
                if (this.varString != null) {
                    this.inputBuffer = new StringBuffer(this.varString.toString());
                } else {
                    if (this.filePath == null) {
                        this.setFileStatus("-1");
                        return;
                    }
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(this.filePath.trim());
                        byte[] b = new byte[in.available()];
                        in.read(b);
                        in.close();
                        this.inputBuffer = new StringBuffer(new String(b));
                    }
                    catch (IOException _ex) {
                        this.setFileStatus("-11");
                        return;
                    }
                }
            } else if (this.inputBuffer.length() == 0) {
                this.setFileStatus("-7");
                return;
            }
            try {
                this.xmlStream.readFromString(this.inputBuffer.toString());
                this.setDocumentType(this.xmlStream);
                this.setFileStatus("0");
                if (!this.xmlStream.isOk()) return;
                this.inputBuffer = new StringBuffer();
                return;
            }
            catch (IscobolRuntimeException ex) {
                int lineNumber = 0;
                if (!this.xmlStream.isOk()) throw ex;
                if (!(ex.getCause() instanceof SAXParseException)) throw ex;
                String msg = ex.getMessage().toLowerCase();
                int idx = msg.indexOf("linenumber");
                if (idx <= 0) throw ex;
                char[] c = msg.substring(idx + 10).toCharArray();
                for (int i = 0; i < c.length; ++i) {
                    if (Character.isDigit(c[i])) {
                        lineNumber = lineNumber * 10 + c[i] - 48;
                        continue;
                    }
                    if (lineNumber > 0) break;
                }
                if (lineNumber <= 0) throw ex;
                --lineNumber;
                BufferedReader br = new BufferedReader(new StringReader(this.inputBuffer.toString()));
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                try {
                    int i = 0;
                    String line = br.readLine();
                    while (line != null) {
                        if (i >= lineNumber) {
                            pw.println(line);
                        }
                        ++i;
                        line = br.readLine();
                    }
                    br.close();
                    pw.close();
                    this.inputBuffer = new StringBuffer(sw.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.createNewStream = true;
                return;
            }
        }
        if (this.xmlStream == null) {
            this.setFileStatus("-2");
            return;
        }
        if (this.xmlStream.readKey(keyName) > 0) {
            this.setFileStatus("0");
            return;
        }
        this.setFileStatus("-7");
    }

    private void setDocumentType(XMLStream xmls) {
        if (this.documentType != null && !this.documentType.isFinal()) {
            String docType = xmls.getSchemaLocation();
            this.documentType.set(docType != null ? docType : "");
        }
    }

    private void getDocumentType(XMLStream xmls) {
        if (this.documentType != null) {
            xmls.setSchemaLocation(this.documentType.toString());
        }
    }

    public void writeXml(ICobolVar recordName, ICobolVar keyName, int writeMode) {
        super.write(false, this.getBufferLength());
        if (keyName == null) {
            XMLStream xmls;
            if (this.xmlStream != null) {
                xmls = this.xmlStream;
            } else {
                if (recordName.getIXMLAttributes() == null) {
                    this.setFileStatus("-2");
                    return;
                }
                xmls = new XMLStream(recordName, true, this.lineAdv);
            }
            this.getDocumentType(xmls);
            StringBuffer sb = new StringBuffer();
            xmls.writeToStringBuffer(sb);
            if (this.varString != null) {
                try {
                    this.varString.intISub(this.varStringOffset).set(sb.toString());
                }
                catch (IscobolRuntimeException iscobolRuntimeException) {
                    // empty catch block
                }
                this.varStringOffset += sb.length();
            } else if (this.filePath != null) {
                PrintWriter of = this.getOutputFile();
                if (of == null) {
                    return;
                }
                of.print(sb.toString());
            }
            this.setFileStatus("" + sb.length());
        } else {
            boolean pi = false;
            boolean all = false;
            switch (writeMode) {
                case 2: {
                    pi = true;
                }
                case 3: {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    XMLStream xmls = new XMLStream(recordName, true, this.lineAdv);
                    xmls.setPrintWriter(pw);
                    TransformerHandler hd = xmls.getTransformerHandler();
                    String s = keyName.toString();
                    if (pi) {
                        s = "<?" + s + "?>";
                    }
                    s = s + eol;
                    char[] c = s.toCharArray();
                    try {
                        if (pi) {
                            hd.processingInstruction("javax.xml.transform.disable-output-escaping", null);
                            hd.characters(c, 0, c.length);
                            hd.processingInstruction("javax.xml.transform.enable-output-escaping", null);
                        } else {
                            hd.characters(c, 0, c.length);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    pw.close();
                    String outStr = sw.toString();
                    if (this.varString != null) {
                        try {
                            this.varString.intISub(this.varStringOffset).set(outStr);
                        }
                        catch (IscobolRuntimeException iscobolRuntimeException) {
                            // empty catch block
                        }
                        this.varStringOffset += outStr.length();
                    } else if (this.filePath != null) {
                        PrintWriter of = this.getOutputFile();
                        if (of == null) {
                            return;
                        }
                        of.print(outStr);
                    }
                    this.setFileStatus("" + outStr);
                    break;
                }
                case 1: {
                    all = true;
                    break;
                }
                default: {
                    if (!this.getStream(recordName)) break;
                    this.xmlStream.writeKey(keyName, all);
                }
            }
        }
    }

    private boolean getStream(ICobolVar recordName) {
        if (this.xmlStream == null) {
            if (recordName == null || recordName.getIXMLAttributes() == null) {
                this.setFileStatus("-2");
                return false;
            }
            XMLStream x = new XMLStream(recordName, false, this.lineAdv);
            StringBuffer sb = new StringBuffer();
            x.writeToStringBuffer(sb);
            this.xmlStream = new XMLStream(recordName, true, this.lineAdv);
            this.xmlStream.readFromString(sb.toString());
        }
        return true;
    }

    private PrintWriter getOutputFile() {
        if (this.outputFile == null) {
            try {
                this.outputFile = new PrintWriter(new FileOutputStream(this.filePath, this.getOpenMode() == 6));
            }
            catch (FileNotFoundException e) {
                this.setFileStatus("-12");
            }
        }
        return this.outputFile;
    }

    public void rewriteXml(ICobolVar recordName, ICobolVar keyName) {
        if (this.getStream(recordName)) {
            this.xmlStream.rewriteKey(keyName);
        }
    }

    public void startXml(ICobolVar keyName, int keyIndex) {
        super.start((ICobolVar[])null, 0, 0);
        if (this.xmlStream == null) {
            this.setFileStatus("-2");
        } else if (this.xmlStream.startKey(keyName, keyIndex)) {
            this.setFileStatus("0");
        } else {
            this.setFileStatus("-6");
        }
    }

    public void deleteXml(ICobolVar keyName) {
        if (this.getStream(null)) {
            this.xmlStream.deleteKey(keyName);
        }
    }

    @Override
    public void deleteFile(ICobolVar path) {
        super.deleteFile(path);
    }

    @Override
    public void rewrite(boolean lock, int len) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public void delete() {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public int readPrev(boolean lock, ICobolVar into) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public int readKey(ICobolVar[] key, boolean lock, ICobolVar into) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public void start(ICobolVar[] key, int type, int keyLen) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }
}

